/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.RIPEMD128Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.WhirlpoolDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.RSABlindedEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.X931Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class X931SignatureSpi
extends SignatureSpi {
    private X931Signer signer;

    public X931SignatureSpi(Digest digest, AsymmetricBlockCipher asymmetricBlockCipher) {
        X931Signer x931Signer;
        X931Signer x931Signer2 = x931Signer;
        x931Signer = new X931Signer(asymmetricBlockCipher, digest);
        v1.signer = x931Signer2;
    }

    @Override
    public void engineInitVerify(PublicKey publicKey) {
        X931SignatureSpi x931SignatureSpi = rSAKeyParameters;
        RSAKeyParameters rSAKeyParameters = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
        x931SignatureSpi.signer.init(false, rSAKeyParameters);
    }

    @Override
    public void engineInitSign(PrivateKey privateKey) {
        X931SignatureSpi x931SignatureSpi = rSAKeyParameters;
        RSAKeyParameters rSAKeyParameters = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        x931SignatureSpi.signer.init(true, rSAKeyParameters);
    }

    @Override
    public void engineUpdate(byte by) {
        this.signer.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n, int n2) {
        this.signer.update(byArray, n, n2);
    }

    @Override
    public byte[] engineSign() {
        try {
            return this.signer.generateSignature();
        }
        catch (Exception exception) {
            throw new SignatureException(((Object)exception).toString());
        }
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        return this.signer.verifySignature(byArray);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class WhirlpoolWithRSAEncryption
    extends X931SignatureSpi {
        public WhirlpoolWithRSAEncryption() {
            RSABlindedEngine rSABlindedEngine;
            WhirlpoolDigest whirlpoolDigest;
            WhirlpoolWithRSAEncryption whirlpoolWithRSAEncryption = whirlpoolDigest2;
            WhirlpoolDigest whirlpoolDigest2 = whirlpoolDigest;
            whirlpoolDigest = new WhirlpoolDigest();
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(whirlpoolDigest2, rSABlindedEngine2);
        }
    }

    public static class SHA512_256WithRSAEncryption
    extends X931SignatureSpi {
        public SHA512_256WithRSAEncryption() {
            RSABlindedEngine rSABlindedEngine;
            SHA512_256WithRSAEncryption sHA512_256WithRSAEncryption = digest;
            Digest digest = DigestFactory.createSHA512_256();
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(digest, rSABlindedEngine2);
        }
    }

    public static class SHA512_224WithRSAEncryption
    extends X931SignatureSpi {
        public SHA512_224WithRSAEncryption() {
            RSABlindedEngine rSABlindedEngine;
            SHA512_224WithRSAEncryption sHA512_224WithRSAEncryption = digest;
            Digest digest = DigestFactory.createSHA512_224();
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(digest, rSABlindedEngine2);
        }
    }

    public static class SHA512WithRSAEncryption
    extends X931SignatureSpi {
        public SHA512WithRSAEncryption() {
            RSABlindedEngine rSABlindedEngine;
            SHA512WithRSAEncryption sHA512WithRSAEncryption = digest;
            Digest digest = DigestFactory.createSHA512();
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(digest, rSABlindedEngine2);
        }
    }

    public static class SHA384WithRSAEncryption
    extends X931SignatureSpi {
        public SHA384WithRSAEncryption() {
            RSABlindedEngine rSABlindedEngine;
            SHA384WithRSAEncryption sHA384WithRSAEncryption = digest;
            Digest digest = DigestFactory.createSHA384();
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(digest, rSABlindedEngine2);
        }
    }

    public static class SHA256WithRSAEncryption
    extends X931SignatureSpi {
        public SHA256WithRSAEncryption() {
            RSABlindedEngine rSABlindedEngine;
            SHA256WithRSAEncryption sHA256WithRSAEncryption = digest;
            Digest digest = DigestFactory.createSHA256();
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(digest, rSABlindedEngine2);
        }
    }

    public static class SHA224WithRSAEncryption
    extends X931SignatureSpi {
        public SHA224WithRSAEncryption() {
            RSABlindedEngine rSABlindedEngine;
            SHA224WithRSAEncryption sHA224WithRSAEncryption = digest;
            Digest digest = DigestFactory.createSHA224();
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(digest, rSABlindedEngine2);
        }
    }

    public static class SHA1WithRSAEncryption
    extends X931SignatureSpi {
        public SHA1WithRSAEncryption() {
            RSABlindedEngine rSABlindedEngine;
            SHA1WithRSAEncryption sHA1WithRSAEncryption = digest;
            Digest digest = DigestFactory.createSHA1();
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(digest, rSABlindedEngine2);
        }
    }

    public static class RIPEMD160WithRSAEncryption
    extends X931SignatureSpi {
        public RIPEMD160WithRSAEncryption() {
            RSABlindedEngine rSABlindedEngine;
            RIPEMD160Digest rIPEMD160Digest;
            RIPEMD160WithRSAEncryption rIPEMD160WithRSAEncryption = rIPEMD160Digest2;
            RIPEMD160Digest rIPEMD160Digest2 = rIPEMD160Digest;
            rIPEMD160Digest = new RIPEMD160Digest();
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(rIPEMD160Digest2, rSABlindedEngine2);
        }
    }

    public static class RIPEMD128WithRSAEncryption
    extends X931SignatureSpi {
        public RIPEMD128WithRSAEncryption() {
            RSABlindedEngine rSABlindedEngine;
            RIPEMD128Digest rIPEMD128Digest;
            RIPEMD128WithRSAEncryption rIPEMD128WithRSAEncryption = rIPEMD128Digest2;
            RIPEMD128Digest rIPEMD128Digest2 = rIPEMD128Digest;
            rIPEMD128Digest = new RIPEMD128Digest();
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(rIPEMD128Digest2, rSABlindedEngine2);
        }
    }
}

