/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP256K1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP256K1FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP256K1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP256K1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final int SECP256K1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP256K1_AFFINE_ZS;
    public SecP256K1Point infinity;

    public SecP256K1Curve() {
        SecP256K1Curve secP256K1Curve = this;
        super(q);
        secP256K1Curve.infinity = new SecP256K1Point(this, null, null);
        secP256K1Curve.a = secP256K1Curve.fromBigInteger(ECConstants.ZERO);
        secP256K1Curve.b = secP256K1Curve.fromBigInteger(BigInteger.valueOf(7L));
        secP256K1Curve.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141"));
        secP256K1Curve.cofactor = BigInteger.valueOf(1L);
        secP256K1Curve.coord = 2;
    }

    static {
        SecP256K1FieldElement secP256K1FieldElement;
        q = SecP256K1FieldElement.Q;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecP256K1FieldElement secP256K1FieldElement2 = secP256K1FieldElement;
        secP256K1FieldElement = new SecP256K1FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secP256K1FieldElement2;
        SECP256K1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecP256K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        return n == 2;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP256K1FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP256K1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP256K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int[] nArray = new int[n2 * 8 * 2];
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[n + k];
            Nat256.copy(((SecP256K1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat256.copy(((SecP256K1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 8);
            n3 += 8;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                SecP256K1FieldElement secP256K1FieldElement;
                SecP256K1FieldElement secP256K1FieldElement2 = secP256K1FieldElement;
                secP256K1FieldElement = new SecP256K1FieldElement(nArray2);
                return secP256K1FieldElement2.SecP256K1Curve.this.createRawPoint(new SecP256K1FieldElement(nArray3), secP256K1FieldElement2, SECP256K1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                int[] nArray4 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    int n3 = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        int[] nArray3 = nArray;
                        nArray4[i2] = nArray4[i2] ^ nArray[n22 + i2] & n3;
                        nArray2[i2] = nArray2[i2] ^ nArray3[n22 + 8 + i2] & n3;
                    }
                    n22 += 16;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                int[] nArray4 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n22 = n * 8 * 2;
                for (int k = 0; k < 8; ++k) {
                    int[] nArray3 = nArray;
                    nArray4[k] = nArray3[n22 + k];
                    nArray2[k] = nArray[n22 + 8 + k];
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Object object = nArray;
        SecP256K1Field.random(secureRandom, nArray);
        return new SecP256K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Object object = nArray;
        SecP256K1Field.randomMult(secureRandom, nArray);
        return new SecP256K1FieldElement((int[])object);
    }
}

