/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCS256KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.Tree;
import java.security.SecureRandom;

public class SPHINCS256KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private Digest treeDigest;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        this.treeDigest = ((SPHINCS256KeyGenerationParameters)keyGenerationParameters).getTreeDigest();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Tree.leafaddr leafaddr2;
        Tree.leafaddr leafaddr3 = leafaddr2;
        leafaddr2 = new Tree.leafaddr();
        byte[] byArray = new byte[1088];
        this.random.nextBytes(byArray);
        byte[] byArray2 = new byte[1056];
        System.arraycopy(byArray, 32, byArray2, 0, 1024);
        leafaddr2.level = 11;
        leafaddr2.subtree = 0L;
        leafaddr2.subleaf = 0L;
        Tree.treehash(new HashFunctions(this.treeDigest), byArray2, 1024, 5, byArray, leafaddr3, byArray2, 0);
        return new AsymmetricCipherKeyPair(new SPHINCSPublicKeyParameters(byArray2, this.treeDigest.getAlgorithmName()), new SPHINCSPrivateKeyParameters(byArray, this.treeDigest.getAlgorithmName()));
    }
}

