/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Matrix;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2mMatrix
extends Matrix {
    public GF2mField field;
    public int[][] matrix;

    public GF2mMatrix(GF2mField gF2mField, byte[] byArray) {
        int n;
        this.field = gF2mField;
        int n2 = 1;
        for (n = 8; gF2mField.getDegree() > n; n += 8) {
            ++n2;
        }
        if (byArray.length >= 5) {
            int n3;
            this.numRows = n3 = (byArray[3] & 0xFF) << 24 ^ (byArray[2] & 0xFF) << 16 ^ (byArray[1] & 0xFF) << 8 ^ byArray[0] & 0xFF;
            if (n3 > 0 && (byArray.length - 4) % (n2 *= n3) == 0) {
                int n4 = n3;
                this.numColumns = n3 = (byArray.length - 4) / n2;
                this.matrix = new int[n4][n3];
                n3 = 4;
                for (n2 = 0; n2 < this.numRows; ++n2) {
                    for (int k = 0; k < this.numColumns; ++k) {
                        for (int i2 = 0; i2 < n; i2 += 8) {
                            int[] nArray = this.matrix[n2];
                            nArray[k] = nArray[k] ^ (byArray[n3++] & 0xFF) << i2;
                        }
                        if (this.field.isElementOfThisField(this.matrix[n2][k])) {
                            continue;
                        }
                        throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
                    }
                }
                return;
            }
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
    }

    public GF2mMatrix(GF2mMatrix gF2mMatrix) {
        int n;
        GF2mMatrix gF2mMatrix2 = this;
        this.numRows = n = gF2mMatrix.numRows;
        this.numColumns = gF2mMatrix.numColumns;
        gF2mMatrix2.field = gF2mMatrix.field;
        gF2mMatrix2.matrix = new int[n][];
        for (n = 0; n < this.numRows; ++n) {
            this.matrix[n] = IntUtils.clone(gF2mMatrix.matrix[n]);
        }
    }

    public GF2mMatrix(GF2mField gF2mField, int[][] nArray) {
        this.field = gF2mField;
        this.matrix = nArray;
        this.numRows = nArray.length;
        this.numColumns = nArray[0].length;
    }

    private static void swapColumns(int[][] object, int n, int n2) {
        int[][] nArray = object;
        int[][] nArray2 = object;
        object = nArray[n];
        nArray[n] = nArray2[n2];
        nArray2[n2] = (int[])object;
    }

    private void multRowWithElementThis(int[] nArray, int n) {
        for (int k = nArray.length - 1; k >= 0; --k) {
            nArray[k] = this.field.mult(nArray[k], n);
        }
    }

    private int[] multRowWithElement(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        for (int k = nArray.length - 1; k >= 0; --k) {
            nArray2[k] = this.field.mult(nArray[k], n);
        }
        return nArray2;
    }

    private void addToRow(int[] nArray, int[] nArray2) {
        for (int k = nArray2.length - 1; k >= 0; --k) {
            int n = nArray[k];
            nArray2[k] = this.field.add(n, nArray2[k]);
        }
    }

    @Override
    public byte[] getEncoded() {
        int n;
        int n2 = 1;
        for (n = 8; this.field.getDegree() > n; n += 8) {
            ++n2;
        }
        int n3 = this.numRows;
        byte[] byArray = new byte[n3 * this.numColumns * n2 + 4];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)(n3 & 0xFF);
        byArray2[1] = (byte)(n3 >>> 8 & 0xFF);
        byArray2[2] = (byte)(n3 >>> 16 & 0xFF);
        byArray[3] = (byte)(n3 >>> 24 & 0xFF);
        n3 = 4;
        for (int k = 0; k < this.numRows; ++k) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                for (int i3 = 0; i3 < n; i3 += 8) {
                    byArray2[n3++] = (byte)(this.matrix[k][i2] >>> i3);
                }
            }
        }
        return byArray2;
    }

    @Override
    public boolean isZero() {
        for (int k = 0; k < this.numRows; ++k) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                if (this.matrix[k][i2] == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Matrix computeInverse() {
        int n = this.numRows;
        if (n == this.numColumns) {
            int n2;
            int n3 = n;
            int[][] nArray = new int[n3][n3];
            for (int k = (v921807) - 1; k >= 0; --k) {
                nArray[k] = IntUtils.clone(this.matrix[k]);
            }
            int n4 = this.numRows;
            int[][] nArray2 = new int[n4][n4];
            for (n2 = (v921825) - 1; n2 >= 0; --n2) {
                nArray2[n2][n2] = 1;
            }
            for (n2 = 0; n2 < this.numRows; ++n2) {
                int n5;
                int n6;
                if (nArray[n2][n2] == 0) {
                    n6 = 0;
                    for (n5 = n2 + 1; n5 < this.numRows; ++n5) {
                        if (nArray[n5][n2] == 0) continue;
                        n6 = 1;
                        GF2mMatrix.swapColumns(nArray, n2, n5);
                        GF2mMatrix.swapColumns(nArray2, n2, n5);
                        n5 = this.numRows;
                    }
                    if (n6 == 0) {
                        throw new ArithmeticException("Matrix is not invertible.");
                    }
                }
                n6 = nArray[n2][n2];
                n6 = this.field.inverse(n6);
                this.multRowWithElementThis(nArray[n2], n6);
                this.multRowWithElementThis(nArray2[n2], n6);
                for (n6 = 0; n6 < this.numRows; ++n6) {
                    if (n6 == n2 || (n5 = nArray[n6][n2]) == 0) continue;
                    int[] nArray3 = this.multRowWithElement(nArray[n2], n5);
                    int[] nArray4 = this.multRowWithElement(nArray2[n2], n5);
                    this.addToRow(nArray3, nArray[n6]);
                    this.addToRow(nArray4, nArray2[n6]);
                }
            }
            return new GF2mMatrix(this.field, nArray2);
        }
        throw new ArithmeticException("Matrix is not invertible.");
    }

    @Override
    public Matrix rightMultiply(Matrix matrix) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Matrix rightMultiply(Permutation permutation) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Vector leftMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Vector rightMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GF2mMatrix) {
            int n;
            object = (GF2mMatrix)object;
            if (this.field.equals(((GF2mMatrix)object).field) && ((Matrix)object).numRows == (n = this.numColumns) && ((Matrix)object).numColumns == n) {
                for (n = 0; n < this.numRows; ++n) {
                    for (int k = 0; k < this.numColumns; ++k) {
                        if (this.matrix[n][k] == ((GF2mMatrix)object).matrix[n][k]) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = (this.field.hashCode() * 31 + this.numRows) * 31 + this.numColumns;
        for (int k = 0; k < this.numRows; ++k) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                n = n * 31 + this.matrix[k][i2];
            }
        }
        return n;
    }

    @Override
    public String toString() {
        String string = this.numRows + " x " + this.numColumns + " Matrix over " + this.field.toString() + ": \n";
        for (int k = 0; k < this.numRows; ++k) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                string = b.a(string).append(this.field.elementToStr(this.matrix[k][i2])).append(" : ").toString();
            }
            string = i.a(string, "\n");
        }
        return string;
    }
}

