/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util.io.pem;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Base64;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.pem.PemHeader;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.pem.PemObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.pem.PemObjectGenerator;
import java.io.BufferedWriter;
import java.io.Writer;
import java.util.Iterator;

public class PemWriter
extends BufferedWriter {
    private static final int LINE_LENGTH = 64;
    private final int nlLength;
    private char[] buf = new char[64];

    public PemWriter(Writer object) {
        super((Writer)object);
        object = Strings.lineSeparator();
        this.nlLength = object != null ? ((String)object).length() : 2;
    }

    private void writeEncoded(byte[] byArray) {
        PemWriter pemWriter;
        byArray = Base64.encode(byArray);
        for (int k = 0; k < byArray.length; k += pemWriter.buf.length) {
            char[] cArray;
            int n = 0;
            while (true) {
                int n2;
                cArray = this.buf;
                if (n == this.buf.length || (n2 = k + n) >= byArray.length) break;
                cArray[n] = (char)byArray[n2];
                ++n;
            }
            pemWriter = this;
            ((Writer)pemWriter).write(cArray, 0, n);
            pemWriter.newLine();
        }
    }

    private void writePreEncapsulationBoundary(String string) {
        PemWriter pemWriter = this;
        pemWriter.write("-----BEGIN " + string + "-----");
        pemWriter.newLine();
    }

    private void writePostEncapsulationBoundary(String string) {
        PemWriter pemWriter = this;
        pemWriter.write("-----END " + string + "-----");
        pemWriter.newLine();
    }

    public int getOutputSize(PemObject pemObject) {
        PemObject pemObject2 = pemObject;
        int n = (pemObject2.getType().length() + 10 + this.nlLength) * 2 + 6 + 4;
        if (!pemObject2.getHeaders().isEmpty()) {
            for (PemHeader pemHeader : pemObject.getHeaders()) {
                int n2 = pemHeader.getName().length() + 2;
                n = pemHeader.getValue().length() + n2 + this.nlLength + n;
            }
            n += this.nlLength;
        }
        int n3 = (pemObject.getContent().length + 2) / 3 * 4;
        return (n3 + 64 - 1) / 64 * this.nlLength + n3 + n;
    }

    public void writeObject(PemObjectGenerator pemObjectGenerator) {
        pemObjectGenerator = pemObjectGenerator.generate();
        this.writePreEncapsulationBoundary(((PemObject)pemObjectGenerator).getType());
        if (!((PemObject)pemObjectGenerator).getHeaders().isEmpty()) {
            Iterator iterator = ((PemObject)pemObjectGenerator).getHeaders().iterator();
            while (iterator.hasNext()) {
                PemWriter pemWriter = this;
                PemHeader pemHeader = (PemHeader)iterator.next();
                pemWriter.write(pemHeader.getName());
                pemWriter.write(": ");
                pemWriter.write(pemHeader.getValue());
                pemWriter.newLine();
            }
            this.newLine();
        }
        this.writeEncoded(((PemObject)pemObjectGenerator).getContent());
        this.writePostEncapsulationBoundary(((PemObject)pemObjectGenerator).getType());
    }
}

