/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.cert;

import com.fis.ekyc.nfc.build_in.cvc.AccessRightEnum;
import com.fis.ekyc.nfc.build_in.cvc.AuthorizationRoleEnum;

public class CVCAuthorizationTemplate {
    private Role role;
    private Permission accessRight;

    public CVCAuthorizationTemplate(com.fis.ekyc.nfc.build_in.cvc.CVCAuthorizationTemplate cVCAuthorizationTemplate) {
        this.role = CVCAuthorizationTemplate.toRole(cVCAuthorizationTemplate);
        this.accessRight = CVCAuthorizationTemplate.toPermission(cVCAuthorizationTemplate);
    }

    public CVCAuthorizationTemplate(Role role, Permission permission) {
        this.role = role;
        this.accessRight = permission;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccessRightEnum fromPermission(Permission permission) {
        try {
            switch (1.$SwitchMap$com$fis$ekyc$nfc$build_in$eidparser$cert$CVCAuthorizationTemplate$Permission[permission.ordinal()]) {
                default: {
                    throw new IllegalArgumentException("Error getting permission for " + (Object)((Object)permission));
                }
                case 4: {
                    return AccessRightEnum.READ_ACCESS_DG3_AND_DG4;
                }
                case 3: {
                    return AccessRightEnum.READ_ACCESS_DG4;
                }
                case 2: {
                    return AccessRightEnum.READ_ACCESS_DG3;
                }
                case 1: 
            }
            return AccessRightEnum.READ_ACCESS_NONE;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error getting permission from AuthZ template", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AuthorizationRoleEnum fromRole(Role role) {
        try {
            switch (1.$SwitchMap$com$fis$ekyc$nfc$build_in$eidparser$cert$CVCAuthorizationTemplate$Role[role.ordinal()]) {
                default: {
                    throw new IllegalArgumentException("Error getting role from AuthZ template " + (Object)((Object)role));
                }
                case 4: {
                    return AuthorizationRoleEnum.IS;
                }
                case 3: {
                    return AuthorizationRoleEnum.DV_F;
                }
                case 2: {
                    return AuthorizationRoleEnum.DV_D;
                }
                case 1: 
            }
            return AuthorizationRoleEnum.CVCA;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error getting role from AuthZ template", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Role toRole(com.fis.ekyc.nfc.build_in.cvc.CVCAuthorizationTemplate object) {
        try {
            object = ((com.fis.ekyc.nfc.build_in.cvc.CVCAuthorizationTemplate)object).getAuthorizationField().getRole();
            switch (1.$SwitchMap$com$fis$ekyc$nfc$build_in$cvc$AuthorizationRoleEnum[((Enum)object).ordinal()]) {
                default: {
                    throw new IllegalArgumentException("Unsupported role " + object);
                }
                case 4: {
                    return Role.IS;
                }
                case 3: {
                    return Role.DV_F;
                }
                case 2: {
                    return Role.DV_D;
                }
                case 1: 
            }
            return Role.CVCA;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("Error getting role from AuthZ template", noSuchFieldException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Permission toPermission(com.fis.ekyc.nfc.build_in.cvc.CVCAuthorizationTemplate object) {
        try {
            object = ((com.fis.ekyc.nfc.build_in.cvc.CVCAuthorizationTemplate)object).getAuthorizationField().getAccessRight();
            switch (1.$SwitchMap$com$fis$ekyc$nfc$build_in$cvc$AccessRightEnum[((Enum)object).ordinal()]) {
                default: {
                    throw new IllegalArgumentException("Unsupported access right " + object);
                }
                case 4: {
                    return Permission.READ_ACCESS_DG3_AND_DG4;
                }
                case 3: {
                    return Permission.READ_ACCESS_DG4;
                }
                case 2: {
                    return Permission.READ_ACCESS_DG3;
                }
                case 1: 
            }
            return Permission.READ_ACCESS_NONE;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("Unsupported access right", noSuchFieldException);
        }
    }

    public Role getRole() {
        return this.role;
    }

    public Permission getAccessRight() {
        return this.accessRight;
    }

    public String toString() {
        return ((Object)((Object)this.role)).toString() + ((Object)((Object)this.accessRight)).toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        object = (CVCAuthorizationTemplate)object;
        return this.role == ((CVCAuthorizationTemplate)object).role && this.accessRight == ((CVCAuthorizationTemplate)object).accessRight;
    }

    public int hashCode() {
        CVCAuthorizationTemplate cVCAuthorizationTemplate = this;
        int n = cVCAuthorizationTemplate.role.value * 2;
        return cVCAuthorizationTemplate.accessRight.value * 3 + n + 61;
    }

    public static final class Role
    extends Enum<Role> {
        public static final /* enum */ Role CVCA;
        public static final /* enum */ Role DV_D;
        public static final /* enum */ Role DV_F;
        public static final /* enum */ Role IS;
        private static final /* synthetic */ Role[] $VALUES;
        private byte value;

        public static Role[] values() {
            return (Role[])$VALUES.clone();
        }

        public static Role valueOf(String string2) {
            return Enum.valueOf(Role.class, string2);
        }

        private Role(int n2) {
            this.value = (byte)n2;
        }

        static {
            Role role;
            Role role2;
            Role role3;
            Role role4;
            Role role5 = role4;
            CVCA = new Role(192);
            Role role6 = role3;
            DV_D = new Role(128);
            Role role7 = role2;
            DV_F = new Role(64);
            Role role8 = role;
            IS = new Role(0);
            $VALUES = new Role[]{role5, role6, role7, role8};
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static final class Permission
    extends Enum<Permission> {
        public static final /* enum */ Permission READ_ACCESS_NONE;
        public static final /* enum */ Permission READ_ACCESS_DG3;
        public static final /* enum */ Permission READ_ACCESS_DG4;
        public static final /* enum */ Permission READ_ACCESS_DG3_AND_DG4;
        private static final /* synthetic */ Permission[] $VALUES;
        private byte value;

        public static Permission[] values() {
            return (Permission[])$VALUES.clone();
        }

        public static Permission valueOf(String string2) {
            return Enum.valueOf(Permission.class, string2);
        }

        private Permission(int n2) {
            this.value = (byte)n2;
        }

        static {
            Permission permission;
            Permission permission2;
            Permission permission3;
            Permission permission4;
            Permission permission5 = permission4;
            READ_ACCESS_NONE = new Permission(0);
            Permission permission6 = permission3;
            READ_ACCESS_DG3 = new Permission(1);
            Permission permission7 = permission2;
            READ_ACCESS_DG4 = new Permission(2);
            Permission permission8 = permission;
            READ_ACCESS_DG3_AND_DG4 = new Permission(3);
            $VALUES = new Permission[]{permission5, permission6, permission7, permission8};
        }

        public boolean implies(Permission permission) {
            switch (1.$SwitchMap$com$fis$ekyc$nfc$build_in$eidparser$cert$CVCAuthorizationTemplate$Permission[this.ordinal()]) {
                default: {
                    return false;
                }
                case 4: {
                    return permission == READ_ACCESS_DG3 || permission == READ_ACCESS_DG4 || permission == READ_ACCESS_DG3_AND_DG4;
                }
                case 3: {
                    return permission == READ_ACCESS_DG4;
                }
                case 2: {
                    return permission == READ_ACCESS_DG3;
                }
                case 1: 
            }
            return permission == READ_ACCESS_NONE;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

