/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.smartcards;

import com.fis.ekyc.nfc.build_in.scuba.smartcards.CardServiceException;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.FileInfo;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.FileSystemStructured;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Logger;

public class CardFileInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.nfc.build_in.scuba");
    private FileInfo[] path;
    private final byte[] buffer;
    private int bufferLength;
    private int offsetBufferInFile;
    private int offsetInBuffer;
    private int markedOffset;
    private int fileLength;
    private FileSystemStructured fs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CardFileInputStream(int n, FileSystemStructured fileSystemStructured) {
        FileSystemStructured fileSystemStructured2 = fileSystemStructured;
        this.fs = fileSystemStructured;
        synchronized (fileSystemStructured2) {
            Object[] objectArray = fileSystemStructured2.getSelectedPath();
            if (objectArray == null) throw new CardServiceException("No valid file selected, path = " + Arrays.toString(objectArray));
            if (objectArray.length < 1) throw new CardServiceException("No valid file selected, path = " + Arrays.toString(objectArray));
            FileSystemStructured fileSystemStructured3 = fileSystemStructured;
            CardFileInputStream cardFileInputStream = this;
            CardFileInputStream cardFileInputStream2 = cardFileInputStream;
            CardFileInputStream cardFileInputStream3 = cardFileInputStream;
            CardFileInputStream cardFileInputStream4 = cardFileInputStream;
            CardFileInputStream cardFileInputStream5 = cardFileInputStream;
            CardFileInputStream cardFileInputStream6 = cardFileInputStream;
            int n2 = n;
            CardFileInputStream cardFileInputStream7 = this;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = objectArray;
            Object[] objectArray4 = objectArray;
            Object[] objectArray5 = objectArray;
            CardFileInputStream cardFileInputStream8 = this;
            FileInfo[] fileInfoArray = new FileInfo[objectArray.length];
            cardFileInputStream8.path = fileInfoArray;
            int n3 = 0;
            int n4 = 0;
            int n5 = objectArray2.length;
            System.arraycopy(objectArray3, n3, fileInfoArray, n4, n5);
            int n6 = objectArray4.length;
            cardFileInputStream7.fileLength = ((FileInfo)objectArray5[n6 - 1]).getFileLength();
            cardFileInputStream3.buffer = new byte[n2];
            cardFileInputStream4.bufferLength = 0;
            cardFileInputStream5.offsetBufferInFile = 0;
            cardFileInputStream6.offsetInBuffer = 0;
            cardFileInputStream2.markedOffset = -1;
            // ** MonitorExit[v2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int fillBufferFromFile(FileInfo[] objectArray, int n, int n2) {
        CardFileInputStream cardFileInputStream = this;
        FileSystemStructured fileSystemStructured = cardFileInputStream.fs;
        synchronized (fileSystemStructured) {
            byte[] byArray;
            int n3;
            int n4;
            block14: {
                block13: {
                    if (n4 > cardFileInputStream.buffer.length) throw new IllegalArgumentException("length too big");
                    if (Arrays.equals(this.fs.getSelectedPath(), objectArray)) break block13;
                    int n5 = objectArray.length;
                    for (int k = 0; k < n5; ++k) {
                        CardFileInputStream cardFileInputStream2 = this;
                        Object object = objectArray[k];
                        cardFileInputStream2.fs.selectFile(((FileInfo)object).getFID());
                        continue;
                    }
                }
                byArray = this.fs.readBinary(n3, n4);
                if (byArray != null) break block14;
                return 0;
            }
            int n6 = 0;
            byte[] byArray2 = this.buffer;
            n3 = 0;
            n4 = byArray.length;
            System.arraycopy(byArray, n6, byArray2, n3, n4);
            return byArray.length;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() {
        v0 = this;
        var1_4 = v0.fs;
        synchronized (var1_4) {
            block16: {
                if (!Arrays.equals(v0.path, this.fs.getSelectedPath())) {
                    var2_5 = this.path;
                    var3_7 = this.path.length;
                    for (var4_8 = 0; var4_8 < var3_7; ++var4_8) {
                        var5_9 = var2_5[var4_8];
                        this.fs.selectFile(var5_9.getFID());
                    }
                }
                var2_6 = this.offsetInBuffer;
                var3_7 = this.offsetBufferInFile + var2_6;
                var4_8 = this.fileLength;
                if (var3_7 < var4_8) ** GOTO lbl19
                return -1;
lbl19:
                // 1 sources

                if (var2_6 < this.bufferLength) ** GOTO lbl42
                v1 = this;
                v2 = v1;
                v3 = v1.buffer.length;
                try {
                    var2_6 = Math.min(v3, var4_8 - var3_7);
                    try {
                        var3_7 = v2.offsetBufferInFile + this.bufferLength;
                        var4_8 = 0;
                        var5_10 = 0;
                        while (var5_10 == 0) {
                            v4 = this;
                            var5_10 = v4.fillBufferFromFile(v4.path, var3_7, var2_6);
                        }
                        v5 = this;
                        v5.offsetBufferInFile = var3_7;
                        v5.offsetInBuffer = var4_8;
                        v5.bufferLength = var5_10;
                    }
                    catch (Exception var0_1) {
                        throw new IOException("Unexpected exception", var0_1);
                    }
                    catch (CardServiceException var0_2) {
                        throw new IOException("Unexpected exception", var0_2);
                    }
lbl42:
                    // 2 sources

                    v6 = this.buffer;
                    var2_6 = this.offsetInBuffer;
                }
                catch (Throwable v7) {}
                this.offsetInBuffer = var2_6 + 1;
                return v6[var2_6] & 255;
                break block16;
                catch (CardServiceException var0_3) {
                    throw new IOException("Unexpected exception", var0_3);
                }
            }
            throw v7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long skip(long l) {
        CardFileInputStream cardFileInputStream = this;
        FileSystemStructured fileSystemStructured = cardFileInputStream.fs;
        synchronized (fileSystemStructured) {
            int n = this.offsetInBuffer;
            if (l < (long)(cardFileInputStream.bufferLength - n)) {
                this.offsetInBuffer = (int)((long)n + l);
            } else {
                this.offsetBufferInFile = (int)((long)(this.offsetBufferInFile + n) + l);
                this.offsetInBuffer = 0;
                this.bufferLength = 0;
            }
            return l;
        }
    }

    @Override
    public synchronized int available() {
        return this.bufferLength - this.offsetInBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n) {
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            int n2 = this.offsetBufferInFile + this.offsetInBuffer;
            this.markedOffset = n2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reset() {
        CardFileInputStream cardFileInputStream = this;
        FileSystemStructured fileSystemStructured = cardFileInputStream.fs;
        synchronized (fileSystemStructured) {
            int n = cardFileInputStream.markedOffset;
            if (n < 0) throw new IOException("Mark not set");
            CardFileInputStream cardFileInputStream2 = this;
            cardFileInputStream2.offsetBufferInFile = n;
            cardFileInputStream2.offsetInBuffer = 0;
            cardFileInputStream2.bufferLength = 0;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        FileSystemStructured fileSystemStructured = ((CardFileInputStream)((Object)fileSystemStructured)).fs;
        synchronized (fileSystemStructured) {
            return true;
        }
    }

    public int getLength() {
        return this.fileLength;
    }

    public int getPostion() {
        return this.offsetBufferInFile + this.offsetInBuffer;
    }
}

