/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.liveness.models;

import android.graphics.Bitmap;
import android.graphics.Rect;
import com.google.mlkit.vision.face.Face;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vn.kalapa.ekyc.liveness.InputFace;
import vn.kalapa.ekyc.liveness.LivenessSession;
import vn.kalapa.ekyc.liveness.models.LivenessActionStatus;
import vn.kalapa.ekyc.liveness.models.LivenessFacePosition;
import vn.kalapa.ekyc.utils.Helpers;

public abstract class LivenessAction {
    @NotNull
    public static final x x = new x(null);
    private static final float TOO_SMALL_WIDTH_RATIO = 0.21f;
    private static final float TOO_SMALL_HEIGHT_RATIO = 0.36f;
    private static final float TOO_BIG_WIDTH_RATIO = 0.37f;
    private static final float TOO_BIG_HEIGHT_RATIO = 0.66f;
    private static final float SMALL_ENOUGH_WIDTH_RATIO = 0.25f;
    private static final float SMALL_ENOUGH_HEIGHT_RATIO = 0.3f;
    private static final float BIG_ENOUGH_WIDTH_RATIO = 0.33f;
    private static final float BIG_ENOUGH_HEIGTH_RATIO = 0.55f;
    private static final float TOO_SMALL_RATIO = 0.3f;
    private static final float TOO_BIG_RATIO = 0.85f;
    private static final float SMALL_ENOUGH_RATIO = 0.45f;
    private static final float BIG_ENOUGH_RATIO = 0.65f;
    private static final int TOO_SMALL_WIDTH_AND_HEIGHT = 300;
    public String TAG;
    private final int MAX_NO_FACE_FRAME;
    private long startTime = System.currentTimeMillis();
    public Bitmap frame;
    public Bitmap cropFrame;
    private boolean isBreakAction;
    private int nMillis = 1500;
    @NotNull
    private LivenessActionStatus currentActionStatus = LivenessActionStatus.FAILED;
    private int timeout = 30;

    public LivenessAction() {
        this.MAX_NO_FACE_FRAME = 10;
    }

    private final boolean isNotEnoughFrame() {
        return this.nMillis != 0 && System.currentTimeMillis() - this.startTime < (long)this.nMillis;
    }

    private final List<InputFace> getFacesByTime(LivenessSession livenessSession, int n) {
        if (n == 0) {
            return CollectionsKt.listOf((Object)livenessSession.getFaceList().get(livenessSession.getFaceList().size() - 1));
        }
        if (livenessSession.getFaceList().get(livenessSession.getFaceList().size() - 1).getInputTime() - livenessSession.getFaceList().get(0).getInputTime() > (long)n) {
            LivenessSession livenessSession2 = livenessSession;
            CollectionsKt.removeAll(livenessSession2.getFaceList(), (Function1)new Function1<InputFace, Boolean>(livenessSession, n){
                public final /* synthetic */ LivenessSession $session;
                public final /* synthetic */ int $millis;
                {
                    this.$session = livenessSession;
                    this.$millis = n;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(InputFace inputFace) {
                    return this.$session.getFaceList().get(this.$session.getFaceList().size() - 1).getInputTime() - inputFace.getInputTime() >= (long)this.$millis;
                }
            });
            return livenessSession2.getFaceList();
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final String getTAG() {
        String string2 = ((LivenessAction)((Object)string2)).TAG;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"TAG");
        return null;
    }

    public final void setTAG(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.TAG = string2;
    }

    public final int getMAX_NO_FACE_FRAME() {
        return this.MAX_NO_FACE_FRAME;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long l) {
        this.startTime = l;
    }

    @NotNull
    public final Bitmap getFrame() {
        LivenessAction livenessAction = livenessAction.frame;
        if (livenessAction != null) {
            return livenessAction;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"frame");
        return null;
    }

    public final void setFrame(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"<set-?>");
        this.frame = bitmap;
    }

    @NotNull
    public final Bitmap getCropFrame() {
        LivenessAction livenessAction = livenessAction.cropFrame;
        if (livenessAction != null) {
            return livenessAction;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cropFrame");
        return null;
    }

    public final void setCropFrame(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"<set-?>");
        this.cropFrame = bitmap;
    }

    public final boolean isBreakAction() {
        return this.isBreakAction;
    }

    public final void setBreakAction(boolean bl) {
        this.isBreakAction = bl;
    }

    public final int getNMillis() {
        return this.nMillis;
    }

    public final void setNMillis(int n) {
        this.nMillis = n;
    }

    @NotNull
    public final LivenessActionStatus getCurrentActionStatus() {
        return this.currentActionStatus;
    }

    public final void setCurrentActionStatus(@NotNull LivenessActionStatus livenessActionStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)livenessActionStatus), (String)"<set-?>");
        this.currentActionStatus = livenessActionStatus;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(int n) {
        this.timeout = n;
    }

    @NotNull
    public final LivenessFacePosition getFacePosition(@NotNull Face face, @NotNull Face face2) {
        block10: {
            LivenessFacePosition livenessFacePosition;
            block4: {
                float f2;
                float f3;
                block9: {
                    block8: {
                        float f4;
                        float f5;
                        block7: {
                            block6: {
                                float f6;
                                float f7;
                                block5: {
                                    block3: {
                                        Face face3 = face;
                                        Intrinsics.checkNotNullParameter((Object)face, (String)"face1");
                                        Intrinsics.checkNotNullParameter((Object)face2, (String)"face2");
                                        f7 = face3.getHeadEulerAngleY();
                                        f3 = face3.getHeadEulerAngleZ();
                                        f5 = face.getHeadEulerAngleX();
                                        boolean bl = f3 < -15.0f || f3 > 15.0f || f5 < -15.0f || f5 > 15.0f || f7 < -15.0f || f7 > 15.0f;
                                        Face face4 = face2;
                                        f6 = face4.getHeadEulerAngleY();
                                        f2 = face4.getHeadEulerAngleZ();
                                        f4 = face2.getHeadEulerAngleX();
                                        boolean bl2 = f2 < -15.0f || f2 > 15.0f || f4 < -15.0f || f4 > 15.0f || f6 < -15.0f || f6 > 15.0f;
                                        if (bl || bl2) break block3;
                                        livenessFacePosition = LivenessFacePosition.STRAIGHT;
                                        break block4;
                                    }
                                    if (!(Math.min(f7, f6) > 15.0f)) break block5;
                                    livenessFacePosition = LivenessFacePosition.LEFT;
                                    break block4;
                                }
                                if (!(Math.max(f7, f6) < -15.0f)) break block6;
                                livenessFacePosition = LivenessFacePosition.RIGHT;
                                break block4;
                            }
                            if (!(Math.min(f5, f4) > 15.0f)) break block7;
                            livenessFacePosition = LivenessFacePosition.UP;
                            break block4;
                        }
                        if (!(Math.max(f5, f4) < -15.0f)) break block8;
                        livenessFacePosition = LivenessFacePosition.DOWN;
                        break block4;
                    }
                    if (!(Math.min(f3, f2) > 25.0f)) break block9;
                    livenessFacePosition = LivenessFacePosition.TILT_RIGHT;
                    break block4;
                }
                if (!(Math.max(f3, f2) < -25.0f)) break block10;
                livenessFacePosition = LivenessFacePosition.TILT_LEFT;
            }
            return livenessFacePosition;
        }
        return LivenessFacePosition.NOT_DETERMINE;
    }

    @NotNull
    public final LivenessFacePosition getFacePosition(@NotNull Face face) {
        Face face2 = face;
        Intrinsics.checkNotNullParameter((Object)face2, (String)"face1");
        float f2 = face2.getHeadEulerAngleY();
        float f3 = face2.getHeadEulerAngleZ();
        float f4 = face.getHeadEulerAngleX();
        return !(f3 < -15.0f || f3 > 15.0f || f4 < -15.0f || f4 > 15.0f || f2 < -15.0f || f2 > 15.0f) ? LivenessFacePosition.STRAIGHT : (f2 > 25.0f ? LivenessFacePosition.LEFT : (f2 < -25.0f ? LivenessFacePosition.RIGHT : (f4 > 15.0f ? LivenessFacePosition.UP : (f4 < -15.0f ? LivenessFacePosition.DOWN : (f3 > 25.0f ? LivenessFacePosition.TILT_RIGHT : (f3 < -25.0f ? LivenessFacePosition.TILT_LEFT : LivenessFacePosition.NOT_DETERMINE))))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEyesClosed(@NotNull Face face) {
        Face face2 = face;
        Intrinsics.checkNotNullParameter((Object)face2, (String)"face");
        if (face2.getRightEyeOpenProbability() == null) return true;
        Float f2 = face.getRightEyeOpenProbability();
        Intrinsics.checkNotNull((Object)f2);
        if (f2.floatValue() < 0.1f) return true;
        if (face.getLeftEyeOpenProbability() == null) return true;
        Float f3 = face.getLeftEyeOpenProbability();
        Intrinsics.checkNotNull((Object)f3);
        if (!(f3.floatValue() < 0.1f)) return false;
        return true;
    }

    @NotNull
    public abstract LivenessActionStatus individualProcess(@NotNull LivenessSession var1, @NotNull List<InputFace> var2);

    @NotNull
    public final LivenessActionStatus process(@NotNull LivenessSession livenessSession) {
        Intrinsics.checkNotNullParameter((Object)livenessSession, (String)"session");
        if (object.isBreakAction) {
            return LivenessActionStatus.SUCCESS;
        }
        if (object.isNotEnoughFrame()) {
            object.currentActionStatus = LivenessActionStatus.FAILED;
            return object.currentActionStatus;
        }
        if (System.currentTimeMillis() - object.startTime > (long)(object.timeout * 1000)) {
            object.currentActionStatus = LivenessActionStatus.TIMEOUT;
            return object.currentActionStatus;
        }
        List<InputFace> list = object.getFacesByTime(livenessSession, object.nMillis);
        if (list.size() < 2) {
            Object object;
            if (object.nMillis == 0 && list.size() == 1) {
                object = object.individualProcess(livenessSession, list);
                ((LivenessAction)v0).currentActionStatus = object;
            } else {
                LivenessAction livenessAction = object;
                object = LivenessActionStatus.FAILED;
                livenessAction.currentActionStatus = object;
            }
            return object;
        }
        Object[] objectArray = new Object[1];
        int n = object.nMillis;
        objectArray[0] = JvmClassMappingKt.getKotlinClass(object.getClass()).getSimpleName() + " is processing... nSeconds " + n + " face.size " + list.size();
        Helpers.Companion.printLog(objectArray);
        object.currentActionStatus = object.individualProcess(livenessSession, list);
        return object.currentActionStatus;
    }

    public static final class x {
        private x() {
        }

        public /* synthetic */ x(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final float getTOO_SMALL_WIDTH_RATIO() {
            return TOO_SMALL_WIDTH_RATIO;
        }

        public final float getTOO_SMALL_HEIGHT_RATIO() {
            return TOO_SMALL_HEIGHT_RATIO;
        }

        public final float getTOO_BIG_WIDTH_RATIO() {
            return TOO_BIG_WIDTH_RATIO;
        }

        public final float getTOO_BIG_HEIGHT_RATIO() {
            return TOO_BIG_HEIGHT_RATIO;
        }

        public final float getSMALL_ENOUGH_WIDTH_RATIO() {
            return SMALL_ENOUGH_WIDTH_RATIO;
        }

        public final float getSMALL_ENOUGH_HEIGHT_RATIO() {
            return SMALL_ENOUGH_HEIGHT_RATIO;
        }

        public final float getBIG_ENOUGH_WIDTH_RATIO() {
            return BIG_ENOUGH_WIDTH_RATIO;
        }

        public final float getBIG_ENOUGH_HEIGTH_RATIO() {
            return BIG_ENOUGH_HEIGTH_RATIO;
        }

        public final float getTOO_SMALL_RATIO() {
            return TOO_SMALL_RATIO;
        }

        public final float getTOO_BIG_RATIO() {
            return TOO_BIG_RATIO;
        }

        public final float getSMALL_ENOUGH_RATIO() {
            return SMALL_ENOUGH_RATIO;
        }

        public final float getBIG_ENOUGH_RATIO() {
            return BIG_ENOUGH_RATIO;
        }

        public final int getTOO_SMALL_WIDTH_AND_HEIGHT() {
            return TOO_SMALL_WIDTH_AND_HEIGHT;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isFaceTooSmall(@NotNull InputFace inputFace) {
            InputFace inputFace2 = inputFace;
            Intrinsics.checkNotNullParameter((Object)inputFace2, (String)"face");
            int n = Math.min(inputFace2.getFrameWidth(), inputFace.getFrameHeight());
            int n2 = Math.max(inputFace2.getFrameWidth(), inputFace.getFrameHeight());
            Rect rect = inputFace2.getFace().getBoundingBox();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"face.face.boundingBox");
            float f2 = n;
            if ((float)rect.width() < this.getTOO_SMALL_RATIO() * f2) return true;
            float f3 = n2;
            if ((float)rect.height() < this.getTOO_SMALL_RATIO() * f3) {
                return true;
            }
            boolean bl = false;
            if (bl) return bl;
            Helpers.Companion.printLog("isFaceTooSmall " + rect.width() + " < " + n + " " + rect.height() + " < " + n2);
            return bl;
        }

        public final boolean isFaceLookStraight(@NotNull Face face) {
            Face face2 = face;
            Intrinsics.checkNotNullParameter((Object)face2, (String)"face");
            float f2 = face2.getHeadEulerAngleY();
            float f3 = face2.getHeadEulerAngleZ();
            float f4 = face.getHeadEulerAngleX();
            boolean bl = f3 < -15.0f || f3 > 15.0f || f4 < -15.0f || f4 > 15.0f || f2 < -15.0f || f2 > 15.0f;
            return bl ^ true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isFaceTooBig(@NotNull InputFace inputFace) {
            InputFace inputFace2 = inputFace;
            Intrinsics.checkNotNullParameter((Object)inputFace2, (String)"face");
            int n = Math.min(inputFace2.getFrameWidth(), inputFace.getFrameHeight());
            int n2 = Math.max(inputFace2.getFrameWidth(), inputFace.getFrameHeight());
            Rect rect = inputFace2.getFace().getBoundingBox();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"face.face.boundingBox");
            float f2 = n;
            if ((float)rect.width() > this.getTOO_BIG_RATIO() * f2) return true;
            float f3 = n2;
            if (!((float)rect.height() > this.getTOO_BIG_RATIO() * f3)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isFaceSmallEnough(@NotNull InputFace inputFace) {
            InputFace inputFace2 = inputFace;
            Intrinsics.checkNotNullParameter((Object)inputFace2, (String)"face");
            int n = Math.min(inputFace2.getFrameWidth(), inputFace.getFrameHeight());
            int n2 = Math.max(inputFace2.getFrameWidth(), inputFace.getFrameHeight());
            Rect rect = inputFace2.getFace().getBoundingBox();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"face.face.boundingBox");
            float f2 = n;
            if ((float)rect.width() < this.getSMALL_ENOUGH_RATIO() * f2) return true;
            float f3 = n2;
            if (!((float)rect.height() < this.getSMALL_ENOUGH_RATIO() * f3)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isFaceSizeJustBiggerThanTooSmall(@NotNull InputFace inputFace) {
            InputFace inputFace2 = inputFace;
            Intrinsics.checkNotNullParameter((Object)inputFace2, (String)"face");
            int n = Math.min(inputFace2.getFrameWidth(), inputFace.getFrameHeight());
            int n2 = Math.max(inputFace2.getFrameWidth(), inputFace.getFrameHeight());
            Rect rect = inputFace2.getFace().getBoundingBox();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"face.face.boundingBox");
            float f2 = n;
            if ((float)rect.width() > this.getTOO_SMALL_RATIO() * f2) return true;
            float f3 = n2;
            if (!((float)rect.height() > this.getTOO_SMALL_RATIO() * f3)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isFaceBigEnough(@NotNull InputFace inputFace) {
            InputFace inputFace2 = inputFace;
            Intrinsics.checkNotNullParameter((Object)inputFace2, (String)"face");
            int n = Math.min(inputFace2.getFrameWidth(), inputFace.getFrameHeight());
            int n2 = Math.max(inputFace2.getFrameWidth(), inputFace.getFrameHeight());
            Rect rect = inputFace2.getFace().getBoundingBox();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"face.face.boundingBox");
            float f2 = n;
            if ((float)rect.width() > this.getBIG_ENOUGH_RATIO() * f2) return true;
            float f3 = n2;
            if (!((float)rect.height() > this.getBIG_ENOUGH_RATIO() * f3)) return false;
            return true;
        }

        public final boolean isFaceMarginRight(@NotNull Face face, int n, int n2) {
            int n3;
            Face face2 = face;
            Intrinsics.checkNotNullParameter((Object)face2, (String)"face");
            x x2 = face2.getBoundingBox();
            Intrinsics.checkNotNullExpressionValue((Object)x2, (String)"face.boundingBox");
            int n4 = ((Rect)x2).top;
            float f2 = n2;
            n4 = !((float)n4 <= f2 * 0.15f) && n4 > 50 && !((float)(n4 = ((Rect)x2).bottom) >= f2 * 0.95f) && n4 < n2 - 25 ? 0 : 1;
            n2 = ((Rect)x2).left;
            f2 = n;
            return !((float)n2 <= f2 * 0.05f || n2 <= 25 || (float)(n3 = ((Rect)x2).right) >= f2 * 0.95f || n3 >= n - 25) && n4 == 0;
        }
    }
}

