/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERGeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERUTF8String;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.util.Date;

public class ObjectData
extends ASN1Object {
    private final BigInteger type;
    private final String identifier;
    private final ASN1GeneralizedTime creationDate;
    private final ASN1GeneralizedTime lastModifiedDate;
    private final ASN1OctetString data;
    private final String comment;

    private ObjectData(ASN1Sequence object) {
        this.type = ASN1Integer.getInstance(((ASN1Sequence)object).getObjectAt(0)).getValue();
        this.identifier = DERUTF8String.getInstance(((ASN1Sequence)object).getObjectAt(1)).getString();
        this.creationDate = ASN1GeneralizedTime.getInstance(((ASN1Sequence)object).getObjectAt(2));
        this.lastModifiedDate = ASN1GeneralizedTime.getInstance(((ASN1Sequence)object).getObjectAt(3));
        this.data = ASN1OctetString.getInstance(((ASN1Sequence)object).getObjectAt(4));
        object = ((ASN1Sequence)object).size() == 6 ? DERUTF8String.getInstance(((ASN1Sequence)object).getObjectAt(5)).getString() : null;
        this.comment = object;
    }

    public ObjectData(BigInteger bigInteger, String string, Date date, Date date2, byte[] byArray, String string2) {
        ObjectData objectData = this;
        this.type = bigInteger;
        objectData.identifier = string;
        objectData.creationDate = new DERGeneralizedTime(date);
        objectData.lastModifiedDate = new DERGeneralizedTime(date2);
        objectData.data = new DEROctetString(Arrays.clone(byArray));
        this.comment = string2;
    }

    public static ObjectData getInstance(Object object) {
        if (object instanceof ObjectData) {
            return (ObjectData)object;
        }
        if (object != null) {
            return new ObjectData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public String getComment() {
        return this.comment;
    }

    public ASN1GeneralizedTime getCreationDate() {
        return this.creationDate;
    }

    public byte[] getData() {
        return Arrays.clone(this.data.getOctets());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ASN1GeneralizedTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public BigInteger getType() {
        return this.type;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector3(6);
        aSN1EncodableVector3.add(new ASN1Integer(((ObjectData)((Object)string)).type));
        aSN1EncodableVector3.add(new DERUTF8String(((ObjectData)((Object)string)).identifier));
        aSN1EncodableVector2.add(((ObjectData)((Object)string)).creationDate);
        aSN1EncodableVector2.add(((ObjectData)((Object)string)).lastModifiedDate);
        aSN1EncodableVector.add(((ObjectData)((Object)string)).data);
        String string = ((ObjectData)((Object)string)).comment;
        if (string != null) {
            DERUTF8String dERUTF8String;
            DERUTF8String dERUTF8String2 = dERUTF8String;
            dERUTF8String = new DERUTF8String(string);
            aSN1EncodableVector2.add(dERUTF8String2);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

