/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class DSTU7564Digest
implements ExtendedDigest,
Memoable {
    private static final int NB_512 = 8;
    private static final int NB_1024 = 16;
    private static final int NR_512 = 10;
    private static final int NR_1024 = 14;
    private static final byte[] S0 = new byte[]{-88, 67, 95, 6, 107, 117, 108, 89, 113, -33, -121, -107, 23, -16, -40, 9, 109, -13, 29, -53, -55, 77, 44, -81, 121, -32, -105, -3, 111, 75, 69, 57, 62, -35, -93, 79, -76, -74, -102, 14, 31, -65, 21, -31, 73, -46, -109, -58, -110, 114, -98, 97, -47, 99, -6, -18, -12, 25, -43, -83, 88, -92, -69, -95, -36, -14, -125, 55, 66, -28, 122, 50, -100, -52, -85, 74, -113, 110, 4, 39, 46, -25, -30, 90, -106, 22, 35, 43, -62, 101, 102, 15, -68, -87, 71, 65, 52, 72, -4, -73, 106, -120, -91, 83, -122, -7, 91, -37, 56, 123, -61, 30, 34, 51, 36, 40, 54, -57, -78, 59, -114, 119, -70, -11, 20, -97, 8, 85, -101, 76, -2, 96, 92, -38, 24, 70, -51, 125, 33, -80, 63, 27, -119, -1, -21, -124, 105, 58, -99, -41, -45, 112, 103, 64, -75, -34, 93, 48, -111, -79, 120, 17, 1, -27, 0, 104, -104, -96, -59, 2, -90, 116, 45, 11, -94, 118, -77, -66, -50, -67, -82, -23, -118, 49, 28, -20, -15, -103, -108, -86, -10, 38, 47, -17, -24, -116, 53, 3, -44, 127, -5, 5, -63, 94, -112, 32, 61, -126, -9, -22, 10, 13, 126, -8, 80, 26, -60, 7, 87, -72, 60, 98, -29, -56, -84, 82, 100, 16, -48, -39, 19, 12, 18, 41, 81, -71, -49, -42, 115, -115, -127, 84, -64, -19, 78, 68, -89, 42, -123, 37, -26, -54, 124, -117, 86, -128};
    private static final byte[] S1 = new byte[]{-50, -69, -21, -110, -22, -53, 19, -63, -23, 58, -42, -78, -46, -112, 23, -8, 66, 21, 86, -76, 101, 28, -120, 67, -59, 92, 54, -70, -11, 87, 103, -115, 49, -10, 100, 88, -98, -12, 34, -86, 117, 15, 2, -79, -33, 109, 115, 77, 124, 38, 46, -9, 8, 93, 68, 62, -97, 20, -56, -82, 84, 16, -40, -68, 26, 107, 105, -13, -67, 51, -85, -6, -47, -101, 104, 78, 22, -107, -111, -18, 76, 99, -114, 91, -52, 60, 25, -95, -127, 73, 123, -39, 111, 55, 96, -54, -25, 43, 72, -3, -106, 69, -4, 65, 18, 13, 121, -27, -119, -116, -29, 32, 48, -36, -73, 108, 74, -75, 63, -105, -44, 98, 45, 6, -92, -91, -125, 95, 42, -38, -55, 0, 126, -94, 85, -65, 17, -43, -100, -49, 14, 10, 61, 81, 125, -109, 27, -2, -60, 71, 9, -122, 11, -113, -99, 106, 7, -71, -80, -104, 24, 50, 113, 75, -17, 59, 112, -96, -28, 64, -1, -61, -87, -26, 120, -7, -117, 70, -128, 30, 56, -31, -72, -88, -32, 12, 35, 118, 29, 37, 36, 5, -15, 110, -108, 40, -102, -124, -24, -93, 79, 119, -45, -123, -30, 82, -14, -126, 80, 122, 47, 116, 83, -77, 97, -81, 57, 53, -34, -51, 31, -103, -84, -83, 114, 44, -35, -48, -121, -66, 94, -90, -20, 4, -58, 3, 52, -5, -37, 89, -74, -62, 1, -16, 90, -19, -89, 102, 33, 127, -118, 39, -57, -64, 41, -41};
    private static final byte[] S2 = new byte[]{-109, -39, -102, -75, -104, 34, 69, -4, -70, 106, -33, 2, -97, -36, 81, 89, 74, 23, 43, -62, -108, -12, -69, -93, 98, -28, 113, -44, -51, 112, 22, -31, 73, 60, -64, -40, 92, -101, -83, -123, 83, -95, 122, -56, 45, -32, -47, 114, -90, 44, -60, -29, 118, 120, -73, -76, 9, 59, 14, 65, 76, -34, -78, -112, 37, -91, -41, 3, 17, 0, -61, 46, -110, -17, 78, 18, -99, 125, -53, 53, 16, -43, 79, -98, 77, -87, 85, -58, -48, 123, 24, -105, -45, 54, -26, 72, 86, -127, -113, 119, -52, -100, -71, -30, -84, -72, 47, 21, -92, 124, -38, 56, 30, 11, 5, -42, 20, 110, 108, 126, 102, -3, -79, -27, 96, -81, 94, 51, -121, -55, -16, 93, 109, 63, -120, -115, -57, -9, 29, -23, -20, -19, -128, 41, 39, -49, -103, -88, 80, 15, 55, 36, 40, 48, -107, -46, 62, 91, 64, -125, -77, 105, 87, 31, 7, 28, -118, -68, 32, -21, -50, -114, -85, -18, 49, -94, 115, -7, -54, 58, 26, -5, 13, -63, -2, -6, -14, 111, -67, -106, -35, 67, 82, -74, 8, -13, -82, -66, 25, -119, 50, 38, -80, -22, 75, 100, -124, -126, 107, -11, 121, -65, 1, 95, 117, 99, 27, 35, 61, 104, 42, 101, -24, -111, -10, -1, 19, 88, -15, 71, 10, 127, -59, -89, -25, 97, 90, 6, 70, 68, 66, 4, -96, -37, 57, -122, 84, -86, -116, 52, 33, -117, -8, 12, 116, 103};
    private static final byte[] S3 = new byte[]{104, -115, -54, 77, 115, 75, 78, 42, -44, 82, 38, -77, 84, 30, 25, 31, 34, 3, 70, 61, 45, 74, 83, -125, 19, -118, -73, -43, 37, 121, -11, -67, 88, 47, 13, 2, -19, 81, -98, 17, -14, 62, 85, 94, -47, 22, 60, 102, 112, 93, -13, 69, 64, -52, -24, -108, 86, 8, -50, 26, 58, -46, -31, -33, -75, 56, 110, 14, -27, -12, -7, -122, -23, 79, -42, -123, 35, -49, 50, -103, 49, 20, -82, -18, -56, 72, -45, 48, -95, -110, 65, -79, 24, -60, 44, 113, 114, 68, 21, -3, 55, -66, 95, -86, -101, -120, -40, -85, -119, -100, -6, 96, -22, -68, 98, 12, 36, -90, -88, -20, 103, 32, -37, 124, 40, -35, -84, 91, 52, 126, 16, -15, 123, -113, 99, -96, 5, -102, 67, 119, 33, -65, 39, 9, -61, -97, -74, -41, 41, -62, -21, -64, -92, -117, -116, 29, -5, -1, -63, -78, -105, 46, -8, 101, -10, 117, 7, 4, 73, 51, -28, -39, -71, -48, 66, -57, 108, -112, 0, -114, 111, 80, 1, -59, -38, 71, 63, -51, 105, -94, -30, 122, -89, -58, -109, 15, 10, 6, -26, 43, -106, -93, 28, -81, 106, 18, -124, 57, -25, -80, -126, -9, -2, -99, -121, 92, -127, 53, -34, -76, -91, -4, -128, -17, -53, -69, 107, 118, -70, 90, 125, 120, 11, -107, -29, -83, 116, -104, 59, 54, 100, 109, -36, -16, 89, -87, 76, 23, 127, -111, -72, -55, 87, 27, -32, 97};
    private int hashSize;
    private int blockSize;
    private int columns;
    private int rounds;
    private long[] state;
    private long[] tempState1;
    private long[] tempState2;
    private long inputBlocks;
    private int bufOff;
    private byte[] buf;

    public DSTU7564Digest(DSTU7564Digest dSTU7564Digest) {
        DSTU7564Digest dSTU7564Digest2 = this;
        dSTU7564Digest2.copyIn(dSTU7564Digest);
    }

    private void copyIn(DSTU7564Digest dSTU7564Digest) {
        this.hashSize = dSTU7564Digest.hashSize;
        this.blockSize = dSTU7564Digest.blockSize;
        this.rounds = dSTU7564Digest.rounds;
        int n = this.columns;
        if (n > 0 && n == dSTU7564Digest.columns) {
            DSTU7564Digest dSTU7564Digest2 = dSTU7564Digest;
            System.arraycopy(dSTU7564Digest2.state, 0, this.state, 0, n);
            DSTU7564Digest dSTU7564Digest3 = this;
            byte[] byArray = dSTU7564Digest3.buf;
            int n2 = dSTU7564Digest3.blockSize;
            System.arraycopy(dSTU7564Digest2.buf, 0, byArray, 0, n2);
        } else {
            this.columns = dSTU7564Digest.columns;
            this.state = Arrays.clone(dSTU7564Digest.state);
            n = this.columns;
            this.tempState1 = new long[n];
            this.tempState2 = new long[n];
            this.buf = Arrays.clone(dSTU7564Digest.buf);
        }
        this.inputBlocks = dSTU7564Digest.inputBlocks;
        this.bufOff = dSTU7564Digest.bufOff;
    }

    public DSTU7564Digest(int n) {
        long l;
        int n2;
        if (n != 256 && n != 384 && n != 512) {
            throw new IllegalArgumentException("Hash size is not recommended. Use 256/384/512 instead");
        }
        this.hashSize = n >>> 3;
        if (n > 256) {
            DSTU7564Digest dSTU7564Digest = this;
            dSTU7564Digest.columns = 16;
            dSTU7564Digest.rounds = 14;
        } else {
            DSTU7564Digest dSTU7564Digest = this;
            dSTU7564Digest.columns = 8;
            dSTU7564Digest.rounds = 10;
        }
        n = this.columns;
        this.blockSize = n2 = n << 3;
        long[] lArray = new long[n];
        long[] lArray2 = lArray;
        this.state = lArray2;
        lArray[0] = l = (long)n2;
        this.tempState1 = new long[n];
        this.tempState2 = new long[n];
        this.buf = new byte[n2];
    }

    private void processBlock(byte[] byArray, int n) {
        for (int k = 0; k < this.columns; ++k) {
            DSTU7564Digest dSTU7564Digest = this;
            long l = Pack.littleEndianToLong(byArray, n);
            n += 8;
            dSTU7564Digest.tempState1[k] = this.state[k] ^ l;
            dSTU7564Digest.tempState2[k] = l;
        }
        DSTU7564Digest dSTU7564Digest = this;
        dSTU7564Digest.P(dSTU7564Digest.tempState1);
        dSTU7564Digest.Q(dSTU7564Digest.tempState2);
        for (int k = 0; k < this.columns; ++k) {
            this.state[k] = this.state[k] ^ (this.tempState1[k] ^ this.tempState2[k]);
        }
    }

    private void P(long[] lArray) {
        for (int k = 0; k < this.rounds; ++k) {
            long l = k;
            for (int i2 = 0; i2 < this.columns; ++i2) {
                lArray[i2] = lArray[i2] ^ l;
                l += 16L;
            }
            DSTU7564Digest dSTU7564Digest = this;
            dSTU7564Digest.shiftRows(lArray);
            dSTU7564Digest.subBytes(lArray);
            dSTU7564Digest.mixColumns(lArray);
        }
    }

    private void Q(long[] lArray) {
        for (int k = 0; k < this.rounds; ++k) {
            long l = (long)(this.columns - 1 << 4 ^ k) << 56 | 0xF0F0F0F0F0F0F3L;
            for (int i2 = 0; i2 < this.columns; ++i2) {
                lArray[i2] = lArray[i2] + l;
                l -= 0x1000000000000000L;
            }
            DSTU7564Digest dSTU7564Digest = this;
            dSTU7564Digest.shiftRows(lArray);
            dSTU7564Digest.subBytes(lArray);
            dSTU7564Digest.mixColumns(lArray);
        }
    }

    private static long mixColumn(long l) {
        long l2 = (l & 0x7F7F7F7F7F7F7F7FL) << 1 ^ ((l & 0x8080808080808080L) >>> 7) * 29L;
        long l3 = DSTU7564Digest.rotate(8, l) ^ l;
        long l4 = l3 ^ DSTU7564Digest.rotate(16, l3) ^ DSTU7564Digest.rotate(48, l);
        l = l4 ^ l ^ l2;
        l = (l & 0x3F3F3F3F3F3F3F3FL) << 2 ^ ((l & 0x8080808080808080L) >>> 6) * 29L ^ ((l & 0x4040404040404040L) >>> 6) * 29L;
        return l4 ^ DSTU7564Digest.rotate(32, l) ^ DSTU7564Digest.rotate(40, l2) ^ DSTU7564Digest.rotate(48, l2);
    }

    private void mixColumns(long[] lArray) {
        for (int k = 0; k < this.columns; ++k) {
            lArray[k] = DSTU7564Digest.mixColumn(lArray[k]);
        }
    }

    private static long rotate(int n, long l) {
        return l >>> n | l << -n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void shiftRows(long[] lArray) {
        int n = this.columns;
        if (n != 8) {
            if (n != 16) throw new IllegalStateException("unsupported state size: only 512/1024 are allowed");
            long[] lArray2 = lArray;
            long[] lArray3 = lArray;
            long l = lArray2[0];
            long l2 = lArray3[1];
            long l3 = lArray2[2];
            long l4 = lArray3[3];
            long l5 = lArray2[4];
            long l6 = lArray3[5];
            long l7 = lArray2[6];
            long l8 = lArray3[7];
            long l9 = lArray2[8];
            long l10 = lArray3[9];
            long l11 = lArray2[10];
            long l12 = lArray3[11];
            long l13 = lArray2[12];
            long l14 = lArray3[13];
            long l15 = lArray2[14];
            long l16 = lArray3[15];
            long l17 = l16;
            long l18 = l8;
            long l19 = l7;
            long l20 = l6;
            long l21 = l5;
            long l22 = l4;
            long l23 = l3;
            long l24 = l2;
            long l25 = l;
            l = (l25 ^ l9) & 0xFF00000000000000L;
            l2 = l25 ^ l;
            l = l9 ^ l;
            l3 = (l24 ^ l10) & 0xFF00000000000000L;
            l4 = l24 ^ l3;
            l3 = l10 ^ l3;
            l5 = (l23 ^ l11) & 0xFFFF000000000000L;
            l6 = l23 ^ l5;
            l5 = l11 ^ l5;
            l7 = (l22 ^ l12) & 0xFFFFFF0000000000L;
            l8 = l22 ^ l7;
            l7 = l12 ^ l7;
            l9 = (l21 ^ l13) & 0xFFFFFFFF00000000L;
            l10 = l21 ^ l9;
            l9 = l13 ^ l9;
            l11 = (l20 ^ l14) & 0xFFFFFFFF000000L;
            l12 = l20 ^ l11;
            l11 = l14 ^ l11;
            l13 = (l19 ^ l15) & 0xFFFFFFFFFF0000L;
            l14 = l19 ^ l13;
            l13 = l15 ^ l13;
            l15 = (l18 ^ l17) & 0xFFFFFFFFFFFF00L;
            l17 = l18 ^ l15;
            long l26 = l16 ^ l15;
            l15 = l26;
            long l27 = l7;
            long l28 = l13;
            long l29 = l5;
            long l30 = l11;
            long l31 = l3;
            long l32 = l9;
            long l33 = l;
            long l34 = l8;
            long l35 = l6;
            long l36 = l4;
            long l37 = l2;
            l = (l37 ^ l10) & 0xFFFFFF00000000L;
            l2 = l37 ^ l;
            l = l10 ^ l;
            l3 = (l36 ^ l12) & 0xFFFFFFFFFF000000L;
            l4 = l36 ^ l3;
            l3 = l12 ^ l3;
            l5 = (l35 ^ l14) & 0xFF00FFFFFFFF0000L;
            l6 = l35 ^ l5;
            l5 = l14 ^ l5;
            l7 = (l34 ^ l17) & 0xFF0000FFFFFFFF00L;
            l8 = l34 ^ l7;
            l7 = l17 ^ l7;
            l9 = (l33 ^ l9) & 0xFFFFFF00000000L;
            l10 = l33 ^ l9;
            l9 = l32 ^ l9;
            l11 = (l31 ^ l11) & 0xFFFFFFFFFF000000L;
            l12 = l31 ^ l11;
            l11 = l30 ^ l11;
            l13 = (l29 ^ l13) & 0xFF00FFFFFFFF0000L;
            l14 = l29 ^ l13;
            l13 = l28 ^ l13;
            l15 = (l27 ^ l15) & 0xFF0000FFFFFFFF00L;
            l17 = l27 ^ l15;
            long l38 = l26 ^ l15;
            l15 = l38;
            long l39 = l11;
            long l40 = l13;
            long l41 = l9;
            long l42 = l12;
            long l43 = l10;
            long l44 = l7;
            long l45 = l3;
            long l46 = l5;
            long l47 = l;
            long l48 = l4;
            long l49 = l2;
            l = (l49 ^ l6) & 0xFFFF0000FFFF0000L;
            l2 = l49 ^ l;
            l = l6 ^ l;
            l3 = (l48 ^ l8) & 0xFFFF0000FFFF00L;
            l4 = l48 ^ l3;
            l3 = l8 ^ l3;
            l5 = (l47 ^ l5) & 0xFFFF0000FFFF0000L;
            l6 = l47 ^ l5;
            l5 = l46 ^ l5;
            l7 = (l45 ^ l7) & 0xFFFF0000FFFF00L;
            l8 = l45 ^ l7;
            l7 = l44 ^ l7;
            l9 = (l43 ^ l14) & 0xFFFF0000FFFF0000L;
            l10 = l43 ^ l9;
            l9 = l14 ^ l9;
            l11 = (l42 ^ l17) & 0xFFFF0000FFFF00L;
            l12 = l42 ^ l11;
            l11 = l17 ^ l11;
            l13 = (l41 ^ l13) & 0xFFFF0000FFFF0000L;
            l14 = l41 ^ l13;
            l13 = l40 ^ l13;
            l15 = (l39 ^ l15) & 0xFFFF0000FFFF00L;
            l17 = l39 ^ l15;
            long l50 = l38 ^ l15;
            l15 = l50;
            long l51 = l13;
            long l52 = l14;
            long l53 = l11;
            long l54 = l9;
            long l55 = l10;
            long l56 = l7;
            long l57 = l5;
            long l58 = l6;
            long l59 = l3;
            long l60 = l;
            long l61 = l2;
            l = (l61 ^ l4) & 0xFF00FF00FF00FF00L;
            l2 = l61 ^ l;
            l = l4 ^ l;
            l3 = (l60 ^ l3) & 0xFF00FF00FF00FF00L;
            l4 = l60 ^ l3;
            l3 = l59 ^ l3;
            l5 = (l58 ^ l8) & 0xFF00FF00FF00FF00L;
            l6 = l58 ^ l5;
            l5 = l8 ^ l5;
            l7 = (l57 ^ l7) & 0xFF00FF00FF00FF00L;
            l8 = l57 ^ l7;
            l7 = l56 ^ l7;
            l9 = (l55 ^ l12) & 0xFF00FF00FF00FF00L;
            l10 = l55 ^ l9;
            l9 = l12 ^ l9;
            l11 = (l54 ^ l11) & 0xFF00FF00FF00FF00L;
            l12 = l54 ^ l11;
            l11 = l53 ^ l11;
            l13 = (l52 ^ l17) & 0xFF00FF00FF00FF00L;
            l14 = l52 ^ l13;
            l13 = l17 ^ l13;
            l15 = (l51 ^ l15) & 0xFF00FF00FF00FF00L;
            l17 = l51 ^ l15;
            l15 = l50 ^ l15;
            lArray2[0] = l2;
            lArray3[1] = l;
            lArray2[2] = l4;
            lArray3[3] = l3;
            lArray2[4] = l6;
            lArray3[5] = l5;
            lArray2[6] = l8;
            lArray3[7] = l7;
            lArray2[8] = l10;
            lArray3[9] = l9;
            lArray2[10] = l12;
            lArray3[11] = l11;
            lArray2[12] = l14;
            lArray3[13] = l13;
            lArray2[14] = l17;
            lArray3[15] = l15;
            return;
        } else {
            long[] lArray4 = lArray;
            long[] lArray5 = lArray;
            long l = lArray4[0];
            long l62 = lArray5[1];
            long l63 = lArray4[2];
            long l64 = lArray5[3];
            long l65 = lArray4[4];
            long l66 = lArray5[5];
            long l67 = lArray4[6];
            long l68 = lArray5[7];
            long l69 = l68;
            long l70 = l64;
            long l71 = l63;
            long l72 = l62;
            long l73 = l;
            l = (l73 ^ l65) & 0xFFFFFFFF00000000L;
            l62 = l73 ^ l;
            l = l65 ^ l;
            l63 = (l72 ^ l66) & 0xFFFFFFFF000000L;
            l64 = l72 ^ l63;
            l63 = l66 ^ l63;
            l65 = (l71 ^ l67) & 0xFFFFFFFF0000L;
            l66 = l71 ^ l65;
            l65 = l67 ^ l65;
            l67 = (l70 ^ l69) & 0xFFFFFFFF00L;
            l69 = l70 ^ l67;
            long l74 = l68 ^ l67;
            l67 = l74;
            long l75 = l63;
            long l76 = l65;
            long l77 = l;
            long l78 = l64;
            long l79 = l62;
            l = (l79 ^ l66) & 0xFFFF0000FFFF0000L;
            l62 = l79 ^ l;
            l = l66 ^ l;
            l63 = (l78 ^ l69) & 0xFFFF0000FFFF00L;
            l64 = l78 ^ l63;
            l63 = l69 ^ l63;
            l65 = (l77 ^ l65) & 0xFFFF0000FFFF0000L;
            l66 = l77 ^ l65;
            l65 = l76 ^ l65;
            l67 = (l75 ^ l67) & 0xFFFF0000FFFF00L;
            l69 = l75 ^ l67;
            long l80 = l74 ^ l67;
            l67 = l80;
            long l81 = l65;
            long l82 = l66;
            long l83 = l63;
            long l84 = l;
            long l85 = l62;
            l = (l85 ^ l64) & 0xFF00FF00FF00FF00L;
            l62 = l85 ^ l;
            l = l64 ^ l;
            l63 = (l84 ^ l63) & 0xFF00FF00FF00FF00L;
            l64 = l84 ^ l63;
            l63 = l83 ^ l63;
            l65 = (l82 ^ l69) & 0xFF00FF00FF00FF00L;
            l66 = l82 ^ l65;
            l65 = l69 ^ l65;
            l67 = (l81 ^ l67) & 0xFF00FF00FF00FF00L;
            l69 = l81 ^ l67;
            l67 = l80 ^ l67;
            lArray4[0] = l62;
            lArray5[1] = l;
            lArray4[2] = l64;
            lArray5[3] = l63;
            lArray4[4] = l66;
            lArray5[5] = l65;
            lArray4[6] = l69;
            lArray5[7] = l67;
        }
    }

    private void subBytes(long[] lArray) {
        for (int k = 0; k < this.columns; ++k) {
            long l = lArray[k];
            int n = (int)l;
            int n2 = (int)(l >>> 32);
            byte by = S0[n & 0xFF];
            byte[] byArray = S1;
            byte by2 = S1[n >>> 8 & 0xFF];
            byte[] byArray2 = S2;
            byte by3 = S2[n >>> 16 & 0xFF];
            byte[] byArray3 = S3;
            n = S3[n >>> 24];
            n = by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | n << 24;
            byte by4 = S0[n2 & 0xFF];
            int n3 = n2;
            int n4 = n2;
            n2 = byArray[n2 >>> 8 & 0xFF];
            byte by5 = byArray2[n4 >>> 16 & 0xFF];
            by2 = byArray3[n3 >>> 24];
            n2 = by4 & 0xFF | (n2 & 0xFF) << 8 | (by5 & 0xFF) << 16 | by2 << 24;
            lArray[k] = (long)n & 0xFFFFFFFFL | (long)n2 << 32;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7564";
    }

    @Override
    public int getDigestSize() {
        return this.hashSize;
    }

    @Override
    public int getByteLength() {
        return this.blockSize;
    }

    @Override
    public void update(byte by) {
        int n;
        DSTU7564Digest dSTU7564Digest = this;
        byte[] byArray = dSTU7564Digest.buf;
        int n2 = dSTU7564Digest.bufOff;
        this.bufOff = n = n2 + 1;
        byArray[n2] = by;
        if (n == this.blockSize) {
            DSTU7564Digest dSTU7564Digest2 = this;
            dSTU7564Digest2.processBlock(byArray, 0);
            dSTU7564Digest2.bufOff = 0;
            ++dSTU7564Digest2.inputBlocks;
        }
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        while (this.bufOff != 0 && n2 > 0) {
            this.update(byArray[n++]);
            --n2;
        }
        if (n2 > 0) {
            while (n2 >= this.blockSize) {
                int n3 = n2;
                int n4 = n;
                DSTU7564Digest dSTU7564Digest = this;
                dSTU7564Digest.processBlock(byArray, n);
                n = dSTU7564Digest.blockSize;
                n2 = n4 + n;
                n = n3 - n;
                ++this.inputBlocks;
                int n5 = n;
                n = n2;
                n2 = n5;
            }
            while (n2 > 0) {
                this.update(byArray[n++]);
                --n2;
            }
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        DSTU7564Digest dSTU7564Digest = this;
        int n5 = dSTU7564Digest.bufOff;
        byte[] byArray2 = dSTU7564Digest.buf;
        this.bufOff = n4 = n5 + 1;
        byArray2[n5] = -128;
        int n6 = this.blockSize - 12;
        if (n4 > n6) {
            while ((n4 = this.bufOff) < this.blockSize) {
                this.bufOff = n4 + 1;
                this.buf[n4] = 0;
            }
            DSTU7564Digest dSTU7564Digest2 = this;
            dSTU7564Digest2.bufOff = 0;
            dSTU7564Digest2.processBlock(dSTU7564Digest2.buf, 0);
        }
        while ((n4 = this.bufOff) < n6) {
            this.bufOff = n4 + 1;
            this.buf[n4] = 0;
        }
        DSTU7564Digest dSTU7564Digest3 = this;
        long l = (dSTU7564Digest3.inputBlocks & 0xFFFFFFFFL) * (long)this.blockSize + (long)n5 << 3;
        Pack.intToLittleEndian((int)l, this.buf, n4);
        this.bufOff = n3 = this.bufOff + 4;
        Pack.longToLittleEndian((l >>> 32) + ((this.inputBlocks >>> 32) * (long)this.blockSize << 3), this.buf, n3);
        dSTU7564Digest3.processBlock(dSTU7564Digest3.buf, 0);
        DSTU7564Digest dSTU7564Digest4 = this;
        long[] lArray = dSTU7564Digest4.tempState1;
        n6 = dSTU7564Digest4.columns;
        System.arraycopy(dSTU7564Digest3.state, 0, lArray, 0, n6);
        dSTU7564Digest3.P(dSTU7564Digest3.tempState1);
        for (n2 = 0; n2 < (n6 = this.columns); ++n2) {
            this.state[n2] = this.state[n2] ^ this.tempState1[n2];
        }
        for (n2 = n6 - (this.hashSize >>> 3); n2 < this.columns; ++n2) {
            Pack.longToLittleEndian(this.state[n2], byArray, n);
            n += 8;
        }
        DSTU7564Digest dSTU7564Digest5 = this;
        dSTU7564Digest5.reset();
        return dSTU7564Digest5.hashSize;
    }

    @Override
    public void reset() {
        long l;
        DSTU7564Digest dSTU7564Digest = this;
        Arrays.fill(dSTU7564Digest.state, 0L);
        dSTU7564Digest.state[0] = l = (long)this.blockSize;
        dSTU7564Digest.inputBlocks = 0L;
        dSTU7564Digest.bufOff = 0;
    }

    @Override
    public Memoable copy() {
        return new DSTU7564Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        this.copyIn((DSTU7564Digest)memoable);
    }
}

