/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GeneralDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SM3Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 32;
    private static final int BLOCK_SIZE = 16;
    private static final int[] T;
    private int[] V;
    private int[] inwords;
    private int xOff;
    private int[] W;

    public SM3Digest() {
        SM3Digest sM3Digest = this;
        sM3Digest.V = new int[8];
        sM3Digest.inwords = new int[16];
        sM3Digest.W = new int[68];
        sM3Digest.reset();
    }

    public SM3Digest(SM3Digest sM3Digest) {
        super(sM3Digest);
        this.V = new int[8];
        this.inwords = new int[16];
        this.W = new int[68];
        this.copyIn(sM3Digest);
    }

    private void copyIn(SM3Digest object) {
        SM3Digest sM3Digest = object2;
        SM3Digest sM3Digest2 = object;
        object = ((SM3Digest)object2).V;
        int n = ((SM3Digest)object2).V.length;
        System.arraycopy(sM3Digest2.V, 0, object, 0, n);
        Object object2 = ((SM3Digest)object2).inwords;
        int n2 = ((SM3Digest)object2).inwords.length;
        System.arraycopy(sM3Digest2.inwords, 0, object2, 0, n2);
        sM3Digest.xOff = sM3Digest2.xOff;
    }

    private int P0(int n) {
        int n2 = n;
        int n3 = n2 << 9 | n >>> 23;
        n = n2 << 17 | n >>> 15;
        return n2 ^ n3 ^ n;
    }

    private int P1(int n) {
        int n2 = n;
        int n3 = n2 << 15 | n >>> 17;
        n = n2 << 23 | n >>> 9;
        return n2 ^ n3 ^ n;
    }

    private int FF0(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int FF1(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    private int GG0(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int GG1(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    static {
        int n;
        T = new int[64];
        for (n = 0; n < 16; ++n) {
            SM3Digest.T[n] = 2043430169 << n | 2043430169 >>> 32 - n;
        }
        for (n = 16; n < 64; ++n) {
            int n2 = n % 32;
            SM3Digest.T[n] = 2055708042 << n2 | 2055708042 >>> 32 - n2;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SM3";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public Memoable copy() {
        return new SM3Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SM3Digest sM3Digest = sM3Digest2;
        SM3Digest sM3Digest2 = (SM3Digest)memoable;
        super.copyIn(sM3Digest2);
        sM3Digest.copyIn(sM3Digest2);
    }

    @Override
    public void reset() {
        SM3Digest sM3Digest = this;
        super.reset();
        int[] nArray = sM3Digest.V;
        int[] nArray2 = sM3Digest.V;
        nArray[0] = 1937774191;
        nArray2[1] = 1226093241;
        nArray[2] = 388252375;
        nArray2[3] = -628488704;
        nArray[4] = -1452330820;
        nArray2[5] = 372324522;
        nArray[6] = -477237683;
        nArray2[7] = -1325724082;
        sM3Digest.xOff = 0;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        SM3Digest sM3Digest = this;
        sM3Digest.finish();
        Pack.intToBigEndian(sM3Digest.V, byArray, n);
        sM3Digest.reset();
        return 32;
    }

    @Override
    public void processWord(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24;
        n = n + 1;
        int n3 = n2 | (byArray[n] & 0xFF) << 16 | (byArray[++n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        n = this.xOff;
        this.inwords[n] = n3;
        this.xOff = n + 1;
        if (this.xOff >= 16) {
            this.processBlock();
        }
    }

    @Override
    public void processLength(long l) {
        int n = this.xOff;
        if (n > 14) {
            this.inwords[n] = 0;
            this.xOff = n + 1;
            this.processBlock();
        }
        while ((n = this.xOff) < 14) {
            this.inwords[n] = 0;
            this.xOff = n + 1;
        }
        int[] nArray = this.inwords;
        int n2 = n + 1;
        nArray[n] = (int)(l >>> 32);
        this.xOff = n2 + 1;
        this.inwords[n2] = (int)l;
    }

    @Override
    public void processBlock() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        for (n8 = 0; n8 < 16; ++n8) {
            this.W[n8] = this.inwords[n8];
        }
        for (n8 = 16; n8 < 68; ++n8) {
            int[] nArray = this.W;
            n7 = nArray[n8 - 3];
            n7 = n7 << 15 | n7 >>> 17;
            n6 = nArray[n8 - 13];
            n6 = n6 << 7 | n6 >>> 25;
            this.W[n8] = this.P1(nArray[n8 - 16] ^ nArray[n8 - 9] ^ n7) ^ n6 ^ this.W[n8 - 6];
        }
        n8 = this.V[0];
        int n9 = this.V[1];
        n7 = this.V[2];
        n6 = this.V[3];
        int n10 = this.V[4];
        int n11 = this.V[5];
        int n12 = this.V[6];
        int n13 = this.V[7];
        int n14 = n8;
        int n15 = n7;
        int n16 = n10;
        int n17 = n12;
        n12 = n13;
        n13 = n17;
        n10 = n11;
        n11 = n16;
        n7 = n6;
        n6 = n15;
        n8 = n9;
        n9 = n14;
        for (n5 = 0; n5 < 16; ++n5) {
            n4 = n9 << 12 | n9 >>> 20;
            n3 = n4 + n11 + T[n5];
            n3 = n3 << 7 | n3 >>> 25;
            n4 = n3 ^ n4;
            int[] nArray = this.W;
            n2 = this.W[n5];
            n = n2 ^ nArray[n5 + 4];
            n7 = a.a(this.FF0(n9, n8, n6), n7, n4, n);
            n12 = a.a(this.GG0(n11, n10, n13), n12, n3, n2);
            n8 = n8 << 9 | n8 >>> 23;
            n10 = n10 << 19 | n10 >>> 13;
            n12 = this.P0(n12);
            int n18 = n7;
            int n19 = n12;
            n12 = n13;
            n13 = n10;
            n10 = n11;
            n11 = n19;
            n7 = n6;
            n6 = n8;
            n8 = n9;
            n9 = n18;
        }
        int n20 = n9;
        int n21 = n6;
        int n22 = n11;
        int n23 = n13;
        n13 = n12;
        n12 = n23;
        n11 = n10;
        n10 = n22;
        n6 = n7;
        n7 = n21;
        n9 = n8;
        n8 = n20;
        for (n5 = 16; n5 < 64; ++n5) {
            n4 = n8 << 12 | n8 >>> 20;
            n3 = n4 + n10 + T[n5];
            n3 = n3 << 7 | n3 >>> 25;
            n4 = n3 ^ n4;
            int[] nArray = this.W;
            n2 = this.W[n5];
            n = n2 ^ nArray[n5 + 4];
            n6 = a.a(this.FF1(n8, n9, n7), n6, n4, n);
            n13 = a.a(this.GG1(n10, n11, n12), n13, n3, n2);
            n9 = n9 << 9 | n9 >>> 23;
            n11 = n11 << 19 | n11 >>> 13;
            n13 = this.P0(n13);
            int n24 = n6;
            int n25 = n13;
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n25;
            n6 = n7;
            n7 = n9;
            n9 = n8;
            n8 = n24;
        }
        SM3Digest sM3Digest = this;
        int[] nArray = sM3Digest.V;
        nArray[0] = sM3Digest.V[0] ^ n8;
        nArray[1] = sM3Digest.V[1] ^ n9;
        nArray[2] = sM3Digest.V[2] ^ n7;
        nArray[3] = sM3Digest.V[3] ^ n6;
        nArray[4] = sM3Digest.V[4] ^ n10;
        nArray[5] = sM3Digest.V[5] ^ n11;
        nArray[6] = sM3Digest.V[6] ^ n12;
        nArray[7] = sM3Digest.V[7] ^ n13;
        sM3Digest.xOff = 0;
    }
}

