/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.elgamal;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ElGamalPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ElGamalPublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;

public class ElGamalUtil {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) {
        if (publicKey instanceof ElGamalPublicKey) {
            publicKey = (ElGamalPublicKey)publicKey;
            return new ElGamalPublicKeyParameters(publicKey.getY(), new ElGamalParameters(publicKey.getParameters().getP(), publicKey.getParameters().getG()));
        }
        if (publicKey instanceof DHPublicKey) {
            publicKey = (DHPublicKey)publicKey;
            return new ElGamalPublicKeyParameters(publicKey.getY(), new ElGamalParameters(publicKey.getParams().getP(), publicKey.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify public key for El Gamal.");
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey privateKey) {
        if (privateKey instanceof ElGamalPrivateKey) {
            privateKey = (ElGamalPrivateKey)privateKey;
            return new ElGamalPrivateKeyParameters(privateKey.getX(), new ElGamalParameters(privateKey.getParameters().getP(), privateKey.getParameters().getG()));
        }
        if (privateKey instanceof DHPrivateKey) {
            privateKey = (DHPrivateKey)privateKey;
            return new ElGamalPrivateKeyParameters(privateKey.getX(), new ElGamalParameters(privateKey.getParams().getP(), privateKey.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify private key for El Gamal.");
    }
}

