/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPrivateKeySpec;
import java.util.Enumeration;

public class BCRSAPrivateKey
implements RSAPrivateKey,
PKCS12BagAttributeCarrier {
    public static final long serialVersionUID = 5110188922551353628L;
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    public BigInteger modulus;
    public BigInteger privateExponent;
    private byte[] algorithmIdentifierEnc;
    public transient AlgorithmIdentifier algorithmIdentifier;
    public transient RSAKeyParameters rsaPrivateKey;
    public transient PKCS12BagAttributeCarrierImpl attrCarrier;

    public BCRSAPrivateKey(RSAKeyParameters rSAKeyParameters) {
        BCRSAPrivateKey bCRSAPrivateKey = algorithmIdentifier;
        BCRSAPrivateKey bCRSAPrivateKey2 = algorithmIdentifier;
        BCRSAPrivateKey bCRSAPrivateKey3 = algorithmIdentifier;
        AlgorithmIdentifier algorithmIdentifier = BCRSAPublicKey.DEFAULT_ALGORITHM_IDENTIFIER;
        v3.algorithmIdentifierEnc = BCRSAPrivateKey.getEncoding(algorithmIdentifier);
        v3.algorithmIdentifier = algorithmIdentifier;
        v3.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        bCRSAPrivateKey3.modulus = rSAKeyParameters.getModulus();
        bCRSAPrivateKey2.privateExponent = rSAKeyParameters.getExponent();
        bCRSAPrivateKey.rsaPrivateKey = rSAKeyParameters;
    }

    public BCRSAPrivateKey(AlgorithmIdentifier algorithmIdentifier, RSAKeyParameters rSAKeyParameters) {
        BCRSAPrivateKey bCRSAPrivateKey = algorithmIdentifier2;
        BCRSAPrivateKey bCRSAPrivateKey2 = algorithmIdentifier2;
        BCRSAPrivateKey bCRSAPrivateKey3 = algorithmIdentifier2;
        BCRSAPrivateKey bCRSAPrivateKey4 = algorithmIdentifier2;
        BCRSAPrivateKey bCRSAPrivateKey5 = algorithmIdentifier2;
        AlgorithmIdentifier algorithmIdentifier2 = BCRSAPublicKey.DEFAULT_ALGORITHM_IDENTIFIER;
        v5.algorithmIdentifierEnc = BCRSAPrivateKey.getEncoding(algorithmIdentifier2);
        v5.algorithmIdentifier = algorithmIdentifier2;
        v5.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        bCRSAPrivateKey5.algorithmIdentifier = algorithmIdentifier;
        bCRSAPrivateKey4.algorithmIdentifierEnc = BCRSAPrivateKey.getEncoding(algorithmIdentifier);
        bCRSAPrivateKey3.modulus = rSAKeyParameters.getModulus();
        bCRSAPrivateKey2.privateExponent = rSAKeyParameters.getExponent();
        bCRSAPrivateKey.rsaPrivateKey = rSAKeyParameters;
    }

    public BCRSAPrivateKey(RSAPrivateKeySpec object) {
        BCRSAPrivateKey bCRSAPrivateKey = serializable;
        RSAPrivateKeySpec rSAPrivateKeySpec = object;
        RSAPrivateKeySpec rSAPrivateKeySpec2 = object;
        object = BCRSAPublicKey.DEFAULT_ALGORITHM_IDENTIFIER;
        serializable.algorithmIdentifierEnc = BCRSAPrivateKey.getEncoding((AlgorithmIdentifier)object);
        serializable.algorithmIdentifier = object;
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        serializable.modulus = rSAPrivateKeySpec2.getModulus();
        bCRSAPrivateKey.privateExponent = rSAPrivateKeySpec.getPrivateExponent();
        BCRSAPrivateKey bCRSAPrivateKey2 = serializable;
        Serializable serializable = bCRSAPrivateKey2.modulus;
        object = bCRSAPrivateKey2.privateExponent;
        bCRSAPrivateKey.rsaPrivateKey = new RSAKeyParameters(true, (BigInteger)serializable, (BigInteger)object);
    }

    public BCRSAPrivateKey(RSAPrivateKey object) {
        BCRSAPrivateKey bCRSAPrivateKey = serializable;
        RSAPrivateKey rSAPrivateKey = object;
        RSAPrivateKey rSAPrivateKey2 = object;
        object = BCRSAPublicKey.DEFAULT_ALGORITHM_IDENTIFIER;
        serializable.algorithmIdentifierEnc = BCRSAPrivateKey.getEncoding((AlgorithmIdentifier)object);
        serializable.algorithmIdentifier = object;
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        serializable.modulus = rSAPrivateKey2.getModulus();
        bCRSAPrivateKey.privateExponent = rSAPrivateKey.getPrivateExponent();
        BCRSAPrivateKey bCRSAPrivateKey2 = serializable;
        Serializable serializable = bCRSAPrivateKey2.modulus;
        object = bCRSAPrivateKey2.privateExponent;
        bCRSAPrivateKey.rsaPrivateKey = new RSAKeyParameters(true, (BigInteger)serializable, (BigInteger)object);
    }

    public BCRSAPrivateKey(AlgorithmIdentifier object, com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPrivateKey rSAPrivateKey) {
        BCRSAPrivateKey bCRSAPrivateKey = serializable;
        AlgorithmIdentifier algorithmIdentifier = object;
        AlgorithmIdentifier algorithmIdentifier2 = object;
        object = BCRSAPublicKey.DEFAULT_ALGORITHM_IDENTIFIER;
        serializable.algorithmIdentifierEnc = BCRSAPrivateKey.getEncoding((AlgorithmIdentifier)object);
        serializable.algorithmIdentifier = object;
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        serializable.algorithmIdentifier = algorithmIdentifier2;
        serializable.algorithmIdentifierEnc = BCRSAPrivateKey.getEncoding(algorithmIdentifier);
        serializable.modulus = rSAPrivateKey.getModulus();
        bCRSAPrivateKey.privateExponent = rSAPrivateKey.getPrivateExponent();
        BCRSAPrivateKey bCRSAPrivateKey2 = serializable;
        Serializable serializable = bCRSAPrivateKey2.modulus;
        object = bCRSAPrivateKey2.privateExponent;
        bCRSAPrivateKey.rsaPrivateKey = new RSAKeyParameters(true, (BigInteger)serializable, (BigInteger)object);
    }

    private void readObject(ObjectInputStream object) {
        ((ObjectInputStream)object).defaultReadObject();
        if (serializable.algorithmIdentifierEnc == null) {
            serializable.algorithmIdentifierEnc = BCRSAPrivateKey.getEncoding(BCRSAPublicKey.DEFAULT_ALGORITHM_IDENTIFIER);
        }
        serializable.algorithmIdentifier = AlgorithmIdentifier.getInstance(serializable.algorithmIdentifierEnc);
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        BCRSAPrivateKey bCRSAPrivateKey = serializable;
        Serializable serializable = bCRSAPrivateKey.modulus;
        object = bCRSAPrivateKey.privateExponent;
        v1.rsaPrivateKey = new RSAKeyParameters(true, (BigInteger)serializable, (BigInteger)object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
    }

    private static byte[] getEncoding(AlgorithmIdentifier algorithmIdentifier) {
        try {
            return algorithmIdentifier.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    @Override
    public String getAlgorithm() {
        if (this.algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            return "RSASSA-PSS";
        }
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public RSAKeyParameters engineGetKeyParameters() {
        return this.rsaPrivateKey;
    }

    @Override
    public byte[] getEncoded() {
        BCRSAPrivateKey bCRSAPrivateKey = serializable;
        Serializable serializable = bCRSAPrivateKey.getModulus();
        BigInteger bigInteger = ZERO;
        BigInteger bigInteger2 = bCRSAPrivateKey.getPrivateExponent();
        Serializable serializable2 = serializable;
        Serializable serializable3 = serializable = ZERO;
        return KeyUtil.getEncodedPrivateKeyInfo(serializable.algorithmIdentifier, new com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPrivateKey((BigInteger)serializable2, bigInteger, bigInteger2, (BigInteger)serializable3, (BigInteger)serializable3, (BigInteger)serializable3, (BigInteger)serializable3, (BigInteger)serializable3));
    }

    public boolean equals(Object object) {
        if (!(object instanceof RSAPrivateKey)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        object = (RSAPrivateKey)object;
        return this.getModulus().equals(object.getModulus()) && this.getPrivateExponent().equals(object.getPrivateExponent());
    }

    public int hashCode() {
        return this.getModulus().hashCode() ^ this.getPrivateExponent().hashCode();
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("RSA Private Key [").append(RSAUtil.generateKeyFingerprint(this.getModulus())).append("],[]").append(string);
        stringBuffer.append("            modulus: ").append(this.getModulus().toString(16)).append(string);
        return stringBuffer.toString();
    }
}

