/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500NameStyle;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.interfaces.BCX509Certificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509AttributeCertificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

class PrincipalUtils {
    public static X500Name getCA(TrustAnchor trustAnchor) {
        return PrincipalUtils.getX500Name(PrincipalUtils.notNull(trustAnchor).getCA());
    }

    public static X500Name getEncodedIssuerPrincipal(Object object) {
        if (object instanceof X509Certificate) {
            return PrincipalUtils.getIssuerPrincipal((X509Certificate)object);
        }
        return PrincipalUtils.getX500Name((X500Principal)((X509AttributeCertificate)object).getIssuer().getPrincipals()[0]);
    }

    public static X500Name getIssuerPrincipal(X509Certificate x509Certificate) {
        if (x509Certificate instanceof BCX509Certificate) {
            return PrincipalUtils.notNull(((BCX509Certificate)((Object)x509Certificate)).getIssuerX500Name());
        }
        return PrincipalUtils.getX500Name(PrincipalUtils.notNull(x509Certificate).getIssuerX500Principal());
    }

    public static X500Name getIssuerPrincipal(X509CRL x509CRL) {
        return PrincipalUtils.getX500Name(PrincipalUtils.notNull(x509CRL).getIssuerX500Principal());
    }

    public static X500Name getSubjectPrincipal(X509Certificate x509Certificate) {
        if (x509Certificate instanceof BCX509Certificate) {
            return PrincipalUtils.notNull(((BCX509Certificate)((Object)x509Certificate)).getSubjectX500Name());
        }
        return PrincipalUtils.getX500Name(PrincipalUtils.notNull(x509Certificate).getSubjectX500Principal());
    }

    public static X500Name getX500Name(X500Principal x500Principal) {
        return PrincipalUtils.notNull(X500Name.getInstance(PrincipalUtils.getEncoded(x500Principal)));
    }

    public static X500Name getX500Name(X500NameStyle x500NameStyle, X500Principal x500Principal) {
        return PrincipalUtils.notNull(X500Name.getInstance(x500NameStyle, PrincipalUtils.getEncoded(x500Principal)));
    }

    private static byte[] getEncoded(X500Principal x500Principal) {
        return PrincipalUtils.notNull(PrincipalUtils.notNull(x500Principal).getEncoded());
    }

    private static byte[] notNull(byte[] byArray) {
        if (byArray != null) {
            return byArray;
        }
        throw new IllegalStateException();
    }

    private static TrustAnchor notNull(TrustAnchor trustAnchor) {
        if (trustAnchor != null) {
            return trustAnchor;
        }
        throw new IllegalStateException();
    }

    private static X509Certificate notNull(X509Certificate x509Certificate) {
        if (x509Certificate != null) {
            return x509Certificate;
        }
        throw new IllegalStateException();
    }

    private static X509CRL notNull(X509CRL x509CRL) {
        if (x509CRL != null) {
            return x509CRL;
        }
        throw new IllegalStateException();
    }

    private static X500Name notNull(X500Name x500Name) {
        if (x500Name != null) {
            return x500Name;
        }
        throw new IllegalStateException();
    }

    private static X500Principal notNull(X500Principal x500Principal) {
        if (x500Principal != null) {
            return x500Principal;
        }
        throw new IllegalStateException();
    }
}

