/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPointMap;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.PreCompCallback;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.PreCompInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WNafPreCompInfo;
import java.math.BigInteger;

public abstract class WNafUtil {
    public static final String PRECOMP_NAME = "bc_wnaf";
    private static final int[] DEFAULT_WINDOW_SIZE_CUTOFFS = new int[]{13, 41, 121, 337, 897, 2305};
    private static final int MAX_WIDTH = 16;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static final ECPoint[] EMPTY_POINTS = new ECPoint[0];

    public static void configureBasepoint(ECPoint eCPoint) {
        PreCompCallback preCompCallback;
        ECCurve eCCurve = eCPoint.getCurve();
        if (eCCurve == null) {
            return;
        }
        Object object = eCCurve.getOrder();
        final int n = Math.min(16, WNafUtil.getWindowSize(object == null ? eCCurve.getFieldSize() + 1 : ((BigInteger)object).bitLength()) + 3);
        object = preCompCallback;
        preCompCallback = new PreCompCallback(){

            @Override
            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                WNafPreCompInfo wNafPreCompInfo;
                WNafPreCompInfo wNafPreCompInfo2;
                if ((preCompInfo = preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null) != null && ((WNafPreCompInfo)preCompInfo).getConfWidth() == n) {
                    PreCompInfo preCompInfo2 = preCompInfo;
                    ((WNafPreCompInfo)preCompInfo2).setPromotionCountdown(0);
                    return preCompInfo2;
                }
                WNafPreCompInfo wNafPreCompInfo3 = wNafPreCompInfo2 = wNafPreCompInfo;
                wNafPreCompInfo3();
                wNafPreCompInfo3.setPromotionCountdown(0);
                wNafPreCompInfo.setConfWidth(n);
                if (preCompInfo != null) {
                    wNafPreCompInfo2.setPreComp(((WNafPreCompInfo)preCompInfo).getPreComp());
                    wNafPreCompInfo2.setPreCompNeg(((WNafPreCompInfo)preCompInfo).getPreCompNeg());
                    wNafPreCompInfo2.setTwice(((WNafPreCompInfo)preCompInfo).getTwice());
                    wNafPreCompInfo2.setWidth(((WNafPreCompInfo)preCompInfo).getWidth());
                }
                return wNafPreCompInfo2;
            }
        };
        eCCurve.precompute(eCPoint, PRECOMP_NAME, (PreCompCallback)object);
    }

    public static int[] generateCompactNaf(BigInteger bigInteger) {
        if (bigInteger.bitLength() >>> 16 == 0) {
            if (bigInteger.signum() == 0) {
                return EMPTY_INTS;
            }
            BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
            int n = bigInteger2.bitLength();
            int n2 = n >> 1;
            int[] nArray = new int[n2];
            BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
            int n3 = n - 1;
            int n4 = 0;
            int n5 = 0;
            for (int k = 1; k < n3; ++k) {
                if (!bigInteger3.testBit(k)) {
                    ++n5;
                    continue;
                }
                int n6 = bigInteger.testBit(k) ? -1 : 1;
                nArray[n4++] = n6 << 16 | n5;
                n5 = 1;
                ++k;
            }
            int n7 = n4 + 1;
            nArray[n4] = n5 | 0x10000;
            if (n2 > n7) {
                nArray = WNafUtil.trim(nArray, n7);
            }
            return nArray;
        }
        throw new IllegalArgumentException("'k' must have bitlength < 2^16");
    }

    public static int[] generateCompactWindowNaf(int n, BigInteger bigInteger) {
        if (n == 2) {
            return WNafUtil.generateCompactNaf(bigInteger);
        }
        if (n >= 2 && n <= 16) {
            if (bigInteger.bitLength() >>> 16 == 0) {
                if (bigInteger.signum() == 0) {
                    return EMPTY_INTS;
                }
                int n2 = bigInteger.bitLength() / n + 1;
                int[] nArray = new int[n2];
                int n3 = 1 << n;
                int n4 = n3 - 1;
                int n5 = n3 >>> 1;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                while (n8 <= bigInteger.bitLength()) {
                    int n9;
                    if (bigInteger.testBit(n8) == n6) {
                        ++n8;
                        continue;
                    }
                    int n10 = n6;
                    bigInteger = bigInteger.shiftRight(n8);
                    n6 = bigInteger.intValue() & n4;
                    if (n10 != 0) {
                        ++n6;
                    }
                    if ((n9 = (n6 & n5) != 0 ? 1 : 0) != 0) {
                        n6 -= n3;
                    }
                    if (n7 > 0) {
                        --n8;
                    }
                    nArray[n7++] = n6 << 16 | n8;
                    n6 = n9;
                    n8 = n;
                }
                if (n2 > n7) {
                    nArray = WNafUtil.trim(nArray, n7);
                }
                return nArray;
            }
            throw new IllegalArgumentException("'k' must have bitlength < 2^16");
        }
        throw new IllegalArgumentException("'width' must be in the range [2, 16]");
    }

    public static byte[] generateJSF(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = Math.max(bigInteger.bitLength(), bigInteger2.bitLength()) + 1;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            int n6;
            if (!(n3 | n4) && bigInteger.bitLength() <= n5 && bigInteger2.bitLength() <= n5) {
                if (n > n2) {
                    byArray = WNafUtil.trim(byArray, n2);
                }
                return byArray;
            }
            int n7 = (bigInteger.intValue() >>> n5) + n3 & 7;
            int n8 = (bigInteger2.intValue() >>> n5) + n4 & 7;
            int n9 = n7 & 1;
            if (n9 != 0 && n7 + (n9 -= n7 & 2) == 4 && (n8 & 3) == 2) {
                n9 = -n9;
            }
            if ((n6 = n8 & 1) != 0 && n8 + (n6 -= n8 & 2) == 4 && (n7 & 3) == 2) {
                n6 = -n6;
            }
            if (n3 << 1 == n9 + 1) {
                n3 ^= 1;
            }
            if (n4 << 1 == n6 + 1) {
                n4 ^= 1;
            }
            if (++n5 == 30) {
                BigInteger bigInteger3 = bigInteger2;
                int n10 = 0;
                bigInteger2 = bigInteger.shiftRight(30);
                BigInteger bigInteger4 = bigInteger3.shiftRight(30);
                BigInteger bigInteger5 = bigInteger2;
                n5 = n10;
                bigInteger2 = bigInteger4;
                bigInteger = bigInteger5;
            }
            byArray[n2++] = (byte)(n9 << 4 | n6 & 0xF);
        }
    }

    public static byte[] generateNaf(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return EMPTY_BYTES;
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        int n = bigInteger2.bitLength() - 1;
        byte[] byArray = new byte[n];
        BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
        for (int k = 1; k < n; ++k) {
            byte by;
            if (!bigInteger3.testBit(k)) continue;
            int n2 = k;
            int n3 = n2 - 1;
            byArray[n3] = by = (byte)(bigInteger.testBit(n2) ? -1 : 1);
            ++k;
        }
        byArray[n - 1] = 1;
        return byArray;
    }

    public static byte[] generateWindowNaf(int n, BigInteger bigInteger) {
        if (n == 2) {
            return WNafUtil.generateNaf(bigInteger);
        }
        if (n >= 2 && n <= 8) {
            if (bigInteger.signum() == 0) {
                return EMPTY_BYTES;
            }
            int n2 = bigInteger.bitLength() + 1;
            byte[] byArray = new byte[n2];
            int n3 = 1 << n;
            int n4 = n3 - 1;
            int n5 = n3 >>> 1;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 <= bigInteger.bitLength()) {
                int n9;
                if (bigInteger.testBit(n8) == n6) {
                    ++n8;
                    continue;
                }
                int n10 = n6;
                bigInteger = bigInteger.shiftRight(n8);
                n6 = bigInteger.intValue() & n4;
                if (n10 != 0) {
                    ++n6;
                }
                if ((n9 = (n6 & n5) != 0 ? 1 : 0) != 0) {
                    n6 -= n3;
                }
                if (n7 > 0) {
                    --n8;
                }
                int n11 = n6;
                n6 = n7 + n8;
                n7 = n6 + 1;
                byArray[n6] = (byte)n11;
                n6 = n9;
                n8 = n;
            }
            if (n2 > n7) {
                byArray = WNafUtil.trim(byArray, n7);
            }
            return byArray;
        }
        throw new IllegalArgumentException("'width' must be in the range [2, 8]");
    }

    public static int getNafWeight(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return 0;
        }
        return bigInteger.shiftLeft(1).add(bigInteger).xor(bigInteger).bitCount();
    }

    public static WNafPreCompInfo getWNafPreCompInfo(ECPoint eCPoint) {
        return WNafUtil.getWNafPreCompInfo(eCPoint.getCurve().getPreCompInfo(eCPoint, PRECOMP_NAME));
    }

    public static WNafPreCompInfo getWNafPreCompInfo(PreCompInfo preCompInfo) {
        return preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null;
    }

    public static int getWindowSize(int n) {
        return WNafUtil.getWindowSize(n, DEFAULT_WINDOW_SIZE_CUTOFFS, 16);
    }

    public static int getWindowSize(int n, int n2) {
        return WNafUtil.getWindowSize(n, DEFAULT_WINDOW_SIZE_CUTOFFS, n2);
    }

    public static int getWindowSize(int n, int[] nArray) {
        return WNafUtil.getWindowSize(n, nArray, 16);
    }

    public static int getWindowSize(int n, int[] nArray, int n2) {
        int n3;
        for (n3 = 0; n3 < nArray.length && n >= nArray[n3]; ++n3) {
        }
        return Math.max(2, Math.min(n2, n3 + 2));
    }

    public static WNafPreCompInfo precompute(final ECPoint eCPoint, final int n, final boolean bl) {
        PreCompCallback preCompCallback;
        final ECCurve eCCurve = eCPoint.getCurve();
        PreCompCallback preCompCallback2 = preCompCallback;
        preCompCallback = new PreCompCallback(){

            private boolean checkExisting(WNafPreCompInfo wNafPreCompInfo, int n3, int n2, boolean bl2) {
                return wNafPreCompInfo != null && wNafPreCompInfo.getWidth() >= Math.max(wNafPreCompInfo.getConfWidth(), n3) && this.checkTable(wNafPreCompInfo.getPreComp(), n2) && (!bl2 || this.checkTable(wNafPreCompInfo.getPreCompNeg(), n2));
            }

            private boolean checkTable(ECPoint[] eCPointArray, int n2) {
                return eCPointArray != null && eCPointArray.length >= n2;
            }

            @Override
            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                WNafPreCompInfo wNafPreCompInfo;
                boolean bl2;
                int n10;
                preCompInfo = preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null;
                2 v0 = this;
                int n2 = Math.max(2, Math.min(16, v0.n));
                if (this.checkExisting((WNafPreCompInfo)preCompInfo, n2, n10 = 1 << n2 - 2, bl2 = v0.bl)) {
                    PreCompInfo preCompInfo2 = preCompInfo;
                    ((WNafPreCompInfo)preCompInfo2).decrementPromotionCountdown();
                    return preCompInfo2;
                }
                WNafPreCompInfo wNafPreCompInfo2 = wNafPreCompInfo;
                wNafPreCompInfo = new WNafPreCompInfo();
                ECPoint[] eCPointArray = null;
                ECPoint[] eCPointArray2 = null;
                ECPoint eCPoint5 = null;
                if (preCompInfo != null) {
                    PreCompInfo preCompInfo3 = preCompInfo;
                    wNafPreCompInfo2.setPromotionCountdown(((WNafPreCompInfo)preCompInfo).decrementPromotionCountdown());
                    wNafPreCompInfo2.setConfWidth(((WNafPreCompInfo)preCompInfo).getConfWidth());
                    eCPointArray = ((WNafPreCompInfo)preCompInfo3).getPreComp();
                    eCPointArray2 = ((WNafPreCompInfo)preCompInfo3).getPreCompNeg();
                    eCPoint5 = ((WNafPreCompInfo)preCompInfo3).getTwice();
                }
                int n3 = Math.min(16, Math.max(wNafPreCompInfo2.getConfWidth(), n2));
                n2 = 1 << n3 - 2;
                int n4 = 0;
                if (eCPointArray == null) {
                    eCPointArray = EMPTY_POINTS;
                } else {
                    n4 = eCPointArray.length;
                }
                if (n4 < n2) {
                    eCPointArray = WNafUtil.resizeTable(eCPointArray, n2);
                    if (n2 == 1) {
                        eCPointArray[0] = eCPoint.normalize();
                    } else {
                        int n5;
                        if (n4 == 0) {
                            eCPointArray[0] = eCPoint;
                            n5 = 1;
                        } else {
                            n5 = n4;
                        }
                        Object object = null;
                        if (n2 == 2) {
                            eCPointArray[1] = eCPoint.threeTimes();
                        } else {
                            int n6;
                            ECPoint eCPoint2;
                            Object object2;
                            int n7;
                            Object object3 = eCPointArray[n5 - 1];
                            if (eCPoint5 == null && !(eCPoint5 = eCPointArray[0].twice()).isInfinity() && ECAlgorithms.isFpCurve(eCCurve) && eCCurve.getFieldSize() >= 64 && ((n7 = eCCurve.getCoordinateSystem()) == 2 || n7 == 3 || n7 == 4)) {
                                ECPoint eCPoint3 = object3;
                                object = eCPoint5.getZCoord(0);
                                object3 = eCCurve.createPoint(eCPoint5.getXCoord().toBigInteger(), eCPoint5.getYCoord().toBigInteger());
                                ECFieldElement eCFieldElement = ((ECFieldElement)object).square();
                                object2 = eCFieldElement.multiply((ECFieldElement)object);
                                object2 = eCPoint3.scaleX(eCFieldElement).scaleY((ECFieldElement)object2);
                                if (n4 == 0) {
                                    eCPointArray[0] = object2;
                                }
                                eCPoint2 = object3;
                                object3 = object;
                                n6 = n5;
                            } else {
                                eCPoint2 = eCPoint5;
                                object2 = object3;
                                object3 = object;
                                n6 = n5;
                            }
                            while (n6 < n2) {
                                ECPoint eCPoint4;
                                int n8 = n6 + 1;
                                eCPointArray[n6] = eCPoint4 = ((ECPoint)object2).add(eCPoint2);
                                object2 = eCPoint4;
                                n6 = n8;
                            }
                            object = object3;
                        }
                        eCCurve.normalizeAll(eCPointArray, n4, n2 - n4, (ECFieldElement)object);
                    }
                }
                if (bl) {
                    int n9;
                    if (eCPointArray2 == null) {
                        n9 = 0;
                        eCPointArray2 = new ECPoint[n2];
                    } else {
                        n9 = eCPointArray2.length;
                        if (n9 < n2) {
                            eCPointArray2 = WNafUtil.resizeTable(eCPointArray2, n2);
                        }
                    }
                    while (n9 < n2) {
                        eCPointArray2[n9] = eCPointArray[n9].negate();
                        ++n9;
                    }
                }
                WNafPreCompInfo wNafPreCompInfo3 = wNafPreCompInfo2;
                wNafPreCompInfo3.setPreComp(eCPointArray);
                wNafPreCompInfo3.setPreCompNeg(eCPointArray2);
                wNafPreCompInfo3.setTwice(eCPoint5);
                wNafPreCompInfo3.setWidth(n3);
                return wNafPreCompInfo3;
            }
        };
        return (WNafPreCompInfo)eCCurve.precompute(eCPoint, PRECOMP_NAME, preCompCallback2);
    }

    public static WNafPreCompInfo precomputeWithPointMap(ECPoint object, final ECPointMap eCPointMap, final WNafPreCompInfo wNafPreCompInfo, final boolean bl) {
        PreCompCallback preCompCallback;
        ECCurve eCCurve = ((ECPoint)object).getCurve();
        ECPoint eCPoint = object;
        object = preCompCallback;
        preCompCallback = new PreCompCallback(){

            private boolean checkExisting(WNafPreCompInfo wNafPreCompInfo2, int n, int n2, boolean bl2) {
                return wNafPreCompInfo2 != null && wNafPreCompInfo2.getWidth() >= n && this.checkTable(wNafPreCompInfo2.getPreComp(), n2) && (!bl2 || this.checkTable(wNafPreCompInfo2.getPreCompNeg(), n2));
            }

            private boolean checkTable(ECPoint[] eCPointArray, int n) {
                return eCPointArray != null && eCPointArray.length >= n;
            }

            @Override
            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                WNafPreCompInfo wNafPreCompInfo2;
                int n;
                int n2;
                int n3;
                if (eCPointArray3.checkExisting((WNafPreCompInfo)(preCompInfo = preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null), n3 = eCPointArray3.wNafPreCompInfo.getWidth(), n2 = eCPointArray3.wNafPreCompInfo.getPreComp().length, (n = eCPointArray3.bl) != 0)) {
                    PreCompInfo preCompInfo2 = preCompInfo;
                    ((WNafPreCompInfo)preCompInfo2).decrementPromotionCountdown();
                    return preCompInfo2;
                }
                preCompInfo = wNafPreCompInfo2;
                ((WNafPreCompInfo)preCompInfo)();
                wNafPreCompInfo2.setPromotionCountdown(eCPointArray3.wNafPreCompInfo.getPromotionCountdown());
                ECPoint[] eCPointArray = eCPointArray3.wNafPreCompInfo.getTwice();
                if (eCPointArray != null) {
                    ((WNafPreCompInfo)preCompInfo).setTwice(eCPointArray3.eCPointMap.map((ECPoint)eCPointArray));
                }
                eCPointArray = eCPointArray3.wNafPreCompInfo.getPreComp();
                n = eCPointArray.length;
                ECPoint[] eCPointArray2 = new ECPoint[n];
                for (int k = 0; k < eCPointArray.length; ++k) {
                    eCPointArray2[k] = eCPointArray3.eCPointMap.map(eCPointArray[k]);
                }
                ((WNafPreCompInfo)preCompInfo).setPreComp(eCPointArray2);
                ((WNafPreCompInfo)preCompInfo).setWidth(n3);
                if (eCPointArray3.bl) {
                    ECPoint[] eCPointArray3 = new ECPoint[n];
                    for (n3 = 0; n3 < n; ++n3) {
                        eCPointArray3[n3] = eCPointArray2[n3].negate();
                    }
                    ((WNafPreCompInfo)preCompInfo).setPreCompNeg(eCPointArray3);
                }
                return preCompInfo;
            }
        };
        return (WNafPreCompInfo)eCCurve.precompute(eCPoint, PRECOMP_NAME, (PreCompCallback)object);
    }

    private static byte[] trim(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private static int[] trim(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    private static ECPoint[] resizeTable(ECPoint[] eCPointArray, int n) {
        ECPoint[] eCPointArray2 = new ECPoint[n];
        int n2 = eCPointArray.length;
        System.arraycopy(eCPointArray, 0, eCPointArray2, 0, n2);
        return eCPointArray2;
    }
}

