/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT193Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT193FieldElement
extends ECFieldElement.AbstractF2m {
    public long[] x;

    public SecT193FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.bitLength() <= 193) {
            this.x = SecT193Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecT193FieldElement");
    }

    public SecT193FieldElement() {
        this.x = Nat256.create64();
    }

    public SecT193FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat256.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat256.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat256.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT193Field";
    }

    @Override
    public int getFieldSize() {
        return 193;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecT193FieldElement secT193FieldElement = object;
        Object object = Nat256.create64();
        SecT193Field.add(secT193FieldElement.x, ((SecT193FieldElement)eCFieldElement).x, (long[])object);
        return new SecT193FieldElement((long[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecT193FieldElement secT193FieldElement = object;
        Object object = Nat256.create64();
        SecT193Field.addOne(secT193FieldElement.x, (long[])object);
        return new SecT193FieldElement((long[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecT193FieldElement secT193FieldElement = object;
        Object object = Nat256.create64();
        SecT193Field.multiply(secT193FieldElement.x, ((SecT193FieldElement)eCFieldElement).x, (long[])object);
        return new SecT193FieldElement((long[])object);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement object, ECFieldElement object2, ECFieldElement object3) {
        Object object4 = ((SecT193FieldElement)object4).x;
        object = ((SecT193FieldElement)object).x;
        object2 = ((SecT193FieldElement)object2).x;
        object3 = ((SecT193FieldElement)object3).x;
        long[] lArray = Nat256.createExt64();
        SecT193Field.multiplyAddToExt((long[])object4, (long[])object, lArray);
        SecT193Field.multiplyAddToExt((long[])object2, (long[])object3, lArray);
        long[] lArray2 = Nat256.create64();
        object4 = lArray2;
        SecT193Field.reduce(lArray, lArray2);
        return new SecT193FieldElement((long[])object4);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        SecT193FieldElement secT193FieldElement = object;
        Object object = Nat256.create64();
        SecT193Field.square(secT193FieldElement.x, (long[])object);
        return new SecT193FieldElement((long[])object);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement object, ECFieldElement object2) {
        Object object3 = ((SecT193FieldElement)object3).x;
        object = ((SecT193FieldElement)object).x;
        object2 = ((SecT193FieldElement)object2).x;
        long[] lArray = Nat256.createExt64();
        SecT193Field.squareAddToExt((long[])object3, lArray);
        SecT193Field.multiplyAddToExt((long[])object, (long[])object2, lArray);
        long[] lArray2 = Nat256.create64();
        object3 = lArray2;
        SecT193Field.reduce(lArray, lArray2);
        return new SecT193FieldElement((long[])object3);
    }

    @Override
    public ECFieldElement squarePow(int n) {
        if (n < 1) {
            return object;
        }
        SecT193FieldElement secT193FieldElement = object;
        Object object = Nat256.create64();
        SecT193Field.squareN(secT193FieldElement.x, n, (long[])object);
        return new SecT193FieldElement((long[])object);
    }

    @Override
    public ECFieldElement halfTrace() {
        SecT193FieldElement secT193FieldElement = object;
        Object object = Nat256.create64();
        SecT193Field.halfTrace(secT193FieldElement.x, (long[])object);
        return new SecT193FieldElement((long[])object);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT193Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        SecT193FieldElement secT193FieldElement = object;
        Object object = Nat256.create64();
        SecT193Field.invert(secT193FieldElement.x, (long[])object);
        return new SecT193FieldElement((long[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        SecT193FieldElement secT193FieldElement = object;
        Object object = Nat256.create64();
        SecT193Field.sqrt(secT193FieldElement.x, (long[])object);
        return new SecT193FieldElement((long[])object);
    }

    public int getRepresentation() {
        return 2;
    }

    public int getM() {
        return 193;
    }

    public int getK1() {
        return 15;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object == secT193FieldElement2) {
            return true;
        }
        if (!(object instanceof SecT193FieldElement)) {
            return false;
        }
        SecT193FieldElement secT193FieldElement = secT193FieldElement2;
        SecT193FieldElement secT193FieldElement2 = (SecT193FieldElement)object;
        return Nat256.eq64(secT193FieldElement.x, secT193FieldElement2.x);
    }

    public int hashCode() {
        return Arrays.hashCode(this.x, 0, 4) ^ 0x1D731F;
    }
}

