/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Matrix;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Vector;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GF2Matrix
extends Matrix {
    private int[][] matrix;
    private int length;

    public GF2Matrix(byte[] byArray) {
        if (byArray.length >= 9) {
            int n;
            this.numRows = LittleEndianConversions.OS2IP(byArray, 0);
            this.numColumns = n = LittleEndianConversions.OS2IP(byArray, 4);
            int n2 = n + 7 >>> 3;
            int n3 = this.numRows;
            if (n3 > 0 && (n2 *= n3) == byArray.length - 8) {
                int n4 = n;
                this.length = n = n + 31 >>> 5;
                this.matrix = new int[n3][n];
                n = n4 >> 5;
                n2 = n4 & 0x1F;
                n3 = 8;
                for (int k = 0; k < this.numRows; ++k) {
                    int n5 = 0;
                    while (n5 < n) {
                        this.matrix[k][n5] = LittleEndianConversions.OS2IP(byArray, n3);
                        ++n5;
                        n3 += 4;
                    }
                    for (n5 = 0; n5 < n2; n5 += 8) {
                        int[] nArray = this.matrix[k];
                        nArray[n] = nArray[n] ^ (byArray[n3++] & 0xFF) << n5;
                    }
                }
                return;
            }
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
    }

    public GF2Matrix(int n, int[][] nArray) {
        int[] nArray2 = nArray[0];
        if (nArray2.length == n + 31 >> 5) {
            this.numColumns = n;
            this.numRows = nArray.length;
            this.length = nArray2.length;
            n = (n &= 0x1F) == 0 ? -1 : (1 << n) - 1;
            for (int k = 0; k < this.numRows; ++k) {
                int[] nArray3 = nArray[k];
                int n2 = this.length - 1;
                nArray3[n2] = nArray3[n2] & n;
            }
            this.matrix = nArray;
            return;
        }
        throw new ArithmeticException("Int array does not match given number of columns.");
    }

    public GF2Matrix(int n, char c2) {
        SecureRandom secureRandom;
        GF2Matrix gF2Matrix = secureRandom2;
        SecureRandom secureRandom2 = secureRandom;
        secureRandom = new SecureRandom();
        gF2Matrix(n, c2, secureRandom2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GF2Matrix(int n, char c2, SecureRandom secureRandom) {
        if (n <= 0) throw new ArithmeticException("Size of matrix is non-positive.");
        if (c2 != 'I') {
            if (c2 != 'L') {
                if (c2 != 'R') {
                    if (c2 != 'U') {
                        if (c2 != 'Z') throw new ArithmeticException("Unknown matrix type.");
                        int n2 = n;
                        this.assignZeroMatrix(n2, n2);
                        return;
                    } else {
                        this.assignRandomUpperTriangularMatrix(n, secureRandom);
                    }
                    return;
                } else {
                    this.assignRandomRegularMatrix(n, secureRandom);
                }
                return;
            } else {
                this.assignRandomLowerTriangularMatrix(n, secureRandom);
            }
            return;
        } else {
            this.assignUnitMatrix(n);
        }
    }

    public GF2Matrix(GF2Matrix gF2Matrix) {
        this.numColumns = gF2Matrix.getNumColumns();
        this.numRows = gF2Matrix.getNumRows();
        this.length = gF2Matrix.length;
        this.matrix = new int[gF2Matrix.matrix.length][];
        int n = 0;
        while (true) {
            int[][] nArray = this.matrix;
            if (n >= this.matrix.length) break;
            nArray[n] = IntUtils.clone(gF2Matrix.matrix[n]);
            ++n;
        }
    }

    private GF2Matrix(int n, int n2) {
        if (n2 > 0 && n > 0) {
            this.assignZeroMatrix(n, n2);
            return;
        }
        throw new ArithmeticException("size of matrix is non-positive");
    }

    private void assignZeroMatrix(int n, int n2) {
        int n3 = this.numRows = n;
        this.numColumns = n2;
        this.length = n = n2 + 31 >>> 5;
        this.matrix = new int[n3][n];
        for (n = 0; n < this.numRows; ++n) {
            for (n2 = 0; n2 < this.length; ++n2) {
                this.matrix[n][n2] = 0;
            }
        }
    }

    private void assignUnitMatrix(int n) {
        int n2;
        int n3 = this.numRows = n;
        this.numColumns = n;
        this.length = n = n + 31 >>> 5;
        this.matrix = new int[n3][n];
        for (n = 0; n < this.numRows; ++n) {
            for (n2 = 0; n2 < this.length; ++n2) {
                this.matrix[n][n2] = 0;
            }
        }
        for (n = 0; n < this.numRows; ++n) {
            n2 = n & 0x1F;
            this.matrix[n][n >>> 5] = 1 << n2;
        }
    }

    private void assignRandomLowerTriangularMatrix(int n, SecureRandom secureRandom) {
        int n2 = this.numRows = n;
        this.numColumns = n;
        this.length = n = n + 31 >>> 5;
        this.matrix = new int[n2][n];
        for (n = 0; n < this.numRows; ++n) {
            int n3 = n;
            int n4 = n3 >>> 5;
            int n5 = n3 & 0x1F;
            int n6 = 31 - n5;
            n5 = 1 << n5;
            for (int k = 0; k < n4; ++k) {
                this.matrix[n][k] = secureRandom.nextInt();
            }
            this.matrix[n][n4] = secureRandom.nextInt() >>> n6 | n5;
            ++n4;
            while (n4 < this.length) {
                this.matrix[n][n4] = 0;
                ++n4;
            }
        }
    }

    private void assignRandomUpperTriangularMatrix(int n, SecureRandom secureRandom) {
        int n2 = n;
        int n3 = this.numRows = n;
        this.numColumns = n;
        this.length = n = n + 31 >>> 5;
        this.matrix = new int[n3][n];
        n = n2 & 0x1F;
        n = n == 0 ? -1 : (1 << n) - 1;
        for (int k = 0; k < this.numRows; ++k) {
            int n4 = k;
            int n5 = n4 >>> 5;
            int n6 = n4 & 0x1F;
            int n7 = 1 << n6;
            for (int i2 = 0; i2 < n5; ++i2) {
                this.matrix[k][i2] = 0;
            }
            this.matrix[k][n5] = secureRandom.nextInt() << n6 | n7;
            ++n5;
            while (n5 < (n6 = this.length)) {
                this.matrix[k][n5] = secureRandom.nextInt();
                ++n5;
            }
            int[] nArray = this.matrix[k];
            n5 = n6 - 1;
            nArray[n5] = nArray[n5] & n;
        }
    }

    private void assignRandomRegularMatrix(int n, SecureRandom object) {
        int n2;
        this.numRows = n;
        this.numColumns = n;
        this.length = n2 = n + 31 >>> 5;
        this.matrix = new int[n][n2];
        GF2Matrix gF2Matrix = (GF2Matrix)new GF2Matrix(n, 'L', (SecureRandom)object).rightMultiply(new GF2Matrix(n, 'U', (SecureRandom)object));
        object = new Permutation(n, (SecureRandom)object).getVector();
        for (int k = 0; k < n; ++k) {
            GF2Matrix gF2Matrix2 = this;
            int[] nArray = gF2Matrix2.matrix[object[k]];
            int n3 = gF2Matrix2.length;
            System.arraycopy(gF2Matrix.matrix[k], 0, nArray, 0, n3);
        }
    }

    public static GF2Matrix[] createRandomRegularMatrixAndItsInverse(int n, SecureRandom object) {
        GF2Matrix gF2Matrix;
        int n2;
        GF2Matrix gF2Matrix2;
        GF2Matrix gF2Matrix3;
        int n3;
        Permutation permutation;
        GF2Matrix gF2Matrix4;
        GF2Matrix gF2Matrix5;
        int n4 = n;
        GF2Matrix[] gF2MatrixArray = new GF2Matrix[2];
        int n5 = n4 + 31 >> 5;
        GF2Matrix gF2Matrix6 = gF2Matrix5;
        GF2Matrix gF2Matrix7 = gF2Matrix4;
        GF2Matrix gF2Matrix8 = (GF2Matrix)new GF2Matrix(n, 'L', (SecureRandom)object).rightMultiply(new GF2Matrix(n, 'U', (SecureRandom)object));
        Permutation permutation2 = permutation;
        object = new Permutation(n, (SecureRandom)object).getVector();
        int[][] nArray = new int[n4][n5];
        for (n3 = 0; n3 < n; ++n3) {
            System.arraycopy(gF2Matrix8.matrix[object[n3]], 0, nArray[n3], 0, n5);
        }
        object = gF2Matrix3;
        gF2Matrix3 = new GF2Matrix(n, nArray);
        gF2MatrixArray[0] = object;
        object = gF2Matrix2;
        gF2Matrix2 = new GF2Matrix(n, 'I');
        int n6 = 0;
        while (n6 < n) {
            int n7 = n6;
            int n8 = n7 & 0x1F;
            n3 = n7 >>> 5;
            n8 = 1 << n8;
            for (int k = n2 = n6 + 1; k < n; ++k) {
                if ((gF2Matrix6.matrix[k][n3] & n8) == 0) continue;
                for (int i2 = 0; i2 <= n3; ++i2) {
                    int[][] nArray2 = ((GF2Matrix)object).matrix;
                    int[] nArray3 = ((GF2Matrix)object).matrix[k];
                    nArray3[i2] = nArray3[i2] ^ nArray2[n6][i2];
                }
            }
            n6 = n2;
        }
        gF2Matrix6 = gF2Matrix;
        gF2Matrix = new GF2Matrix(n, 'I');
        --n;
        while (n >= 0) {
            int n9 = n;
            n6 = n9 & 0x1F;
            int n10 = n9 >>> 5;
            n6 = 1 << n6;
            for (n3 = (v909895) - 1; n3 >= 0; --n3) {
                if ((gF2Matrix7.matrix[n3][n10] & n6) == 0) continue;
                for (n2 = n10; n2 < n5; ++n2) {
                    int[][] nArray4 = gF2Matrix6.matrix;
                    int[] nArray5 = gF2Matrix6.matrix[n3];
                    nArray5[n2] = nArray5[n2] ^ nArray4[n][n2];
                }
            }
            --n;
        }
        gF2MatrixArray[1] = (GF2Matrix)gF2Matrix6.rightMultiply(((GF2Matrix)object).rightMultiply(permutation2));
        return gF2MatrixArray;
    }

    private static void swapRows(int[][] object, int n, int n2) {
        int[][] nArray = object;
        int[][] nArray2 = object;
        object = nArray[n];
        nArray[n] = nArray2[n2];
        nArray2[n2] = (int[])object;
    }

    private static void addToRow(int[] nArray, int[] nArray2, int n) {
        for (int k = nArray2.length - 1; k >= n; --k) {
            nArray2[k] = nArray[k] ^ nArray2[k];
        }
    }

    public int[][] getIntArray() {
        return this.matrix;
    }

    public int getLength() {
        return this.length;
    }

    public int[] getRow(int n) {
        return this.matrix[n];
    }

    @Override
    public byte[] getEncoded() {
        GF2Matrix gF2Matrix = this;
        int n = gF2Matrix.numColumns + 7 >>> 3;
        int n2 = gF2Matrix.numRows;
        byte[] byArray = new byte[n * n2 + 8];
        LittleEndianConversions.I2OSP(n2, byArray, 0);
        LittleEndianConversions.I2OSP(gF2Matrix.numColumns, byArray, 4);
        int n3 = gF2Matrix.numColumns;
        int n4 = n3 >>> 5;
        int n5 = n3 & 0x1F;
        int n6 = 8;
        for (int k = 0; k < this.numRows; ++k) {
            int n7 = 0;
            while (n7 < n4) {
                LittleEndianConversions.I2OSP(this.matrix[k][n7], byArray, n6);
                ++n7;
                n6 += 4;
            }
            for (n7 = 0; n7 < n5; n7 += 8) {
                byArray[n6++] = (byte)(this.matrix[k][n4] >>> n7 & 0xFF);
            }
        }
        return byArray;
    }

    public double getHammingWeight() {
        double d2 = 0.0;
        double d3 = 0.0;
        int n = this.numColumns & 0x1F;
        int n2 = n == 0 ? this.length : this.length - 1;
        for (int k = 0; k < this.numRows; ++k) {
            int n3;
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = this.matrix[k][n4];
                for (int i2 = 0; i2 < 32; ++i2) {
                    d2 += (double)(n3 >>> i2 & 1);
                    d3 += 1.0;
                }
            }
            n4 = this.matrix[k][this.length - 1];
            for (n3 = 0; n3 < n; ++n3) {
                d2 += (double)(n4 >>> n3 & 1);
                d3 += 1.0;
            }
        }
        return d2 / d3;
    }

    @Override
    public boolean isZero() {
        for (int k = 0; k < this.numRows; ++k) {
            for (int i2 = 0; i2 < this.length; ++i2) {
                if (this.matrix[k][i2] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public GF2Matrix getLeftSubMatrix() {
        int n = this.numRows;
        if (this.numColumns > n) {
            int n2 = n;
            int n3 = n2 + 31 >> 5;
            int[][] nArray = new int[n2][n3];
            int n4 = (1 << (n2 & 0x1F)) - 1;
            if (n4 == 0) {
                n4 = -1;
            }
            --n;
            while (n >= 0) {
                System.arraycopy(this.matrix[n], 0, nArray[n], 0, n3);
                int[] nArray2 = nArray[n];
                int n5 = n3 - 1;
                nArray2[n5] = nArray2[n5] & n4;
                --n;
            }
            return new GF2Matrix(this.numRows, nArray);
        }
        throw new ArithmeticException("empty submatrix");
    }

    public GF2Matrix extendLeftCompactForm() {
        GF2Matrix gF2Matrix;
        GF2Matrix gF2Matrix2 = this;
        int n = this.numRows;
        int n2 = gF2Matrix2.numColumns + n;
        GF2Matrix gF2Matrix3 = gF2Matrix;
        gF2Matrix = new GF2Matrix(n, n2);
        int n3 = gF2Matrix2.numRows;
        n = n3 - 1 + this.numColumns;
        n2 = n3 - 1;
        while (n2 >= 0) {
            int[] nArray = gF2Matrix3.matrix[n2];
            int n4 = this.length;
            System.arraycopy(this.matrix[n2], 0, nArray, 0, n4);
            int[] nArray2 = gF2Matrix3.matrix[n2];
            int n5 = n >> 5;
            nArray2[n5] = nArray2[n5] | 1 << (n & 0x1F);
            --n2;
            --n;
        }
        return gF2Matrix3;
    }

    public GF2Matrix getRightSubMatrix() {
        int n = this.numColumns;
        int n2 = this.numRows;
        if (n > n2) {
            GF2Matrix gF2Matrix;
            int n3 = n2;
            int n4 = n3 >> 5;
            int n5 = n3 & 0x1F;
            GF2Matrix gF2Matrix2 = gF2Matrix;
            gF2Matrix = new GF2Matrix(n2, n - n2);
            for (n = this.numRows - 1; n >= 0; --n) {
                int n6;
                if (n5 != 0) {
                    int n7;
                    n6 = n4;
                    for (n2 = 0; n2 < (n7 = gF2Matrix2.length) - 1; ++n2) {
                        int[] nArray = this.matrix[n];
                        gF2Matrix2.matrix[n][n2] = nArray[n6++] >>> n5 | nArray[n6] << 32 - n5;
                    }
                    int[] nArray = gF2Matrix2.matrix[n];
                    int n8 = n7 - 1;
                    int[] nArray2 = this.matrix[n];
                    int n9 = n6 + 1;
                    nArray[n8] = nArray2[n6] >>> n5;
                    if (n9 >= this.length) continue;
                    int n10 = n7 - 1;
                    nArray[n10] = nArray[n10] | nArray2[n9] << 32 - n5;
                    continue;
                }
                GF2Matrix gF2Matrix3 = gF2Matrix2;
                int[] nArray = gF2Matrix3.matrix[n];
                n6 = gF2Matrix3.length;
                System.arraycopy(this.matrix[n], n4, nArray, 0, n6);
            }
            return gF2Matrix2;
        }
        throw new ArithmeticException("empty submatrix");
    }

    public GF2Matrix extendRightCompactForm() {
        GF2Matrix gF2Matrix;
        GF2Matrix gF2Matrix2 = gF2Matrix;
        int n = this.numRows;
        gF2Matrix = new GF2Matrix(n, n + this.numColumns);
        int n2 = this.numRows;
        int n3 = n2 >> 5;
        int n4 = n2 & 0x1F;
        for (int k = (v910437) - 1; k >= 0; --k) {
            int[] nArray = gF2Matrix2.matrix[k];
            int[] nArray2 = nArray;
            int n5 = k >> 5;
            nArray[n5] = nArray[n5] | 1 << (k & 0x1F);
            if (n4 != 0) {
                int n6;
                int n7;
                n5 = n3;
                for (n7 = 0; n7 < (n6 = this.length) - 1; ++n7) {
                    n6 = this.matrix[k][n7];
                    int[] nArray3 = gF2Matrix2.matrix[k];
                    int n8 = n5++;
                    nArray3[n5] = nArray3[n8] | n6 << n4;
                    nArray3[n5] = nArray3[n5] | n6 >>> 32 - n4;
                }
                n7 = this.matrix[k][n6 - 1];
                int[] nArray4 = gF2Matrix2.matrix[k];
                int n9 = n5 + 1;
                nArray4[n5] = nArray4[n5] | n7 << n4;
                if (n9 >= gF2Matrix2.length) continue;
                nArray4[n9] = nArray4[n9] | n7 >>> 32 - n4;
                continue;
            }
            n5 = this.length;
            System.arraycopy(this.matrix[k], 0, nArray2, n3, n5);
        }
        return gF2Matrix2;
    }

    public Matrix computeTranspose() {
        int n;
        int[][] nArray = new int[this.numColumns][this.numRows + 31 >>> 5];
        for (int k = 0; k < (n = this.numRows); ++k) {
            for (n = 0; n < this.numColumns; ++n) {
                int n2 = n;
                int n3 = n2 >>> 5;
                int n4 = n2 & 0x1F;
                int n5 = this.matrix[k][n3] >>> n4 & 1;
                int n6 = k;
                n3 = n6 >>> 5;
                n4 = n6 & 0x1F;
                if (n5 != 1) continue;
                int[] nArray2 = nArray[n];
                nArray2[n3] = nArray2[n3] | 1 << n4;
            }
        }
        return new GF2Matrix(n, nArray);
    }

    @Override
    public Matrix computeInverse() {
        int n = this.numRows;
        if (n == this.numColumns) {
            int n2;
            int n3;
            int[][] nArray = new int[n][this.length];
            for (int k = (v910647) - 1; k >= 0; --k) {
                nArray[k] = IntUtils.clone(this.matrix[k]);
            }
            int n4 = this.numRows;
            int[][] nArray2 = new int[n4][this.length];
            int n5 = n4 - 1;
            while (n5 >= 0) {
                int n6 = n5--;
                n3 = n6 >> 5;
                n2 = n6 & 0x1F;
                nArray2[n6][n3] = 1 << n2;
            }
            for (n5 = 0; n5 < this.numRows; ++n5) {
                int n7;
                int n8 = n5;
                n3 = n8 >> 5;
                n2 = 1 << (n8 & 0x1F);
                if ((nArray[n8][n3] & n2) == 0) {
                    n7 = 0;
                    for (int k = n5 + 1; k < this.numRows; ++k) {
                        if ((nArray[k][n3] & n2) == 0) continue;
                        n7 = 1;
                        GF2Matrix.swapRows(nArray, n5, k);
                        GF2Matrix.swapRows(nArray2, n5, k);
                        k = this.numRows;
                    }
                    if (n7 == 0) {
                        throw new ArithmeticException("Matrix is not invertible.");
                    }
                }
                for (n7 = this.numRows - 1; n7 >= 0; --n7) {
                    int[] nArray3;
                    if (n7 == n5 || ((nArray3 = nArray[n7])[n3] & n2) == 0) continue;
                    GF2Matrix.addToRow(nArray[n5], nArray3, n3);
                    GF2Matrix.addToRow(nArray2[n5], nArray2[n7], 0);
                }
            }
            return new GF2Matrix(this.numColumns, nArray2);
        }
        throw new ArithmeticException("Matrix is not invertible.");
    }

    public Matrix leftMultiply(Permutation object) {
        int[] nArray = ((Permutation)object).getVector();
        object = nArray;
        int n = this.numRows;
        if (nArray.length == n) {
            int[][] nArrayArray = new int[n][];
            for (int k = (v910794) - 1; k >= 0; --k) {
                nArrayArray[k] = IntUtils.clone(this.matrix[object[k]]);
            }
            return new GF2Matrix(this.numRows, nArrayArray);
        }
        throw new ArithmeticException("length mismatch");
    }

    @Override
    public Vector leftMultiply(Vector object) {
        if (object instanceof GF2Vector) {
            if (((Vector)object).length == this.numRows) {
                int n;
                int n2;
                GF2Matrix gF2Matrix = this;
                object = ((GF2Vector)object).getVecArray();
                int[] nArray = new int[gF2Matrix.length];
                int n3 = gF2Matrix.numRows;
                int n4 = n3 >> 5;
                int n5 = 1 << (n3 & 0x1F);
                int n6 = 0;
                for (n2 = 0; n2 < n4; ++n2) {
                    n = 1;
                    do {
                        if ((object[n2] & n) != 0) {
                            for (int k = 0; k < this.length; ++k) {
                                nArray[k] = nArray[k] ^ this.matrix[n6][k];
                            }
                        }
                        ++n6;
                    } while ((n <<= 1) != 0);
                }
                for (n2 = 1; n2 != n5; n2 <<= 1) {
                    if ((object[n4] & n2) != 0) {
                        for (n = 0; n < this.length; ++n) {
                            nArray[n] = nArray[n] ^ this.matrix[n6][n];
                        }
                    }
                    ++n6;
                }
                return new GF2Vector(nArray, this.numColumns);
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("vector is not defined over GF(2)");
    }

    public Vector leftMultiplyLeftCompactForm(Vector object) {
        if (object instanceof GF2Vector) {
            if (((Vector)object).length == this.numRows) {
                int n;
                int n2;
                int n3;
                int n4;
                object = ((GF2Vector)object).getVecArray();
                int n5 = this.numRows;
                int[] nArray = new int[n5 + this.numColumns + 31 >>> 5];
                int n6 = n5 >>> 5;
                int n7 = 0;
                for (n4 = 0; n4 < n6; ++n4) {
                    n3 = 1;
                    do {
                        if ((object[n4] & n3) != 0) {
                            for (n2 = 0; n2 < this.length; ++n2) {
                                nArray[n2] = nArray[n2] ^ this.matrix[n7][n2];
                            }
                            int n8 = this.numColumns;
                            n2 = n8 + n7 >>> 5;
                            n = n8 + n7 & 0x1F;
                            nArray[n2] = nArray[n2] | 1 << n;
                        }
                        ++n7;
                    } while ((n3 <<= 1) != 0);
                }
                n4 = 1 << (this.numRows & 0x1F);
                for (n3 = 1; n3 != n4; n3 <<= 1) {
                    if ((object[n6] & n3) != 0) {
                        for (n2 = 0; n2 < this.length; ++n2) {
                            nArray[n2] = nArray[n2] ^ this.matrix[n7][n2];
                        }
                        int n9 = this.numColumns;
                        n2 = n9 + n7 >>> 5;
                        n = n9 + n7 & 0x1F;
                        nArray[n2] = nArray[n2] | 1 << n;
                    }
                    ++n7;
                }
                return new GF2Vector(nArray, this.numRows + this.numColumns);
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("vector is not defined over GF(2)");
    }

    @Override
    public Matrix rightMultiply(Matrix matrix) {
        if (matrix instanceof GF2Matrix) {
            if (matrix.numRows == this.numColumns) {
                GF2Matrix gF2Matrix;
                GF2Matrix gF2Matrix2 = (GF2Matrix)matrix;
                GF2Matrix gF2Matrix3 = gF2Matrix;
                int n = this.numRows;
                gF2Matrix = new GF2Matrix(n, matrix.numColumns);
                n = this.numColumns & 0x1F;
                int n2 = n == 0 ? this.length : this.length - 1;
                for (int k = 0; k < this.numRows; ++k) {
                    int n3;
                    int n4;
                    int n5;
                    int n6 = 0;
                    for (n5 = 0; n5 < n2; ++n5) {
                        n4 = this.matrix[k][n5];
                        for (n3 = 0; n3 < 32; ++n3) {
                            if ((n4 & 1 << n3) != 0) {
                                for (int i2 = 0; i2 < gF2Matrix2.length; ++i2) {
                                    int[] nArray = gF2Matrix3.matrix[k];
                                    nArray[i2] = nArray[i2] ^ gF2Matrix2.matrix[n6][i2];
                                }
                            }
                            ++n6;
                        }
                    }
                    n5 = this.matrix[k][this.length - 1];
                    for (n4 = 0; n4 < n; ++n4) {
                        if ((n5 & 1 << n4) != 0) {
                            for (n3 = 0; n3 < gF2Matrix2.length; ++n3) {
                                int[] nArray = gF2Matrix3.matrix[k];
                                nArray[n3] = nArray[n3] ^ gF2Matrix2.matrix[n6][n3];
                            }
                        }
                        ++n6;
                    }
                }
                return gF2Matrix3;
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("matrix is not defined over GF(2)");
    }

    @Override
    public Matrix rightMultiply(Permutation object) {
        int[] nArray = ((Permutation)object).getVector();
        object = nArray;
        int n = this.numColumns;
        if (nArray.length == n) {
            GF2Matrix gF2Matrix;
            GF2Matrix gF2Matrix2 = gF2Matrix;
            gF2Matrix = new GF2Matrix(this.numRows, n);
            for (n = this.numColumns - 1; n >= 0; --n) {
                int n2 = n;
                int n3 = n2 >>> 5;
                int n4 = n2 & 0x1F;
                Object object2 = object[n2];
                reference var6_6 = object2 >>> 5;
                int n5 = object2 & 0x1F;
                for (int k = this.numRows - 1; k >= 0; --k) {
                    int[] nArray2 = gF2Matrix2.matrix[k];
                    nArray2[n3] = nArray2[n3] | (this.matrix[k][var6_6] >>> n5 & 1) << n4;
                }
            }
            return gF2Matrix2;
        }
        throw new ArithmeticException("length mismatch");
    }

    @Override
    public Vector rightMultiply(Vector object) {
        if (object instanceof GF2Vector) {
            if (((Vector)object).length == this.numColumns) {
                int n;
                object = ((GF2Vector)object).getVecArray();
                int[] nArray = new int[this.numRows + 31 >>> 5];
                for (int k = 0; k < (n = this.numRows); ++k) {
                    int n2;
                    n = 0;
                    for (n2 = 0; n2 < this.length; ++n2) {
                        n ^= this.matrix[k][n2] & object[n2];
                    }
                    n2 = 0;
                    for (int i2 = 0; i2 < 32; ++i2) {
                        n2 ^= n >>> i2 & 1;
                    }
                    if (n2 != 1) continue;
                    n = k >>> 5;
                    nArray[n] = nArray[n] | 1 << (k & 0x1F);
                }
                return new GF2Vector(nArray, n);
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("vector is not defined over GF(2)");
    }

    public Vector rightMultiplyRightCompactForm(Vector object) {
        if (object instanceof GF2Vector) {
            if (((Vector)object).length == this.numColumns + this.numRows) {
                int n;
                object = ((GF2Vector)object).getVecArray();
                int n2 = this.numRows;
                int[] nArray = new int[n2 + 31 >>> 5];
                int n3 = n2 >> 5;
                int n4 = n2 & 0x1F;
                for (int k = 0; k < (n = this.numRows); ++k) {
                    int n5;
                    Object object2;
                    n = k >> 5;
                    int n6 = k & 0x1F;
                    Object object3 = object[n] >>> n6 & 1;
                    if (n4 != 0) {
                        int n7;
                        object2 = n3;
                        for (n5 = 0; n5 < (n7 = this.length) - 1; ++n5) {
                            Object object4 = object3;
                            int n8 = object2;
                            object3 = n8 + 1;
                            object2 = object[n8] >>> n4 | object[object3] << 32 - n4;
                            object2 = object4 ^ this.matrix[k][n5] & object2;
                            Object object5 = object3;
                            object3 = object2;
                            object2 = object5;
                        }
                        n5 = object2 + 1;
                        Object object6 = object;
                        object2 = object6[object2] >>> n4;
                        if (n5 < ((Object)object6).length) {
                            object2 |= object[n5] << 32 - n4;
                        }
                        object3 ^= this.matrix[k][n7 - 1] & object2;
                    } else {
                        object2 = n3;
                        for (n5 = 0; n5 < this.length; ++n5) {
                            Object object7 = object3;
                            int n9 = object2;
                            object3 = n9 + 1;
                            object2 = object7 ^ this.matrix[k][n5] & object[n9];
                            Object object8 = object2;
                            object2 = object3;
                            object3 = object8;
                        }
                    }
                    n5 = 0;
                    for (object2 = 0; object2 < 32; ++object2) {
                        n5 ^= object3 & 1;
                        object3 >>>= 1;
                    }
                    if (n5 != 1) continue;
                    nArray[n] = nArray[n] | 1 << n6;
                }
                return new GF2Vector(nArray, n);
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("vector is not defined over GF(2)");
    }

    public boolean equals(Object object) {
        if (!(object instanceof GF2Matrix)) {
            return false;
        }
        object = (GF2Matrix)object;
        if (this.numRows == ((Matrix)object).numRows && this.numColumns == ((Matrix)object).numColumns && this.length == ((GF2Matrix)object).length) {
            for (int k = 0; k < this.numRows; ++k) {
                if (IntUtils.equals(this.matrix[k], ((GF2Matrix)object).matrix[k])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = (this.numRows * 31 + this.numColumns) * 31 + this.length;
        for (int k = 0; k < this.numRows; ++k) {
            n *= 31;
            n = Arrays.hashCode(this.matrix[k]) + n;
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer;
        int n = this.numColumns & 0x1F;
        int n2 = n == 0 ? this.length : this.length - 1;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (int k = 0; k < this.numRows; ++k) {
            int n3;
            int n4;
            stringBuffer2.append(k + ": ");
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = this.matrix[k][n4];
                for (int i2 = 0; i2 < 32; ++i2) {
                    if ((n3 >>> i2 & 1) == 0) {
                        stringBuffer2.append('0');
                        continue;
                    }
                    stringBuffer2.append('1');
                }
                stringBuffer2.append(' ');
            }
            n4 = this.matrix[k][this.length - 1];
            for (n3 = 0; n3 < n; ++n3) {
                if ((n4 >>> n3 & 1) == 0) {
                    stringBuffer2.append('0');
                    continue;
                }
                stringBuffer2.append('1');
            }
            stringBuffer2.append('\n');
        }
        return stringBuffer2.toString();
    }
}

