/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.ContentInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.SignedData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.icao.DataGroupHash;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.icao.LDSSecurityObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.icao.LDSVersionInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractTaggedLDSFile;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SignedDataUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

public class SODFile
extends AbstractTaggedLDSFile {
    private static final long serialVersionUID = -1081347374739311111L;
    private static final String ICAO_LDS_SOD_OID = "2.23.136.1.1.1";
    private static final String ICAO_LDS_SOD_ALT_OID = "1.3.27.1.1.1";
    private static final String SDU_LDS_SOD_OID = "1.2.528.1.1006.1.20.1";
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private transient SignedData signedData;

    public SODFile(String string2, String string3, Map<Integer, byte[]> map, PrivateKey privateKey, X509Certificate x509Certificate) {
        this(string2, string3, map, privateKey, x509Certificate, null);
    }

    public SODFile(String string2, String string3, AlgorithmParameterSpec algorithmParameterSpec, Map<Integer, byte[]> map, PrivateKey privateKey, X509Certificate x509Certificate) {
        this(string2, string3, algorithmParameterSpec, map, privateKey, x509Certificate, null);
    }

    public SODFile(String string2, String string3, Map<Integer, byte[]> map, PrivateKey privateKey, X509Certificate x509Certificate, String string4) {
        this(string2, string3, map, privateKey, x509Certificate, string4, null, null);
    }

    public SODFile(String string2, String string3, AlgorithmParameterSpec algorithmParameterSpec, Map<Integer, byte[]> map, PrivateKey privateKey, X509Certificate x509Certificate, String string4) {
        this(string2, string3, algorithmParameterSpec, map, privateKey, x509Certificate, string4, null, null);
    }

    public SODFile(String object, String object2, Map<Integer, byte[]> map, PrivateKey privateKey, X509Certificate x509Certificate, String string2, String string3, String string4) {
        String string5 = object;
        String string6 = object2;
        String string7 = object;
        super(119);
        try {
            object = SODFile.toContentInfo(ICAO_LDS_SOD_OID, (String)object, map, string3, string4);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error creating signedData", iOException);
        }
        object2 = SignedDataUtil.signData(string7, (String)object2, ICAO_LDS_SOD_OID, (ContentInfo)object, privateKey, string2);
        this.signedData = SignedDataUtil.createSignedData(string5, string6, ICAO_LDS_SOD_OID, (ContentInfo)object, (byte[])object2, x509Certificate);
    }

    public SODFile(String object, String object2, AlgorithmParameterSpec algorithmParameterSpec, Map<Integer, byte[]> map, PrivateKey privateKey, X509Certificate x509Certificate, String string2, String string3, String string4) {
        String string5 = object;
        String string6 = object2;
        String string7 = object;
        super(119);
        try {
            object = SODFile.toContentInfo(ICAO_LDS_SOD_OID, (String)object, map, string3, string4);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error creating signedData", iOException);
        }
        object2 = SignedDataUtil.signData(string7, (String)object2, algorithmParameterSpec, ICAO_LDS_SOD_OID, (ContentInfo)object, privateKey, string2);
        this.signedData = SignedDataUtil.createSignedData(string5, string6, algorithmParameterSpec, ICAO_LDS_SOD_OID, (ContentInfo)object, (byte[])object2, x509Certificate);
    }

    public SODFile(String string2, String string3, Map<Integer, byte[]> map, byte[] byArray, X509Certificate x509Certificate) {
        super(119);
        if (map != null) {
            try {
                this.signedData = SignedDataUtil.createSignedData(string2, string3, ICAO_LDS_SOD_OID, SODFile.toContentInfo(ICAO_LDS_SOD_OID, string2, map, null, null), byArray, x509Certificate);
                return;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Error creating signedData", iOException);
            }
        }
        throw new IllegalArgumentException("Cannot construct security object from null datagroup hashes");
    }

    public SODFile(String object, String string2, AlgorithmParameterSpec algorithmParameterSpec, Map<Integer, byte[]> map, byte[] byArray, X509Certificate x509Certificate) {
        super(119);
        if (map != null) {
            String string3;
            String string4;
            String string5;
            try {
                SODFile sODFile = this;
                string5 = object;
                string4 = string2;
                string3 = ICAO_LDS_SOD_OID;
                object = SODFile.toContentInfo(ICAO_LDS_SOD_OID, (String)object, map, null, null);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Error creating signedData", iOException);
            }
            sODFile.signedData = SignedDataUtil.createSignedData(string5, string4, algorithmParameterSpec, string3, (ContentInfo)object, byArray, x509Certificate);
            return;
        }
        throw new IllegalArgumentException("Cannot construct security object from null datagroup hashes");
    }

    public SODFile(InputStream inputStream) {
        SODFile sODFile = this;
        super(119, inputStream);
        SignedDataUtil.getSignerInfo(sODFile.signedData);
    }

    private static String getDigestAlgorithm(LDSSecurityObject lDSSecurityObject) {
        try {
            return SignedDataUtil.lookupMnemonicByOID(lDSSecurityObject.getDigestAlgorithmIdentifier().getAlgorithm().getId());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.log(Level.WARNING, "Exception", noSuchAlgorithmException);
            return null;
        }
    }

    private static ContentInfo toContentInfo(String object, String object2, Map<Integer, byte[]> object3, String string2, String string3) {
        DEROctetString dEROctetString;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        AlgorithmIdentifier algorithmIdentifier;
        Map<Integer, byte[]> map = object3;
        DataGroupHash[] dataGroupHashArray = new DataGroupHash[map.size()];
        int n = 0;
        Iterator<Map.Entry<Integer, byte[]>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            DEROctetString dEROctetString2;
            DataGroupHash dataGroupHash;
            int n2 = iterator.next().getKey();
            byte[] byArray = object3.get(n2);
            DataGroupHash dataGroupHash2 = dataGroupHash;
            DEROctetString dEROctetString3 = dEROctetString2;
            dEROctetString2 = new DEROctetString(byArray);
            dataGroupHash = new DataGroupHash(n2, dEROctetString3);
            dataGroupHashArray[n++] = dataGroupHash2;
        }
        object3 = algorithmIdentifier;
        algorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(SignedDataUtil.lookupOIDByMnemonic((String)object2)));
        if (string2 == null) {
            LDSSecurityObject lDSSecurityObject;
            object2 = lDSSecurityObject;
            lDSSecurityObject = new LDSSecurityObject((AlgorithmIdentifier)object3, dataGroupHashArray);
        } else {
            LDSVersionInfo lDSVersionInfo;
            LDSSecurityObject lDSSecurityObject;
            object2 = lDSSecurityObject;
            LDSVersionInfo lDSVersionInfo2 = lDSVersionInfo;
            lDSVersionInfo = new LDSVersionInfo(string2, string3);
            lDSSecurityObject = new LDSSecurityObject((AlgorithmIdentifier)object3, dataGroupHashArray, lDSVersionInfo2);
        }
        object3 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier((String)object);
        object = dEROctetString;
        dEROctetString = new DEROctetString((ASN1Encodable)object2);
        return new ContentInfo((ASN1ObjectIdentifier)object3, (ASN1Encodable)object);
    }

    /*
     * Loose catch block
     */
    private static LDSSecurityObject getLDSSecurityObject(SignedData object) {
        ASN1Object aSN1Object;
        block18: {
            block19: {
                ASN1InputStream aSN1InputStream;
                block17: {
                    ContentInfo contentInfo = ((SignedData)object).getEncapContentInfo();
                    ContentInfo contentInfo2 = contentInfo;
                    object = contentInfo.getContentType().getId();
                    {
                        catch (IOException iOException) {
                            throw new IllegalStateException("Could not read security object in signedData", iOException);
                        }
                    }
                    aSN1Object = (ASN1OctetString)contentInfo2.getContent();
                    if (ICAO_LDS_SOD_OID.equals(object)) break block17;
                    if (SDU_LDS_SOD_OID.equals(object)) break block17;
                    if (ICAO_LDS_SOD_ALT_OID.equals(object)) break block17;
                    LOGGER.warning("SignedData does not appear to contain an LDS SOd. (content type is " + (String)object + ", was expecting 2.23.136.1.1.1)");
                }
                object = aSN1InputStream;
                aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(((ASN1OctetString)aSN1Object).getOctets()));
                aSN1Object = aSN1InputStream.readObject();
                if (!(aSN1Object instanceof ASN1Sequence)) break block18;
                Object object2 = object;
                aSN1Object = LDSSecurityObject.getInstance(aSN1Object);
                if (((ASN1InputStream)object2).readObject() == null) break block19;
                LOGGER.warning("Ignoring extra object found after LDSSecurityObject...");
            }
            ((InputStream)object).close();
            return aSN1Object;
        }
        try {
            throw new IllegalStateException("Expected ASN1Sequence, found " + aSN1Object.getClass().getSimpleName());
        }
        catch (Throwable throwable) {
            ((InputStream)object).close();
            throw throwable;
        }
    }

    @Override
    public void readContent(InputStream inputStream) {
        this.signedData = SignedDataUtil.readSignedData(inputStream);
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        SignedDataUtil.writeData(this.signedData, outputStream);
    }

    public Map<Integer, byte[]> getDataGroupHashes() {
        TreeMap<Integer, byte[]> treeMap;
        DataGroupHash[] dataGroupHashArray = SODFile.getLDSSecurityObject(dataGroupHashArray.signedData).getDatagroupHash();
        TreeMap<Integer, byte[]> treeMap2 = treeMap;
        treeMap = new TreeMap<Integer, byte[]>();
        for (DataGroupHash dataGroupHash : dataGroupHashArray) {
            Object object = dataGroupHash;
            object = ((DataGroupHash)object).getDataGroupHashValue().getOctets();
            treeMap2.put(dataGroupHash.getDataGroupNumber(), (byte[])object);
        }
        return treeMap2;
    }

    public byte[] getEncryptedDigest() {
        return SignedDataUtil.getEncryptedDigest(this.signedData);
    }

    public AlgorithmParameterSpec getDigestEncryptionAlgorithmParams() {
        return SignedDataUtil.getDigestEncryptionAlgorithmParams(this.signedData);
    }

    public byte[] getEContent() {
        return SignedDataUtil.getEContent(this.signedData);
    }

    public String getDigestAlgorithm() {
        return SODFile.getDigestAlgorithm(SODFile.getLDSSecurityObject(this.signedData));
    }

    public String getSignerInfoDigestAlgorithm() {
        return SignedDataUtil.getSignerInfoDigestAlgorithm(this.signedData);
    }

    public String getDigestEncryptionAlgorithm() {
        return SignedDataUtil.getDigestEncryptionAlgorithm(this.signedData);
    }

    public String getLDSVersion() {
        LDSVersionInfo lDSVersionInfo = SODFile.getLDSSecurityObject(((SODFile)((Object)lDSVersionInfo)).signedData).getVersionInfo();
        if (lDSVersionInfo == null) {
            return null;
        }
        return lDSVersionInfo.getLdsVersion();
    }

    public String getUnicodeVersion() {
        LDSVersionInfo lDSVersionInfo = SODFile.getLDSSecurityObject(((SODFile)((Object)lDSVersionInfo)).signedData).getVersionInfo();
        if (lDSVersionInfo == null) {
            return null;
        }
        return lDSVersionInfo.getUnicodeVersion();
    }

    public List<X509Certificate> getDocSigningCertificates() {
        return SignedDataUtil.getCertificates(this.signedData);
    }

    public X509Certificate getDocSigningCertificate() {
        if ((this = ((SODFile)this).getDocSigningCertificates()) != null && !this.isEmpty()) {
            Object object = this;
            return (X509Certificate)object.get(object.size() - 1);
        }
        return null;
    }

    public X500Principal getIssuerX500Principal() {
        block5: {
            Object object;
            block4: {
                try {
                    object = SignedDataUtil.getIssuerAndSerialNumber(((SODFile)object).signedData);
                    if (object != null) break block4;
                    return null;
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "Could not get issuer", iOException);
                    return null;
                }
            }
            object = ((IssuerAndSerialNumber)object).getName();
            if (object != null) break block5;
            return null;
        }
        return new X500Principal(((ASN1Object)object).getEncoded("DER"));
    }

    public BigInteger getSerialNumber() {
        IssuerAndSerialNumber issuerAndSerialNumber = SignedDataUtil.getIssuerAndSerialNumber(((SODFile)((Object)issuerAndSerialNumber)).signedData);
        if (issuerAndSerialNumber == null) {
            return null;
        }
        return issuerAndSerialNumber.getSerialNumber().getValue();
    }

    public byte[] getSubjectKeyIdentifier() {
        return SignedDataUtil.getSubjectKeyIdentifier(this.signedData);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder;
        SODFile sODFile = serializable;
        Serializable serializable = stringBuilder;
        new StringBuilder().append("SODFile ");
        Iterator<X509Certificate> iterator = sODFile.getDocSigningCertificates().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            Serializable serializable2 = serializable;
            Serializable serializable3 = serializable2;
            ((StringBuilder)serializable2).append(iterator.next().getIssuerX500Principal().getName());
            ((StringBuilder)serializable3).append(", ");
        }
        try {
            return ((StringBuilder)serializable).toString();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Unexpected exception", exception);
            return "SODFile";
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == sODFile2) {
            return true;
        }
        if (!object.getClass().equals(sODFile2.getClass())) {
            return false;
        }
        SODFile sODFile = sODFile2;
        SODFile sODFile2 = (SODFile)object;
        return Arrays.equals(sODFile.getEncoded(), sODFile2.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded()) * 11 + 111;
    }
}

