package vn.kalapa.ekyc.extension

import android.animation.AnimatorSet
import android.animation.ObjectAnimator
import android.animation.ValueAnimator
import android.view.View
import android.view.animation.OvershootInterpolator
import androidx.core.animation.doOnEnd

object ViewUtils {

    fun fadeIn(view: View) {
        ViewUtils.visible(view)
        ObjectAnimator.ofFloat(view, "alpha", 0f, 1f).apply {
            this.duration = 300L
            this.start()
        }
    }

    fun fadeOut(view: View) {
        ObjectAnimator.ofFloat(view, "alpha", 1f, 0f).apply {
            this.duration = 300L
            this.doOnEnd { ViewUtils.gone(view) }
            this.start()
        }
    }

    fun scaleIn(view: View) {
        ViewUtils.visible(view)
        AnimatorSet().apply {
            playTogether(
                ObjectAnimator.ofFloat(view, "scaleX", 0f, 1f),
                ObjectAnimator.ofFloat(view, "scaleY", 0f, 1f)
            )
            this.duration = 600L
            this.start()
        }
    }

    fun appearAnimZoom(view: View) {
        ViewUtils.visible(view)
        AnimatorSet().apply {
            playTogether(
                ObjectAnimator.ofFloat(view, "alpha", 0f, 1f),
                ObjectAnimator.ofFloat(view, "scaleX", 0.5f, 1f),
                ObjectAnimator.ofFloat(view, "scaleY", 0.5f, 1f),
                ObjectAnimator.ofFloat(view, "translationY", 100f, 0f)
            )
            this.duration = 500L
            this.interpolator = OvershootInterpolator(2f)
            this.start()
        }
    }

    fun animBounce(view: View) {
        ValueAnimator.ofFloat(0.95f, 1.05f).apply {
            duration = 500L
            addUpdateListener { anim ->
                view.scaleX = anim.animatedValue as Float
                view.scaleY = anim.animatedValue as Float
            }
            repeatCount = ValueAnimator.INFINITE
            repeatMode = ValueAnimator.REVERSE
            start()
        }
    }

    fun shakeLeftRight(view: View, shakeDuration: Long = 500L, restDuration: Long = 300L) {
        AnimatorSet().apply {
            playSequentially(
                ObjectAnimator.ofFloat(
                    view,
                    "translationX",
                    0f,
                    5f,
                    -5f,
                    5f,
                    -5f,
                    3f,
                    -3f,
                    0f
                ).apply {
                    duration = shakeDuration
                },
                ValueAnimator.ofFloat(0f, 1f).apply {
                    duration = restDuration
                }
            )
            start()
        }
    }

    fun appearAnimSpin(view: View) {
        ViewUtils.visible(view)
        AnimatorSet().apply {
            playTogether(
                ObjectAnimator.ofFloat(view, "scaleX", 0f, 1f),
                ObjectAnimator.ofFloat(view, "scaleY", 0f, 1f),
                ObjectAnimator.ofFloat(view, "alpha", 0f, 1f),
                ObjectAnimator.ofFloat(view, "rotation", 0f, 360f)
            )
            this.duration = 300L
            this.start()
        }
    }

    fun gone(view : View) {
        view.visibility = View.GONE
    }

    fun visible(view : View) {
        view.visibility = View.VISIBLE
    }
}