/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class ASN1OutputStream {
    private OutputStream os;

    public static ASN1OutputStream create(OutputStream outputStream) {
        return new ASN1OutputStream(outputStream);
    }

    public static ASN1OutputStream create(OutputStream outputStream, String string) {
        if (string.equals("DER")) {
            return new DEROutputStream(outputStream);
        }
        if (string.equals("DL")) {
            return new DLOutputStream(outputStream);
        }
        return new ASN1OutputStream(outputStream);
    }

    public ASN1OutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    public final void writeLength(int n) {
        if (n > 127) {
            int n2 = 1;
            int n3 = n;
            while ((n3 >>>= 8) != 0) {
                ++n2;
            }
            this.write((byte)(n2 | 0x80));
            for (n2 = (n2 - 1) * 8; n2 >= 0; n2 -= 8) {
                this.write((byte)(n >> n2));
            }
        } else {
            this.write((byte)n);
        }
    }

    public final void write(int n) {
        this.os.write(n);
    }

    public final void write(byte[] byArray, int n, int n2) {
        this.os.write(byArray, n, n2);
    }

    public final void writeElements(ASN1Encodable[] aSN1EncodableArray) {
        int n = aSN1EncodableArray.length;
        for (int k = 0; k < n; ++k) {
            this.writePrimitive(aSN1EncodableArray[k].toASN1Primitive(), true);
        }
    }

    public final void writeElements(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.writePrimitive(((ASN1Encodable)enumeration.nextElement()).toASN1Primitive(), true);
        }
    }

    public final void writeEncoded(boolean bl, int n, byte by) {
        if (bl) {
            this.write(n);
        }
        ASN1OutputStream aSN1OutputStream = this;
        aSN1OutputStream.writeLength(1);
        aSN1OutputStream.write(by);
    }

    public final void writeEncoded(boolean bl, int n, byte[] byArray) {
        if (bl) {
            this.write(n);
        }
        this.writeLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public final void writeEncoded(boolean bl, int n, byte[] byArray, int n2, int n3) {
        if (bl) {
            this.write(n);
        }
        ASN1OutputStream aSN1OutputStream = this;
        aSN1OutputStream.writeLength(n3);
        aSN1OutputStream.write(byArray, n2, n3);
    }

    public final void writeEncoded(boolean bl, int n, byte by, byte[] byArray) {
        if (bl) {
            this.write(n);
        }
        this.writeLength(byArray.length + 1);
        this.write(by);
        this.write(byArray, 0, byArray.length);
    }

    public final void writeEncoded(boolean bl, int n, byte by, byte[] byArray, int n2, int n3, byte by2) {
        if (bl) {
            this.write(n);
        }
        this.writeLength(n3 + 2);
        this.write(by);
        this.write(byArray, n2, n3);
        this.write(by2);
    }

    public final void writeEncoded(boolean bl, int n, int n2, byte[] byArray) {
        this.writeTag(bl, n, n2);
        this.writeLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public final void writeEncodedIndef(boolean bl, int n, int n2, byte[] byArray) {
        ASN1OutputStream aSN1OutputStream = this;
        ASN1OutputStream aSN1OutputStream2 = this;
        aSN1OutputStream2.writeTag(bl, n, n2);
        aSN1OutputStream2.write(128);
        int n3 = byArray.length;
        aSN1OutputStream.write(byArray, 0, n3);
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }

    public final void writeEncodedIndef(boolean bl, int n, ASN1Encodable[] aSN1EncodableArray) {
        if (bl) {
            this.write(n);
        }
        ASN1OutputStream aSN1OutputStream = this;
        aSN1OutputStream.write(128);
        aSN1OutputStream.writeElements(aSN1EncodableArray);
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }

    public final void writeEncodedIndef(boolean bl, int n, Enumeration enumeration) {
        if (bl) {
            this.write(n);
        }
        ASN1OutputStream aSN1OutputStream = this;
        aSN1OutputStream.write(128);
        aSN1OutputStream.writeElements(enumeration);
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTag(boolean bl, int n, int n2) {
        void byArray2;
        void var3_6;
        if (!bl) {
            return;
        }
        if (var3_6 < 31) {
            this.write(byArray2 | var3_6);
        } else {
            this.write((int)(byArray2 | 0x1F));
            if (var3_6 < 128) {
                this.write((int)var3_6);
            } else {
                int n3 = 5;
                byte[] byArray = new byte[5];
                byte[] byArray3 = byArray;
                int n4 = 4;
                byArray[n4] = (byte)(var3_6 & 0x7F);
                do {
                    byArray3[--n4] = (byte)((var3_6 >>= 7) & 0x7F | 0x80);
                } while (var3_6 > 127);
                int n42 = n3 - n4;
                this.write(byArray3, n4, n42);
            }
        }
    }

    public void writeObject(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            ASN1OutputStream aSN1OutputStream = this;
            aSN1OutputStream.writePrimitive(aSN1Encodable.toASN1Primitive(), true);
            aSN1OutputStream.flushInternal();
            return;
        }
        throw new IOException("null object detected");
    }

    public void writeObject(ASN1Primitive aSN1Primitive) {
        if (aSN1Primitive != null) {
            ASN1OutputStream aSN1OutputStream = this;
            aSN1OutputStream.writePrimitive(aSN1Primitive, true);
            aSN1OutputStream.flushInternal();
            return;
        }
        throw new IOException("null object detected");
    }

    public void writePrimitive(ASN1Primitive aSN1Primitive, boolean bl) {
        aSN1Primitive.encode(this, bl);
    }

    public void close() {
        this.os.close();
    }

    public void flush() {
        this.os.flush();
    }

    public void flushInternal() {
    }

    public DEROutputStream getDERSubStream() {
        return new DEROutputStream(this.os);
    }

    public ASN1OutputStream getDLSubStream() {
        return new DLOutputStream(this.os);
    }
}

