/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Time;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Properties;
import java.math.BigInteger;

public class TBSCertificate
extends ASN1Object {
    public ASN1Sequence seq;
    public ASN1Integer version;
    public ASN1Integer serialNumber;
    public AlgorithmIdentifier signature;
    public X500Name issuer;
    public Time startDate;
    public Time endDate;
    public X500Name subject;
    public SubjectPublicKeyInfo subjectPublicKeyInfo;
    public DERBitString issuerUniqueId;
    public DERBitString subjectUniqueId;
    public Extensions extensions;

    public static TBSCertificate getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return TBSCertificate.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static TBSCertificate getInstance(Object object) {
        if (object instanceof TBSCertificate) {
            return (TBSCertificate)object;
        }
        if (object != null) {
            return new TBSCertificate(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private TBSCertificate(ASN1Sequence aSN1Sequence) {
        block14: {
            int n;
            boolean bl;
            boolean bl2;
            int n2;
            block12: {
                block13: {
                    block11: {
                        n2 = 0;
                        this.seq = aSN1Sequence;
                        if (aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject) {
                            this.version = ASN1Integer.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(0), true);
                        } else {
                            ASN1Integer aSN1Integer;
                            n2 = -1;
                            ASN1Integer aSN1Integer2 = aSN1Integer;
                            aSN1Integer = new ASN1Integer(0L);
                            this.version = aSN1Integer2;
                        }
                        bl2 = false;
                        bl = false;
                        if (!this.version.hasValue(BigInteger.valueOf(0L))) break block11;
                        bl2 = true;
                        break block12;
                    }
                    if (!this.version.hasValue(BigInteger.valueOf(1L))) break block13;
                    bl = true;
                    break block12;
                }
                if (!this.version.hasValue(BigInteger.valueOf(2L))) break block14;
            }
            this.serialNumber = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(n2 + 1));
            this.signature = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n2 + 2));
            this.issuer = X500Name.getInstance(aSN1Sequence.getObjectAt(n2 + 3));
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(n2 + 4);
            this.startDate = Time.getInstance(aSN1Sequence2.getObjectAt(0));
            this.endDate = Time.getInstance(aSN1Sequence2.getObjectAt(1));
            this.subject = X500Name.getInstance(aSN1Sequence.getObjectAt(n2 + 5));
            this.subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1Sequence.getObjectAt(n2 += 6));
            if (n != 0 && bl2) {
                throw new IllegalArgumentException("version 1 certificate contains extra data");
            }
            for (n = aSN1Sequence.size() - n2 - 1; n > 0; --n) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(n2 + n);
                int n3 = aSN1TaggedObject.getTagNo();
                if (n3 != 1) {
                    if (n3 != 2) {
                        if (n3 == 3) {
                            if (!bl) {
                                this.extensions = Extensions.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, true));
                                continue;
                            }
                            throw new IllegalArgumentException("version 2 certificate cannot contain extensions");
                        }
                        throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b.a(aSN1TaggedObject, b.a("Unknown tag encountered in structure: ")));
                    }
                    this.subjectUniqueId = DERBitString.getInstance(aSN1TaggedObject, false);
                    continue;
                }
                this.issuerUniqueId = DERBitString.getInstance(aSN1TaggedObject, false);
            }
            return;
        }
        throw new IllegalArgumentException("version number not recognised");
    }

    public int getVersionNumber() {
        return this.version.intValueExact() + 1;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public Time getStartDate() {
        return this.startDate;
    }

    public Time getEndDate() {
        return this.endDate;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public DERBitString getIssuerUniqueId() {
        return this.issuerUniqueId;
    }

    public DERBitString getSubjectUniqueId() {
        return this.subjectUniqueId;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (Properties.getPropertyValue("com.fis.ekyc.nfc.build_in.bouncycastle.x509.allow_non-der_tbscert") != null) {
            Extensions extensions;
            ASN1EncodableVector aSN1EncodableVector;
            ASN1Primitive aSN1Primitive;
            Object object;
            ASN1EncodableVector aSN1EncodableVector2;
            if (Properties.isOverrideSet("com.fis.ekyc.nfc.build_in.bouncycastle.x509.allow_non-der_tbscert")) {
                return this.seq;
            }
            ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2;
            aSN1EncodableVector2 = new ASN1EncodableVector();
            if (!this.version.hasValue(BigIntegers.ZERO)) {
                DERTaggedObject dERTaggedObject;
                object = dERTaggedObject;
                aSN1Primitive = this.version;
                dERTaggedObject = new DERTaggedObject(true, 0, aSN1Primitive);
                aSN1EncodableVector3.add((ASN1Encodable)object);
            }
            ASN1EncodableVector aSN1EncodableVector4 = aSN1EncodableVector3;
            aSN1EncodableVector3.add(this.serialNumber);
            aSN1EncodableVector3.add(this.signature);
            aSN1EncodableVector4.add(this.issuer);
            object = aSN1EncodableVector;
            ((ASN1EncodableVector)object)(2);
            ((ASN1EncodableVector)object).add(this.startDate);
            aSN1EncodableVector.add(this.endDate);
            aSN1EncodableVector4.add(new DERSequence((ASN1EncodableVector)object));
            object = this.subject;
            if (object != null) {
                aSN1EncodableVector3.add((ASN1Encodable)object);
            } else {
                DERSequence dERSequence;
                object = dERSequence;
                dERSequence = new DERSequence();
                aSN1EncodableVector3.add((ASN1Encodable)object);
            }
            aSN1EncodableVector3.add(this.subjectPublicKeyInfo);
            object = this.issuerUniqueId;
            if (object != null) {
                DERTaggedObject dERTaggedObject;
                aSN1Primitive = dERTaggedObject;
                dERTaggedObject = new DERTaggedObject(false, 1, (ASN1Encodable)object);
                aSN1EncodableVector3.add(aSN1Primitive);
            }
            if ((object = this.subjectUniqueId) != null) {
                DERTaggedObject dERTaggedObject;
                aSN1Primitive = dERTaggedObject;
                dERTaggedObject = new DERTaggedObject(false, 2, (ASN1Encodable)object);
                aSN1EncodableVector3.add(aSN1Primitive);
            }
            if ((extensions = this.extensions) != null) {
                DERTaggedObject dERTaggedObject;
                object = dERTaggedObject;
                dERTaggedObject = new DERTaggedObject(true, 3, extensions);
                aSN1EncodableVector3.add((ASN1Encodable)object);
            }
            return new DERSequence(aSN1EncodableVector3);
        }
        return this.seq;
    }
}

