/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public final class Kangaroo {
    private static final int DIGESTLEN = 32;

    public static class KangarooSponge {
        private static long[] KeccakRoundConstants = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};
        private final int theRounds;
        private final int theRateBytes;
        private final long[] theState = new long[25];
        private final byte[] theQueue;
        private int bytesInQueue;
        private boolean squeezing;

        public KangarooSponge(int n, int n2) {
            int n3;
            this.theRateBytes = n3 = 1600 - (n << 1) >> 3;
            this.theRounds = n2;
            this.theQueue = new byte[n3];
            this.initSponge();
        }

        private void initSponge() {
            KangarooSponge kangarooSponge = this;
            Arrays.fill(kangarooSponge.theState, 0L);
            Arrays.fill(kangarooSponge.theQueue, (byte)0);
            kangarooSponge.bytesInQueue = 0;
            kangarooSponge.squeezing = false;
        }

        private void absorb(byte[] byArray, int n, int n2) {
            if (!this.squeezing) {
                int n3 = 0;
                block0: while (n3 < n2) {
                    int n4 = this.bytesInQueue;
                    if (n4 == 0 && n3 <= n2 - this.theRateBytes) {
                        while (true) {
                            int n5 = n3;
                            KangarooSponge kangarooSponge = this;
                            kangarooSponge.KangarooAbsorb(byArray, n + n3);
                            n3 = kangarooSponge.theRateBytes;
                            n4 = n5 + n3;
                            if (n4 > n2 - n3) {
                                n3 = n4;
                                continue block0;
                            }
                            n3 = n4;
                        }
                    }
                    KangarooSponge kangarooSponge = this;
                    n4 = Math.min(this.theRateBytes - n4, n2 - n3);
                    int n6 = n + n3;
                    byte[] byArray2 = kangarooSponge.theQueue;
                    int n7 = kangarooSponge.bytesInQueue;
                    System.arraycopy(byArray, n6, byArray2, n7, n4);
                    this.bytesInQueue = n6 = this.bytesInQueue + n4;
                    n3 += n4;
                    if (n6 != this.theRateBytes) continue;
                    KangarooSponge kangarooSponge2 = this;
                    kangarooSponge2.KangarooAbsorb(kangarooSponge2.theQueue, 0);
                    kangarooSponge2.bytesInQueue = 0;
                }
                return;
            }
            throw new IllegalStateException("attempt to absorb while squeezing");
        }

        private void padAndSwitchToSqueezingPhase() {
            int n;
            for (int k = this.bytesInQueue; k < (n = this.theRateBytes); ++k) {
                this.theQueue[k] = 0;
            }
            KangarooSponge kangarooSponge = this;
            byte[] byArray = kangarooSponge.theQueue;
            int n2 = n - 1;
            byArray[n2] = (byte)(byArray[n2] ^ 0x80);
            kangarooSponge.KangarooAbsorb(kangarooSponge.theQueue, 0);
            kangarooSponge.KangarooExtract();
            kangarooSponge.bytesInQueue = kangarooSponge.theRateBytes;
            kangarooSponge.squeezing = true;
        }

        private void squeeze(byte[] byArray, int n, int n2) {
            if (!this.squeezing) {
                this.padAndSwitchToSqueezingPhase();
            }
            int n3 = 0;
            while (n3 < n2) {
                if (this.bytesInQueue == 0) {
                    KangarooSponge kangarooSponge = this;
                    kangarooSponge.KangarooPermutation();
                    kangarooSponge.KangarooExtract();
                    kangarooSponge.bytesInQueue = kangarooSponge.theRateBytes;
                }
                int n4 = n3;
                KangarooSponge kangarooSponge = this;
                int n5 = Math.min(kangarooSponge.bytesInQueue, n2 - n3);
                int n6 = n3;
                n3 = this.theRateBytes - this.bytesInQueue;
                int n7 = n + n6;
                System.arraycopy(kangarooSponge.theQueue, n3, byArray, n7, n5);
                kangarooSponge.bytesInQueue -= n5;
                n3 = n4 + n5;
            }
        }

        private void KangarooAbsorb(byte[] byArray, int n) {
            int n2 = this.theRateBytes >> 3;
            for (int k = 0; k < n2; ++k) {
                this.theState[k] = this.theState[k] ^ Pack.littleEndianToLong(byArray, n);
                n += 8;
            }
            this.KangarooPermutation();
        }

        private void KangarooExtract() {
            KangarooSponge kangarooSponge = this;
            int n = kangarooSponge.theRateBytes >> 3;
            byte[] byArray = kangarooSponge.theQueue;
            Pack.longToLittleEndian(this.theState, 0, n, byArray, 0);
        }

        private void KangarooPermutation() {
            long[] lArray = this.theState;
            long l = this.theState[0];
            long l2 = lArray[1];
            long l3 = this.theState[2];
            long l4 = lArray[3];
            long l5 = this.theState[4];
            long l6 = lArray[5];
            long l7 = this.theState[6];
            long l8 = lArray[7];
            long l9 = this.theState[8];
            long l10 = lArray[9];
            long l11 = this.theState[10];
            long l12 = lArray[11];
            long l13 = this.theState[12];
            long l14 = lArray[13];
            long l15 = this.theState[14];
            long l16 = lArray[15];
            long l17 = this.theState[16];
            long l18 = lArray[17];
            long l19 = this.theState[18];
            long l20 = lArray[19];
            long l21 = this.theState[20];
            long l22 = lArray[21];
            long l23 = this.theState[22];
            long l24 = lArray[23];
            long l25 = this.theState[24];
            int n = KeccakRoundConstants.length - this.theRounds;
            for (int k = 0; k < this.theRounds; ++k) {
                long l26 = l;
                l = l26 ^ l6 ^ l11 ^ l16 ^ l21;
                long l27 = l2 ^ l7 ^ l12 ^ l17 ^ l22;
                long l28 = l3 ^ l8 ^ l13 ^ l18 ^ l23;
                long l29 = l4 ^ l9 ^ l14 ^ l19 ^ l24;
                long l30 = l5 ^ l10 ^ l15 ^ l20 ^ l25;
                long l31 = (l27 << 1 | l27 >>> -1) ^ l30;
                long l32 = (l28 << 1 | l28 >>> -1) ^ l;
                l27 = (l29 << 1 | l29 >>> -1) ^ l27;
                l28 = (l30 << 1 | l30 >>> -1) ^ l28;
                l = (l << 1 | l >>> -1) ^ l29;
                l29 = l26 ^ l31;
                long l33 = l7;
                long l34 = l2;
                l2 = l6 ^ l31;
                l6 = l11 ^ l31;
                l7 = l16 ^ l31;
                l11 = l21 ^ l31;
                l16 = l34 ^ l32;
                l21 = l33 ^ l32;
                long l35 = l;
                long l36 = l20;
                long l37 = l;
                long l38 = l15;
                long l39 = l;
                long l40 = l10;
                long l41 = l;
                long l42 = l5;
                long l43 = l;
                long l44 = l14;
                long l45 = l9;
                long l46 = l4;
                long l47 = l3;
                l = l12 ^ l32;
                l3 = l17 ^ l32;
                l4 = l22 ^ l32;
                l5 = l47 ^ l27;
                l8 ^= l27;
                l9 = l13 ^ l27;
                l10 = l18 ^ l27;
                l12 = l23 ^ l27;
                l13 = l46 ^ l28;
                l14 = l45 ^ l28;
                l15 = l44 ^ l28;
                l17 = l19 ^ l28;
                l18 = l24 ^ l28;
                l19 = l42 ^ l43;
                l20 = l40 ^ l41;
                l22 = l38 ^ l39;
                l23 = l36 ^ l37;
                l24 = l25 ^ l35;
                l16 = l16 << 1 | l16 >>> 63;
                l21 = l21 << 44 | l21 >>> 20;
                l20 = l20 << 20 | l20 >>> 44;
                l12 = l12 << 61 | l12 >>> 3;
                l22 = l22 << 39 | l22 >>> 25;
                l11 = l11 << 18 | l11 >>> 46;
                l5 = l5 << 62 | l5 >>> 2;
                l9 = l9 << 43 | l9 >>> 21;
                l15 = l15 << 25 | l15 >>> 39;
                l23 = l23 << 8 | l23 >>> 56;
                l18 = l18 << 56 | l18 >>> 8;
                l7 = l7 << 41 | l7 >>> 23;
                l19 = l19 << 27 | l19 >>> 37;
                l24 = l24 << 14 | l24 >>> 50;
                l4 = l4 << 2 | l4 >>> 62;
                l14 = l14 << 55 | l14 >>> 9;
                l3 = l3 << 45 | l3 >>> 19;
                l2 = l2 << 36 | l2 >>> 28;
                l13 = l13 << 28 | l13 >>> 36;
                l17 = l17 << 21 | l17 >>> 43;
                l10 = l10 << 15 | l10 >>> 49;
                l = l << 10 | l >>> 54;
                l8 = l8 << 6 | l8 >>> 58;
                l6 = l6 << 3 | l6 >>> 61;
                long l48 = l29 ^ (l21 ^ 0xFFFFFFFFFFFFFFFFL) & l9;
                long l49 = l4;
                long l50 = l5;
                long l51 = l7;
                long l52 = l4;
                long l53 = l22;
                long l54 = l7;
                long l55 = l22;
                long l56 = l18;
                long l57 = l19;
                long l58 = l10;
                long l59 = l18;
                long l60 = l;
                long l61 = l10;
                long l62 = l;
                long l63 = l11;
                long l64 = l16;
                long l65 = l23;
                long l66 = l11;
                long l67 = l15;
                long l68 = l23;
                long l69 = l15;
                long l70 = l12;
                long l71 = l13;
                long l72 = l3;
                long l73 = l12;
                long l74 = l6;
                long l75 = l3;
                long l76 = l6;
                long l77 = l24;
                long l78 = l17;
                long l79 = l9;
                l9 = l21 ^ (l9 ^ 0xFFFFFFFFFFFFFFFFL) & l17;
                l17 = l79 ^ (l17 ^ 0xFFFFFFFFFFFFFFFFL) & l24;
                l24 = l78 ^ (l24 ^ 0xFFFFFFFFFFFFFFFFL) & l29;
                l21 = l77 ^ (l29 ^ 0xFFFFFFFFFFFFFFFFL) & l21;
                l6 = l13 ^ (l20 ^ 0xFFFFFFFFFFFFFFFFL) & l6;
                l3 = l20 ^ (l76 ^ 0xFFFFFFFFFFFFFFFFL) & l3;
                l12 = l74 ^ (l75 ^ 0xFFFFFFFFFFFFFFFFL) & l12;
                l13 = l72 ^ (l73 ^ 0xFFFFFFFFFFFFFFFFL) & l13;
                l20 = l70 ^ (l71 ^ 0xFFFFFFFFFFFFFFFFL) & l20;
                l15 = l16 ^ (l8 ^ 0xFFFFFFFFFFFFFFFFL) & l15;
                l23 = l8 ^ (l69 ^ 0xFFFFFFFFFFFFFFFFL) & l23;
                l11 = l67 ^ (l68 ^ 0xFFFFFFFFFFFFFFFFL) & l11;
                l16 = l65 ^ (l66 ^ 0xFFFFFFFFFFFFFFFFL) & l16;
                l8 = l63 ^ (l64 ^ 0xFFFFFFFFFFFFFFFFL) & l8;
                l = l19 ^ (l2 ^ 0xFFFFFFFFFFFFFFFFL) & l;
                l10 = l2 ^ (l62 ^ 0xFFFFFFFFFFFFFFFFL) & l10;
                l18 = l60 ^ (l61 ^ 0xFFFFFFFFFFFFFFFFL) & l18;
                l19 = l58 ^ (l59 ^ 0xFFFFFFFFFFFFFFFFL) & l19;
                l2 = l56 ^ (l57 ^ 0xFFFFFFFFFFFFFFFFL) & l2;
                l22 = l5 ^ (l14 ^ 0xFFFFFFFFFFFFFFFFL) & l22;
                l7 = l14 ^ (l55 ^ 0xFFFFFFFFFFFFFFFFL) & l7;
                l4 = l53 ^ (l54 ^ 0xFFFFFFFFFFFFFFFFL) & l4;
                l5 = l51 ^ (l52 ^ 0xFFFFFFFFFFFFFFFFL) & l5;
                l25 = l49 ^ (l50 ^ 0xFFFFFFFFFFFFFFFFL) & l14;
                l14 = l48 ^ KeccakRoundConstants[n + k];
                long l80 = l14;
                long l81 = l9;
                long l82 = l17;
                long l83 = l24;
                long l84 = l21;
                long l85 = l12;
                long l86 = l13;
                long l87 = l20;
                long l88 = l15;
                long l89 = l23;
                long l90 = l16;
                long l91 = l22;
                l24 = l5;
                l23 = l4;
                l22 = l7;
                l21 = l91;
                l20 = l2;
                l17 = l10;
                l16 = l;
                l15 = l8;
                l14 = l90;
                l13 = l11;
                l12 = l89;
                l11 = l88;
                l10 = l87;
                l9 = l86;
                l8 = l85;
                l7 = l3;
                l5 = l84;
                l4 = l83;
                l3 = l82;
                l2 = l81;
                l = l80;
            }
            long[] lArray2 = lArray;
            lArray2[0] = l;
            lArray2[1] = l2;
            lArray2[2] = l3;
            lArray2[3] = l4;
            lArray2[4] = l5;
            lArray2[5] = l6;
            lArray2[6] = l7;
            lArray2[7] = l8;
            lArray2[8] = l9;
            lArray2[9] = l10;
            lArray2[10] = l11;
            lArray2[11] = l12;
            lArray2[12] = l13;
            lArray2[13] = l14;
            lArray2[14] = l15;
            lArray2[15] = l16;
            lArray2[16] = l17;
            lArray2[17] = l18;
            lArray2[18] = l19;
            lArray2[19] = l20;
            lArray2[20] = l21;
            lArray2[21] = l22;
            lArray2[22] = l23;
            lArray2[23] = l24;
            lArray[24] = l25;
        }
    }

    public static abstract class KangarooBase
    implements ExtendedDigest,
    Xof {
        private static final int BLKSIZE = 8192;
        private static final byte[] SINGLE = new byte[]{7};
        private static final byte[] INTERMEDIATE = new byte[]{11};
        private static final byte[] FINAL = new byte[]{-1, -1, 6};
        private static final byte[] FIRST = new byte[]{3, 0, 0, 0, 0, 0, 0, 0};
        private final byte[] singleByte = new byte[1];
        private final KangarooSponge theTree;
        private final KangarooSponge theLeaf;
        private final int theChainLen;
        private byte[] thePersonal;
        private boolean squeezing;
        private int theCurrNode;
        private int theProcessed;

        public KangarooBase(int n, int n2, int n3) {
            this.theTree = new KangarooSponge(n, n2);
            this.theLeaf = new KangarooSponge(n, n2);
            this.theChainLen = n >> 2;
            this.buildPersonal(null);
        }

        private void buildPersonal(byte[] byArray) {
            int n = byArray == null ? 0 : byArray.length;
            byte[] byArray2 = KangarooBase.lengthEncode(n);
            byArray = byArray == null ? new byte[n + byArray2.length] : Arrays.copyOf(byArray, n + byArray2.length);
            this.thePersonal = byArray;
            int n2 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n, n2);
        }

        private void processData(byte[] byArray, int n, int n2) {
            if (!this.squeezing) {
                KangarooSponge kangarooSponge = this.theCurrNode == 0 ? this.theTree : this.theLeaf;
                int n3 = 8192 - this.theProcessed;
                if (n3 >= n2) {
                    kangarooSponge.absorb(byArray, n, n2);
                    this.theProcessed += n2;
                    return;
                }
                if (n3 > 0) {
                    kangarooSponge.absorb(byArray, n, n3);
                    this.theProcessed += n3;
                }
                while (n3 < n2) {
                    if (this.theProcessed == 8192) {
                        this.switchLeaf(true);
                    }
                    KangarooBase kangarooBase = this;
                    int n4 = Math.min(n2 - n3, 8192);
                    kangarooBase.theLeaf.absorb(byArray, n + n3, n4);
                    kangarooBase.theProcessed += n4;
                    n3 += n4;
                }
                return;
            }
            throw new IllegalStateException("attempt to absorb while squeezing");
        }

        private void switchLeaf(boolean bl) {
            if (this.theCurrNode == 0) {
                this.theTree.absorb(KangarooBase.FIRST, 0, KangarooBase.FIRST.length);
            } else {
                KangarooBase kangarooBase = this;
                kangarooBase.theLeaf.absorb(KangarooBase.INTERMEDIATE, 0, KangarooBase.INTERMEDIATE.length);
                int n = kangarooBase.theChainLen;
                byte[] byArray = new byte[n];
                kangarooBase.theLeaf.squeeze(byArray, 0, n);
                kangarooBase.theTree.absorb(byArray, 0, this.theChainLen);
                kangarooBase.theLeaf.initSponge();
            }
            if (bl) {
                ++this.theCurrNode;
            }
            this.theProcessed = 0;
        }

        private void switchToSqueezing() {
            KangarooBase kangarooBase = this;
            kangarooBase.processData(kangarooBase.thePersonal, 0, kangarooBase.thePersonal.length);
            if (kangarooBase.theCurrNode == 0) {
                this.switchSingle();
            } else {
                this.switchFinal();
            }
        }

        private void switchSingle() {
            KangarooBase kangarooBase = this;
            kangarooBase.theTree.absorb(KangarooBase.SINGLE, 0, 1);
            kangarooBase.theTree.padAndSwitchToSqueezingPhase();
        }

        private void switchFinal() {
            KangarooBase kangarooBase = this;
            kangarooBase.switchLeaf(false);
            Object object = this = (Object)KangarooBase.lengthEncode(kangarooBase.theCurrNode);
            kangarooBase.theTree.absorb((byte[])object, 0, ((Object)object).length);
            kangarooBase.theTree.absorb(KangarooBase.FINAL, 0, KangarooBase.FINAL.length);
            kangarooBase.theTree.padAndSwitchToSqueezingPhase();
        }

        private static byte[] lengthEncode(long l) {
            int n = 0;
            if (l != 0L) {
                n = 1;
                long l2 = l;
                while ((l2 >>= 8) != 0L) {
                    n = (byte)(n + 1);
                }
            }
            byte[] byArray = new byte[n + 1];
            byte[] byArray2 = byArray;
            int n2 = n;
            byArray[n2] = n2;
            for (int k = 0; k < n; ++k) {
                byArray2[k] = (byte)(l >> (n - k - 1) * 8);
            }
            return byArray2;
        }

        @Override
        public int getByteLength() {
            return this.theTree.theRateBytes;
        }

        @Override
        public int getDigestSize() {
            return this.theChainLen >> 1;
        }

        public void init(KangarooParameters kangarooParameters) {
            KangarooBase kangarooBase = this;
            kangarooBase.buildPersonal(kangarooParameters.getPersonalisation());
            kangarooBase.reset();
        }

        @Override
        public void update(byte by) {
            KangarooBase kangarooBase = object;
            Object object = kangarooBase.singleByte;
            kangarooBase.singleByte[0] = by;
            kangarooBase.update((byte[])object, 0, 1);
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.processData(byArray, n, n2);
        }

        @Override
        public int doFinal(byte[] byArray, int n) {
            return this.doFinal(byArray, n, this.getDigestSize());
        }

        @Override
        public int doFinal(byte[] byArray, int n, int n2) {
            if (!this.squeezing) {
                int n3 = this.doOutput(byArray, n, n2);
                this.reset();
                return n3;
            }
            throw new IllegalStateException("Already outputting");
        }

        @Override
        public int doOutput(byte[] byArray, int n, int n2) {
            if (!this.squeezing) {
                this.switchToSqueezing();
            }
            if (n2 >= 0) {
                this.theTree.squeeze(byArray, n, n2);
                return n2;
            }
            throw new IllegalArgumentException("Invalid output length");
        }

        @Override
        public void reset() {
            KangarooBase kangarooBase = this;
            kangarooBase.theTree.initSponge();
            kangarooBase.theLeaf.initSponge();
            kangarooBase.theCurrNode = 0;
            kangarooBase.theProcessed = 0;
            kangarooBase.squeezing = false;
        }
    }

    public static class KangarooParameters
    implements CipherParameters {
        private byte[] thePersonal;

        public static /* synthetic */ byte[] access$002(KangarooParameters kangarooParameters, byte[] byArray) {
            kangarooParameters.thePersonal = byArray;
            return byArray;
        }

        public byte[] getPersonalisation() {
            return Arrays.clone(this.thePersonal);
        }

        public static class Builder {
            private byte[] thePersonal;

            public Builder setPersonalisation(byte[] byArray) {
                this.thePersonal = Arrays.clone(byArray);
                return this;
            }

            public KangarooParameters build() {
                KangarooParameters kangarooParameters;
                Builder builder = kangarooParameters2;
                KangarooParameters kangarooParameters2 = kangarooParameters;
                kangarooParameters = new KangarooParameters();
                byte[] byArray = builder.thePersonal;
                if (builder.thePersonal != null) {
                    KangarooParameters.access$002(kangarooParameters2, byArray);
                }
                return kangarooParameters2;
            }
        }
    }

    public static class MarsupilamiFourteen
    extends KangarooBase {
        public MarsupilamiFourteen() {
            this(32);
        }

        public MarsupilamiFourteen(int n) {
            super(256, 14, n);
        }

        @Override
        public String getAlgorithmName() {
            return "MarsupilamiFourteen";
        }
    }

    public static class KangarooTwelve
    extends KangarooBase {
        public KangarooTwelve() {
            this(32);
        }

        public KangarooTwelve(int n) {
            super(128, 12, n);
        }

        @Override
        public String getAlgorithmName() {
            return "KangarooTwelve";
        }
    }
}

