/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Wrapper;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.DESedeEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class DESedeWrapEngine
implements Wrapper {
    private static final byte[] IV2 = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    private CBCBlockCipher engine;
    private KeyParameter param;
    private ParametersWithIV paramPlusIV;
    private byte[] iv;
    private boolean forWrapping;
    public Digest sha1 = DigestFactory.createSHA1();
    public byte[] digest = new byte[20];

    private byte[] calculateCMSKeyChecksum(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        DESedeWrapEngine dESedeWrapEngine = this;
        dESedeWrapEngine.sha1.update(byArray, 0, byArray.length);
        dESedeWrapEngine.sha1.doFinal(this.digest, 0);
        System.arraycopy(dESedeWrapEngine.digest, 0, byArray2, 0, 8);
        return byArray2;
    }

    private boolean checkCMSKeyChecksum(byte[] byArray, byte[] byArray2) {
        return Arrays.constantTimeAreEqual(this.calculateCMSKeyChecksum(byArray), byArray2);
    }

    private static byte[] reverse(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            byArray2[n++] = byArray[byArray.length - n];
        }
        return byArray2;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        Object object;
        Object object2;
        DESedeWrapEngine dESedeWrapEngine = object;
        dESedeWrapEngine.forWrapping = bl;
        dESedeWrapEngine.engine = new CBCBlockCipher(new DESedeEngine());
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            cipherParameters = parametersWithRandom.getParameters();
            object2 = parametersWithRandom.getRandom();
        } else {
            object2 = CryptoServicesRegistrar.getSecureRandom();
        }
        if (cipherParameters instanceof KeyParameter) {
            ((DESedeWrapEngine)object).param = (KeyParameter)cipherParameters;
            if (((DESedeWrapEngine)object).forWrapping) {
                ParametersWithIV parametersWithIV;
                DESedeWrapEngine dESedeWrapEngine2 = object;
                SecureRandom secureRandom = object2;
                byte[] byArray = new byte[8];
                object2 = byArray;
                ((DESedeWrapEngine)object).iv = byArray;
                secureRandom.nextBytes((byte[])object2);
                object2 = parametersWithIV;
                DESedeWrapEngine dESedeWrapEngine3 = object;
                object = dESedeWrapEngine3.param;
                parametersWithIV = new ParametersWithIV((CipherParameters)object, dESedeWrapEngine3.iv);
                dESedeWrapEngine2.paramPlusIV = object2;
            }
        } else if (cipherParameters instanceof ParametersWithIV) {
            DESedeWrapEngine dESedeWrapEngine4 = object;
            object2 = (ParametersWithIV)cipherParameters;
            dESedeWrapEngine4.paramPlusIV = object2;
            dESedeWrapEngine4.iv = ((ParametersWithIV)object2).getIV();
            dESedeWrapEngine4.param = (KeyParameter)dESedeWrapEngine4.paramPlusIV.getParameters();
            if (dESedeWrapEngine4.forWrapping) {
                object = ((DESedeWrapEngine)object).iv;
                if (((DESedeWrapEngine)object).iv == null || ((Object)object).length != 8) {
                    throw new IllegalArgumentException("IV is not 8 octets");
                }
            } else {
                throw new IllegalArgumentException("You should not supply an IV for unwrapping");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return "DESede";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) {
        if (this.forWrapping) {
            byte[] byArray2 = byArray;
            byArray = new byte[n2];
            System.arraycopy(byArray2, n, byArray, 0, n2);
            byte[] byArray3 = this.calculateCMSKeyChecksum(byArray);
            int n3 = n2 + byArray3.length;
            byte[] byArray4 = byArray;
            byArray = new byte[n3];
            System.arraycopy(byArray4, 0, byArray, 0, n2);
            int n4 = byArray3.length;
            System.arraycopy(byArray3, 0, byArray, n2, n4);
            n4 = this.engine.getBlockSize();
            if (n3 % n4 == 0) {
                ParametersWithIV parametersWithIV;
                this.engine.init(true, this.paramPlusIV);
                Object object = new byte[n3];
                for (int k = 0; k != n3; k += n4) {
                    this.engine.processBlock(byArray, k, (byte[])object, k);
                }
                DESedeWrapEngine dESedeWrapEngine = this;
                byArray = dESedeWrapEngine.iv;
                byte[] byArray5 = new byte[dESedeWrapEngine.iv.length + n3];
                int n5 = byArray.length;
                System.arraycopy(byArray, 0, byArray5, 0, n5);
                n5 = this.iv.length;
                System.arraycopy(object, 0, byArray5, n5, n3);
                byte[] byArray6 = DESedeWrapEngine.reverse(byArray5);
                object = parametersWithIV;
                parametersWithIV = new ParametersWithIV(this.param, IV2);
                dESedeWrapEngine.engine.init(true, (CipherParameters)object);
                for (int k = 0; k != byArray6.length; k += n4) {
                    this.engine.processBlock(byArray6, k, byArray6, k);
                }
                return byArray6;
            }
            throw new IllegalStateException("Not multiple of block length");
        }
        throw new IllegalStateException("Not initialized for wrapping");
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) {
        if (!this.forWrapping) {
            if (byArray != null) {
                int n3 = this.engine.getBlockSize();
                if (n2 % n3 == 0) {
                    ParametersWithIV parametersWithIV;
                    ParametersWithIV parametersWithIV2;
                    Object object = parametersWithIV2;
                    parametersWithIV2 = new ParametersWithIV(this.param, IV2);
                    this.engine.init(false, (CipherParameters)object);
                    object = new byte[n2];
                    for (int k = 0; k != n2; k += n3) {
                        this.engine.processBlock(byArray, n + k, (byte[])object, k);
                    }
                    byArray = DESedeWrapEngine.reverse((byte[])object);
                    byte[] byArray2 = new byte[8];
                    this.iv = byArray2;
                    n2 = byArray.length - 8;
                    byte[] byArray3 = byArray;
                    byArray = new byte[n2];
                    System.arraycopy(byArray3, 0, byArray2, 0, 8);
                    int n4 = byArray3.length - 8;
                    System.arraycopy(byArray, 8, byArray, 0, n4);
                    Object object2 = parametersWithIV;
                    DESedeWrapEngine dESedeWrapEngine = this;
                    object = dESedeWrapEngine.param;
                    this.paramPlusIV = new ParametersWithIV((CipherParameters)object, dESedeWrapEngine.iv);
                    this.engine.init(false, (CipherParameters)object2);
                    object2 = new byte[n2];
                    for (int k = 0; k != n2; k += n3) {
                        this.engine.processBlock(byArray, k, (byte[])object2, k);
                    }
                    Object object3 = object2;
                    int n5 = n2 - 8;
                    byArray = new byte[n5];
                    object2 = new byte[8];
                    System.arraycopy(object3, 0, byArray, 0, n5);
                    System.arraycopy(object3, n5, object2, 0, 8);
                    if (this.checkCMSKeyChecksum(byArray, (byte[])object2)) {
                        return byArray;
                    }
                    throw new InvalidCipherTextException("Checksum inside ciphertext is corrupted");
                }
                throw new InvalidCipherTextException(a.a("Ciphertext not multiple of ", n3));
            }
            throw new InvalidCipherTextException("Null pointer as ciphertext");
        }
        throw new IllegalStateException("Not set for unwrapping");
    }
}

