/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Wrapper;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.GOST28147Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.GOST28147Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithUKM;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class GOST28147WrapEngine
implements Wrapper {
    private GOST28147Engine cipher;
    private GOST28147Mac mac;

    public GOST28147WrapEngine() {
        GOST28147Mac gOST28147Mac;
        GOST28147Engine gOST28147Engine;
        Object object = gOST28147Engine;
        gOST28147Engine = new GOST28147Engine();
        v1.cipher = object;
        object = gOST28147Mac;
        gOST28147Mac = new GOST28147Mac();
        v1.mac = object;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        GOST28147WrapEngine gOST28147WrapEngine = object;
        Object object = (ParametersWithUKM)cipherParameters;
        gOST28147WrapEngine.cipher.init(bl, ((ParametersWithUKM)object).getParameters());
        Object object2 = object;
        object = ((ParametersWithUKM)object2).getParameters();
        gOST28147WrapEngine.mac.init(new ParametersWithIV((CipherParameters)object, ((ParametersWithUKM)object2).getUKM()));
    }

    @Override
    public String getAlgorithmName() {
        return "GOST28147Wrap";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) {
        GOST28147WrapEngine gOST28147WrapEngine = this;
        gOST28147WrapEngine.mac.update(byArray, n, n2);
        byte[] byArray2 = new byte[gOST28147WrapEngine.mac.getMacSize() + n2];
        GOST28147WrapEngine gOST28147WrapEngine2 = this;
        gOST28147WrapEngine2.cipher.processBlock(byArray, n, byArray2, 0);
        gOST28147WrapEngine2.cipher.processBlock(byArray, n + 8, byArray2, 8);
        gOST28147WrapEngine2.cipher.processBlock(byArray, n + 16, byArray2, 16);
        gOST28147WrapEngine2.cipher.processBlock(byArray, n + 24, byArray2, 24);
        gOST28147WrapEngine2.mac.doFinal(byArray2, n2);
        return byArray2;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) {
        GOST28147WrapEngine gOST28147WrapEngine = this;
        int n3 = n2 - this.mac.getMacSize();
        byte[] byArray2 = new byte[n3];
        gOST28147WrapEngine.cipher.processBlock(byArray, n, byArray2, 0);
        gOST28147WrapEngine.cipher.processBlock(byArray, n + 8, byArray2, 8);
        gOST28147WrapEngine.cipher.processBlock(byArray, n + 16, byArray2, 16);
        gOST28147WrapEngine.cipher.processBlock(byArray, n + 24, byArray2, 24);
        byte[] byArray3 = new byte[gOST28147WrapEngine.mac.getMacSize()];
        byte[] byArray4 = byArray;
        GOST28147WrapEngine gOST28147WrapEngine2 = this;
        gOST28147WrapEngine2.mac.update(byArray2, 0, n3);
        gOST28147WrapEngine2.mac.doFinal(byArray3, 0);
        byArray = new byte[gOST28147WrapEngine2.mac.getMacSize()];
        System.arraycopy(byArray4, n + n2 - 4, byArray, 0, this.mac.getMacSize());
        if (Arrays.constantTimeAreEqual(byArray3, byArray)) {
            return byArray2;
        }
        throw new IllegalStateException("mac mismatch");
    }
}

