/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.MacCFBBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.BlockCipherPadding;

public class CFBBlockCipherMac
implements Mac {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private MacCFBBlockCipher cipher;
    private BlockCipherPadding padding;
    private int macSize;

    public CFBBlockCipherMac(BlockCipher blockCipher) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, 8, blockCipher2.getBlockSize() * 8 / 2, null);
    }

    public CFBBlockCipherMac(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, 8, blockCipher2.getBlockSize() * 8 / 2, blockCipherPadding);
    }

    public CFBBlockCipherMac(BlockCipher blockCipher, int n, int n2) {
        this(blockCipher, n, n2, null);
    }

    public CFBBlockCipherMac(BlockCipher blockCipher, int n, int n2, BlockCipherPadding blockCipherPadding) {
        ((CFBBlockCipherMac)((Object)macCFBBlockCipher2)).padding = null;
        if (n2 % 8 == 0) {
            MacCFBBlockCipher macCFBBlockCipher;
            CFBBlockCipherMac cFBBlockCipherMac = macCFBBlockCipher2;
            CFBBlockCipherMac cFBBlockCipherMac2 = macCFBBlockCipher2;
            CFBBlockCipherMac cFBBlockCipherMac3 = macCFBBlockCipher2;
            cFBBlockCipherMac3.mac = new byte[blockCipher.getBlockSize()];
            MacCFBBlockCipher macCFBBlockCipher2 = macCFBBlockCipher;
            cFBBlockCipherMac3.cipher = new MacCFBBlockCipher(blockCipher, n);
            cFBBlockCipherMac2.padding = blockCipherPadding;
            cFBBlockCipherMac.macSize = n2 / 8;
            cFBBlockCipherMac.buf = new byte[macCFBBlockCipher2.getBlockSize()];
            cFBBlockCipherMac.bufOff = 0;
            return;
        }
        throw new IllegalArgumentException("MAC size must be multiple of 8");
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        CFBBlockCipherMac cFBBlockCipherMac = this;
        cFBBlockCipherMac.reset();
        cFBBlockCipherMac.cipher.init(cipherParameters);
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte by) {
        byte[] byArray = this.buf;
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(byArray, 0, this.mac, 0);
            this.bufOff = 0;
        }
        int n = this.bufOff;
        this.bufOff = n + 1;
        this.buf[n] = by;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (n2 >= 0) {
            int n3;
            int n4 = ((CFBBlockCipherMac)object).cipher.getBlockSize();
            int n5 = n4 - (n3 = ((CFBBlockCipherMac)object).bufOff);
            if (n2 > n5) {
                int n6 = n;
                System.arraycopy(byArray, n, ((CFBBlockCipherMac)object).buf, n3, n5);
                Object object = object;
                byte[] byArray2 = ((CFBBlockCipherMac)object).buf;
                byte[] byArray3 = ((CFBBlockCipherMac)object).mac;
                ((CFBBlockCipherMac)object).cipher.processBlock(byArray2, 0, byArray3, 0);
                ((CFBBlockCipherMac)object).bufOff = 0;
                n = n2 - n5;
                n2 = n6 + n5;
                int n7 = n;
                n = n2;
                n2 = n7;
                while (n2 > n4) {
                    int n8 = n;
                    ((CFBBlockCipherMac)object).cipher.processBlock(byArray, n, ((CFBBlockCipherMac)object).mac, 0);
                    n = n2 - n4;
                    n2 = n8 + n4;
                    int n9 = n;
                    n = n2;
                    n2 = n9;
                }
            }
            CFBBlockCipherMac cFBBlockCipherMac = object;
            CFBBlockCipherMac cFBBlockCipherMac2 = object;
            Object object = cFBBlockCipherMac2.buf;
            System.arraycopy(byArray, n, object, cFBBlockCipherMac2.bufOff, n2);
            cFBBlockCipherMac.bufOff += n2;
            return;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        CFBBlockCipherMac cFBBlockCipherMac = this;
        int n2 = cFBBlockCipherMac.cipher.getBlockSize();
        BlockCipherPadding blockCipherPadding = cFBBlockCipherMac.padding;
        if (blockCipherPadding == null) {
            int n3;
            while ((n3 = this.bufOff) < n2) {
                this.buf[n3] = 0;
                this.bufOff = n3 + 1;
            }
        } else {
            CFBBlockCipherMac cFBBlockCipherMac2 = this;
            byte[] byArray2 = cFBBlockCipherMac2.buf;
            blockCipherPadding.addPadding(byArray2, cFBBlockCipherMac2.bufOff);
        }
        CFBBlockCipherMac cFBBlockCipherMac3 = this;
        CFBBlockCipherMac cFBBlockCipherMac4 = this;
        byte[] byArray3 = cFBBlockCipherMac4.buf;
        byte[] byArray4 = cFBBlockCipherMac4.mac;
        cFBBlockCipherMac3.cipher.processBlock(byArray3, 0, byArray4, 0);
        cFBBlockCipherMac3.cipher.getMacBlock(this.mac);
        int n4 = this.macSize;
        System.arraycopy(cFBBlockCipherMac3.mac, 0, byArray, n, n4);
        cFBBlockCipherMac3.reset();
        return cFBBlockCipherMac3.macSize;
    }

    @Override
    public void reset() {
        int n = 0;
        while (true) {
            byte[] byArray = this.buf;
            if (n >= this.buf.length) break;
            byArray[n] = 0;
            ++n;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

