/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.elgamal;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.ElGamalParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ElGamalPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ElGamalParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ElGamalPublicKeySpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class BCElGamalPublicKey
implements ElGamalPublicKey,
DHPublicKey {
    public static final long serialVersionUID = 8712728417091216948L;
    private BigInteger y;
    private transient ElGamalParameterSpec elSpec;

    public BCElGamalPublicKey(ElGamalPublicKeySpec elGamalPublicKeySpec) {
        BCElGamalPublicKey bCElGamalPublicKey = this;
        bCElGamalPublicKey.y = elGamalPublicKeySpec.getY();
        bCElGamalPublicKey.elSpec = new ElGamalParameterSpec(elGamalPublicKeySpec.getParams().getP(), elGamalPublicKeySpec.getParams().getG());
    }

    public BCElGamalPublicKey(DHPublicKeySpec dHPublicKeySpec) {
        BCElGamalPublicKey bCElGamalPublicKey = serializable;
        bCElGamalPublicKey.y = dHPublicKeySpec.getY();
        DHPublicKeySpec dHPublicKeySpec2 = dHPublicKeySpec;
        Serializable serializable = dHPublicKeySpec2.getP();
        bCElGamalPublicKey.elSpec = new ElGamalParameterSpec((BigInteger)serializable, dHPublicKeySpec2.getG());
    }

    public BCElGamalPublicKey(ElGamalPublicKey elGamalPublicKey) {
        this.y = elGamalPublicKey.getY();
        this.elSpec = elGamalPublicKey.getParameters();
    }

    public BCElGamalPublicKey(DHPublicKey dHPublicKey) {
        BCElGamalPublicKey bCElGamalPublicKey = this;
        bCElGamalPublicKey.y = dHPublicKey.getY();
        bCElGamalPublicKey.elSpec = new ElGamalParameterSpec(dHPublicKey.getParams().getP(), dHPublicKey.getParams().getG());
    }

    public BCElGamalPublicKey(ElGamalPublicKeyParameters elGamalPublicKeyParameters) {
        BCElGamalPublicKey bCElGamalPublicKey = this;
        bCElGamalPublicKey.y = elGamalPublicKeyParameters.getY();
        bCElGamalPublicKey.elSpec = new ElGamalParameterSpec(elGamalPublicKeyParameters.getParameters().getP(), elGamalPublicKeyParameters.getParameters().getG());
    }

    public BCElGamalPublicKey(BigInteger bigInteger, ElGamalParameterSpec elGamalParameterSpec) {
        this.y = bigInteger;
        this.elSpec = elGamalParameterSpec;
    }

    public BCElGamalPublicKey(SubjectPublicKeyInfo aSN1Object) {
        BCElGamalPublicKey bCElGamalPublicKey = serializable;
        SubjectPublicKeyInfo subjectPublicKeyInfo = aSN1Object;
        aSN1Object = ElGamalParameter.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
        try {
            bCElGamalPublicKey.y = ((ASN1Integer)subjectPublicKeyInfo.parsePublicKey()).getValue();
            ASN1Object aSN1Object2 = aSN1Object;
            Serializable serializable = ((ElGamalParameter)aSN1Object2).getP();
            bCElGamalPublicKey.elSpec = new ElGamalParameterSpec((BigInteger)serializable, ((ElGamalParameter)aSN1Object2).getG());
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in DSA public key");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.elSpec = new ElGamalParameterSpec((BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.elSpec.getP());
        objectOutputStream.writeObject(this.elSpec.getG());
    }

    @Override
    public String getAlgorithm() {
        return "ElGamal";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(this.elSpec.getP(), this.elSpec.getG())), new ASN1Integer(this.y)).getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public ElGamalParameterSpec getParameters() {
        return this.elSpec;
    }

    @Override
    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.elSpec.getP(), this.elSpec.getG());
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    public int hashCode() {
        return this.getY().hashCode() ^ this.getParams().getG().hashCode() ^ this.getParams().getP().hashCode() ^ this.getParams().getL();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DHPublicKey)) {
            return false;
        }
        object = (DHPublicKey)object;
        return this.getY().equals(object.getY()) && this.getParams().getG().equals(object.getParams().getG()) && this.getParams().getP().equals(object.getParams().getP()) && this.getParams().getL() == object.getParams().getL();
    }
}

