/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.drbg;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.HMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySource;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySourceProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.SP800SecureRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Properties;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DRBG {
    private static final String PREFIX = "com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.drbg.DRBG";
    private static final String[][] initialEntropySourceNames;

    private static final Object[] findSource() {
        int n = 0;
        while (true) {
            int n2;
            Object[] objectArray;
            String[][] stringArray = initialEntropySourceNames;
            if (n >= initialEntropySourceNames.length) break;
            stringArray = stringArray[n];
            try {
                objectArray = new Object[2];
                n2 = 0;
            }
            catch (Throwable throwable) {
                ++n;
                continue;
            }
            objectArray[n2] = Class.forName((String)stringArray[0]).newInstance();
            n2 = 1;
            objectArray[n2] = Class.forName((String)stringArray[1]).newInstance();
            return objectArray;
            break;
        }
        return null;
    }

    private static SecureRandom createInitialEntropySource() {
        if (AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean bl;
                try {
                    bl = SecureRandom.class.getMethod("getInstanceStrong", new Class[0]) != null;
                }
                catch (Exception exception) {
                    return Boolean.FALSE;
                }
                return bl;
            }
        }).booleanValue()) {
            return AccessController.doPrivileged(new PrivilegedAction<SecureRandom>(){

                @Override
                public SecureRandom run() {
                    Method method;
                    try {
                        method = SecureRandom.class.getMethod("getInstanceStrong", new Class[0]);
                    }
                    catch (Exception exception) {
                        return DRBG.createCoreSecureRandom();
                    }
                    return (SecureRandom)method.invoke(null, new Object[0]);
                }
            });
        }
        return DRBG.createCoreSecureRandom();
    }

    private static SecureRandom createCoreSecureRandom() {
        String string;
        if (Security.getProperty("securerandom.source") == null) {
            return new CoreSecureRandom(DRBG.findSource());
        }
        try {
            string = Security.getProperty("securerandom.source");
        }
        catch (Exception exception) {
            return new CoreSecureRandom(DRBG.findSource());
        }
        return new URLSeededSecureRandom(new URL(string));
    }

    private static EntropySourceProvider createEntropySource() {
        final String string = Properties.getPropertyValue("com.fis.ekyc.nfc.build_in.bouncycastle.drbg.entropysource");
        return AccessController.doPrivileged(new PrivilegedAction<EntropySourceProvider>(){

            @Override
            public EntropySourceProvider run() {
                try {
                    return (EntropySourceProvider)ClassUtil.loadClass(DRBG.class, string).newInstance();
                }
                catch (Exception exception) {
                    throw new IllegalStateException(a.a(exception, b.a("entropy source ").append(string).append(" not created: ")), exception);
                }
            }
        });
    }

    private static SecureRandom createBaseRandom(boolean bl) {
        SHA512Digest sHA512Digest;
        HybridSecureRandom hybridSecureRandom;
        if (Properties.getPropertyValue("com.fis.ekyc.nfc.build_in.bouncycastle.drbg.entropysource") != null) {
            EntropySourceProvider entropySourceProvider = DRBG.createEntropySource();
            EntropySource entropySource = entropySourceProvider.get(128);
            byte[] byArray = bl ? DRBG.generateDefaultPersonalizationString(entropySource.getEntropy()) : DRBG.generateNonceIVPersonalizationString(entropySource.getEntropy());
            return new SP800SecureRandomBuilder(entropySourceProvider).setPersonalizationString(byArray).buildHash(new SHA512Digest(), Arrays.concatenate(entropySource.getEntropy(), entropySource.getEntropy()), bl);
        }
        Object object = hybridSecureRandom;
        hybridSecureRandom = new HybridSecureRandom();
        byte[] byArray = bl ? DRBG.generateDefaultPersonalizationString(((HybridSecureRandom)object).generateSeed(16)) : DRBG.generateNonceIVPersonalizationString(((HybridSecureRandom)object).generateSeed(16));
        SP800SecureRandomBuilder sP800SecureRandomBuilder = new SP800SecureRandomBuilder((SecureRandom)object, true);
        HybridSecureRandom hybridSecureRandom2 = object;
        object = sHA512Digest;
        sHA512Digest = new SHA512Digest();
        return sP800SecureRandomBuilder.setPersonalizationString(byArray).buildHash((Digest)object, hybridSecureRandom2.generateSeed(32), bl);
    }

    private static byte[] generateDefaultPersonalizationString(byte[] byArray) {
        return Arrays.concatenate(Strings.toByteArray("Default"), byArray, Pack.longToBigEndian(Thread.currentThread().getId()), Pack.longToBigEndian(System.currentTimeMillis()));
    }

    private static byte[] generateNonceIVPersonalizationString(byte[] byArray) {
        return Arrays.concatenate(Strings.toByteArray("Nonce"), byArray, Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }

    public static /* synthetic */ SecureRandom access$100(boolean bl) {
        return DRBG.createBaseRandom(bl);
    }

    static {
        String[][] stringArrayArray = new String[4][];
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "sun.security.provider.Sun";
        stringArray[1] = "sun.security.provider.SecureRandom";
        stringArrayArray[0] = stringArray2;
        String[] stringArray3 = new String[2];
        stringArray2 = stringArray3;
        stringArray3[0] = "com.fis.ekyc.sdk.nfc.build_in.apache.harmony.security.provider.crypto.CryptoProvider";
        stringArray3[1] = "com.fis.ekyc.sdk.nfc.build_in.apache.harmony.security.provider.crypto.SHA1PRNG_SecureRandomImpl";
        stringArrayArray[1] = stringArray2;
        String[] stringArray4 = new String[2];
        stringArray2 = stringArray4;
        stringArray4[0] = "com.android.com.fis.ekyc.sdk.nfc.build_in.conscrypt.OpenSSLProvider";
        stringArray4[1] = "com.android.com.fis.ekyc.sdk.nfc.build_in.conscrypt.OpenSSLRandom";
        stringArrayArray[2] = stringArray2;
        String[] stringArray5 = new String[2];
        stringArray2 = stringArray5;
        stringArray5[0] = "com.fis.ekyc.sdk.nfc.build_in.conscrypt.OpenSSLProvider";
        stringArray5[1] = "com.fis.ekyc.sdk.nfc.build_in.conscrypt.OpenSSLRandom";
        stringArrayArray[3] = stringArray2;
        initialEntropySourceNames = stringArrayArray;
    }

    public static class HybridSecureRandom
    extends SecureRandom {
        private final AtomicBoolean seedAvailable;
        private final AtomicInteger samples;
        private final SecureRandom baseRandom;
        private final SP800SecureRandom drbg;

        public HybridSecureRandom() {
            HMac hMac;
            HybridRandomProvider hybridRandomProvider;
            Serializable serializable = hybridRandomProvider;
            hybridRandomProvider = new HybridRandomProvider();
            super(null, (Provider)serializable);
            ((HybridSecureRandom)((Object)hMac2)).seedAvailable = new AtomicBoolean(false);
            ((HybridSecureRandom)((Object)hMac2)).samples = new AtomicInteger(0);
            serializable = DRBG.createInitialEntropySource();
            ((HybridSecureRandom)((Object)hMac2)).baseRandom = serializable;
            SP800SecureRandomBuilder sP800SecureRandomBuilder = new SP800SecureRandomBuilder(new EntropySourceProvider((HybridSecureRandom)((Object)hMac2)){
                public final /* synthetic */ HybridSecureRandom this$0;
                {
                    this.this$0 = hybridSecureRandom;
                }

                @Override
                public EntropySource get(int n) {
                    return this.this$0.new SignallingEntropySource(n);
                }
            });
            HMac hMac2 = hMac;
            hMac = new HMac(new SHA512Digest());
            v3.drbg = sP800SecureRandomBuilder.setPersonalizationString(Strings.toByteArray("Bouncy Castle Hybrid Entropy Source")).buildHMAC(hMac2, ((SecureRandom)serializable).generateSeed(32), false);
        }

        @Override
        public void setSeed(byte[] byArray) {
            SecureRandom secureRandom = ((HybridSecureRandom)secureRandom).drbg;
            if (secureRandom != null) {
                ((SP800SecureRandom)secureRandom).setSeed(byArray);
            }
        }

        @Override
        public void setSeed(long l) {
            SecureRandom secureRandom = ((HybridSecureRandom)secureRandom).drbg;
            if (secureRandom != null) {
                ((SP800SecureRandom)secureRandom).setSeed(l);
            }
        }

        @Override
        public byte[] generateSeed(int n) {
            byte[] byArray = new byte[n];
            if (this.samples.getAndIncrement() > 20 && this.seedAvailable.getAndSet(false)) {
                HybridSecureRandom hybridSecureRandom = this;
                hybridSecureRandom.samples.set(0);
                hybridSecureRandom.drbg.reseed((byte[])null);
            }
            this.drbg.nextBytes(byArray);
            return byArray;
        }

        public class SignallingEntropySource
        implements EntropySource {
            private final int byteLength;
            private final AtomicReference entropy = new AtomicReference();
            private final AtomicBoolean scheduled = new AtomicBoolean(false);

            public SignallingEntropySource(int n) {
                this.byteLength = (n + 7) / 8;
            }

            @Override
            public boolean isPredictionResistant() {
                return true;
            }

            @Override
            public byte[] getEntropy() {
                byte[] byArray = this.entropy.getAndSet(null);
                if (byArray != null && byArray.length == this.byteLength) {
                    this.scheduled.set(false);
                } else {
                    byArray = HybridSecureRandom.this.baseRandom.generateSeed(this.byteLength);
                }
                if (!this.scheduled.getAndSet(true)) {
                    EntropyGatherer entropyGatherer;
                    EntropyGatherer entropyGatherer2 = entropyGatherer;
                    entropyGatherer = new EntropyGatherer(this.byteLength);
                    Thread thread = new Thread(entropyGatherer2);
                    thread.setDaemon(true);
                    thread.start();
                }
                return byArray;
            }

            @Override
            public int entropySize() {
                return this.byteLength * 8;
            }

            public class EntropyGatherer
            implements Runnable {
                private final int numBytes;

                public EntropyGatherer(int n) {
                    this.numBytes = n;
                }

                private void sleep(long l) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }

                @Override
                public void run() {
                    int n;
                    long l;
                    String string = Properties.getPropertyValue("com.fis.ekyc.nfc.build_in.bouncycastle.drbg.gather_pause_secs");
                    if (string != null) {
                        try {
                            l = Long.parseLong(string) * 1000L;
                        }
                        catch (Exception exception) {}
                    }
                    l = 5000L;
                    int n2 = this.numBytes;
                    byte[] byArray = new byte[n2];
                    for (n = 0; n < SignallingEntropySource.this.byteLength / 8; ++n) {
                        EntropyGatherer entropyGatherer = this;
                        entropyGatherer.sleep(l);
                        byte[] byArray2 = entropyGatherer.HybridSecureRandom.this.baseRandom.generateSeed(8);
                        int n3 = n * 8;
                        int n4 = byArray2.length;
                        System.arraycopy(byArray2, 0, byArray, n3, n4);
                    }
                    n = SignallingEntropySource.this.byteLength - SignallingEntropySource.this.byteLength / 8 * 8;
                    if (n != 0) {
                        EntropyGatherer entropyGatherer = this;
                        entropyGatherer.sleep(l);
                        byte[] byArray3 = entropyGatherer.HybridSecureRandom.this.baseRandom.generateSeed(n);
                        int n5 = n2 - byArray3.length;
                        int n6 = byArray3.length;
                        System.arraycopy(byArray3, 0, byArray, n5, n6);
                    }
                    EntropyGatherer entropyGatherer = this;
                    entropyGatherer.SignallingEntropySource.this.entropy.set(byArray);
                    entropyGatherer.HybridSecureRandom.this.seedAvailable.set(true);
                }
            }
        }
    }

    public static class URLSeededSecureRandom
    extends SecureRandom {
        private final InputStream seedStream;

        public URLSeededSecureRandom(final URL uRL) {
            HybridRandomProvider hybridRandomProvider;
            HybridRandomProvider hybridRandomProvider2 = hybridRandomProvider;
            hybridRandomProvider = new HybridRandomProvider();
            super(null, hybridRandomProvider2);
            this.seedStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    try {
                        return uRL.openStream();
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException("unable to open random source");
                    }
                }
            });
        }

        private int privilegedRead(final byte[] byArray, final int n, final int n2) {
            return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    2 v3;
                    2 v2;
                    InputStream inputStream;
                    try {
                        inputStream = seedStream;
                        2 v1 = object;
                        v2 = v1;
                        v3 = v1;
                        Object object = v1.byArray;
                    }
                    catch (IOException iOException) {
                        throw new InternalError("unable to read random source");
                    }
                    int n3 = v3.n;
                    int n22 = v2.n2;
                    return inputStream.read((byte[])object, n3, n22);
                }
            });
        }

        @Override
        public void setSeed(byte[] byArray) {
        }

        @Override
        public void setSeed(long l) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public byte[] generateSeed(int n) {
            synchronized (this) {
                int n2;
                int n3;
                byte[] byArray = new byte[n];
                for (n2 = 0; n2 != n; n2 += n3) {
                    n3 = this.privilegedRead(byArray, n2, n - n2);
                    if (n3 <= -1) break;
                    continue;
                }
                if (n2 != n) throw new InternalError("unable to fully read random source");
                return byArray;
            }
        }
    }

    public static class HybridRandomProvider
    extends Provider {
        public HybridRandomProvider() {
            super("BCHEP", 1.0, "Bouncy Castle Hybrid Entropy Provider");
        }
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            ConfigurableProvider configurableProvider2 = configurableProvider;
            configurableProvider2.addAlgorithm("SecureRandom.DEFAULT", PREFIX + "$Default");
            configurableProvider2.addAlgorithm("SecureRandom.NONCEANDIV", PREFIX + "$NonceAndIV");
        }
    }

    public static class NonceAndIV
    extends SecureRandomSpi {
        private static final SecureRandom random = DRBG.access$100(false);

        @Override
        public void engineSetSeed(byte[] byArray) {
            random.setSeed(byArray);
        }

        @Override
        public void engineNextBytes(byte[] byArray) {
            random.nextBytes(byArray);
        }

        @Override
        public byte[] engineGenerateSeed(int n) {
            return random.generateSeed(n);
        }
    }

    public static class Default
    extends SecureRandomSpi {
        private static final SecureRandom random = DRBG.access$100(true);

        @Override
        public void engineSetSeed(byte[] byArray) {
            random.setSeed(byArray);
        }

        @Override
        public void engineNextBytes(byte[] byArray) {
            random.nextBytes(byArray);
        }

        @Override
        public byte[] engineGenerateSeed(int n) {
            return random.generateSeed(n);
        }
    }

    public static class CoreSecureRandom
    extends SecureRandom {
        public CoreSecureRandom(Object[] objectArray) {
            CoreSecureRandom coreSecureRandom = serializable;
            Serializable serializable = (SecureRandomSpi)objectArray[1];
            super((SecureRandomSpi)serializable, (Provider)objectArray[0]);
        }
    }
}

