/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Interleave;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import java.math.BigInteger;

public class SecT193Field {
    private static final long M01 = 1L;
    private static final long M49 = 0x1FFFFFFFFFFFFL;

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        long l2;
        lArray3[0] = l2 = lArray[0] ^ lArray2[0];
        lArray3[1] = l2 = lArray[1] ^ lArray2[1];
        lArray3[2] = l2 = lArray[2] ^ lArray2[2];
        lArray3[3] = l = lArray[3] ^ lArray2[3];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        long l2;
        lArray3[0] = l2 = lArray[0] ^ lArray2[0];
        lArray3[1] = l2 = lArray[1] ^ lArray2[1];
        lArray3[2] = l2 = lArray[2] ^ lArray2[2];
        lArray3[3] = l2 = lArray[3] ^ lArray2[3];
        lArray3[4] = l2 = lArray[4] ^ lArray2[4];
        lArray3[5] = l2 = lArray[5] ^ lArray2[5];
        lArray3[6] = l = lArray[6] ^ lArray2[6];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        long l;
        lArray2[0] = l = lArray[0] ^ 1L;
        lArray2[1] = l = lArray[1];
        lArray2[2] = l = lArray[2];
        lArray2[3] = l = lArray[3];
    }

    private static void addTo(long[] lArray, long[] lArray2) {
        long l;
        long l2;
        long[] lArray3 = lArray2;
        lArray3[0] = l2 = lArray2[0] ^ lArray[0];
        lArray3[1] = l2 = lArray2[1] ^ lArray[1];
        lArray3[2] = l2 = lArray2[2] ^ lArray[2];
        lArray3[3] = l = lArray2[3] ^ lArray[3];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        return Nat.fromBigInteger64(193, bigInteger);
    }

    public static void halfTrace(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        Nat256.copy64(lArray, lArray2);
        for (int k = 1; k < 193; k += 2) {
            SecT193Field.implSquare(lArray2, lArray3);
            SecT193Field.reduce(lArray3, lArray2);
            SecT193Field.implSquare(lArray2, lArray3);
            SecT193Field.reduce(lArray3, lArray2);
            SecT193Field.addTo(lArray, lArray2);
        }
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (!Nat256.isZero64(lArray)) {
            long[] lArray3 = Nat256.create64();
            long[] lArray4 = Nat256.create64();
            SecT193Field.square(lArray, lArray3);
            SecT193Field.squareN(lArray3, 1, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray4, 1, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray3, 3, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray3, 6, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray3, 12, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray3, 24, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray3, 48, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray3);
            SecT193Field.squareN(lArray3, 96, lArray4);
            SecT193Field.multiply(lArray3, lArray4, lArray2);
            return;
        }
        throw new IllegalStateException();
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat256.createExt64();
        SecT193Field.implMultiply(lArray, lArray2, lArray4);
        SecT193Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = lArray;
        lArray = Nat256.createExt64();
        SecT193Field.implMultiply(lArray4, lArray2, lArray);
        SecT193Field.addExt(lArray3, lArray, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l;
        long l2 = lArray[0];
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[4];
        long l6 = lArray[5];
        long l7 = lArray[6];
        long l8 = l4 ^= l7 << 63;
        long l9 = l3;
        l3 = l5 ^ l7 >>> 50;
        l4 = l9 ^ l6 << 63;
        l5 = l8 ^ (l6 >>> 1 ^ l6 << 14);
        l6 = lArray[3] ^ (l7 >>> 1 ^ l7 << 14) ^ l6 >>> 50;
        l2 ^= l3 << 63;
        long l10 = l4 ^ (l3 >>> 1 ^ l3 << 14);
        l3 = l5 ^ l3 >>> 50;
        l4 = l6 >>> 1;
        lArray2[0] = l = l2 ^ l4 ^ l4 << 15;
        lArray2[1] = l = l10 ^ l4 >>> 49;
        lArray2[2] = l3;
        lArray2[3] = l = l6 & 1L;
    }

    public static void reduce63(long[] lArray, int n) {
        long l;
        int n2 = n + 3;
        long l2 = lArray[n2];
        long[] lArray2 = lArray;
        long l3 = l = l2 >>> 1;
        lArray2[n] = lArray[n] ^ (l3 ^ l3 << 15);
        int n3 = n + 1;
        lArray[n3] = l = lArray2[n3] ^ l >>> 49;
        lArray[n2] = l2 & 1L;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l;
        long l2 = Interleave.unshuffle(lArray[0]);
        long l3 = Interleave.unshuffle(lArray[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        l3 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        long l5 = Interleave.unshuffle(lArray[2]);
        long l6 = l5 & 0xFFFFFFFFL ^ lArray[3] << 32;
        long l7 = l5 >>> 32;
        lArray2[0] = l = l4 ^ l3 << 8;
        lArray2[1] = l = l6 ^ l7 << 8 ^ l3 >>> 56 ^ l3 << 33;
        lArray2[2] = l = l7 >>> 56 ^ l7 << 33 ^ l3 >>> 31;
        lArray2[3] = l = l7 >>> 31;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT193Field.implSquare(lArray, lArray3);
        SecT193Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = lArray;
        lArray = Nat256.createExt64();
        SecT193Field.implSquare(lArray3, lArray);
        SecT193Field.addExt(lArray2, lArray, lArray2);
    }

    public static void squareN(long[] lArray, int n, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT193Field.implSquare(lArray, lArray3);
        SecT193Field.reduce(lArray3, lArray2);
        while ((n += -1) > 0) {
            SecT193Field.implSquare(lArray2, lArray3);
            SecT193Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)lArray[0] & 1;
    }

    public static void implCompactExt(long[] lArray) {
        long[] lArray2 = lArray;
        long[] lArray3 = lArray;
        long l = lArray2[0];
        long l2 = lArray3[1];
        long l3 = lArray2[2];
        long l4 = lArray3[3];
        long l5 = lArray2[4];
        long l6 = lArray3[5];
        long l7 = lArray2[6];
        long l8 = lArray3[7];
        lArray[0] = l ^= l2 << 49;
        lArray[1] = l = l2 >>> 15 ^ l3 << 34;
        lArray[2] = l = l3 >>> 30 ^ l4 << 19;
        lArray[3] = l = l4 >>> 45 ^ l5 << 4 ^ l6 << 53;
        lArray[4] = l = l5 >>> 60 ^ l7 << 38 ^ l6 >>> 11;
        lArray[5] = l = l7 >>> 26 ^ l8 << 23;
        lArray2[6] = l = l8 >>> 41;
        lArray3[7] = 0L;
    }

    public static void implExpand(long[] lArray, long[] lArray2) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = l;
        long l5 = lArray[3];
        lArray2[0] = l &= 0x1FFFFFFFFFFFFL;
        lArray2[1] = l = (l4 >>> 49 ^ l2 << 15) & 0x1FFFFFFFFFFFFL;
        lArray2[2] = l = (l2 >>> 34 ^ l3 << 30) & 0x1FFFFFFFFFFFFL;
        lArray2[3] = l5 = l3 >>> 19 ^ l5 << 45;
    }

    public static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        long[] lArray4 = lArray2;
        long[] lArray5 = lArray;
        lArray = new long[4];
        lArray2 = new long[4];
        SecT193Field.implExpand(lArray5, lArray);
        SecT193Field.implExpand(lArray4, lArray2);
        long[] lArray6 = new long[8];
        long l2 = lArray[0];
        long l3 = lArray2[0];
        SecT193Field.implMulwAcc(lArray6, l2, l3, lArray3, 0);
        l2 = lArray[1];
        l3 = lArray2[1];
        SecT193Field.implMulwAcc(lArray6, l2, l3, lArray3, 1);
        l2 = lArray[2];
        l3 = lArray2[2];
        SecT193Field.implMulwAcc(lArray6, l2, l3, lArray3, 2);
        l2 = lArray[3];
        l3 = lArray2[3];
        SecT193Field.implMulwAcc(lArray6, l2, l3, lArray3, 3);
        for (int k = 5; k > 0; --k) {
            lArray3[k] = lArray3[k] ^ lArray3[k - 1];
        }
        long l4 = lArray[0] ^ lArray[1];
        l3 = lArray2[0] ^ lArray2[1];
        SecT193Field.implMulwAcc(lArray6, l4, l3, lArray3, 1);
        l4 = lArray[2] ^ lArray[3];
        l3 = lArray2[2] ^ lArray2[3];
        SecT193Field.implMulwAcc(lArray6, l4, l3, lArray3, 3);
        for (int k = 7; k > 1; --k) {
            lArray3[k] = lArray3[k] ^ lArray3[k - 2];
        }
        long[] lArray7 = lArray3;
        long l5 = lArray[0] ^ lArray[2];
        l3 = lArray[1] ^ lArray[3];
        long l6 = lArray2[0] ^ lArray2[2];
        long l7 = lArray2[1] ^ lArray2[3];
        long l8 = l5 ^ l3;
        long l9 = l6 ^ l7;
        SecT193Field.implMulwAcc(lArray6, l8, l9, lArray3, 3);
        lArray3 = new long[3];
        SecT193Field.implMulwAcc(lArray6, l5, l6, lArray3, 0);
        SecT193Field.implMulwAcc(lArray6, l3, l7, lArray3, 1);
        l7 = lArray3[0];
        long l10 = lArray3[1];
        long l11 = lArray3[2];
        lArray7[2] = l = lArray7[2] ^ l7;
        lArray7[3] = l7 = lArray7[3] ^ (l7 ^ l10);
        lArray7[4] = l7 = lArray7[4] ^ (l11 ^ l10);
        lArray7[5] = l7 = lArray7[5] ^ l11;
        SecT193Field.implCompactExt(lArray3);
    }

    public static void implMulwAcc(long[] lArray, long l, long l2, long[] lArray2, int n) {
        long l3;
        long l4;
        lArray[1] = l2;
        lArray[2] = l4 = l2 << 1;
        lArray[3] = l3 = l4 ^ l2;
        lArray[4] = l4 <<= 1;
        lArray[5] = l4 ^= l2;
        lArray[6] = l4 = l3 << 1;
        lArray[7] = l2 = l4 ^ l2;
        int n2 = (int)l;
        l4 = 0L;
        long l5 = lArray[n2 & 7] ^ lArray[n2 >>> 3 & 7] << 3;
        int n3 = 36;
        do {
            long l6 = l4;
            int n4 = (int)(l >>> n3);
            l4 = lArray[n4 & 7] ^ lArray[n4 >>> 3 & 7] << 3 ^ lArray[n4 >>> 6 & 7] << 6 ^ lArray[n4 >>> 9 & 7] << 9 ^ lArray[n4 >>> 12 & 7] << 12;
            l5 ^= l4 << n3;
            l4 = l6 ^ l4 >>> -n3;
        } while ((n3 += -15) > 0);
        long[] lArray3 = lArray2;
        lArray3[n] = lArray2[n] ^ l5 & 0x1FFFFFFFFFFFFL;
        int n5 = n + 1;
        lArray2[n5] = l = lArray3[n5] ^ (l5 >>> 49 ^ l4 << 15);
    }

    public static void implSquare(long[] lArray, long[] lArray2) {
        long l;
        Interleave.expand64To128(lArray, 0, 3, lArray2, 0);
        lArray2[6] = l = lArray[3] & 1L;
    }
}

