/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class GMSSParameters {
    private int numOfLayers;
    private int[] heightOfTrees;
    private int[] winternitzParameter;
    private int[] K;

    public GMSSParameters(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        GMSSParameters gMSSParameters = this;
        gMSSParameters.init(n, nArray, nArray2, nArray3);
    }

    private void init(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        boolean bl = true;
        String string = "";
        this.numOfLayers = n;
        if (n != nArray2.length || n != nArray.length || n != nArray3.length) {
            bl = false;
            string = "Unexpected parameterset format";
        }
        for (n = 0; n < this.numOfLayers; ++n) {
            int n2 = nArray3[n];
            if (n2 < 2 || (nArray[n] - n2) % 2 != 0) {
                bl = false;
                string = "Wrong parameter K (K >= 2 and H-K even required)!";
            }
            if (nArray[n] >= 4 && nArray2[n] >= 2) continue;
            bl = false;
            string = "Wrong parameter H or w (H > 3 and w > 1 required)!";
        }
        if (bl) {
            this.heightOfTrees = Arrays.clone(nArray);
            this.winternitzParameter = Arrays.clone(nArray2);
            this.K = Arrays.clone(nArray3);
            return;
        }
        throw new IllegalArgumentException(string);
    }

    public GMSSParameters(int n) {
        Object object;
        if (n <= 10) {
            GMSSParameters gMSSParameters = object;
            int[] nArray = new int[1];
            object = nArray;
            nArray[0] = 10;
            int[] nArray2 = new int[1];
            int[] nArray3 = nArray2;
            nArray2[0] = 3;
            int[] nArray4 = new int[1];
            int[] nArray5 = nArray4;
            nArray4[0] = 2;
            gMSSParameters.init(1, (int[])object, nArray3, nArray5);
        } else if (n <= 20) {
            GMSSParameters gMSSParameters = object;
            int[] nArray = new int[2];
            object = nArray;
            nArray[0] = 10;
            nArray[1] = 10;
            int[] nArray6 = new int[2];
            int[] nArray7 = nArray6;
            nArray6[0] = 5;
            nArray6[1] = 4;
            int[] nArray8 = new int[2];
            int[] nArray9 = nArray8;
            nArray8[0] = 2;
            nArray8[1] = 2;
            gMSSParameters.init(2, (int[])object, nArray7, nArray9);
        } else {
            GMSSParameters gMSSParameters = object;
            int[] nArray = new int[4];
            object = nArray;
            nArray[0] = 10;
            nArray[1] = 10;
            nArray[2] = 10;
            nArray[3] = 10;
            int[] nArray10 = new int[4];
            int[] nArray11 = nArray10;
            nArray10[0] = 9;
            nArray10[1] = 9;
            nArray10[2] = 9;
            nArray10[3] = 3;
            int[] nArray12 = new int[4];
            int[] nArray13 = nArray12;
            nArray12[0] = 2;
            nArray12[1] = 2;
            nArray12[2] = 2;
            nArray12[3] = 2;
            gMSSParameters.init(4, (int[])object, nArray11, nArray13);
        }
    }

    public int getNumOfLayers() {
        return this.numOfLayers;
    }

    public int[] getHeightOfTrees() {
        return Arrays.clone(this.heightOfTrees);
    }

    public int[] getWinternitzParameter() {
        return Arrays.clone(this.winternitzParameter);
    }

    public int[] getK() {
        return Arrays.clone(this.K);
    }
}

