/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.BigIntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Vector;
import java.math.BigInteger;

final class Conversions {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    private Conversions() {
    }

    public static GF2Vector encode(int n, int n2, byte[] object) {
        if (n >= n2) {
            BigInteger bigInteger;
            BigInteger bigInteger2 = IntegerFunctions.binomial(n, n2);
            BigInteger bigInteger3 = bigInteger;
            bigInteger3(1, (byte[])object);
            if (bigInteger.compareTo(bigInteger2) < 0) {
                GF2Vector gF2Vector;
                object = gF2Vector;
                gF2Vector = new GF2Vector(n);
                int n3 = n;
                for (int k = 0; k < n; ++k) {
                    bigInteger2 = bigInteger2.multiply(BigInteger.valueOf(n3 - n2)).divide(BigInteger.valueOf(n3));
                    --n3;
                    if (bigInteger2.compareTo(bigInteger3) > 0) continue;
                    ((GF2Vector)object).setBit(k);
                    bigInteger3 = bigInteger3.subtract(bigInteger2);
                    bigInteger2 = n3 == (n2 += -1) ? ONE : bigInteger2.multiply(BigInteger.valueOf(n2 + 1)).divide(BigInteger.valueOf(n3 - n2));
                }
                return object;
            }
            throw new IllegalArgumentException("Encoded number too large.");
        }
        throw new IllegalArgumentException("n < t");
    }

    public static byte[] decode(int n, int n2, GF2Vector object) {
        if (((Vector)object).getLength() == n && ((GF2Vector)object).getHammingWeight() == n2) {
            object = ((GF2Vector)object).getVecArray();
            BigInteger bigInteger = IntegerFunctions.binomial(n, n2);
            BigInteger bigInteger2 = ZERO;
            int n3 = n;
            for (int k = 0; k < n; ++k) {
                bigInteger = bigInteger.multiply(BigInteger.valueOf(n3 - n2)).divide(BigInteger.valueOf(n3));
                --n3;
                if ((object[k >> 5] & 1 << (k & 0x1F)) == 0) continue;
                bigInteger2 = bigInteger2.add(bigInteger);
                bigInteger = n3 == (n2 += -1) ? ONE : bigInteger.multiply(BigInteger.valueOf(n2 + 1)).divide(BigInteger.valueOf(n3 - n2));
            }
            return BigIntUtils.toMinimalByteArray(bigInteger2);
        }
        throw new IllegalArgumentException("vector has wrong length or hamming weight");
    }

    public static byte[] signConversion(int n, int n2, byte[] byArray) {
        if (n >= n2) {
            BigInteger bigInteger = IntegerFunctions.binomial(n, n2);
            int n3 = bigInteger.bitLength() - 1;
            int n4 = n3 >> 3;
            int n5 = n3 & 7;
            if (n5 == 0) {
                --n4;
                n5 = 8;
            }
            int n6 = n;
            int n7 = n6 >> 3;
            int n8 = n6 & 7;
            if (n8 == 0) {
                --n7;
                n8 = 8;
            }
            int n9 = n7 + 1;
            byte[] byArray2 = new byte[n9];
            if (byArray.length < n9) {
                int n10 = byArray.length;
                System.arraycopy(byArray, 0, byArray2, 0, n10);
                for (n10 = byArray.length; n10 < n9; ++n10) {
                    byArray2[n10] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, byArray2, 0, n7);
                byArray2[n7] = (byte)((1 << n8) - 1 & byArray[n7]);
            }
            Object object = ZERO;
            n8 = n;
            for (n7 = 0; n7 < n; ++n7) {
                int n11 = n7;
                bigInteger = bigInteger.multiply(new BigInteger(Integer.toString(n8 - n2))).divide(new BigInteger(Integer.toString(n8)));
                --n8;
                n9 = n11 >>> 3;
                if ((byte)(1 << (n11 & 7) & byArray2[n9]) == 0) continue;
                object = ((BigInteger)object).add(bigInteger);
                bigInteger = n8 == (n2 += -1) ? ONE : bigInteger.multiply(new BigInteger(Integer.toString(n2 + 1))).divide(new BigInteger(Integer.toString(n8 - n2)));
            }
            n = n4 + 1;
            byte[] byArray3 = new byte[n];
            byte[] byArray4 = ((BigInteger)object).toByteArray();
            object = byArray4;
            if (byArray4.length < n) {
                Object object2 = object;
                int n12 = ((Object)object2).length;
                System.arraycopy(object2, 0, byArray3, 0, n12);
                for (n12 = ((Object)(v792367)).length; n12 < n; ++n12) {
                    byArray3[n12] = 0;
                }
            } else {
                System.arraycopy(object, 0, byArray3, 0, n4);
                byArray3[n4] = (byte)((1 << n5) - 1 & object[n4]);
            }
            return byArray3;
        }
        throw new IllegalArgumentException("n < t");
    }
}

