/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.capturesdk.tflite;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.SystemClock;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.Interpreter;
import org.tensorflow.lite.gpu.CompatibilityList;
import org.tensorflow.lite.gpu.GpuDelegate;
import org.tensorflow.lite.support.common.FileUtil;
import org.tensorflow.lite.support.common.TensorOperator;
import org.tensorflow.lite.support.common.ops.CastOp;
import org.tensorflow.lite.support.common.ops.NormalizeOp;
import org.tensorflow.lite.support.image.ImageProcessor;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;
import vn.kalapa.ekyc.capturesdk.tflite.BoundingBox;
import vn.kalapa.ekyc.capturesdk.tflite.KLPDetectorListener;
import vn.kalapa.ekyc.capturesdk.tflite.OnImageDetectedListener;

@SourceDebugExtension(value={"SMAP\nDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Detector.kt\nvn/kalapa/ekyc/capturesdk/tflite/KLPDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n1054#2:309\n*S KotlinDebug\n*F\n+ 1 Detector.kt\nvn/kalapa/ekyc/capturesdk/tflite/KLPDetector\n*L\n208#1:309\n*E\n"})
public final class KLPDetector
implements KLPDetectorListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final float INPUT_MEAN = 0.0f;
    private static final float INPUT_STANDARD_DEVIATION = 255.0f;
    @NotNull
    private static final DataType INPUT_IMAGE_TYPE;
    @NotNull
    private static final DataType OUTPUT_IMAGE_TYPE;
    private static final float CONFIDENCE_THRESHOLD = 0.3f;
    private static final float IOU_THRESHOLD = 0.5f;
    @NotNull
    private final Context context;
    @NotNull
    private final String modelPath;
    private boolean shouldCapture;
    @NotNull
    private final OnImageDetectedListener onImageListener;
    @NotNull
    private Interpreter interpreter;
    @NotNull
    private final List<String> labels;
    private int tensorWidth;
    private int tensorHeight;
    private int numChannel;
    private int numElements;
    private final float CARD_CONF;
    private final float CORNER_CONF;
    private final ImageProcessor imageProcessor;
    private int detectCount;
    private boolean detected;

    public KLPDetector(@NotNull Context object, @NotNull String object2, @NotNull String string2, boolean bl, @NotNull OnImageDetectedListener onImageDetectedListener) {
        Object object3;
        Object object4;
        Interpreter interpreter;
        Interpreter.Options options;
        CompatibilityList compatibilityList;
        KLPDetector kLPDetector = this;
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"modelPath");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"labelPath");
        Intrinsics.checkNotNullParameter((Object)onImageDetectedListener, (String)"onImageListener");
        this.context = object;
        this.modelPath = object2;
        this.shouldCapture = bl;
        kLPDetector.onImageListener = onImageDetectedListener;
        kLPDetector.labels = new ArrayList<String>();
        kLPDetector.CARD_CONF = 0.75f;
        kLPDetector.CORNER_CONF = 0.4f;
        kLPDetector.imageProcessor = new ImageProcessor.Builder().add((TensorOperator)new NormalizeOp(0.0f, 255.0f)).add((TensorOperator)new CastOp(INPUT_IMAGE_TYPE)).build();
        CompatibilityList compatibilityList2 = compatibilityList;
        onImageDetectedListener = options;
        options = new Interpreter.Options();
        if (new CompatibilityList().isDelegateSupportedOnThisDevice()) {
            GpuDelegate gpuDelegate;
            compatibilityList2 = compatibilityList2.getBestOptionsForThisDevice();
            GpuDelegate gpuDelegate2 = gpuDelegate;
            gpuDelegate = new GpuDelegate((GpuDelegate.Options)compatibilityList2);
            onImageDetectedListener.addDelegate((Delegate)gpuDelegate2);
        } else {
            onImageDetectedListener.setNumThreads(4);
        }
        object = FileUtil.loadMappedFile((Context)object, (String)object2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"loadMappedFile(context, modelPath)");
        object2 = interpreter;
        try {
            interpreter = new Interpreter((ByteBuffer)object, (Interpreter.Options)onImageDetectedListener);
        }
        catch (Throwable throwable) {
            Interpreter interpreter2;
            object2 = interpreter2;
            interpreter2 = new Interpreter((MappedByteBuffer)object);
        }
        this.interpreter = object2;
        object = object2.getInputTensor(0);
        object = object != null ? (Object)object.shape() : null;
        object2 = this.interpreter.getOutputTensor(0);
        object2 = object2 != null ? (Object)object2.shape() : null;
        if (object != null) {
            Context context = object[1];
            Context context2 = context;
            this.tensorWidth = (int)context2;
            context2 = object[2];
            this.tensorHeight = (int)context2;
            if (context == 3) {
                this.tensorWidth = (int)context2;
                this.tensorHeight = (int)object[3];
            }
        }
        if (object2 != null) {
            this.numChannel = (int)object2[1];
            this.numElements = (int)object2[2];
        }
        object = this.context.getAssets().open(string2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.assets.open(labelPath)");
        object2 = object4;
        object4 = object3 = new BufferedReader(new InputStreamReader((InputStream)object));
        while ((string2 = ((BufferedReader)object3).readLine()) != null) {
            if (Intrinsics.areEqual((Object)string2, (Object)"")) break;
            object3 = object2;
            this.labels.add(string2);
        }
        try {
            ((BufferedReader)object2).close();
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public /* synthetic */ KLPDetector(Context context, String string2, String string3, boolean bl, OnImageDetectedListener onImageDetectedListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(context, string2, string3, bl, onImageDetectedListener);
    }

    private final List<BoundingBox> bestBox(float[] fArray) {
        ArrayList<BoundingBox> arrayList;
        ArrayList<BoundingBox> arrayList2 = arrayList;
        arrayList = new ArrayList<BoundingBox>();
        int n = this.numElements;
        for (int i = 0; i < n; ++i) {
            BoundingBox boundingBox;
            float f;
            float f2 = 0.3f;
            int n2 = -1;
            int n3 = 4;
            int n4 = this.numElements * n3 + i;
            while (n3 < this.numChannel) {
                float f3;
                f = fArray[n4];
                if (f3 > f2) {
                    int n5;
                    n2 = n5 = n3 - 4;
                    f2 = f;
                }
                ++n3;
                n4 += this.numElements;
            }
            if (!(f2 > 0.3f)) continue;
            String string2 = this.labels.get(n2);
            float f4 = fArray[i];
            int n6 = this.numElements;
            float f5 = fArray[i + n6];
            float f6 = fArray[n6 * 2 + i];
            f = fArray[n6 * 3 + i];
            float f7 = f6 / 2.0f;
            float f8 = f4 - f7;
            float f9 = f7;
            f7 = f / 2.0f;
            float f10 = f5 - f7;
            float f11 = f4 + f9;
            f7 = f5 + f7;
            if (f8 < 0.0f || f8 > 1.0f || f10 < 0.0f || f10 > 1.0f || f11 < 0.0f || f11 > 1.0f || f7 < 0.0f || f7 > 1.0f) continue;
            BoundingBox boundingBox2 = boundingBox;
            boundingBox = new BoundingBox(f8, f10, f11, f7, f4, f5, f6, f, f2, n2, string2);
            arrayList2.add(boundingBox2);
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        return this.applyNMS(arrayList2);
    }

    private final List<BoundingBox> applyNMS(List<BoundingBox> list) {
        ArrayList<BoundingBox> arrayList;
        list = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith(list, new Comparator(){

            public final int compare(T t, T t2) {
                return ComparisonsKt.compareValues((Comparable)Float.valueOf(((BoundingBox)t2).getCnf()), (Comparable)Float.valueOf(((BoundingBox)t).getCnf()));
            }
        }));
        ArrayList<BoundingBox> arrayList2 = arrayList;
        arrayList = new ArrayList<BoundingBox>();
        while (list.isEmpty() ^ true) {
            List list2 = list;
            BoundingBox boundingBox = (BoundingBox)CollectionsKt.first((List)list);
            arrayList2.add(boundingBox);
            list2.remove(boundingBox);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                if (!(this.calculateIoU(boundingBox, (BoundingBox)iterator.next()) >= 0.5f)) continue;
                iterator.remove();
            }
        }
        return arrayList2;
    }

    private final float calculateIoU(BoundingBox boundingBox, BoundingBox boundingBox2) {
        BoundingBox boundingBox3 = boundingBox;
        float f = Math.max(boundingBox3.getX1(), boundingBox2.getX1());
        float f2 = Math.max(boundingBox3.getY1(), boundingBox2.getY1());
        float f3 = Math.min(boundingBox3.getX2(), boundingBox2.getX2());
        f = Math.max(0.0f, f3 - f);
        float f4 = Math.max(0.0f, Math.min(boundingBox3.getY2(), boundingBox2.getY2()) - f2) * f;
        BoundingBox boundingBox4 = boundingBox2;
        BoundingBox boundingBox5 = boundingBox;
        f = boundingBox5.getW();
        f = boundingBox5.getH() * f;
        float f5 = boundingBox4.getW();
        return f4 / (boundingBox4.getH() * f5 + f - f4);
    }

    static {
        OUTPUT_IMAGE_TYPE = INPUT_IMAGE_TYPE = DataType.FLOAT32;
    }

    public final boolean getShouldCapture() {
        return this.shouldCapture;
    }

    public final void setShouldCapture(boolean bl) {
        this.shouldCapture = bl;
    }

    public final void restart(boolean bl) {
        Interpreter.Options options;
        ((KLPDetector)((Object)mappedByteBuffer)).close();
        ((KLPDetector)((Object)mappedByteBuffer)).detected = false;
        if (bl) {
            Interpreter.Options options2;
            CompatibilityList compatibilityList;
            CompatibilityList compatibilityList2 = compatibilityList;
            options = options2;
            options2 = new Interpreter.Options();
            if (new CompatibilityList().isDelegateSupportedOnThisDevice()) {
                GpuDelegate gpuDelegate;
                compatibilityList2 = compatibilityList2.getBestOptionsForThisDevice();
                GpuDelegate gpuDelegate2 = gpuDelegate;
                gpuDelegate = new GpuDelegate((GpuDelegate.Options)compatibilityList2);
                options.addDelegate((Delegate)gpuDelegate2);
            } else {
                options.setNumThreads(4);
            }
        } else {
            Interpreter.Options options3;
            options = options3;
            new Interpreter.Options().setNumThreads(4);
        }
        MappedByteBuffer mappedByteBuffer = FileUtil.loadMappedFile((Context)((KLPDetector)((Object)mappedByteBuffer)).context, (String)((KLPDetector)((Object)mappedByteBuffer)).modelPath);
        Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"loadMappedFile(context, modelPath)");
        v4.interpreter = new Interpreter((ByteBuffer)mappedByteBuffer, options);
    }

    public final void close() {
        try {
            this.interpreter.close();
        }
        catch (Exception exception) {}
    }

    public final void detect(@NotNull Bitmap object, @NotNull Function0<Unit> function0) {
        Function0<Unit> function02;
        TensorImage tensorImage;
        Intrinsics.checkNotNullParameter((Object)object, (String)"frame");
        Intrinsics.checkNotNullParameter(function0, (String)"doneProcessed");
        if (this.tensorWidth == 0) {
            return;
        }
        if (this.tensorHeight == 0) {
            return;
        }
        if (this.numChannel == 0) {
            return;
        }
        if (this.numElements == 0) {
            return;
        }
        KLPDetector kLPDetector = this;
        KLPDetector kLPDetector2 = this;
        long l = SystemClock.uptimeMillis();
        int n = kLPDetector2.tensorWidth;
        Object object2 = Bitmap.createScaledBitmap((Bitmap)object, (int)n, (int)kLPDetector2.tensorHeight, (boolean)false);
        Object object3 = tensorImage;
        object3(INPUT_IMAGE_TYPE);
        tensorImage.load(object2);
        object2 = ((TensorImage)kLPDetector.imageProcessor.process(object3)).getBuffer();
        int[] nArray = new int[3];
        object3 = nArray;
        object3[0] = (TensorImage)true;
        object3[1] = (TensorImage)this.numChannel;
        nArray[2] = this.numElements;
        object3 = TensorBuffer.createFixedSize((int[])nArray, (DataType)OUTPUT_IMAGE_TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"createFixedSize(intArray\u2026ents), OUTPUT_IMAGE_TYPE)");
        this.interpreter.run(object2, (Object)object3.getBuffer());
        float[] fArray = object3.getFloatArray();
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"output.floatArray");
        object2 = kLPDetector.bestBox(fArray);
        l = SystemClock.uptimeMillis() - l;
        if (object2 == null) {
            this.onEmptyDetect();
            return;
        }
        Bitmap bitmap = object;
        int n2 = bitmap.getWidth();
        object = function02;
        function02 = new Function0<Unit>(function0){
            public final /* synthetic */ Function0<Unit> $doneProcessed;
            {
                this.$doneProcessed = function0;
                super(0);
            }

            public final void invoke() {
                this.$doneProcessed.invoke();
            }
        };
        this.onDetect(n2, bitmap.getHeight(), (List<BoundingBox>)object2, l, (Function0<Unit>)object);
    }

    @Override
    public void onEmptyDetect() {
        this.onImageListener.onImageNotDetected();
    }

    @Override
    public void onDetect(int n, int n2, @NotNull List<BoundingBox> arrayList, long l, @NotNull Function0<Unit> function0) {
        StringBuffer stringBuffer;
        ArrayList<BoundingBox> arrayList2;
        ArrayList<BoundingBox> arrayList3;
        Intrinsics.checkNotNullParameter(arrayList, (String)"boundingBoxes");
        Intrinsics.checkNotNullParameter(function0, (String)"doneProcessed");
        if (this.detected && this.shouldCapture) {
            return;
        }
        ArrayList<BoundingBox> arrayList4 = arrayList;
        float f = (float)n * 0.75f;
        float f2 = n2;
        f = (f2 - f) / (float)2 / f2;
        f2 = 1.0f - f;
        arrayList = arrayList3;
        arrayList3 = new ArrayList<BoundingBox>();
        ArrayList<BoundingBox> arrayList5 = arrayList2;
        arrayList2 = new ArrayList<BoundingBox>();
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        float f3 = -1.0f;
        float f4 = -1.0f;
        float f5 = -1.0f;
        float f6 = -1.0f;
        for (BoundingBox boundingBox : arrayList4) {
            BoundingBox boundingBox2;
            if (boundingBox2.getCnf() < Math.min(this.CARD_CONF, this.CORNER_CONF)) continue;
            if (Intrinsics.areEqual((Object)boundingBox.getClsName(), (Object)"card")) {
                arrayList5.add(boundingBox);
            } else if (Intrinsics.areEqual((Object)boundingBox.getClsName(), (Object)"corner")) {
                arrayList.add(boundingBox);
            }
            if (f3 == -1.0f || boundingBox.getY1() < f3) {
                f3 = boundingBox.getY1();
            }
            if (f4 == -1.0f || boundingBox.getY2() > f4) {
                f4 = boundingBox.getY2();
            }
            if (f5 == -1.0f || boundingBox.getX1() < f5) {
                f5 = boundingBox.getX1();
            }
            if (f6 == -1.0f || boundingBox.getX2() > f6) {
                f6 = boundingBox.getX2();
            }
            stringBuffer2.append(boundingBox.getClsName() + " " + boundingBox.getCnf() + " \t");
        }
        if (arrayList5.size() == 1) {
            int n3;
            if (f4 - f3 < 0.5f && f6 - f5 < 0.5f) {
                this.onImageListener.onImageTooSmall();
            } else if (arrayList5.size() == 1 && 4 <= (n3 = arrayList.size()) && n3 < 6 && f3 > f && f4 < f2) {
                KLPDetector kLPDetector = this;
                kLPDetector.onImageListener.onImageInMask();
                if (kLPDetector.shouldCapture && ++this.detectCount >= 5) {
                    this.detectCount = 0;
                    this.onImageListener.onImageDetected();
                    this.detected = true;
                }
            } else {
                if ((this.detectCount += -1) < 0) {
                    this.detectCount = 0;
                }
                if (arrayList5.size() > 0) {
                    this.onImageListener.onImageOutOfMask();
                }
            }
        }
        function0.invoke();
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

