/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.liveness;

import android.content.Context;
import android.graphics.Bitmap;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vn.kalapa.ekyc.liveness.LivenessSession;
import vn.kalapa.ekyc.liveness.LivenessSessionStatus;
import vn.kalapa.ekyc.managers.KLPFaceDetectorListener;
import vn.kalapa.ekyc.utils.Helpers;
import vn.kalapa.ekyc.utils.LIVENESS_VERSION;

public final class LivenessHandler {
    @NotNull
    private final Context context;
    @NotNull
    private final LIVENESS_VERSION livenessSessionType;
    @NotNull
    private final KLPFaceDetectorListener faceDetectorListener;
    private final int rotationAngle;
    private final int LIVENESS_MAX_TIME;
    @NotNull
    private LivenessSession livenessSession;
    private boolean isStop;
    private long startTime;
    @NotNull
    private LivenessSessionStatus sessionStatus;
    @NotNull
    private String sessionAction;

    public LivenessHandler(@NotNull Context context, @NotNull LIVENESS_VERSION lIVENESS_VERSION, @NotNull KLPFaceDetectorListener kLPFaceDetectorListener, int n) {
        LivenessHandler livenessHandler = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)lIVENESS_VERSION), (String)"livenessSessionType");
        Intrinsics.checkNotNullParameter((Object)kLPFaceDetectorListener, (String)"faceDetectorListener");
        this.context = context;
        this.livenessSessionType = lIVENESS_VERSION;
        this.faceDetectorListener = kLPFaceDetectorListener;
        livenessHandler.rotationAngle = n;
        livenessHandler.LIVENESS_MAX_TIME = 60000;
        livenessHandler.livenessSession = new LivenessSession(lIVENESS_VERSION);
        livenessHandler.startTime = System.currentTimeMillis();
        livenessHandler.sessionStatus = LivenessSessionStatus.UNVERIFIED;
        livenessHandler.sessionAction = "";
    }

    public /* synthetic */ LivenessHandler(Context context, LIVENESS_VERSION lIVENESS_VERSION, KLPFaceDetectorListener kLPFaceDetectorListener, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(context, lIVENESS_VERSION, kLPFaceDetectorListener, n);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final LivenessSession getLivenessSession() {
        return this.livenessSession;
    }

    public final void setLivenessSession(@NotNull LivenessSession livenessSession) {
        Intrinsics.checkNotNullParameter((Object)livenessSession, (String)"<set-?>");
        this.livenessSession = livenessSession;
    }

    public final boolean isStop() {
        return this.isStop;
    }

    public final void setStop(boolean bl) {
        this.isStop = bl;
    }

    @NotNull
    public final String getSessionAction() {
        return this.sessionAction;
    }

    public final void setSessionAction(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.sessionAction = string2;
    }

    public final void stop() {
        this.isStop = true;
    }

    public final void renewSession() {
        LivenessHandler livenessHandler = this;
        Helpers.Companion.printLog("on renewSession");
        livenessHandler.livenessSession.renewSession(this.livenessSessionType);
        livenessHandler.sessionStatus = livenessHandler.livenessSession.getSessionStatus();
        livenessHandler.startTime = System.currentTimeMillis();
    }

    public final void processSession(@NotNull Bitmap object, @NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"image");
        boolean bl = System.currentTimeMillis() - this.startTime > (long)this.LIVENESS_MAX_TIME;
        if (!(this.isStop || this.livenessSession.isFinished() || bl)) {
            LivenessHandler livenessHandler = this;
            Bitmap bitmap2 = object;
            LivenessHandler livenessHandler2 = this;
            int n = livenessHandler2.rotationAngle;
            object = livenessHandler2.faceDetectorListener;
            livenessHandler.livenessSession.process(bitmap2, bitmap, n, (KLPFaceDetectorListener)object);
            livenessHandler.sessionStatus = livenessHandler.livenessSession.getSessionStatus();
            livenessHandler.sessionAction = livenessHandler.livenessSession.getCurrentAction();
        } else {
            LivenessHandler livenessHandler = this;
            livenessHandler.sessionStatus = livenessHandler.livenessSession.getSessionStatus();
            livenessHandler.sessionAction = livenessHandler.livenessSession.getCurrentAction();
            if (livenessHandler.livenessSession.isFinished()) {
                if (this.sessionStatus == LivenessSessionStatus.VERIFIED) {
                    if (this.livenessSession.getGotTypicalFace()) {
                        this.faceDetectorListener.onFaceDetected(this.livenessSession.getTypicalFrame(), this.livenessSession.getTypicalFace());
                    }
                } else {
                    KLPFaceDetectorListener.DefaultImpls.onFaceDetected$default(this.faceDetectorListener, object, null, 2, null);
                }
            } else if (this.sessionStatus == LivenessSessionStatus.EXPIRED || bl) {
                this.faceDetectorListener.onExpired();
            }
        }
    }
}

