/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.liveness;

import android.graphics.Bitmap;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.face.Face;
import com.google.mlkit.vision.face.FaceDetection;
import com.google.mlkit.vision.face.FaceDetector;
import com.google.mlkit.vision.face.FaceDetectorOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.KalapaSDK;
import vn.kalapa.ekyc.liveness.InputFace;
import vn.kalapa.ekyc.liveness.LivenessSession;
import vn.kalapa.ekyc.liveness.LivenessSessionStatus;
import vn.kalapa.ekyc.liveness.models.ComeClose;
import vn.kalapa.ekyc.liveness.models.GoFar;
import vn.kalapa.ekyc.liveness.models.HoldSteady2Seconds;
import vn.kalapa.ekyc.liveness.models.LivenessAction;
import vn.kalapa.ekyc.liveness.models.LivenessActionStatus;
import vn.kalapa.ekyc.liveness.models.Processing;
import vn.kalapa.ekyc.liveness.models.Success;
import vn.kalapa.ekyc.liveness.models.TiltLeft;
import vn.kalapa.ekyc.liveness.models.TiltRight;
import vn.kalapa.ekyc.liveness.models.TurnDown;
import vn.kalapa.ekyc.liveness.models.TurnLeft;
import vn.kalapa.ekyc.liveness.models.TurnRight;
import vn.kalapa.ekyc.liveness.models.TurnUp;
import vn.kalapa.ekyc.managers.KLPFaceDetectorListener;
import vn.kalapa.ekyc.utils.Helpers;
import vn.kalapa.ekyc.utils.LIVENESS_VERSION;

@SourceDebugExtension(value={"SMAP\nLivenessSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LivenessSession.kt\nvn/kalapa/ekyc/liveness/LivenessSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1#2:257\n*E\n"})
public final class LivenessSession {
    @NotNull
    private LIVENESS_VERSION livenessSessionType;
    @NotNull
    private LivenessSessionStatus sessionStatus;
    private final int MAX_N_FRAME;
    @NotNull
    private ArrayList<InputFace> faceList;
    @NotNull
    private ArrayList<LivenessAction> actionList;
    private int currActionIdx;
    @Nullable
    private LivenessAction currAction;
    private Map<Integer, ? extends LivenessAction> index2Action;
    @NotNull
    private final String TAG;
    public Bitmap typicalFace;
    public Bitmap typicalFrame;
    private boolean gotTypicalFace;
    @NotNull
    private final FaceDetectorOptions faceDetectorOptions;
    @NotNull
    private FaceDetector faceDetector;

    public LivenessSession(@NotNull LIVENESS_VERSION lIVENESS_VERSION) {
        Intrinsics.checkNotNullParameter((Object)((Object)lIVENESS_VERSION), (String)"livenessSessionType");
        this.livenessSessionType = lIVENESS_VERSION;
        this.sessionStatus = LivenessSessionStatus.UNVERIFIED;
        this.MAX_N_FRAME = 600;
        this.faceList = new ArrayList();
        this.actionList = new ArrayList();
        this.currActionIdx = -1;
        this.TAG = "LivenessSession";
        FaceDetectorOptions faceDetectorOptions = new FaceDetectorOptions.Builder().setClassificationMode(2).setMinFaceSize(0.9f).build();
        Intrinsics.checkNotNullExpressionValue((Object)faceDetectorOptions, (String)"Builder()\n        .setCl\u2026ze(0.9f)\n        .build()");
        this.faceDetectorOptions = faceDetectorOptions;
        FaceDetector faceDetector = FaceDetection.getClient((FaceDetectorOptions)faceDetectorOptions);
        Intrinsics.checkNotNullExpressionValue((Object)faceDetector, (String)"getClient(faceDetectorOptions)");
        this.faceDetector = faceDetector;
        this.genActionList();
    }

    public /* synthetic */ LivenessSession(LIVENESS_VERSION lIVENESS_VERSION, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            lIVENESS_VERSION = LIVENESS_VERSION.PASSIVE;
        }
        this(lIVENESS_VERSION);
    }

    private final void refreshFaceList() {
        ArrayList arrayList;
        LivenessSession livenessSession = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        livenessSession.faceList = arrayList2;
    }

    private final void genActionList() {
        Helpers.Companion.printLog("genActionList " + this.livenessSessionType.name() + " ");
        int n = WhenMappings.$EnumSwitchMapping$0[this.livenessSessionType.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    this.index2Action = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)1, (Object)new HoldSteady2Seconds(1500)), TuplesKt.to((Object)2, (Object)new GoFar()), TuplesKt.to((Object)3, (Object)new ComeClose()), TuplesKt.to((Object)4, (Object)new Processing())});
                }
            } else {
                LivenessAction livenessAction;
                Pair[] pairArray = new Pair[5];
                Pair[] pairArray2 = pairArray;
                pairArray[0] = TuplesKt.to((Object)1, (Object)new HoldSteady2Seconds(1500));
                int n2 = 1;
                Integer n3 = 2;
                if (Random.Default.nextInt(2) % 2 == 0) {
                    TurnLeft turnLeft;
                    livenessAction = turnLeft;
                    turnLeft = new TurnLeft();
                } else {
                    TurnRight turnRight;
                    livenessAction = turnRight;
                    turnRight = new TurnRight();
                }
                pairArray2[n2] = TuplesKt.to((Object)n3, (Object)livenessAction);
                n2 = 2;
                n3 = 3;
                if (Random.Default.nextInt(2) % 2 == 0) {
                    TurnUp turnUp;
                    livenessAction = turnUp;
                    turnUp = new TurnUp();
                } else {
                    TurnDown turnDown;
                    livenessAction = turnDown;
                    turnDown = new TurnDown();
                }
                pairArray2[n2] = TuplesKt.to((Object)n3, (Object)livenessAction);
                n2 = 3;
                n3 = 4;
                if (Random.Default.nextInt(2) % 2 == 0) {
                    TiltLeft tiltLeft;
                    livenessAction = tiltLeft;
                    tiltLeft = new TiltLeft();
                } else {
                    TiltRight tiltRight;
                    livenessAction = tiltRight;
                    tiltRight = new TiltRight();
                }
                Pair[] pairArray3 = pairArray2;
                pairArray3[n2] = TuplesKt.to((Object)n3, (Object)livenessAction);
                pairArray3[4] = TuplesKt.to((Object)5, (Object)new Processing());
                this.index2Action = MapsKt.mapOf((Pair[])pairArray2);
            }
        } else {
            this.index2Action = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)1, (Object)new HoldSteady2Seconds(1500)), TuplesKt.to((Object)2, (Object)new Processing())});
        }
        LivenessSession livenessSession = this;
        livenessSession.currActionIdx = 0;
        livenessSession.currAction = null;
    }

    private final void _process(Face face, int n, int n2) {
        LivenessSession livenessSession = this;
        livenessSession.faceList.add(new InputFace(System.currentTimeMillis(), face, n, n2));
        if (livenessSession.faceList.size() > this.MAX_N_FRAME) {
            this.sessionStatus = LivenessSessionStatus.EXPIRED;
        }
    }

    private final void addAction(int n, LivenessAction livenessAction) {
        int n2;
        LivenessSession livenessSession = this;
        livenessSession.currActionIdx = n2 = livenessSession.currActionIdx + n;
        Map<Integer, ? extends LivenessAction> map = livenessSession.index2Action;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"index2Action");
            map = null;
        }
        Integer n3 = Collections.max(map.keySet());
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"max(index2Action.keys)");
        if (n2 > ((Number)n3).intValue()) {
            this.sessionStatus = LivenessSessionStatus.VERIFIED;
            return;
        }
        if (n == 0) {
            if (livenessAction != null) {
                this.actionList.add(livenessAction);
            }
        } else {
            Map<Integer, ? extends LivenessAction> map2 = this.index2Action;
            if (map2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"index2Action");
                map2 = null;
            }
            if ((map2 = map2.get(this.currActionIdx)) != null) {
                this.actionList.add((LivenessAction)((Object)map2));
            }
        }
    }

    public static /* synthetic */ void addAction$default(LivenessSession livenessSession, int n, LivenessAction livenessAction, int n2, Object object) {
        if ((n2 & 2) != 0) {
            livenessAction = null;
        }
        livenessSession.addAction(n, livenessAction);
    }

    private final void handleAction(Bitmap bitmap, Bitmap bitmap2) {
        if (((LivenessSession)((Object)success3)).currActionIdx == 0) {
            LivenessSession.addAction$default((LivenessSession)((Object)success3), 1, null, 2, null);
        }
        LivenessSession livenessSession = success3;
        int n = livenessSession.currActionIdx;
        Map<Integer, ? extends LivenessAction> map = livenessSession.index2Action;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"index2Action");
            map = null;
        }
        Integer n2 = Collections.max(map.keySet());
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"max(index2Action.keys)");
        if (n <= ((Number)n2).intValue()) {
            int n3;
            ArrayList<LivenessAction> arrayList = ((LivenessSession)((Object)success3)).actionList;
            Object object = arrayList.get(arrayList.size() - 1);
            ((LivenessSession)((Object)success3)).currAction = object;
            Intrinsics.checkNotNull((Object)object);
            object = ((LivenessAction)object).process((LivenessSession)((Object)success3));
            if (object == LivenessActionStatus.SUCCESS && (Intrinsics.areEqual((Object)((map = ((LivenessSession)((Object)success3)).currAction) != null ? ((LivenessAction)((Object)map)).getTAG() : null), (Object)"HoldSteady2Seconds") || Intrinsics.areEqual((Object)((map = ((LivenessSession)((Object)success3)).currAction) != null ? ((LivenessAction)((Object)map)).getTAG() : null), (Object)"ComeClose"))) {
                if (!((LivenessSession)((Object)success3)).gotTypicalFace) {
                    Helpers.Companion.printLog("Found typical frame!");
                    ((LivenessSession)((Object)success3)).setTypicalFrame(bitmap);
                    ((LivenessSession)((Object)success3)).setTypicalFace(bitmap2);
                }
                ((LivenessSession)((Object)success3)).gotTypicalFace = true;
            }
            if ((n3 = WhenMappings.$EnumSwitchMapping$1[((Enum)object).ordinal()]) != 1) {
                if (n3 != 2) {
                    if (n3 == 3) {
                        ((LivenessSession)((Object)success3)).sessionStatus = LivenessSessionStatus.PROCESSING;
                    }
                } else {
                    ((LivenessSession)((Object)success3)).genActionList();
                }
            } else {
                LivenessAction livenessAction = ((LivenessSession)((Object)success3)).currAction;
                Intrinsics.checkNotNull((Object)livenessAction);
                if (livenessAction.isBreakAction()) {
                    LivenessSession.addAction$default((LivenessSession)((Object)success3), 1, null, 2, null);
                } else {
                    Success success2;
                    LivenessSession livenessSession2 = success3;
                    Success success3 = success2;
                    success2 = new Success();
                    livenessSession2.addAction(0, success3);
                }
            }
        }
    }

    private static final void process$lambda$0(Function1 function1, Object object) {
        Function1 function12 = function1;
        Intrinsics.checkNotNullParameter((Object)function12, (String)"$tmp0");
        function12.invoke(object);
    }

    public LivenessSession() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$refreshFaceList(LivenessSession livenessSession) {
        livenessSession.refreshFaceList();
    }

    public static final /* synthetic */ void access$_process(LivenessSession livenessSession, Face face, int n, int n2) {
        livenessSession._process(face, n, n2);
    }

    public static final /* synthetic */ void access$handleAction(LivenessSession livenessSession, Bitmap bitmap, Bitmap bitmap2) {
        livenessSession.handleAction(bitmap, bitmap2);
    }

    public static final /* synthetic */ String access$getTAG$p(LivenessSession livenessSession) {
        return livenessSession.TAG;
    }

    public static final /* synthetic */ LivenessAction access$getCurrAction$p(LivenessSession livenessSession) {
        return livenessSession.currAction;
    }

    @NotNull
    public final LivenessSessionStatus getSessionStatus() {
        return this.sessionStatus;
    }

    public final void setSessionStatus(@NotNull LivenessSessionStatus livenessSessionStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)livenessSessionStatus), (String)"<set-?>");
        this.sessionStatus = livenessSessionStatus;
    }

    @NotNull
    public final ArrayList<InputFace> getFaceList() {
        return this.faceList;
    }

    public final void setFaceList(@NotNull ArrayList<InputFace> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.faceList = arrayList;
    }

    @NotNull
    public final Bitmap getTypicalFace() {
        LivenessSession livenessSession = livenessSession.typicalFace;
        if (livenessSession != null) {
            return livenessSession;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"typicalFace");
        return null;
    }

    public final void setTypicalFace(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"<set-?>");
        this.typicalFace = bitmap;
    }

    @NotNull
    public final Bitmap getTypicalFrame() {
        LivenessSession livenessSession = livenessSession.typicalFrame;
        if (livenessSession != null) {
            return livenessSession;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"typicalFrame");
        return null;
    }

    public final void setTypicalFrame(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"<set-?>");
        this.typicalFrame = bitmap;
    }

    public final boolean getGotTypicalFace() {
        return this.gotTypicalFace;
    }

    public final void setGotTypicalFace(boolean bl) {
        this.gotTypicalFace = bl;
    }

    public final void renewSession(@NotNull LIVENESS_VERSION lIVENESS_VERSION) {
        LivenessSession livenessSession = this;
        LIVENESS_VERSION lIVENESS_VERSION2 = lIVENESS_VERSION;
        Intrinsics.checkNotNullParameter((Object)((Object)lIVENESS_VERSION2), (String)"livenessSessionType");
        livenessSession.livenessSessionType = lIVENESS_VERSION2;
        livenessSession.sessionStatus = LivenessSessionStatus.UNVERIFIED;
        livenessSession.gotTypicalFace = false;
        livenessSession.refreshFaceList();
        livenessSession.genActionList();
    }

    public final void process(@NotNull Bitmap bitmap, @NotNull Bitmap bitmap2, int n, @NotNull KLPFaceDetectorListener kLPFaceDetectorListener) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"cropImage");
        Intrinsics.checkNotNullParameter((Object)kLPFaceDetectorListener, (String)"faceDetectorListener");
        if (!this.isFinished()) {
            this.faceDetector.process(InputImage.fromBitmap((Bitmap)bitmap2, (int)n)).addOnSuccessListener(arg_0 -> LivenessSession.process$lambda$0((Function1)new Function1<List<Face>, Unit>(this, bitmap2, bitmap, kLPFaceDetectorListener){
                public final /* synthetic */ LivenessSession this$0;
                public final /* synthetic */ Bitmap $cropImage;
                public final /* synthetic */ Bitmap $frame;
                public final /* synthetic */ KLPFaceDetectorListener $faceDetectorListener;
                {
                    this.this$0 = livenessSession;
                    this.$cropImage = bitmap;
                    this.$frame = bitmap2;
                    this.$faceDetectorListener = kLPFaceDetectorListener;
                    super(1);
                }

                public final void invoke(List<Face> list) {
                    if (!object9.this$0.isFinished()) {
                        Object object;
                        if (list.size() == 0) {
                            object9.this$0.setSessionStatus(LivenessSessionStatus.NO_FACE);
                        } else {
                            InputFace inputFace;
                            int n = 0;
                            for (Face face : list) {
                                InputFace inputFace2;
                                inputFace = inputFace2;
                                long l = System.currentTimeMillis();
                                Intrinsics.checkNotNullExpressionValue((Object)face, (String)"face");
                                process.1 v1 = object9;
                                int n2 = v1.$cropImage.getWidth();
                                int n3 = v1.$cropImage.getHeight();
                                inputFace2 = new InputFace(l, face, n2, n3);
                                if (!LivenessAction.x.isFaceSizeJustBiggerThanTooSmall(inputFace)) continue;
                                ++n;
                            }
                            if (list.size() > 1) {
                                Helpers.Companion.printLog("So many faces... " + n + " counted");
                            }
                            if (list.size() > 1 && n > 1) {
                                process.1 v2 = object9;
                                v2.this$0.setSessionStatus(LivenessSessionStatus.TOO_MANY_FACES);
                                LivenessSession.access$refreshFaceList(v2.this$0);
                            } else {
                                InputFace inputFace3;
                                InputFace inputFace4 = inputFace3;
                                long l = System.currentTimeMillis();
                                inputFace = list.get(0);
                                process.1 v4 = object9;
                                InputFace inputFace5 = inputFace;
                                Intrinsics.checkNotNullExpressionValue((Object)inputFace5, (String)"it[0]");
                                object = (Face)inputFace5;
                                int n4 = v4.$cropImage.getWidth();
                                int n5 = v4.$cropImage.getHeight();
                                inputFace3 = new InputFace(l, (Face)object, n4, n5);
                                object = LivenessAction.x;
                                if (((LivenessAction.x)object).isFaceTooSmall(inputFace4)) {
                                    object9.this$0.setSessionStatus(LivenessSessionStatus.TOO_SMALL);
                                } else if (((LivenessAction.x)object).isFaceTooBig(inputFace4)) {
                                    object9.this$0.setSessionStatus(LivenessSessionStatus.TOO_LARGE);
                                } else {
                                    Object object2 = object9;
                                    n4 = object2.$cropImage.getWidth();
                                    if (!((LivenessAction.x)object).isFaceMarginRight(inputFace4.getFace(), n4, object2.$cropImage.getHeight())) {
                                        Object object3 = object9;
                                        object3.this$0.setSessionStatus(LivenessSessionStatus.OFF_CENTER);
                                        LivenessSession.access$refreshFaceList(object3.this$0);
                                    } else if (KalapaSDK.Companion.getConfig$kalapa_release().getLivenessVersion() != LIVENESS_VERSION.ACTIVE.getVersion() && !((LivenessAction.x)object).isFaceLookStraight(inputFace4.getFace())) {
                                        Object object4 = object9;
                                        object4.this$0.setSessionStatus(LivenessSessionStatus.ANGLE_NOT_CORRECT);
                                        LivenessSession.access$refreshFaceList(object4.this$0);
                                    } else {
                                        Object object5 = object9;
                                        Object object6 = object9;
                                        int n6 = object6.$cropImage.getWidth();
                                        LivenessSession.access$_process(object5.this$0, inputFace4.getFace(), n6, object6.$cropImage.getHeight());
                                        Object object7 = object9;
                                        Bitmap bitmap = object7.$frame;
                                        LivenessSession.access$handleAction(object5.this$0, bitmap, object7.$cropImage);
                                    }
                                }
                            }
                        }
                        process.1 v12 = object9;
                        Helpers.Companion companion = Helpers.Companion;
                        object = new Object[1];
                        int n = 0;
                        String string2 = LivenessSession.access$getTAG$p(v12.this$0);
                        Object object8 = LivenessSession.access$getCurrAction$p(v12.this$0);
                        object8 = object8 != null ? ((LivenessAction)object8).getTAG() : null;
                        process.1 v13 = object9;
                        Face face = object;
                        process.1 v15 = object9;
                        Object object9 = object9.this$0.getSessionStatus();
                        int n7 = list.size();
                        int n8 = v15.this$0.getFaceList().size();
                        face[n] = string2 + " Processing: " + (String)object8 + " - Liveness Session Status " + (LivenessSessionStatus)((Object)object9) + " " + n7 + " - faceList " + n8;
                        companion.printLog((Object[])face);
                        object9 = v13.$faceDetectorListener;
                        LivenessSessionStatus livenessSessionStatus = v13.this$0.getSessionStatus();
                        Object object10 = LivenessSession.access$getCurrAction$p(v13.this$0);
                        object10 = object10 != null ? ((LivenessAction)object10).getTAG() : null;
                        object9.onMessage(livenessSessionStatus, (String)object10);
                    }
                }
            }, arg_0));
        }
    }

    @NotNull
    public final String getCurrentAction() {
        String string2;
        int n = this.currActionIdx;
        if (n > 0 && n < this.actionList.size()) {
            ArrayList<LivenessAction> arrayList = this.actionList;
            string2 = arrayList.get(arrayList.size() - 1).getTAG();
        } else {
            string2 = "";
        }
        return string2;
    }

    public final boolean isFinished() {
        Object object = object.sessionStatus;
        return object == LivenessSessionStatus.FAILED || object == LivenessSessionStatus.VERIFIED;
    }

    public final void switchAction() {
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LIVENESS_VERSION.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[LIVENESS_VERSION.PASSIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LIVENESS_VERSION.ACTIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LIVENESS_VERSION.SEMI_ACTIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
            int[] nArray3 = new int[LivenessActionStatus.values().length];
            nArray2 = nArray3;
            try {
                nArray3[LivenessActionStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LivenessActionStatus.TIMEOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[LivenessActionStatus.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray2;
        }
    }
}

