/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class Utils {
    public static MappedByteBuffer loadModelFile(AssetManager assetManager, String string2) {
        AssetManager assetManager2 = assetManager = assetManager.openFd(string2);
        long l = assetManager2.getStartOffset();
        long l2 = assetManager2.getDeclaredLength();
        return new FileInputStream(assetManager.getFileDescriptor()).getChannel().map(FileChannel.MapMode.READ_ONLY, l, l2);
    }

    public static void softmax(float[] fArray) {
        int n;
        float f = Float.NEGATIVE_INFINITY;
        int n2 = fArray.length;
        for (n = 0; n < n2; ++n) {
            f = Math.max(f, fArray[n]);
        }
        float f2 = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            float f3 = f2;
            fArray[n] = f2 = (float)Math.exp(fArray[n] - f);
            f2 = f3 + f2;
        }
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = fArray[i] / f2;
        }
    }

    public static float expit(float f) {
        double d = Math.exp(-f) + 1.0;
        return (float)(1.0 / d);
    }

    public static Bitmap getBitmapFromAsset(Context context, String string2) {
        AssetManager assetManager = context.getAssets();
        context = null;
        try {
            context = BitmapFactory.decodeStream((InputStream)assetManager.open(string2));
        }
        catch (IOException iOException) {
            Log.e((String)"getBitmapFromAsset", (String)("getBitmapFromAsset: " + iOException.getMessage()));
        }
        return context;
    }

    public static Matrix getTransformationMatrix(int n, int n2, int n3, int n4, int n5, boolean bl) {
        Matrix matrix;
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        if (n5 != 0) {
            matrix2.postTranslate((float)(-n) / 2.0f, (float)(-n2) / 2.0f);
            matrix2.postRotate((float)n5);
        }
        boolean bl2 = (Math.abs(n5) + 90) % 180 == 0;
        int n6 = bl2 ? n2 : n;
        if (!bl2) {
            n = n2;
        }
        if (n6 != n3 || n != n4) {
            float f = (float)n3 / (float)n6;
            float f2 = (float)n4 / (float)n;
            if (bl) {
                float f3 = Math.max(f, f2);
                matrix2.postScale(f3, f3);
            } else {
                matrix2.postScale(f, f2);
            }
        }
        if (n5 != 0) {
            matrix2.postTranslate((float)n3 / 2.0f, (float)n4 / 2.0f);
        }
        return matrix2;
    }

    public static Bitmap processBitmap(Bitmap bitmap, int n) {
        Matrix matrix;
        Bitmap bitmap2 = bitmap;
        int n2 = bitmap2.getHeight();
        int n3 = bitmap2.getWidth();
        Bitmap bitmap3 = Bitmap.createBitmap((int)n, (int)n, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int n4 = n;
        Matrix matrix2 = Utils.getTransformationMatrix(n3, n2, n4, n4, 0, false);
        Matrix matrix3 = matrix;
        matrix = new Matrix();
        matrix2.invert(matrix3);
        new Canvas(bitmap3).drawBitmap(bitmap, matrix2, null);
        return bitmap3;
    }

    /*
     * Loose catch block
     */
    public static void writeToFile(String string2, Context object) {
        FileOutputStream fileOutputStream;
        File file;
        object = Environment.getExternalStorageDirectory().getAbsolutePath();
        String string32 = "myFile.txt";
        File file2 = file;
        file = new File((String)object + File.separator + string32);
        object = fileOutputStream;
        String string4 = string2;
        ((FileOutputStream)object)(file2);
        fileOutputStream.write(string4.getBytes());
        fileOutputStream.close();
        catch (Throwable throwable) {
            try {
                ((FileOutputStream)object).close();
                throw throwable;
            }
            catch (IOException iOException) {
                Log.e((String)"Exception", (String)("File write failed: " + ((Object)iOException).toString()));
            }
        }
    }
}

