/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.views;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.R;
import vn.kalapa.ekyc.KalapaSDK;
import vn.kalapa.ekyc.utils.BitmapUtil;
import vn.kalapa.ekyc.utils.Helpers;
import vn.kalapa.ekyc.views.MaskView;

public final class CardMaskView
extends MaskView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ID_CARD_WIDTH_SIZE = 860;
    private static final int ID_CARD_HEIGHT_SIZE = 540;
    private float roundRadius;
    private float ovalTop;
    private float ovalFrameTop;
    private final float foldOpenConst;
    private final float foldClosedConst;
    private float normalWidth;
    private float normalHeight;
    private float smallWidth;
    private float smallHeight;
    private boolean isLivenessMode;

    @JvmOverloads
    public CardMaskView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        CardMaskView cardMaskView = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, n);
        cardMaskView.foldOpenConst = 1.5f;
        cardMaskView.foldClosedConst = 0.8f;
        cardMaskView.init(context, attributeSet, n, 0);
    }

    public /* synthetic */ CardMaskView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @TargetApi(value=21)
    public CardMaskView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n, int n2) {
        CardMaskView cardMaskView = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, n, n2);
        cardMaskView.foldOpenConst = 1.5f;
        cardMaskView.foldClosedConst = 0.8f;
        cardMaskView.init(context, attributeSet, n, n2);
    }

    @SuppressLint(value={"Recycle"})
    private final void init(Context context, AttributeSet attributeSet, int n, int n2) {
        CardMaskView cardMaskView = this;
        cardMaskView.setWillNotDraw(false);
        cardMaskView.setLayerType(2, null);
        if (attributeSet != null) {
            PorterDuffColorFilter porterDuffColorFilter;
            CardMaskView cardMaskView2 = this;
            CardMaskView cardMaskView3 = this;
            DisplayMetrics displayMetrics = cardMaskView3.getResources().getDisplayMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"resources.displayMetrics");
            cardMaskView3.setMetrics(displayMetrics);
            AttributeSet attributeSet2 = attributeSet = context.obtainStyledAttributes(attributeSet, R.styleable.CardMaskView, n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)attributeSet2, (String)"context.obtainStyledAttr\u2026defStyleRes\n            )");
            this.isLivenessMode = attributeSet2.getBoolean(R.styleable.CardMaskView_liveness_mode, false);
            this.setMaskColor(attributeSet.getInt(R.styleable.CardMaskView_maskColor, R.color.maskColor));
            this.setDashColor(attributeSet.getInt(R.styleable.CardMaskView_dashColor, R.color.colorPrimary));
            this.setCenterX(attributeSet.getDimension(R.styleable.CardMaskView_centerX, (float)this.getMetrics().widthPixels / 2.0f));
            cardMaskView2.setCenterY(attributeSet.getDimension(R.styleable.CardMaskView_centerY, (float)this.getMetrics().heightPixels / 2.0f));
            cardMaskView2.getTransparentPaint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            cardMaskView2.getDashPaint().setStyle(Paint.Style.STROKE);
            cardMaskView2.getDashPaint().setColor(attributeSet.getInt(R.styleable.CardMaskView_dashColor, R.color.colorPrimary));
            float f = 2;
            cardMaskView2.getDashPaint().setStrokeWidth(attributeSet.getDimension(R.styleable.FaceDetectionView_strokeWidth, f * this.getMetrics().density));
            cardMaskView2.getDashPaint().setPathEffect((PathEffect)new DashPathEffect(new float[]{20.0f, 20.0f}, 0.0f));
            float f2 = cardMaskView2.getMetrics().density * 18.0f;
            f2 = cardMaskView2.isLivenessMode ? (float)(this.getMetrics().widthPixels / 5) * 4.0f : (float)this.getMetrics().widthPixels * 1.0f - f * f2;
            if (f2 > (float)(this.getMetrics().heightPixels / 2) || KalapaSDK.Companion.isFoldOpen(context)) {
                f2 = (float)this.getMetrics().widthPixels / this.foldOpenConst;
            }
            Helpers.Companion.printLog("CardMaskView " + this.getMetrics().widthPixels + " - Height: " + this.getMetrics().heightPixels);
            boolean bl = this.isLivenessMode;
            float f3 = bl ? f2 : f2 / (float)ID_CARD_WIDTH_SIZE * (float)ID_CARD_HEIGHT_SIZE;
            float f4 = bl ? f2 / f : attributeSet.getDimension(R.styleable.CardMaskView_radius, 0.0f) * this.getMetrics().density;
            CardMaskView cardMaskView4 = this;
            CardMaskView cardMaskView5 = this;
            this.roundRadius = f4;
            this.normalWidth = attributeSet.getDimension(R.styleable.CardMaskView_frameWidth, f2);
            float f5 = attributeSet.getDimension(R.styleable.CardMaskView_frameHeight, f3);
            this.normalHeight = f4 = f5;
            f4 = this.normalWidth;
            this.smallWidth = f4 * 0.8f;
            cardMaskView5.smallHeight = f5 * 0.8f;
            cardMaskView5.setFrameWidth(f4);
            cardMaskView5.setFrameHeight(cardMaskView5.normalHeight);
            this.setTransOff(attributeSet.getDimension(R.styleable.CardMaskView_transOff, this.getMetrics().density * 0.0f));
            this.setTransOffY(attributeSet.getDimension(R.styleable.CardMaskView_transOffY, this.getMetrics().density * 0.0f));
            cardMaskView4.setCornerColor(attributeSet.getColor(R.styleable.CardMaskView_cornerColor, -1));
            PorterDuffColorFilter porterDuffColorFilter2 = porterDuffColorFilter;
            porterDuffColorFilter = new PorterDuffColorFilter(this.getCornerColor(), PorterDuff.Mode.DST_IN);
            if (cardMaskView4.getCornerColor() != -1) {
                PorterDuffColorFilter porterDuffColorFilter3;
                porterDuffColorFilter2 = porterDuffColorFilter3;
                porterDuffColorFilter3 = new PorterDuffColorFilter(this.getCornerColor(), PorterDuff.Mode.SRC_IN);
            }
            CardMaskView cardMaskView6 = this;
            cardMaskView6.getCornerPaint().setColorFilter((ColorFilter)porterDuffColorFilter2);
            cardMaskView6.setFrame();
            cardMaskView6.setConner(null);
        }
    }

    private final void draw4Corners(Canvas canvas, RectF rectF, Paint paint) {
        canvas.drawBitmap(BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.drawable.frame_exclude_png), null, rectF, paint);
    }

    @JvmOverloads
    public CardMaskView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public CardMaskView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public final float getNormalWidth() {
        return this.normalWidth;
    }

    public final void setNormalWidth(float f) {
        this.normalWidth = f;
    }

    public final float getNormalHeight() {
        return this.normalHeight;
    }

    public final void setNormalHeight(float f) {
        this.normalHeight = f;
    }

    public final float getSmallWidth() {
        return this.smallWidth;
    }

    public final void setSmallWidth(float f) {
        this.smallWidth = f;
    }

    public final float getSmallHeight() {
        return this.smallHeight;
    }

    public final void setSmallHeight(float f) {
        this.smallHeight = f;
    }

    public final boolean isLivenessMode() {
        return this.isLivenessMode;
    }

    public final void setLivenessMode(boolean bl) {
        this.isLivenessMode = bl;
    }

    @Override
    public void setFrame() {
        CardMaskView cardMaskView = this;
        Helpers.Companion.printLog("setFrame transOffY " + this.getTransOffY());
        CardMaskView cardMaskView2 = this;
        float f = 2;
        float f2 = cardMaskView2.getCenterX() - this.getFrameWidth() / f;
        float f3 = cardMaskView2.getCenterY();
        f3 = cardMaskView2.getTransOffY() + f3 - this.getFrameHeight() / f;
        float f4 = cardMaskView2.getCenterX();
        f4 = cardMaskView2.getFrameWidth() / f + f4;
        float f5 = cardMaskView2.getCenterY();
        float f6 = f2;
        CardMaskView cardMaskView3 = this;
        f2 = cardMaskView3.getTransOffY() + f5;
        cardMaskView.setFrame(new RectF(f6, f3, f4, cardMaskView3.getFrameHeight() / f + f2));
        CardMaskView cardMaskView4 = this;
        f = cardMaskView4.getFrame().left;
        float f7 = cardMaskView4.getTransOff() + f;
        CardMaskView cardMaskView5 = this;
        f = cardMaskView5.getFrame().top;
        f = cardMaskView5.getTransOff() + f;
        f2 = cardMaskView5.getFrame().right - this.getTransOff();
        float f8 = cardMaskView5.getFrame().bottom - this.getTransOff();
        cardMaskView.setTransparentFrame(new RectF(f7, f, f2, f8));
    }

    public final void switchIntoFarModeLiveness() {
        CardMaskView cardMaskView = this;
        cardMaskView.setFrameWidth(cardMaskView.smallWidth);
        cardMaskView.setFrameHeight(cardMaskView.smallWidth);
        cardMaskView.setFrame();
    }

    public final void resetToDefault() {
        CardMaskView cardMaskView = this;
        cardMaskView.setFrameWidth(cardMaskView.normalWidth);
        cardMaskView.setFrameHeight(cardMaskView.normalWidth);
        cardMaskView.setFrame();
    }

    public void draw(@NotNull Canvas canvas) {
        float f;
        CardMaskView cardMaskView = this;
        Canvas canvas2 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        super.draw(canvas2);
        if (!cardMaskView.isLivenessMode) {
            CardMaskView cardMaskView2 = this;
            CardMaskView cardMaskView3 = this;
            RectF rectF = cardMaskView3.getTransparentFrame();
            float f2 = cardMaskView3.roundRadius;
            Paint paint = cardMaskView3.getTransparentPaint();
            float f3 = f2;
            canvas.drawRoundRect(rectF, f3, f3, paint);
            rectF = cardMaskView2.getFrame();
            Paint paint2 = cardMaskView2.getDashPaint();
            cardMaskView2.draw4Corners(canvas, rectF, paint2);
        } else {
            if (this.ovalTop == 0.0f) {
                this.ovalTop = this.getTransparentFrame().top - this.getTransparentFrame().bottom * 0.0618f;
            }
            if (this.ovalFrameTop == 0.0f) {
                this.ovalFrameTop = this.getFrame().top - this.getFrame().bottom * 0.0618f;
            }
            CardMaskView cardMaskView4 = this;
            CardMaskView cardMaskView5 = this;
            float f4 = cardMaskView5.getTransparentFrame().left;
            float f5 = cardMaskView5.ovalTop;
            float f6 = cardMaskView5.getTransparentFrame().right;
            f = cardMaskView5.getTransparentFrame().bottom;
            Paint paint = cardMaskView5.getTransparentPaint();
            canvas.drawOval(f4, f5, f6, f, paint);
            f4 = cardMaskView4.getFrame().left;
            f5 = cardMaskView4.ovalFrameTop;
            f6 = cardMaskView4.getFrame().right;
            f = cardMaskView4.getFrame().bottom;
            paint = cardMaskView4.getDashPaint();
            canvas.drawOval(f4, f5, f6, f, paint);
        }
        Bitmap bitmap = this.getConner();
        if (bitmap != null) {
            RectF rectF;
            Matrix matrix;
            RectF rectF2;
            Matrix matrix2;
            RectF rectF3;
            Matrix matrix3;
            RectF rectF4;
            Bitmap bitmap2 = bitmap;
            Bitmap bitmap3 = bitmap;
            Bitmap bitmap4 = bitmap;
            Bitmap bitmap5 = bitmap;
            CardMaskView cardMaskView6 = this;
            float f7 = cardMaskView6.getConnerSize() / 2.0f;
            bitmap = rectF4;
            CardMaskView cardMaskView7 = this;
            float f8 = cardMaskView7.getFrame().top - f7;
            float f9 = cardMaskView7.getFrame().left - f7;
            f9 = cardMaskView7.getConnerSize() + f9;
            f = cardMaskView7.getFrame().top - f7;
            f = cardMaskView7.getConnerSize() + f;
            rectF4 = new RectF(this.getFrame().left - f7, f8, f9, f);
            Paint paint = cardMaskView6.getCornerPaint();
            canvas.drawBitmap(bitmap5, null, (RectF)bitmap, paint);
            bitmap = matrix3;
            new Matrix().setRotate(90.0f);
            int n = bitmap4.getWidth();
            int n2 = bitmap4.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap4, (int)0, (int)0, (int)n, (int)n2, (Matrix)bitmap, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(it, 0, 0, i\u2026 it.height, matrix, true)");
            RectF rectF5 = rectF3;
            CardMaskView cardMaskView8 = this;
            float f10 = cardMaskView8.getFrame().top - f7;
            f = cardMaskView8.getFrame().right - f7;
            f = cardMaskView8.getConnerSize() + f;
            float f11 = cardMaskView8.getFrame().top - f7;
            f11 = cardMaskView8.getConnerSize() + f11;
            rectF3 = new RectF(this.getFrame().right - f7, f10, f, f11);
            Paint paint3 = this.getCornerPaint();
            canvas.drawBitmap(bitmap, null, rectF5, paint3);
            bitmap = matrix2;
            new Matrix().setRotate(-90.0f);
            int n3 = bitmap3.getWidth();
            int n4 = bitmap3.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap3, (int)0, (int)0, (int)n3, (int)n4, (Matrix)bitmap, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(it, 0, 0, i\u2026 it.height, matrix, true)");
            RectF rectF6 = rectF2;
            CardMaskView cardMaskView9 = this;
            float f12 = cardMaskView9.getFrame().bottom - f7;
            f = cardMaskView9.getFrame().left - f7;
            f = cardMaskView9.getConnerSize() + f;
            f11 = cardMaskView9.getFrame().bottom - f7;
            f11 = cardMaskView9.getConnerSize() + f11;
            rectF2 = new RectF(this.getFrame().left - f7, f12, f, f11);
            Paint paint4 = this.getCornerPaint();
            canvas.drawBitmap(bitmap, null, rectF6, paint4);
            bitmap = matrix;
            new Matrix().setRotate(180.0f);
            int n5 = bitmap2.getWidth();
            int n6 = bitmap2.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n5, (int)n6, (Matrix)bitmap, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(it, 0, 0, i\u2026 it.height, matrix, true)");
            RectF rectF7 = rectF;
            float f13 = this.getFrame().right - f7;
            CardMaskView cardMaskView10 = this;
            float f14 = cardMaskView10.getFrame().bottom - f7;
            float f15 = cardMaskView10.getFrame().right - f7;
            f15 = cardMaskView10.getConnerSize() + f15;
            f7 = cardMaskView10.getFrame().bottom - f7;
            f7 = cardMaskView10.getConnerSize() + f7;
            rectF = new RectF(f13, f14, f15, f7);
            Paint paint5 = this.getCornerPaint();
            canvas.drawBitmap(bitmap, null, rectF7, paint5);
        }
    }

    @Override
    @NotNull
    public Bitmap crop(@NotNull Bitmap bitmap, int n) {
        CardMaskView cardMaskView = this;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"inputImage");
        bitmap = BitmapUtil.rotateBitmapToStraight$default(BitmapUtil.INSTANCE, bitmap, n, false, 4, null);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        float f = (float)bitmap.getWidth() / (float)this.getWidth();
        float f2 = (float)bitmap.getHeight() / (float)this.getHeight();
        float f3 = Math.min(f, f2);
        float f4 = cardMaskView.getTransparentFrame().left - this.getTransOffY();
        f4 = (cardMaskView.getTransOff() * (float)2 + f4) * f;
        float f5 = cardMaskView.getTransparentFrame().top * f2;
        float f6 = cardMaskView.getTransparentFrame().width() * f3;
        f3 = cardMaskView.getTransparentFrame().height() * f3;
        Helpers.Companion companion = Helpers.Companion;
        Object[] objectArray = new Object[1];
        int n2 = n;
        CardMaskView cardMaskView2 = this;
        DisplayMetrics displayMetrics2 = displayMetrics;
        n = displayMetrics2.densityDpi;
        float f7 = displayMetrics2.density;
        float f8 = cardMaskView2.getTransOffY();
        float f9 = cardMaskView2.getTransOff();
        objectArray[0] = "Camera Degree: cameraDegree " + n2 + " " + n + " " + f7 + " scaleW " + f + " scaleH " + f2 + " transOffY " + f8 + " transOff " + f9;
        companion.printLog(objectArray);
        Object[] objectArray2 = new Object[1];
        CardMaskView cardMaskView3 = this;
        Bitmap bitmap2 = bitmap;
        CardMaskView cardMaskView4 = this;
        float f10 = cardMaskView4.getFrameHeight();
        f7 = cardMaskView4.getFrame().centerX();
        f8 = cardMaskView4.getFrame().centerY();
        int n3 = bitmap2.getWidth();
        int n4 = bitmap2.getHeight();
        int n5 = cardMaskView3.getWidth();
        int n6 = cardMaskView3.getHeight();
        float f11 = cardMaskView3.getCenterX();
        float f12 = cardMaskView3.getCenterY();
        float f13 = f10;
        CardMaskView cardMaskView5 = this;
        f10 = cardMaskView5.getFrame().width();
        float f14 = cardMaskView5.getFrame().height();
        float f15 = cardMaskView5.getFrame().top;
        float f16 = cardMaskView5.getFrame().left;
        float f17 = cardMaskView5.getFrame().centerX();
        float f18 = cardMaskView5.getFrame().centerY();
        objectArray2[0] = "frameWidth " + this.getFrameWidth() + " frameHeight " + f13 + " frame centerX " + f7 + " frame center Y " + f8 + " \n image.width " + n3 + " image.height " + n4 + " \n width " + n5 + " height " + n6 + " centerX " + f11 + " centerY " + f12 + "\n frame " + f10 + " height() " + f14 + " top() " + f15 + "  left() " + f16 + " center X " + f17 + " center Y " + f18;
        companion.printLog(objectArray2);
        KalapaSDK.Companion companion2 = KalapaSDK.Companion;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        if (companion2.isFoldOpen(context)) {
            companion.printLog("Crop on Foldable is open");
            float f19 = f5 + f3;
            if (Math.abs(this.getTransOffY()) + f19 <= (float)bitmap.getHeight()) {
                f3 = Math.abs(this.getTransOffY()) + f3;
            }
            if (f5 + f3 > (float)bitmap.getHeight()) {
                f3 = (float)bitmap.getHeight() - f5;
            }
            int n7 = (int)f5;
            int n8 = bitmap.getWidth();
            int n9 = (int)f3;
            Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)n7, (int)n8, (int)n9);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(\n          \u2026rop.toInt()\n            )");
            return bitmap3;
        }
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        if (companion2.isTablet(context2)) {
            float f20;
            float f21;
            float f22;
            companion.printLog("Crop on Tablet");
            float f23 = 40;
            f7 = f4 - f23 * f;
            if (f22 > 0.0f) {
                f4 = f7;
            }
            f23 = f5 - f23 * f2;
            if (f21 > 0.0f) {
                f5 = f23;
            }
            float f24 = this.getTransparentFrame().width();
            f24 = Math.max(f, f2) * f24;
            f23 = this.getTransparentFrame().height();
            f23 = Math.max(f, f2) * f23;
            if (f5 + f20 > (float)bitmap.getHeight()) {
                f23 = (float)bitmap.getHeight() - f5;
            }
            if (f4 + f24 > (float)bitmap.getWidth()) {
                f24 = (float)bitmap.getWidth() - f4;
            }
            int n10 = (int)f4;
            int n11 = (int)f5;
            int n12 = (int)f24;
            int n13 = (int)f23;
            Bitmap bitmap4 = Bitmap.createBitmap((Bitmap)bitmap, (int)n10, (int)n11, (int)n12, (int)n13);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"createBitmap(\n          \u2026rop.toInt()\n            )");
            return bitmap4;
        }
        float f25 = f4 - 0.0f;
        float f26 = f25 == 0.0f ? 0 : (f25 < 0.0f ? -1 : 1);
        int n14 = f26 >= 0 && !(f4 + f6 > (float)bitmap.getWidth()) ? 0 : 1;
        float f27 = f5 - 0.0f;
        float f28 = f27 == 0.0f ? 0 : (f27 < 0.0f ? -1 : 1);
        boolean bl = f28 < 0 || f5 + f3 > (float)bitmap.getHeight();
        if (n14 == 0 && !bl) {
            f26 = (int)f4;
            int n15 = (int)f5;
            n14 = (int)f6;
            f28 = (int)f3;
            Bitmap bitmap5 = Bitmap.createBitmap((Bitmap)bitmap, (int)f26, (int)n15, (int)n14, (int)f28);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap5, (String)"createBitmap(\n          \u2026rop.toInt()\n            )");
            return bitmap5;
        }
        if (n14 != 0) {
            if (f28 < 0) {
                f5 = 0.0f;
            }
            int n16 = (int)((float)bitmap.getWidth() * 1.0f * (float)ID_CARD_HEIGHT_SIZE / (float)ID_CARD_WIDTH_SIZE);
            f26 = n16;
            if (f5 + (float)n16 > (float)bitmap.getHeight()) {
                f26 = bitmap.getHeight();
            }
            Bitmap bitmap6 = bitmap;
            int n17 = (int)f5;
            n14 = bitmap6.getWidth();
            Bitmap bitmap7 = Bitmap.createBitmap((Bitmap)bitmap6, (int)0, (int)n17, (int)n14, (int)f26);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap7, (String)"createBitmap(image, 0, y\u2026, image.width, newHeight)");
            return bitmap7;
        }
        if (f26 < 0) {
            f4 = 0.0f;
        }
        int n18 = (int)((float)bitmap.getHeight() * 1.0f * (float)ID_CARD_WIDTH_SIZE / (float)ID_CARD_HEIGHT_SIZE);
        f26 = n18;
        if (f5 + (float)n18 > (float)bitmap.getWidth()) {
            f26 = bitmap.getWidth();
        }
        Bitmap bitmap8 = bitmap;
        int n19 = (int)f4;
        n14 = bitmap8.getHeight();
        Bitmap bitmap9 = Bitmap.createBitmap((Bitmap)bitmap8, (int)n19, (int)0, (int)f26, (int)n14);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap9, (String)"createBitmap(image, xCro\u2026, newWidth, image.height)");
        return bitmap9;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final int getID_CARD_WIDTH_SIZE() {
            return ID_CARD_WIDTH_SIZE;
        }

        public final int getID_CARD_HEIGHT_SIZE() {
            return ID_CARD_HEIGHT_SIZE;
        }
    }
}

