package vn.kalapa.ekyc.capturesdk

//import vn.kalapa.ekyc.capturesdk.tflite.OverlayView
import android.annotation.SuppressLint
import android.graphics.Bitmap
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.Matrix
import android.graphics.PointF
import android.os.Handler
import android.os.Looper
import android.util.Size
import android.view.View
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.TextView
import android.widget.Toast
import androidx.camera.core.AspectRatio
import androidx.camera.core.ImageAnalysis
import androidx.camera.core.ImageProxy
import androidx.camera.core.resolutionselector.ResolutionSelector
import androidx.camera.core.resolutionselector.ResolutionStrategy
import androidx.camera.view.PreviewView
import vn.kalapa.R
import vn.kalapa.ekyc.DialogListener
import vn.kalapa.ekyc.KalapaCaptureHandler
import vn.kalapa.ekyc.KalapaSDK
import vn.kalapa.ekyc.KalapaSDKMediaType
import vn.kalapa.ekyc.KalapaSDKResultCode
import vn.kalapa.ekyc.activity.CameraXActivity
import vn.kalapa.ekyc.capturesdk.tflite.BoundingBox
import vn.kalapa.ekyc.capturesdk.tflite.KLPDetector
import vn.kalapa.ekyc.capturesdk.tflite.OnImageDetectedListener
import vn.kalapa.ekyc.extension.ViewUtils
import vn.kalapa.ekyc.fragment.BottomGuideFragment
import vn.kalapa.ekyc.fragment.GuideType
import vn.kalapa.ekyc.managers.KLPLanguageManager
import vn.kalapa.ekyc.utils.BitmapUtil
import vn.kalapa.ekyc.utils.Common.Companion.vibratePhone
import vn.kalapa.ekyc.utils.Helpers
import vn.kalapa.ekyc.utils.KALAPA_LOG_ACTION
import vn.kalapa.ekyc.utils.KALAPA_LOG_LEVEL
import vn.kalapa.ekyc.utils.LogUtil.logEndSession
import vn.kalapa.ekyc.utils.LogUtil.logEvent
import vn.kalapa.ekyc.views.ProgressView

class CameraXAutoCaptureActivity(private val modelString: String = "klp_model_16.tflite") :
    CameraXActivity(activityLayoutId = R.layout.activity_camera_x_id_card, hideAutoCapture = false),
    OnImageDetectedListener {
    private lateinit var ivPreviewImage: ImageView
    private lateinit var tvTitle: TextView
    private lateinit var tvGuide1: TextView
    private lateinit var ivGuide: ImageView
    private var latestMessageTimestamp = System.currentTimeMillis()

    @Volatile
    private var detector: KLPDetector? = null

    //    private lateinit var overlay: OverlayView
    private lateinit var ivCardInMask: ImageView
    private lateinit var tvAutoCapture: TextView
    private val previewView: PreviewView by lazy(LazyThreadSafetyMode.NONE) { findViewById(R.id.viewFinder) }
    private val loadingProgressBar: ProgressBar by lazy(LazyThreadSafetyMode.NONE) { findViewById(R.id.progress_bar) }

    private lateinit var documentType: KalapaSDKMediaType
    private lateinit var captureGuide: String

    // Test
//    private lateinit var ivBitmapReview: ImageView
    private fun getIntentData() {
        documentType = KalapaSDKMediaType.fromName(
            intent.getStringExtra("document_type") ?: KalapaSDKMediaType.BACK.name
        )
        captureGuide =
            KLPLanguageManager.get(resources.getString(R.string.klp_id_capture_subtitle)) +
                    KLPLanguageManager.get(resources.getString(if (documentType == KalapaSDKMediaType.FRONT) R.string.klp_id_capture_subtitle_front else R.string.klp_id_capture_subtitle_back))
        Helpers.printLog("DocumentType: $documentType")
    }

    override fun onAutoCaptureToggle(isAutoCapturing: Boolean) {
        logEvent(
            this,
            KALAPA_LOG_LEVEL.INFO,
            if (isAutoCapturing) KALAPA_LOG_ACTION.CAPTURE_AUTO_ON else KALAPA_LOG_ACTION.CAPTURE_AUTO_OFF,
            SCREEN_ID
        )
        detector?.isAutoCaptureOn = isAutoCapturing
//        if (isAutoCapturing) {
//            ViewUtils.visible(ivCardInMask)
//        } else {
//            ViewUtils.gone(ivCardInMask)
//        }
    }

    override fun setupCustomUI() {
        getIntentData()
//        ivBitmapReview = findViewById(R.id.iv_bitmap_preview)
        tvError.text = captureGuide
        ivGuide = findViewById(R.id.iv_action)
        ivGuide.setImageResource(
            when (documentType) {
                KalapaSDKMediaType.FRONT -> R.drawable.klp_ic_footer_front
                KalapaSDKMediaType.BACK -> R.drawable.klp_ic_footer_back
                else -> R.drawable.ic_passport_black
            }
        )
        tvTitle = findViewById(R.id.tv_title)
        tvTitle.text = KLPLanguageManager.get(resources.getString(R.string.klp_id_capture_title))
        ivPreviewImage = findViewById(R.id.iv_preview_image)
        ivPreviewImage.isDrawingCacheEnabled = false
        tvGuide1 = findViewById(R.id.tv_guide)
        ivGuide.setColorFilter(Color.parseColor(KalapaSDK.config.mainColor))
//        overlay = findViewById(R.id.overlay)
        ivCardInMask = findViewById(R.id.iv_card_in_mask)
        tvAutoCapture = findViewById(R.id.klp_auto_capture)
        tvAutoCapture.setTextColor(Color.parseColor(KalapaSDK.config.mainTextColor))
        tvAutoCapture.text = KLPLanguageManager.get(resources.getString(R.string.klp_id_capture_ac))
        tvTitle.setTextColor((Color.parseColor(KalapaSDK.config.mainTextColor)))
        tvGuide1.text = KLPLanguageManager.get(resources.getString(R.string.klp_id_capture_note))
        tvGuide1.setTextColor(Color.parseColor(KalapaSDK.config.mainTextColor))

    }


    override fun postSetupCamera() {
        cameraExecutor.execute {
            detector = KLPDetector(
                this@CameraXAutoCaptureActivity,
                modelString,
                "klp_label.txt",
                isAutocapturing,
                this
            )
        }
    }

    override fun previewViewLayerMode(isCameraMode: Boolean) {
        super.previewViewLayerMode(isCameraMode)
        if (isCameraMode) {
            ViewUtils.fadeIn(holderAutoCapture)
            ViewUtils.fadeIn(ivGuide)
            ViewUtils.fadeIn(tvGuide)
        } else {
            if (KalapaSDK.isFoldOpen(this@CameraXAutoCaptureActivity)) {
                ViewUtils.gone(holderAutoCapture)
                ViewUtils.gone(ivGuide)
                ViewUtils.gone(tvGuide)
            }
        }
    }

    private var currError = ""
    override fun sendError(message: String?) {
        val isIgnore = message == null || currError == message || (System.currentTimeMillis() - latestMessageTimestamp < 1000) || (System.currentTimeMillis() - (manualCaptureTime ?: 0) < 1000)
        Helpers.printLog("sendError! $message isIgnore: $isIgnore")
        if (isIgnore) return

        latestMessageTimestamp = System.currentTimeMillis()
        ProgressView.hideProgress()
        this.runOnUiThread {
            currError = message ?: ""
            tvError.setTextColor(
                if (message.isNullOrEmpty()) Color.parseColor(KalapaSDK.config.mainTextColor) else resources.getColor(
                    R.color.ekyc_red, null
                )
            )
            tvError.text = currError
            btnNext.visibility = View.INVISIBLE
        }
        Helpers.printLog("onError message: $message")
    }

    override fun sendDone(nextAction: () -> Unit) {
        logEvent(this, KALAPA_LOG_LEVEL.INFO, KALAPA_LOG_ACTION.CAPTURE_SUCCESS, SCREEN_ID)
        nextAction()
        runOnUiThread {
            ProgressView.hideProgress()
        }
        finish()
    }


    override fun onRetryClicked() {
        super.onRetryClicked()
        renewSession()
    }

    override fun setupAnalyzer(): ImageAnalysis {
        return ImageAnalysis.Builder()
            .setResolutionSelector(
                ResolutionSelector.Builder().setResolutionStrategy(
                    ResolutionStrategy(
                        Size(1600, 900),
                        ResolutionStrategy.FALLBACK_RULE_CLOSEST_HIGHER_THEN_LOWER
                    )
                ).build()
            )
            .setBackpressureStrategy(ImageAnalysis.STRATEGY_KEEP_ONLY_LATEST)
            .setOutputImageFormat(ImageAnalysis.OUTPUT_IMAGE_FORMAT_RGBA_8888)
            .build().also { imageAnalysis ->
                imageAnalysis.setAnalyzer(cameraExecutor) { imageProxy ->
                    val bitmapBuffer = Bitmap.createBitmap(
                        imageProxy.width,
                        imageProxy.height,
                        Bitmap.Config.ARGB_8888
                    )
                    imageProxy.use { bitmapBuffer.copyPixelsFromBuffer(imageProxy.planes[0].buffer) }

                    val matrix = Matrix().apply {
                        postRotate(imageProxy.imageInfo.rotationDegrees.toFloat())
                    }
                    val rotatedBitmap = Bitmap.createBitmap(
                        bitmapBuffer, 0, 0, bitmapBuffer.width, bitmapBuffer.height, matrix, true
                    )
                    detector?.let {
                        it.detect(
                            frame = rotatedBitmap,
                            doneProcessed = {
                                rotatedBitmap.recycle()
                                imageProxy.close()
                            }
                        )
                    } ?: run {
                        rotatedBitmap.recycle()
                        imageProxy.close()
                    }
                }
            }
    }

    override fun onPause() {
        super.onPause()
        detector?.close()
        detector = null
    }

    override fun showEndEkyc() {
        Helpers.showEndKYC(this, object : DialogListener {
            override fun onYes() {
                KalapaSDK.handler.onError(KalapaSDKResultCode.USER_LEAVE)
                logEndSession(this@CameraXAutoCaptureActivity)
                finish()
            }

            override fun onNo() {

            }
        })
    }

    override fun onCaptureSuccess(rotationDegree: Int) {
        val cameraRotationDegree = getCameraRotationDegree()
        val rotation =
            if (rotationDegree != cameraRotationDegree) ((cameraRotationDegree - rotationDegree + 270) % 360) else rotationDegree
        Helpers.printLog("onCaptureSuccess $rotationDegree ${getCameraRotationDegree()} $rotation $tmpBitmap")
        tmpBitmap?.let { bm ->
            val rotatedBitmap = BitmapUtil.rotateBitmapToStraight(bm, rotation, false)
            runOnUiThread {
                ViewUtils.gone(ivCardInMask)
                ViewUtils.gone(loadingProgressBar)
                ViewUtils.visible(tvError)
                when ((1..2).random()) {
                    1 -> ViewUtils.appearAnimZoom(ivPreviewImage)
                    2 -> ViewUtils.appearAnimSpin(ivPreviewImage)
                }
//                ivBitmapReview.setImageBitmap(tmpBitmap)
                val previewBitmap = cropDetectedIdCard(
                    bitmap = rotatedBitmap,
                    boundingBoxes = detector?.getCurrentBoundingBoxes(frame = rotatedBitmap) ?: emptyList()
                )
                ivPreviewImage.setImageBitmap(previewBitmap)
//                ivPreviewImage.setImageBitmap(tmpBitmap)
            }
        } ?: run {
            errorToast()
        }
    }

    private fun errorToast() {
        logEvent(
            this,
            KALAPA_LOG_LEVEL.ERROR,
            KALAPA_LOG_ACTION.CAPTURE_FAIL,
            SCREEN_ID,
        )
        Toast.makeText(
            this,
            KLPLanguageManager.get(resources.getString(R.string.klp_id_capture_ac_corners)),
            Toast.LENGTH_SHORT
        ).show()
        btnRetry.performClick()
    }

    /**
     * Crop the detected ID card from the original image.
     * =========================
     * Get 4 corner points of the bounding box, then calculate the width and height of the ID card.
     * Then, create a matrix to crop the ID card from the original image.
     * @param bitmap The original image.
     * @param boundingBoxes The bounding box of the detected ID card.
     * @return The cropped ID card.
     * @see BoundingBox
     * @see Bitmap
     */

    private fun cropDetectedIdCard(
        bitmap: Bitmap,
        boundingBoxes: List<BoundingBox>,
        offset: Float = 200f
    ): Bitmap {
        if (boundingBoxes.size < 4) {
            val ratio = viewFinder.height * 1.0f / viewFinder.width
            tmpBitmap = BitmapUtil.crop(bitmap, bitmap.width, (bitmap.width * ratio).toInt(), 0.5f, 0.5f)
            return BitmapUtil.crop(bitmap, bitmap.width, (bitmap.width * ratio).toInt(), 0.5f, 0.5f)
        } else {
            val bitmapWidth = bitmap.width.toFloat()
            val bitmapHeight = bitmap.height.toFloat()

            val points = boundingBoxes.map { PointF(it.cx * bitmapWidth, it.cy * bitmapHeight) }
            val topLeft = PointF(Float.MAX_VALUE, Float.MAX_VALUE)
            val topRight = PointF(Float.MIN_VALUE, Float.MAX_VALUE)
            val bottomRight = PointF(Float.MIN_VALUE, Float.MIN_VALUE)
            val bottomLeft = PointF(Float.MAX_VALUE, Float.MIN_VALUE)

            points.forEach { point ->
                val sum = point.x + point.y
                val diff = point.x - point.y

                if (sum < topLeft.x + topLeft.y) {
                    topLeft.set(point.x, point.y)
                }
                if (diff > topRight.x - topRight.y) {
                    topRight.set(point.x, point.y)
                }
                if (sum > bottomRight.x + bottomRight.y) {
                    bottomRight.set(point.x, point.y)
                }
                if (diff < bottomLeft.x - bottomLeft.y) {
                    bottomLeft.set(point.x, point.y)
                }
            }
            // Calculate the width and height with an additional 40 pixels (20 on each side)
            val zoomWidth = (maxOf(topRight.x - topLeft.x, bottomRight.x - bottomLeft.x))
            val zoomHeight = (maxOf(bottomLeft.y - topLeft.y, bottomRight.y - topRight.y))

            val originalWidth = (maxOf(topRight.x - topLeft.x, bottomRight.x - bottomLeft.x) + offset).toInt()
            val originalHeight = (maxOf(bottomLeft.y - topLeft.y, bottomRight.y - topRight.y) + offset).toInt()


            // Set source points (the original corners)
            val srcPoints = floatArrayOf(
                topLeft.x, topLeft.y,
                topRight.x, topRight.y,
                bottomRight.x, bottomRight.y,
                bottomLeft.x, bottomLeft.y
            )

            // Set destination points with 20-pixel padding on each side
            val originalDstPoints = floatArrayOf(
                offset / 2, offset / 2,
                originalWidth - offset / 2, offset / 2,
                originalWidth - offset / 2, originalHeight - offset / 2,
                offset, originalHeight - offset / 2
            )
            val zoomDstPoints = floatArrayOf(
                0f, 0f,
                zoomWidth, 0f,
                zoomWidth, zoomHeight,
                0f, zoomHeight
            )

            // Apply the transformation matrix
            val zoomMatrix = Matrix().apply {
                setPolyToPoly(srcPoints, 0, zoomDstPoints, 0, 4)
            }
            val originalMatrix = Matrix().apply {
                setPolyToPoly(srcPoints, 0, originalDstPoints, 0, 4)
            }

            // Create a new Bitmap with the expanded width and height, and draw the original bitmap on it
            tmpBitmap = Bitmap.createBitmap(originalWidth, originalHeight, Bitmap.Config.ARGB_8888).apply {
                Canvas(this).drawBitmap(bitmap, originalMatrix, null)
            }
            return Bitmap.createBitmap(zoomWidth.toInt(), zoomHeight.toInt(), Bitmap.Config.ARGB_8888).apply {
                Canvas(this).drawBitmap(bitmap, zoomMatrix, null)
            }

        }
    }


    private fun renewSession() {
        currError = ""
        postSetupCamera()
//        previewView.visible()
//        ivPreviewImage.gone()
//        ivCardInMask.scaleIn()
        ViewUtils.visible(previewView)
        ViewUtils.gone(ivPreviewImage)
        ViewUtils.scaleIn(ivCardInMask)
        if (isAutocapturing) {
//            ViewUtils.scaleIn(ivCardInMask)
            ViewUtils.visible(ivCardInMask)
            ViewUtils.visible(tvError)
        } else {
//            ViewUtils.gone(ivCardInMask)
//            ViewUtils.gone(tvError)
        }
        tvError.setTextColor(Color.parseColor(KalapaSDK.config.mainTextColor))
        tvError.text = captureGuide
        tmpBitmap = null
    }

    override fun onResume() {
        super.onResume()
        renewSession()
    }

    override fun verifyImage() {
        ProgressView.showProgress(this@CameraXAutoCaptureActivity)
        (KalapaSDK.handler as KalapaCaptureHandler).process(
            BitmapUtil.convertBitmapToBase64(tmpBitmap!!),
            documentType,
            this@CameraXAutoCaptureActivity
        )
    }

    override fun onBackBtnClicked() {
        if (showingGuide) {
            supportFragmentManager.popBackStack()
            logEvent(
                this,
                KALAPA_LOG_LEVEL.INFO,
                KALAPA_LOG_ACTION.GUIDE_TAP_CLOSE,
                SCREEN_ID
            )
            showingGuide = false
        } else
            showEndEkyc()
    }

    private var showingGuide = false

    override fun onInfoBtnClicked() {
        showingGuide = true
        Helpers.printLog("On Info Btn Clicked $documentType")
        val bottomFragment = BottomGuideFragment(
            when (documentType) {
                KalapaSDKMediaType.FRONT -> GuideType.FRONT
                KalapaSDKMediaType.BACK -> GuideType.BACK
                KalapaSDKMediaType.PASSPORT -> GuideType.PASSPORT
                KalapaSDKMediaType.PORTRAIT -> GuideType.SELFIE
                else -> GuideType.FRONT
            }
        )
        supportFragmentManager.beginTransaction()
            .setCustomAnimations(
                R.anim.slide_in_bottom,
                R.anim.slide_in_bottom,
                R.anim.slide_in_bottom,
                R.anim.slide_out_bottom
            )
            .replace(R.id.fragment_container, bottomFragment)
            .addToBackStack(null)
            .commit()
    }

    private fun fillBytes(planes: Array<ImageProxy.PlaneProxy>, yuvBytes: Array<ByteArray?>) {
        // Because of the variable row stride it's not possible to know in
        // advance the actual necessary dimensions of the yuv planes.
        for (i in planes.indices) {
            val buffer = planes[i].buffer
            if (yuvBytes[i] == null) {
                Helpers.printLog("Initializing buffer %d at size %d", i, buffer.capacity())
                yuvBytes[i] = ByteArray(buffer.capacity())
            }
            buffer[yuvBytes[i] ?: return]
        }
    }

    private var inFrameAtLeastOnce = false

    override fun onImageDetected() {
        logEvent(this, KALAPA_LOG_LEVEL.INFO, KALAPA_LOG_ACTION.CAPTURE_AUTO_SUCCESS, SCREEN_ID)
        takePhoto()
        Handler(Looper.getMainLooper()).postDelayed({
            vibratePhone(this)
            runOnUiThread {
//                loadingProgressBar.visible()
//                ivCardInMask.gone()
                ViewUtils.visible(loadingProgressBar)
                ViewUtils.gone(ivCardInMask)
                tvError.setTextColor(resources.getColor(R.color.ekyc_green, null))
                tvError.setTextColor(resources.getColor(R.color.ekyc_green))
                tvError.text =
                    KLPLanguageManager.get(resources.getString(R.string.klp_id_capture_ac_success))
            }
        }, 200)
    }

    @SuppressLint("ResourceType")
    override fun onImageOutOfMask() {
        runOnUiThread {
            inFrameAtLeastOnce = false
            sendError(KLPLanguageManager.get(resources.getString(R.string.klp_id_capture_ac_corners)))
            Helpers.setBackgroundColorTintList(ivCardInMask, resources.getString(R.color.ekyc_red))
        }
    }

    @SuppressLint("ResourceType")
    override fun onImageInMask() {
        runOnUiThread {
            sendError("")
            if (inFrameAtLeastOnce)
                Helpers.setBackgroundColorTintList(ivCardInMask, resources.getString(R.color.ekyc_green))
            inFrameAtLeastOnce = true

        }
    }

    @SuppressLint("ResourceType")
    override fun onImageNotDetected() {
        runOnUiThread {
//            overlay.clear()
//            overlay.invalidate()
            inFrameAtLeastOnce = false
            if (currError == "")
                Helpers.setBackgroundColorTintList(ivCardInMask, resources.getString(R.color.white))
        }
    }

    @SuppressLint("ResourceType")
    override fun onImageTooSmall() {
        runOnUiThread {
            inFrameAtLeastOnce = false
            sendError(KLPLanguageManager.get(resources.getString(R.string.klp_id_capture_ac_too_small)))
            Helpers.setBackgroundColorTintList(ivCardInMask, resources.getString(R.color.ekyc_red))
        }
    }

    fun showLoadingProcess() {
//        loadingProgressBar.visible()
//        ivCardInMask.gone()
        ViewUtils.visible(loadingProgressBar)
        ViewUtils.gone(ivCardInMask)
    }

}
typealias InputImageListener = (inputImage: Bitmap) -> Unit