/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.icao;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import java.util.Enumeration;

public class DataGroupHash
extends ASN1Object {
    public ASN1Integer dataGroupNumber;
    public ASN1OctetString dataGroupHashValue;

    public static DataGroupHash getInstance(Object object) {
        if (object instanceof DataGroupHash) {
            return (DataGroupHash)object;
        }
        if (object != null) {
            return new DataGroupHash(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private DataGroupHash(ASN1Sequence aSN1Sequence) {
        DataGroupHash dataGroupHash = enumeration;
        Enumeration enumeration = aSN1Sequence.getObjects();
        dataGroupHash.dataGroupNumber = ASN1Integer.getInstance(enumeration.nextElement());
        dataGroupHash.dataGroupHashValue = ASN1OctetString.getInstance(enumeration.nextElement());
    }

    public DataGroupHash(int n, ASN1OctetString aSN1OctetString) {
        this.dataGroupNumber = new ASN1Integer(n);
        this.dataGroupHashValue = aSN1OctetString;
    }

    public int getDataGroupNumber() {
        return this.dataGroupNumber.intValueExact();
    }

    public ASN1OctetString getDataGroupHashValue() {
        return this.dataGroupHashValue;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(2);
        aSN1EncodableVector2.add(this.dataGroupNumber);
        aSN1EncodableVector.add(this.dataGroupHashValue);
        return new DERSequence(aSN1EncodableVector2);
    }
}

