/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class Grainv1Engine
implements StreamCipher {
    private static final int STATE_SIZE = 5;
    private byte[] workingKey;
    private byte[] workingIV;
    private byte[] out;
    private int[] lfsr;
    private int[] nfsr;
    private int output;
    private int index = 2;
    private boolean initialised = false;

    private void initGrain() {
        for (int k = 0; k < 10; ++k) {
            Grainv1Engine grainv1Engine = this;
            grainv1Engine.output = grainv1Engine.getOutput();
            grainv1Engine.nfsr = grainv1Engine.shift(grainv1Engine.nfsr, this.getOutputNFSR() ^ this.lfsr[0] ^ this.output);
            grainv1Engine.lfsr = grainv1Engine.shift(grainv1Engine.lfsr, this.getOutputLFSR() ^ this.output);
        }
        this.initialised = true;
    }

    private int getOutputNFSR() {
        Object object = ((Grainv1Engine)object).nfsr;
        int n = ((Grainv1Engine)object).nfsr[0];
        int n2 = n >>> 9;
        int n3 = ((Grainv1Engine)object).nfsr[1];
        int n4 = n;
        n2 |= n3 << 7;
        int n5 = n4 >>> 14 | n3 << 2;
        int n6 = n4 >>> 15 | n3 << 1;
        int n7 = n3 >>> 5;
        int n8 = ((Grainv1Engine)object).nfsr[2];
        int n9 = n3;
        n3 = n7 | n8 << 11;
        n7 = n9 >>> 12 | n8 << 4;
        int n10 = n8 >>> 1;
        int n11 = ((Grainv1Engine)object).nfsr[3];
        int n12 = n8;
        n8 = n10 | n11 << 15;
        n10 = n12 >>> 5 | n11 << 11;
        int n13 = n12 >>> 13 | n11 << 3;
        Object object2 = object[4];
        int n14 = n11 >>> 4 | object2 << 12;
        int n15 = n11 >>> 12 | object2 << 4;
        int n16 = n11 >>> 14 | object2 << 2;
        object2 = n11 >>> 15 | object2 << 1;
        int n17 = n16 ^ n15 ^ n14 ^ n13 ^ n10 ^ n8 ^ n7 ^ n3 ^ n5 ^ n2 ^ n;
        n = object2 & n15;
        n5 = n15 & n14;
        n11 = n8 & n7 & n3;
        return (n17 ^ n ^ n10 & n8 ^ n6 & n2 ^ n5 & n13 ^ n11 ^ object2 & n13 & n7 & n2 ^ n5 & n10 & n8 ^ n & n3 & n6 ^ n & n14 & n13 & n10 ^ n11 & n6 & n2 ^ n14 & n13 & n10 & n8 & n7 & n3) & 0xFFFF;
    }

    private int getOutputLFSR() {
        Object object = ((Grainv1Engine)object).lfsr;
        int n = ((Grainv1Engine)object).lfsr[0];
        int n2 = n;
        Object object2 = object;
        n2 >>>= 13;
        Object object3 = object2[1];
        n2 |= object3 << 3;
        Object object4 = object3 >>> 7;
        Object object5 = object2[2];
        object4 = object4 | object5 << 9;
        Object object6 = object5 >>> 6;
        Object object7 = object2[3];
        int n3 = n2;
        Object object8 = object7;
        n2 = object6 | object7 << 10;
        Object object9 = object[4];
        object6 = object8 >>> 3 | object9 << 13;
        object9 = object8 >>> 14 | object9 << 2;
        return (n ^ n3 ^ object4 ^ n2 ^ object6 ^ object9) & 0xFFFF;
    }

    private int getOutput() {
        Grainv1Engine grainv1Engine = object;
        Object object = grainv1Engine.nfsr;
        int n = grainv1Engine.nfsr[0];
        int n2 = n >>> 1;
        int n3 = grainv1Engine.nfsr[1];
        int n4 = n3;
        int n5 = n;
        n = n2 | n4 << 15;
        n2 = n5 >>> 2 | n4 << 14;
        int n6 = n5 >>> 4 | n4 << 12;
        n4 = n5 >>> 10 | n4 << 6;
        int n7 = n3 >>> 15;
        int n8 = grainv1Engine.nfsr[2];
        n7 |= n8 << 1;
        int n9 = n8 >>> 11;
        int n10 = grainv1Engine.nfsr[3];
        n9 |= n10 << 5;
        Object object2 = object[4];
        int n11 = n10 >>> 8 | object2 << 8;
        object2 = n10 >>> 15 | object2 << 1;
        int[] nArray = grainv1Engine.lfsr;
        int n12 = nArray[0] >>> 3;
        int n13 = grainv1Engine.lfsr[1];
        n12 |= n13 << 13;
        int n14 = nArray[2];
        int n15 = n13 >>> 9 | n14 << 7;
        int n16 = n14 >>> 14 | nArray[3] << 2;
        n14 = nArray[4];
        int n17 = n16 & n14;
        return (n15 ^ object2 ^ n12 & n14 ^ n17 ^ n14 & object2 ^ n12 & n15 & n16 ^ (n12 &= n16) & n14 ^ n12 & object2 ^ n15 & n16 & object2 ^ n17 & object2 ^ n ^ n2 ^ n6 ^ n4 ^ n7 ^ n9 ^ n11) & 0xFFFF;
    }

    private int[] shift(int[] nArray, int n) {
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        nArray3[0] = nArray2[1];
        nArray3[1] = nArray2[2];
        nArray3[2] = nArray2[3];
        nArray3[3] = nArray2[4];
        nArray2[4] = n;
        return nArray3;
    }

    private void setKey(byte[] byArray, byte[] byArray2) {
        Grainv1Engine grainv1Engine = this;
        byArray2[8] = -1;
        byArray2[9] = -1;
        grainv1Engine.workingKey = byArray;
        grainv1Engine.workingIV = byArray2;
        int n = 0;
        int n2 = 0;
        while (true) {
            Object[] objectArray = this.nfsr;
            if (n2 >= this.nfsr.length) break;
            int[] nArray = objectArray;
            objectArray = this.workingKey;
            int n3 = n + 1;
            nArray[n2] = (this.workingKey[n3] << 8 | objectArray[n] & 0xFF) & 0xFFFF;
            objectArray = this.workingIV;
            this.lfsr[n2] = (this.workingIV[n3] << 8 | objectArray[n] & 0xFF) & 0xFFFF;
            n += 2;
            ++n2;
        }
    }

    private void oneRound() {
        int n;
        Grainv1Engine grainv1Engine = object;
        grainv1Engine.output = n = grainv1Engine.getOutput();
        grainv1Engine.out[0] = (byte)n;
        grainv1Engine.out[1] = (byte)(n >> 8);
        grainv1Engine.nfsr = grainv1Engine.shift(grainv1Engine.nfsr, ((Grainv1Engine)object).getOutputNFSR() ^ ((Grainv1Engine)object).lfsr[0]);
        Object object = grainv1Engine.lfsr;
        grainv1Engine.lfsr = grainv1Engine.shift((int[])object, grainv1Engine.getOutputLFSR());
    }

    private byte getKeyStream() {
        if (this.index > 1) {
            this.oneRound();
            this.index = 0;
        }
        int n = this.index;
        this.index = n + 1;
        return this.out[n];
    }

    @Override
    public String getAlgorithmName() {
        return "Grain v1";
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            CipherParameters cipherParameters = (ParametersWithIV)object;
            byte[] byArray = ((ParametersWithIV)cipherParameters).getIV();
            object = byArray;
            if (byArray != null && ((Object)object).length == 8) {
                if (((ParametersWithIV)cipherParameters).getParameters() instanceof KeyParameter) {
                    Grainv1Engine grainv1Engine = object3;
                    Object object2 = object;
                    cipherParameters = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                    ((Grainv1Engine)object3).workingIV = new byte[((KeyParameter)cipherParameters).getKey().length];
                    ((Grainv1Engine)object3).workingKey = new byte[((KeyParameter)cipherParameters).getKey().length];
                    ((Grainv1Engine)object3).lfsr = new int[5];
                    ((Grainv1Engine)object3).nfsr = new int[5];
                    ((Grainv1Engine)object3).out = new byte[2];
                    object = ((Grainv1Engine)object3).workingIV;
                    int n = ((Object)object2).length;
                    System.arraycopy(object2, 0, object, 0, n);
                    Object object3 = ((Grainv1Engine)object3).workingKey;
                    int n2 = ((KeyParameter)cipherParameters).getKey().length;
                    System.arraycopy(((KeyParameter)cipherParameters).getKey(), 0, object3, 0, n2);
                    grainv1Engine.reset();
                    return;
                }
                throw new IllegalArgumentException("Grain v1 Init parameters must include a key");
            }
            throw new IllegalArgumentException("Grain v1 requires exactly 8 bytes of IV");
        }
        throw new IllegalArgumentException("Grain v1 Init parameters must include an IV");
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.initialised) {
            if (n + n2 <= byArray.length) {
                if (n3 + n2 <= byArray2.length) {
                    for (int k = 0; k < n2; ++k) {
                        int n4 = n3 + k;
                        byArray2[n4] = (byte)(byArray[n + k] ^ this.getKeyStream());
                    }
                    return n2;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
        Grainv1Engine grainv1Engine = object;
        grainv1Engine.index = 2;
        Object object = grainv1Engine.workingKey;
        grainv1Engine.setKey((byte[])object, grainv1Engine.workingIV);
        grainv1Engine.initGrain();
    }

    @Override
    public byte returnByte(byte by) {
        if (this.initialised) {
            return (byte)(by ^ this.getKeyStream());
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }
}

