/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DigestDerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ISO18033KDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class BaseKDFBytesGenerator
implements DigestDerivationFunction {
    private int counterStart;
    private Digest digest;
    private byte[] shared;
    private byte[] iv;

    public BaseKDFBytesGenerator(int n, Digest digest) {
        this.counterStart = n;
        this.digest = digest;
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        block4: {
            block3: {
                block2: {
                    if (!(derivationParameters instanceof KDFParameters)) break block2;
                    BaseKDFBytesGenerator baseKDFBytesGenerator = kDFParameters;
                    KDFParameters kDFParameters = (KDFParameters)derivationParameters;
                    baseKDFBytesGenerator.shared = kDFParameters.getSharedSecret();
                    baseKDFBytesGenerator.iv = kDFParameters.getIV();
                    break block3;
                }
                if (!(derivationParameters instanceof ISO18033KDFParameters)) break block4;
                BaseKDFBytesGenerator baseKDFBytesGenerator = kDFParameters;
                baseKDFBytesGenerator.shared = ((ISO18033KDFParameters)derivationParameters).getSeed();
                baseKDFBytesGenerator.iv = null;
            }
            return;
        }
        throw new IllegalArgumentException("KDF parameters required for generator");
    }

    @Override
    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) {
        if (byArray.length - n2 >= n) {
            long l = n2;
            int n3 = this.digest.getDigestSize();
            if (l <= 0x1FFFFFFFFL) {
                BaseKDFBytesGenerator baseKDFBytesGenerator = this;
                long l2 = n3;
                int n4 = (int)((l + l2 - 1L) / l2);
                byte[] byArray2 = new byte[baseKDFBytesGenerator.digest.getDigestSize()];
                int n5 = 4;
                byte[] byArray3 = new byte[4];
                Pack.intToBigEndian(baseKDFBytesGenerator.counterStart, byArray3, 0);
                int n6 = baseKDFBytesGenerator.counterStart & 0xFFFFFF00;
                for (int k = 0; k < n4; ++k) {
                    byte by;
                    BaseKDFBytesGenerator baseKDFBytesGenerator2 = this;
                    baseKDFBytesGenerator2.digest.update(this.shared, 0, this.shared.length);
                    baseKDFBytesGenerator2.digest.update(byArray3, 0, n5);
                    byte[] byArray4 = baseKDFBytesGenerator2.iv;
                    if (baseKDFBytesGenerator2.iv != null) {
                        this.digest.update(byArray4, 0, byArray4.length);
                    }
                    this.digest.doFinal(byArray2, 0);
                    if (n2 > n3) {
                        System.arraycopy(byArray2, 0, byArray, n, n3);
                        n += n3;
                        n2 -= n3;
                    } else {
                        System.arraycopy(byArray2, 0, byArray, n, n2);
                    }
                    byArray3[3] = by = (byte)(byArray3[3] + 1);
                    if (by != 0) continue;
                    Pack.intToBigEndian(n6 += 256, byArray3, 0);
                }
                this.digest.reset();
                return (int)l;
            }
            throw new IllegalArgumentException("Output length too large");
        }
        throw new OutputLengthException("output buffer too small");
    }
}

