/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.Zuc128CoreEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.Zuc256CoreEngine;

public final class Zuc256Mac
implements Mac {
    private static final int TOPBIT = 128;
    private final InternalZuc256Engine theEngine;
    private final int theMacLength;
    private final int[] theMac;
    private final int[] theKeyStream;
    private Zuc256CoreEngine theState;
    private int theWordIndex;
    private int theByteIndex;

    public Zuc256Mac(int n) {
        this.theEngine = new InternalZuc256Engine(n);
        this.theMacLength = n;
        int n2 = n / 32;
        this.theMac = new int[n2];
        this.theKeyStream = new int[n2 + 1];
    }

    private void initKeyStream() {
        int[] nArray;
        int n = 0;
        while (true) {
            nArray = this.theMac;
            if (n >= this.theMac.length) break;
            nArray[n] = this.theEngine.createKeyStreamWord();
            ++n;
        }
        n = 0;
        while (true) {
            nArray = this.theKeyStream;
            if (n >= this.theKeyStream.length - 1) break;
            nArray[n] = this.theEngine.createKeyStreamWord();
            ++n;
        }
        Zuc256Mac zuc256Mac = this;
        zuc256Mac.theWordIndex = nArray.length - 1;
        zuc256Mac.theByteIndex = 3;
    }

    private void shift4NextByte() {
        this.theByteIndex = (this.theByteIndex + 1) % 4;
        if (this.theByteIndex == 0) {
            Zuc256Mac zuc256Mac = this;
            zuc256Mac.theKeyStream[this.theWordIndex] = this.theEngine.createKeyStreamWord();
            zuc256Mac.theWordIndex = (zuc256Mac.theWordIndex + 1) % this.theKeyStream.length;
        }
    }

    private void shift4Final() {
        this.theByteIndex = (this.theByteIndex + 1) % 4;
        if (this.theByteIndex == 0) {
            this.theWordIndex = (this.theWordIndex + 1) % this.theKeyStream.length;
        }
    }

    private void updateMac(int n) {
        int n2 = 0;
        while (true) {
            int[] nArray = this.theMac;
            if (n2 >= this.theMac.length) break;
            nArray[n2] = nArray[n2] ^ this.getKeyStreamWord(n2, n);
            ++n2;
        }
    }

    private int getKeyStreamWord(int n, int n2) {
        int[] nArray = this.theKeyStream;
        int n3 = this.theWordIndex;
        int n4 = this.theKeyStream[(n3 + n) % nArray.length];
        if (n2 == 0) {
            return n4;
        }
        n3 = nArray[(n3 + n + 1) % nArray.length];
        return n4 << n2 | n3 >>> 32 - n2;
    }

    @Override
    public String getAlgorithmName() {
        return b.a("Zuc256Mac-").append(this.theMacLength).toString();
    }

    @Override
    public int getMacSize() {
        return this.theMacLength / 8;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        Zuc256Mac zuc256Mac = this;
        zuc256Mac.theEngine.init(true, cipherParameters);
        zuc256Mac.theState = (Zuc256CoreEngine)zuc256Mac.theEngine.copy();
        zuc256Mac.initKeyStream();
    }

    @Override
    public void update(byte by) {
        Zuc256Mac zuc256Mac = this;
        zuc256Mac.shift4NextByte();
        int n = zuc256Mac.theByteIndex * 8;
        int n2 = 128;
        int n3 = 0;
        while (n2 > 0) {
            if ((by & n2) != 0) {
                this.updateMac(n + n3);
            }
            n2 >>= 1;
            ++n3;
        }
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        for (int k = 0; k < n2; ++k) {
            this.update(byArray[n + k]);
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        Zuc256Mac zuc256Mac = this;
        zuc256Mac.shift4Final();
        zuc256Mac.updateMac(zuc256Mac.theByteIndex * 8);
        int n2 = 0;
        while (true) {
            int[] nArray = this.theMac;
            if (n2 >= this.theMac.length) break;
            Zuc128CoreEngine.encode32be(nArray[n2], byArray, n2 * 4 + n);
            ++n2;
        }
        Zuc256Mac zuc256Mac2 = this;
        zuc256Mac2.reset();
        return zuc256Mac2.getMacSize();
    }

    @Override
    public void reset() {
        Zuc256CoreEngine zuc256CoreEngine = this.theState;
        if (zuc256CoreEngine != null) {
            this.theEngine.reset(zuc256CoreEngine);
        }
        this.initKeyStream();
    }

    public static class InternalZuc256Engine
    extends Zuc256CoreEngine {
        public InternalZuc256Engine(int n) {
            super(n);
        }

        public int createKeyStreamWord() {
            return super.makeKeyStreamWord();
        }
    }
}

