/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class KCCMBlockCipher
implements AEADBlockCipher {
    private static final int BYTES_IN_INT = 4;
    private static final int BITS_IN_BYTE = 8;
    private static final int MAX_MAC_BIT_LENGTH = 512;
    private static final int MIN_MAC_BIT_LENGTH = 64;
    private BlockCipher engine;
    private int macSize;
    private boolean forEncryption;
    private byte[] initialAssociatedText;
    private byte[] mac;
    private byte[] macBlock;
    private byte[] nonce;
    private byte[] G1;
    private byte[] buffer;
    private byte[] s;
    private byte[] counter;
    private ExposedByteArrayOutputStream associatedText = new ExposedByteArrayOutputStream();
    private ExposedByteArrayOutputStream data = new ExposedByteArrayOutputStream();
    private int Nb_ = 4;

    private void setNb(int n) {
        if (n != 4 && n != 6 && n != 8) {
            throw new IllegalArgumentException("Nb = 4 is recommended by DSTU7624 but can be changed to only 6 or 8 in this implementation");
        }
        this.Nb_ = n;
    }

    public KCCMBlockCipher(BlockCipher blockCipher) {
        this(blockCipher, 4);
    }

    public KCCMBlockCipher(BlockCipher blockCipher, int n) {
        this.engine = blockCipher;
        this.macSize = blockCipher.getBlockSize();
        this.nonce = new byte[blockCipher.getBlockSize()];
        this.initialAssociatedText = new byte[blockCipher.getBlockSize()];
        this.mac = new byte[blockCipher.getBlockSize()];
        this.macBlock = new byte[blockCipher.getBlockSize()];
        this.G1 = new byte[blockCipher.getBlockSize()];
        this.buffer = new byte[blockCipher.getBlockSize()];
        this.s = new byte[blockCipher.getBlockSize()];
        this.counter = new byte[blockCipher.getBlockSize()];
        this.setNb(n);
    }

    private void processAAD(byte[] byArray, int n, int n2, int n3) {
        if (n2 - n >= this.engine.getBlockSize()) {
            if (n2 % this.engine.getBlockSize() == 0) {
                int n4;
                KCCMBlockCipher kCCMBlockCipher = this;
                KCCMBlockCipher kCCMBlockCipher2 = this;
                KCCMBlockCipher kCCMBlockCipher3 = this;
                byte[] byArray2 = this.G1;
                int n5 = kCCMBlockCipher3.nonce.length - this.Nb_ - 1;
                System.arraycopy(kCCMBlockCipher3.nonce, 0, byArray2, 0, n5);
                kCCMBlockCipher2.intToBytes(n3, kCCMBlockCipher3.buffer, 0);
                KCCMBlockCipher kCCMBlockCipher4 = this;
                byArray2 = kCCMBlockCipher4.G1;
                n5 = kCCMBlockCipher4.nonce.length - this.Nb_ - 1;
                System.arraycopy(kCCMBlockCipher2.buffer, 0, byArray2, n5, 4);
                byArray2 = kCCMBlockCipher2.G1;
                KCCMBlockCipher kCCMBlockCipher5 = this;
                int n6 = byArray2.length - 1;
                kCCMBlockCipher2.G1[n6] = kCCMBlockCipher5.getFlag(true, kCCMBlockCipher5.macSize);
                KCCMBlockCipher kCCMBlockCipher6 = this;
                byte[] byArray3 = kCCMBlockCipher6.G1;
                byte[] byArray4 = kCCMBlockCipher6.macBlock;
                kCCMBlockCipher2.engine.processBlock(byArray3, 0, byArray4, 0);
                kCCMBlockCipher.intToBytes(n2, kCCMBlockCipher2.buffer, 0);
                if (n2 <= kCCMBlockCipher.engine.getBlockSize() - this.Nb_) {
                    for (int k = 0; k < n2; ++k) {
                        int n7 = k + this.Nb_;
                        this.buffer[n7] = (byte)(this.buffer[n7] ^ byArray[n + k]);
                    }
                    for (int k = 0; k < this.engine.getBlockSize(); ++k) {
                        this.macBlock[k] = (byte)(this.macBlock[k] ^ this.buffer[k]);
                    }
                    this.engine.processBlock(this.macBlock, 0, this.macBlock, 0);
                    return;
                }
                for (n4 = 0; n4 < this.engine.getBlockSize(); ++n4) {
                    this.macBlock[n4] = (byte)(this.macBlock[n4] ^ this.buffer[n4]);
                }
                this.engine.processBlock(this.macBlock, 0, this.macBlock, 0);
                while (n2 != 0) {
                    for (n4 = 0; n4 < this.engine.getBlockSize(); ++n4) {
                        this.macBlock[n4] = (byte)(this.macBlock[n4] ^ byArray[n4 + n]);
                    }
                    KCCMBlockCipher kCCMBlockCipher7 = this;
                    kCCMBlockCipher7.engine.processBlock(this.macBlock, 0, this.macBlock, 0);
                    n = kCCMBlockCipher7.engine.getBlockSize() + n;
                    n2 -= kCCMBlockCipher7.engine.getBlockSize();
                }
                return;
            }
            throw new IllegalArgumentException("padding not supported");
        }
        throw new IllegalArgumentException("authText buffer too short");
    }

    private void ProcessBlock(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte[] byArray3;
        n2 = 0;
        while (true) {
            byArray3 = this.counter;
            if (n2 >= this.counter.length) break;
            this.s[n2] = (byte)(this.s[n2] + byArray3[n2]);
            ++n2;
        }
        KCCMBlockCipher kCCMBlockCipher = this;
        byte[] byArray4 = kCCMBlockCipher.s;
        byArray3 = kCCMBlockCipher.buffer;
        this.engine.processBlock(byArray4, 0, byArray3, 0);
        for (int k = 0; k < this.engine.getBlockSize(); ++k) {
            byArray2[n3 + k] = (byte)(this.buffer[k] ^ byArray[n + k]);
        }
    }

    private void CalculateMac(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            for (int k = 0; k < this.engine.getBlockSize(); ++k) {
                this.macBlock[k] = (byte)(this.macBlock[k] ^ byArray[n + k]);
            }
            KCCMBlockCipher kCCMBlockCipher = this;
            kCCMBlockCipher.engine.processBlock(this.macBlock, 0, this.macBlock, 0);
            n2 -= kCCMBlockCipher.engine.getBlockSize();
            n = this.engine.getBlockSize() + n;
        }
    }

    private void intToBytes(int n, byte[] byArray, int n2) {
        int n3 = n2 + 3;
        byArray[n3] = (byte)(n >> 24);
        n3 = n2 + 2;
        byArray[n3] = (byte)(n >> 16);
        n3 = n2 + 1;
        byArray[n3] = (byte)(n >> 8);
        byArray[n2] = (byte)n;
    }

    private byte getFlag(boolean bl, int n) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer2.append("1");
        } else {
            stringBuffer2.append("0");
        }
        if (n != 8) {
            if (n != 16) {
                if (n != 32) {
                    if (n != 48) {
                        if (n == 64) {
                            stringBuffer2.append("110");
                        }
                    } else {
                        stringBuffer2.append("101");
                    }
                } else {
                    stringBuffer2.append("100");
                }
            } else {
                stringBuffer2.append("011");
            }
        } else {
            stringBuffer2.append("010");
        }
        Object object = Integer.toBinaryString(((KCCMBlockCipher)object).Nb_ - 1);
        while (((String)object).length() < 4) {
            object = new StringBuffer((String)object).insert(0, "0").toString();
        }
        StringBuffer stringBuffer3 = stringBuffer2;
        stringBuffer3.append((String)object);
        return (byte)Integer.parseInt(stringBuffer3.toString(), 2);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        block7: {
            block6: {
                block4: {
                    block5: {
                        if (!(cipherParameters instanceof AEADParameters)) break block4;
                        if (((AEADParameters)(cipherParameters = (AEADParameters)cipherParameters)).getMacSize() > 512 || ((AEADParameters)cipherParameters).getMacSize() < 64 || ((AEADParameters)cipherParameters).getMacSize() % 8 != 0) break block5;
                        this.nonce = ((AEADParameters)cipherParameters).getNonce();
                        this.macSize = ((AEADParameters)cipherParameters).getMacSize() / 8;
                        this.initialAssociatedText = ((AEADParameters)cipherParameters).getAssociatedText();
                        cipherParameters = ((AEADParameters)cipherParameters).getKey();
                        break block6;
                    }
                    throw new IllegalArgumentException("Invalid mac size specified");
                }
                if (!(cipherParameters instanceof ParametersWithIV)) break block7;
                cipherParameters = (ParametersWithIV)cipherParameters;
                this.nonce = ((ParametersWithIV)cipherParameters).getIV();
                this.macSize = this.engine.getBlockSize();
                this.initialAssociatedText = null;
                cipherParameters = ((ParametersWithIV)cipherParameters).getParameters();
            }
            KCCMBlockCipher kCCMBlockCipher = this;
            this.mac = new byte[this.macSize];
            kCCMBlockCipher.forEncryption = bl;
            kCCMBlockCipher.engine.init(true, cipherParameters);
            kCCMBlockCipher.counter[0] = 1;
            byte[] byArray = kCCMBlockCipher.initialAssociatedText;
            if (kCCMBlockCipher.initialAssociatedText != null) {
                int n = byArray.length;
                this.processAADBytes(byArray, 0, n);
            }
            return;
        }
        throw new IllegalArgumentException("Invalid parameters specified");
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KCCM";
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void processAADByte(byte by) {
        ((OutputStream)this.associatedText).write(by);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n, int n2) {
        ((OutputStream)this.associatedText).write(byArray, n, n2);
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n) {
        ((OutputStream)this.data).write(by);
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray.length >= n + n2) {
            ((OutputStream)this.data).write(byArray, n, n2);
            return 0;
        }
        throw new DataLengthException("input buffer too short");
    }

    public int processPacket(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray.length - n >= n2) {
            if (byArray2.length - n3 >= n2) {
                if (this.associatedText.size() > 0) {
                    int n4;
                    int n5;
                    if (this.forEncryption) {
                        KCCMBlockCipher kCCMBlockCipher = this;
                        KCCMBlockCipher kCCMBlockCipher2 = this;
                        n5 = kCCMBlockCipher2.associatedText.size();
                        n4 = kCCMBlockCipher2.data.size();
                        kCCMBlockCipher.processAAD(kCCMBlockCipher.associatedText.getBuffer(), 0, n5, n4);
                    } else {
                        KCCMBlockCipher kCCMBlockCipher = this;
                        KCCMBlockCipher kCCMBlockCipher3 = this;
                        n5 = kCCMBlockCipher3.associatedText.size();
                        n4 = kCCMBlockCipher3.data.size() - this.macSize;
                        kCCMBlockCipher.processAAD(kCCMBlockCipher.associatedText.getBuffer(), 0, n5, n4);
                    }
                }
                if (this.forEncryption) {
                    if (n2 % this.engine.getBlockSize() == 0) {
                        int n6;
                        byte[] byArray3;
                        KCCMBlockCipher kCCMBlockCipher;
                        KCCMBlockCipher kCCMBlockCipher4 = this;
                        kCCMBlockCipher4.CalculateMac(byArray, n, n2);
                        KCCMBlockCipher kCCMBlockCipher5 = this;
                        byte[] byArray4 = kCCMBlockCipher5.nonce;
                        byte[] byArray5 = kCCMBlockCipher5.s;
                        kCCMBlockCipher4.engine.processBlock(byArray4, 0, byArray5, 0);
                        for (int k = n2; k > 0; k -= kCCMBlockCipher.engine.getBlockSize()) {
                            KCCMBlockCipher kCCMBlockCipher6 = this;
                            kCCMBlockCipher = this;
                            kCCMBlockCipher.ProcessBlock(byArray, n, n2, byArray2, n3);
                            n = kCCMBlockCipher6.engine.getBlockSize() + n;
                            n3 = kCCMBlockCipher6.engine.getBlockSize() + n3;
                        }
                        int n7 = 0;
                        while (true) {
                            byArray3 = this.counter;
                            if (n7 >= this.counter.length) break;
                            this.s[n7] = (byte)(this.s[n7] + byArray3[n7]);
                            ++n7;
                        }
                        KCCMBlockCipher kCCMBlockCipher7 = this;
                        byte[] byArray6 = kCCMBlockCipher7.s;
                        byArray3 = kCCMBlockCipher7.buffer;
                        this.engine.processBlock(byArray6, 0, byArray3, 0);
                        for (int k = 0; k < (n6 = this.macSize); ++k) {
                            byArray2[n3 + k] = (byte)(this.buffer[k] ^ this.macBlock[k]);
                        }
                        KCCMBlockCipher kCCMBlockCipher8 = this;
                        System.arraycopy(kCCMBlockCipher8.macBlock, 0, this.mac, 0, n6);
                        kCCMBlockCipher8.reset();
                        return n2 + kCCMBlockCipher8.macSize;
                    }
                    throw new DataLengthException("partial blocks not supported");
                }
                if ((n2 - this.macSize) % this.engine.getBlockSize() == 0) {
                    byte[] byArray7;
                    int n8;
                    KCCMBlockCipher kCCMBlockCipher = this;
                    KCCMBlockCipher kCCMBlockCipher9 = this;
                    byte[] byArray8 = kCCMBlockCipher9.nonce;
                    byte[] byArray9 = kCCMBlockCipher9.s;
                    kCCMBlockCipher.engine.processBlock(byArray8, 0, byArray9, 0);
                    int n9 = n2 / kCCMBlockCipher.engine.getBlockSize();
                    for (n8 = 0; n8 < n9; ++n8) {
                        KCCMBlockCipher kCCMBlockCipher10 = this;
                        kCCMBlockCipher10.ProcessBlock(byArray, n, n2, byArray2, n3);
                        n = kCCMBlockCipher10.engine.getBlockSize() + n;
                        n3 = kCCMBlockCipher10.engine.getBlockSize() + n3;
                    }
                    if (n2 > n) {
                        byte[] byArray10;
                        n9 = 0;
                        while (true) {
                            byArray10 = this.counter;
                            if (n9 >= this.counter.length) break;
                            this.s[n9] = (byte)(this.s[n9] + byArray10[n9]);
                            ++n9;
                        }
                        KCCMBlockCipher kCCMBlockCipher11 = this;
                        byte[] byArray11 = kCCMBlockCipher11.s;
                        byArray10 = kCCMBlockCipher11.buffer;
                        this.engine.processBlock(byArray11, 0, byArray10, 0);
                        for (n9 = 0; n9 < (n8 = this.macSize); ++n9) {
                            byArray2[n3 + n9] = (byte)(this.buffer[n9] ^ byArray[n + n9]);
                        }
                        n3 += n8;
                    }
                    int n10 = 0;
                    while (true) {
                        byArray7 = this.counter;
                        if (n10 >= this.counter.length) break;
                        this.s[n10] = (byte)(this.s[n10] + byArray7[n10]);
                        ++n10;
                    }
                    KCCMBlockCipher kCCMBlockCipher12 = this;
                    KCCMBlockCipher kCCMBlockCipher13 = this;
                    KCCMBlockCipher kCCMBlockCipher14 = this;
                    byte[] byArray12 = kCCMBlockCipher14.s;
                    byArray7 = kCCMBlockCipher14.buffer;
                    kCCMBlockCipher13.engine.processBlock(byArray12, 0, byArray7, 0);
                    int n11 = kCCMBlockCipher13.macSize;
                    int n12 = n3 - n11;
                    System.arraycopy(byArray2, n12, this.buffer, 0, n11);
                    kCCMBlockCipher12.CalculateMac(byArray2, 0, n3 - this.macSize);
                    KCCMBlockCipher kCCMBlockCipher15 = this;
                    byte[] byArray13 = kCCMBlockCipher15.mac;
                    n12 = kCCMBlockCipher15.macSize;
                    System.arraycopy(kCCMBlockCipher12.macBlock, 0, byArray13, 0, n12);
                    int n13 = kCCMBlockCipher12.macSize;
                    byte[] byArray14 = new byte[n13];
                    System.arraycopy(kCCMBlockCipher12.buffer, 0, byArray14, 0, n13);
                    if (Arrays.constantTimeAreEqual(kCCMBlockCipher12.mac, byArray14)) {
                        KCCMBlockCipher kCCMBlockCipher16 = this;
                        kCCMBlockCipher16.reset();
                        return n2 - kCCMBlockCipher16.macSize;
                    }
                    throw new InvalidCipherTextException("mac check failed");
                }
                throw new DataLengthException("partial blocks not supported");
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        KCCMBlockCipher kCCMBlockCipher = this;
        int n2 = kCCMBlockCipher.processPacket(kCCMBlockCipher.data.getBuffer(), 0, this.data.size(), byArray, n);
        this.reset();
        return n2;
    }

    @Override
    public byte[] getMac() {
        return Arrays.clone(this.mac);
    }

    @Override
    public int getUpdateOutputSize(int n) {
        return n;
    }

    @Override
    public int getOutputSize(int n) {
        return n + this.macSize;
    }

    @Override
    public void reset() {
        KCCMBlockCipher kCCMBlockCipher = this;
        Arrays.fill(kCCMBlockCipher.G1, (byte)0);
        Arrays.fill(kCCMBlockCipher.buffer, (byte)0);
        Arrays.fill(kCCMBlockCipher.counter, (byte)0);
        Arrays.fill(kCCMBlockCipher.macBlock, (byte)0);
        kCCMBlockCipher.counter[0] = 1;
        kCCMBlockCipher.data.reset();
        kCCMBlockCipher.associatedText.reset();
        byte[] byArray = kCCMBlockCipher.initialAssociatedText;
        if (kCCMBlockCipher.initialAssociatedText != null) {
            int n = byArray.length;
            this.processAADBytes(byArray, 0, n);
        }
    }

    public class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

