/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.GOST3410KeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.GOST3410Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class GOST3410Signer
implements DSAExt {
    public GOST3410KeyParameters key;
    public SecureRandom random;

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                GOST3410Signer gOST3410Signer = parametersWithRandom;
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                gOST3410Signer.random = parametersWithRandom.getRandom();
                gOST3410Signer.key = (GOST3410PrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                ((GOST3410Signer)((Object)parametersWithRandom)).random = CryptoServicesRegistrar.getSecureRandom();
                ((GOST3410Signer)((Object)parametersWithRandom)).key = (GOST3410PrivateKeyParameters)cipherParameters;
            }
        } else {
            ((GOST3410Signer)((Object)parametersWithRandom)).key = (GOST3410PublicKeyParameters)cipherParameters;
        }
    }

    @Override
    public BigInteger getOrder() {
        return this.key.getParameters().getQ();
    }

    @Override
    public BigInteger[] generateSignature(byte[] object) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        object = Arrays.reverse((byte[])object);
        BigInteger bigInteger3 = bigInteger2;
        bigInteger2 = new BigInteger(1, (byte[])object);
        object = ((GOST3410Signer)((Object)bigInteger5)).key.getParameters();
        while ((bigInteger = BigIntegers.createRandomBigInteger(((GOST3410Parameters)object).getQ().bitLength(), ((GOST3410Signer)((Object)bigInteger5)).random)).compareTo(((GOST3410Parameters)object).getQ()) >= 0) {
        }
        BigInteger bigInteger4 = bigInteger3;
        bigInteger3 = ((GOST3410Parameters)object).getA().modPow(bigInteger, ((GOST3410Parameters)object).getP()).mod(((GOST3410Parameters)object).getQ());
        BigInteger bigInteger5 = bigInteger.multiply(bigInteger4).add(((GOST3410PrivateKeyParameters)((GOST3410Signer)((Object)bigInteger5)).key).getX().multiply(bigInteger3)).mod(((GOST3410Parameters)object).getQ());
        return new BigInteger[]{bigInteger3, bigInteger5};
    }

    @Override
    public boolean verifySignature(byte[] object, BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        object = Arrays.reverse((byte[])object);
        BigInteger bigInteger4 = bigInteger3;
        bigInteger3 = new BigInteger(1, (byte[])object);
        object = this.key.getParameters();
        BigInteger bigInteger5 = BigInteger.valueOf(0L);
        if (bigInteger5.compareTo(bigInteger) < 0 && ((GOST3410Parameters)object).getQ().compareTo(bigInteger) > 0) {
            if (bigInteger5.compareTo(bigInteger2) < 0 && ((GOST3410Parameters)object).getQ().compareTo(bigInteger2) > 0) {
                Object object2 = object;
                BigInteger bigInteger6 = bigInteger2;
                Object object3 = object;
                bigInteger2 = ((GOST3410Parameters)object3).getQ().subtract(new BigInteger("2"));
                bigInteger2 = bigInteger4.modPow(bigInteger2, ((GOST3410Parameters)object3).getQ());
                bigInteger4 = bigInteger6.multiply(bigInteger2).mod(((GOST3410Parameters)object).getQ());
                bigInteger2 = ((GOST3410Parameters)object2).getQ().subtract(bigInteger).multiply(bigInteger2).mod(((GOST3410Parameters)object).getQ());
                return ((GOST3410Parameters)object2).getA().modPow(bigInteger4, ((GOST3410Parameters)object).getP()).multiply(((GOST3410PublicKeyParameters)this.key).getY().modPow(bigInteger2, ((GOST3410Parameters)object).getP())).mod(((GOST3410Parameters)object).getP()).mod(((GOST3410Parameters)object).getQ()).equals(bigInteger);
            }
            return false;
        }
        return false;
    }
}

