/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X448PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.interfaces.XDHPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.interfaces.XDHPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Properties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCXDHPrivateKey
implements XDHPrivateKey {
    public static final long serialVersionUID = 1L;
    public transient AsymmetricKeyParameter xdhPrivateKey;
    private final boolean hasPublicKey;
    private final byte[] attributes;

    public BCXDHPrivateKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.hasPublicKey = true;
        this.attributes = null;
        this.xdhPrivateKey = asymmetricKeyParameter;
    }

    public BCXDHPrivateKey(PrivateKeyInfo privateKeyInfo) {
        this.hasPublicKey = privateKeyInfo.hasPublicKey();
        byte[] byArray = privateKeyInfo.getAttributes() != null ? privateKeyInfo.getAttributes().getEncoded() : null;
        this.attributes = byArray;
        this.populateFromPrivateKeyInfo(privateKeyInfo);
    }

    private void populateFromPrivateKeyInfo(PrivateKeyInfo privateKeyInfo) {
        ASN1OctetString aSN1OctetString = privateKeyInfo.getPrivateKey();
        byte[] byArray = aSN1OctetString.getOctets();
        if (byArray.length != 32 && byArray.length != 56) {
            aSN1OctetString = ASN1OctetString.getInstance(privateKeyInfo.parsePrivateKey());
        }
        this.xdhPrivateKey = EdECObjectIdentifiers.id_X448.equals(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? new X448PrivateKeyParameters(ASN1OctetString.getInstance(aSN1OctetString).getOctets(), 0) : new X25519PrivateKeyParameters(ASN1OctetString.getInstance(aSN1OctetString).getOctets(), 0);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.populateFromPrivateKeyInfo(PrivateKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public String getAlgorithm() {
        return this.xdhPrivateKey instanceof X448PrivateKeyParameters ? "X448" : "X25519";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getEncoded() {
        try {
            BCXDHPrivateKey bCXDHPrivateKey = aSN1Set;
            ASN1Set aSN1Set = ASN1Set.getInstance(bCXDHPrivateKey.attributes);
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(bCXDHPrivateKey.xdhPrivateKey, aSN1Set);
            if (bCXDHPrivateKey.hasPublicKey && !Properties.isOverrideSet("com.fis.ekyc.nfc.build_in.bouncycastle.pkcs8.v1_info_only")) {
                return privateKeyInfo.getEncoded();
            }
            PrivateKeyInfo privateKeyInfo2 = privateKeyInfo;
            AlgorithmIdentifier algorithmIdentifier = privateKeyInfo2.getPrivateKeyAlgorithm();
            return new PrivateKeyInfo(algorithmIdentifier, privateKeyInfo2.parsePrivateKey(), aSN1Set).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public XDHPublicKey getPublicKey() {
        AsymmetricKeyParameter asymmetricKeyParameter = ((BCXDHPrivateKey)((Object)asymmetricKeyParameter)).xdhPrivateKey;
        if (asymmetricKeyParameter instanceof X448PrivateKeyParameters) {
            return new BCXDHPublicKey(((X448PrivateKeyParameters)asymmetricKeyParameter).generatePublicKey());
        }
        return new BCXDHPublicKey(((X25519PrivateKeyParameters)asymmetricKeyParameter).generatePublicKey());
    }

    public AsymmetricKeyParameter engineGetKeyParameters() {
        return this.xdhPrivateKey;
    }

    public String toString() {
        AsymmetricKeyParameter asymmetricKeyParameter = this.xdhPrivateKey;
        asymmetricKeyParameter = asymmetricKeyParameter instanceof X448PrivateKeyParameters ? ((X448PrivateKeyParameters)asymmetricKeyParameter).generatePublicKey() : ((X25519PrivateKeyParameters)asymmetricKeyParameter).generatePublicKey();
        return Utils.keyToString("Private Key", this.getAlgorithm(), asymmetricKeyParameter);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PrivateKey)) {
            return false;
        }
        return Arrays.areEqual(((PrivateKey)object).getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }
}

