/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.DHParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.DHDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Enumeration;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;

public class JCEDHPrivateKey
implements DHPrivateKey,
PKCS12BagAttributeCarrier {
    public static final long serialVersionUID = 311058815616901812L;
    public BigInteger x;
    private DHParameterSpec dhSpec;
    private PrivateKeyInfo info;
    private PKCS12BagAttributeCarrier attrCarrier;

    public JCEDHPrivateKey() {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        v1.attrCarrier = pKCS12BagAttributeCarrier;
    }

    public JCEDHPrivateKey(DHPrivateKey dHPrivateKey) {
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.x = dHPrivateKey.getX();
        this.dhSpec = dHPrivateKey.getParams();
    }

    public JCEDHPrivateKey(DHPrivateKeySpec dHPrivateKeySpec) {
        JCEDHPrivateKey jCEDHPrivateKey = serializable;
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        jCEDHPrivateKey.x = dHPrivateKeySpec.getX();
        DHPrivateKeySpec dHPrivateKeySpec2 = dHPrivateKeySpec;
        Serializable serializable = dHPrivateKeySpec2.getP();
        jCEDHPrivateKey.dhSpec = new DHParameterSpec((BigInteger)serializable, dHPrivateKeySpec2.getG());
    }

    public JCEDHPrivateKey(PrivateKeyInfo object) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        block7: {
            block6: {
                Object object2;
                Object object3;
                block5: {
                    PrivateKeyInfo privateKeyInfo = object;
                    ((JCEDHPrivateKey)object2).attrCarrier = new PKCS12BagAttributeCarrierImpl();
                    object3 = ASN1Sequence.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
                    ASN1Integer aSN1Integer = ASN1Integer.getInstance(privateKeyInfo.parsePrivateKey());
                    aSN1ObjectIdentifier = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
                    ((JCEDHPrivateKey)object2).info = object;
                    ((JCEDHPrivateKey)object2).x = aSN1Integer.getValue();
                    if (!aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.dhKeyAgreement)) break block5;
                    object = DHParameter.getInstance(object3);
                    if (((DHParameter)object).getL() != null) {
                        JCEDHPrivateKey jCEDHPrivateKey = object2;
                        ASN1Object aSN1Object = object;
                        object2 = ((DHParameter)aSN1Object).getP();
                        object3 = ((DHParameter)aSN1Object).getG();
                        jCEDHPrivateKey.dhSpec = new DHParameterSpec((BigInteger)object2, (BigInteger)object3, ((DHParameter)object).getL().intValue());
                    } else {
                        DHParameterSpec dHParameterSpec;
                        JCEDHPrivateKey jCEDHPrivateKey = object2;
                        object2 = dHParameterSpec;
                        ASN1Object aSN1Object = object;
                        object = ((DHParameter)aSN1Object).getP();
                        dHParameterSpec = new DHParameterSpec((BigInteger)object, ((DHParameter)aSN1Object).getG());
                        jCEDHPrivateKey.dhSpec = object2;
                    }
                    break block6;
                }
                if (!aSN1ObjectIdentifier.equals(X9ObjectIdentifiers.dhpublicnumber)) break block7;
                JCEDHPrivateKey jCEDHPrivateKey = object2;
                object2 = DHDomainParameters.getInstance(object3);
                jCEDHPrivateKey.dhSpec = new DHParameterSpec(((DHDomainParameters)object2).getP().getValue(), ((DHDomainParameters)object2).getG().getValue());
            }
            return;
        }
        throw new IllegalArgumentException(a.a("unknown algorithm type: ", aSN1ObjectIdentifier));
    }

    public JCEDHPrivateKey(DHPrivateKeyParameters dHPrivateKeyParameters) {
        JCEDHPrivateKey jCEDHPrivateKey = serializable;
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        jCEDHPrivateKey.x = dHPrivateKeyParameters.getX();
        DHPrivateKeyParameters dHPrivateKeyParameters2 = dHPrivateKeyParameters;
        Serializable serializable = dHPrivateKeyParameters2.getParameters().getG();
        jCEDHPrivateKey.dhSpec = new DHParameterSpec(dHPrivateKeyParameters.getParameters().getP(), (BigInteger)serializable, dHPrivateKeyParameters2.getParameters().getL());
    }

    private void readObject(ObjectInputStream object) {
        JCEDHPrivateKey jCEDHPrivateKey = serializable;
        jCEDHPrivateKey.x = (BigInteger)((ObjectInputStream)object).readObject();
        ObjectInputStream objectInputStream = object;
        Serializable serializable = (BigInteger)objectInputStream.readObject();
        object = (BigInteger)objectInputStream.readObject();
        int n = objectInputStream.readInt();
        jCEDHPrivateKey.dhSpec = new DHParameterSpec((BigInteger)serializable, (BigInteger)object, n);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.getX());
        objectOutputStream.writeObject(this.dhSpec.getP());
        objectOutputStream.writeObject(this.dhSpec.getG());
        objectOutputStream.writeInt(this.dhSpec.getL());
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getEncoded() {
        Object object;
        try {
            object = this.info;
            if (object != null) {
                return ((ASN1Object)object).getEncoded("DER");
            }
        }
        catch (IOException iOException) {
            return null;
        }
        {
            JCEDHPrivateKey jCEDHPrivateKey = this;
            object = jCEDHPrivateKey.dhSpec.getG();
            return new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.dhKeyAgreement, new DHParameter(this.dhSpec.getP(), (BigInteger)object, jCEDHPrivateKey.dhSpec.getL())), new ASN1Integer(this.getX())).getEncoded("DER");
        }
    }

    @Override
    public DHParameterSpec getParams() {
        return this.dhSpec;
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }
}

