/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUEncryptionParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class IndexGenerator {
    private byte[] seed;
    private int N;
    private int c;
    private int minCallsR;
    private int totLen;
    private int remLen;
    private BitString buf;
    private int counter;
    private boolean initialized;
    private Digest hashAlg;
    private int hLen;

    public IndexGenerator(byte[] byArray, NTRUEncryptionParameters nTRUEncryptionParameters) {
        IndexGenerator indexGenerator = digest;
        IndexGenerator indexGenerator2 = digest;
        ((IndexGenerator)((Object)digest)).seed = byArray;
        ((IndexGenerator)((Object)digest)).N = nTRUEncryptionParameters.N;
        ((IndexGenerator)((Object)digest)).c = nTRUEncryptionParameters.c;
        indexGenerator2.minCallsR = nTRUEncryptionParameters.minCallsR;
        indexGenerator2.totLen = 0;
        indexGenerator2.remLen = 0;
        indexGenerator2.counter = 0;
        Digest digest = nTRUEncryptionParameters.hashAlg;
        indexGenerator.hashAlg = digest;
        indexGenerator.hLen = digest.getDigestSize();
        indexGenerator.initialized = false;
    }

    private void appendHash(BitString bitString, byte[] byArray) {
        IndexGenerator indexGenerator = digest;
        indexGenerator.hashAlg.update(((IndexGenerator)((Object)digest)).seed, 0, ((IndexGenerator)((Object)digest)).seed.length);
        Digest digest = indexGenerator.hashAlg;
        indexGenerator.putInt(digest, indexGenerator.counter);
        indexGenerator.hashAlg.doFinal(byArray, 0);
        bitString.appendBits(byArray);
    }

    private void putInt(Digest digest, int n) {
        digest.update((byte)(n >> 24));
        digest.update((byte)(n >> 16));
        digest.update((byte)(n >> 8));
        digest.update((byte)n);
    }

    private static byte[] copyOf(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        if (n >= byArray.length) {
            n = byArray.length;
        }
        System.arraycopy(byArray, n2, byArray2, n3, n);
        return byArray2;
    }

    public int nextIndex() {
        int n;
        int n2;
        if (!this.initialized) {
            this.buf = new BitString();
            byte[] byArray = new byte[this.hashAlg.getDigestSize()];
            while (this.counter < (n2 = this.minCallsR)) {
                IndexGenerator indexGenerator = this;
                indexGenerator.appendHash(indexGenerator.buf, byArray);
                ++indexGenerator.counter;
            }
            IndexGenerator indexGenerator = this;
            indexGenerator.totLen = n = n2 * 8 * this.hLen;
            indexGenerator.remLen = n;
            indexGenerator.initialized = true;
        }
        do {
            IndexGenerator indexGenerator = this;
            indexGenerator.totLen += this.c;
            BitString bitString = indexGenerator.buf.getTrailing(this.remLen);
            n2 = indexGenerator.remLen;
            int n3 = this.c;
            if (n2 < n3) {
                BitString bitString2;
                n2 = n3 - n2;
                IndexGenerator indexGenerator2 = this;
                n3 = indexGenerator2.counter;
                int n4 = indexGenerator2.hLen;
                n3 = (n2 + n4 - 1) / n4 + n3;
                byte[] byArray = new byte[this.hashAlg.getDigestSize()];
                while (this.counter < n3) {
                    IndexGenerator indexGenerator3 = this;
                    indexGenerator3.appendHash(bitString, byArray);
                    ++indexGenerator3.counter;
                    int n5 = indexGenerator3.hLen;
                    if (n2 <= n5 * 8) continue;
                    n2 -= n5 * 8;
                }
                this.remLen = this.hLen * 8 - n2;
                BitString bitString3 = bitString2;
                bitString3();
                this.buf = this.buf;
                bitString2.appendBits(byArray);
            } else {
                this.remLen = n2 - n3;
            }
            n = bitString.getLeadingAsInt(this.c);
            n2 = this.c;
        } while (n >= (1 << n2) - (1 << n2) % (n2 = this.N));
        return n % n2;
    }

    public static class BitString {
        public byte[] bytes = new byte[4];
        public int numBytes;
        public int lastByteBits;

        public void appendBits(byte[] byArray) {
            for (int k = 0; k != byArray.length; ++k) {
                this.appendBits(byArray[k]);
            }
        }

        public void appendBits(byte by) {
            int n;
            byte[] byArray = this.bytes;
            if (this.numBytes == this.bytes.length) {
                this.bytes = IndexGenerator.copyOf(byArray, byArray.length * 2);
            }
            if ((n = this.numBytes) == 0) {
                this.numBytes = 1;
                this.bytes[0] = by;
                this.lastByteBits = 8;
            } else {
                int n2 = this.lastByteBits;
                if (n2 == 8) {
                    this.numBytes = n + 1;
                    this.bytes[n] = by;
                } else {
                    int n3 = 8 - n2;
                    byte[] byArray2 = this.bytes;
                    byte by2 = by;
                    int n4 = n - 1;
                    by = (byte)n4;
                    byte by3 = byArray2[n4];
                    int n5 = by2 & 0xFF;
                    byArray2[by] = (byte)(by3 | n5 << n2);
                    this.numBytes = n + 1;
                    this.bytes[n] = (byte)(n5 >> n3);
                }
            }
        }

        public BitString getTrailing(int n) {
            int n2;
            int n3;
            int n4;
            BitString bitString;
            BitString bitString2 = bitString;
            bitString2();
            bitString.numBytes = n4 = (n + 7) / 8;
            bitString.bytes = new byte[n4];
            for (n4 = 0; n4 < (n3 = bitString2.numBytes); ++n4) {
                bitString2.bytes[n4] = this.bytes[n4];
            }
            bitString2.lastByteBits = n2 = n % 8;
            if (n2 == 0) {
                bitString2.lastByteBits = 8;
            } else {
                n2 = 32 - n2;
                int n5 = n3;
                n = n5 - 1;
                bitString2.bytes[n] = (byte)(bitString2.bytes[n5 - 1] << n2 >>> n2);
            }
            return bitString2;
        }

        public int getLeadingAsInt(int n) {
            BitString bitString = this;
            int n2 = (bitString.numBytes - 1) * 8 + this.lastByteBits - n;
            n = n2 / 8;
            int n3 = n2 % 8;
            int n4 = (bitString.bytes[n] & 0xFF) >>> n3;
            n3 = 8 - n3;
            ++n;
            while (n < this.numBytes) {
                n4 |= (this.bytes[n] & 0xFF) << n3;
                n3 += 8;
                ++n;
            }
            return n4;
        }

        public byte[] getBytes() {
            return Arrays.clone(this.bytes);
        }
    }
}

