/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.mrz.types;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class MrzDate
implements Serializable,
Comparable<MrzDate> {
    private static final long serialVersionUID = 1L;
    private static final SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
    public final int year;
    public final int month;
    public final int day;
    private final String mrz;
    private final boolean isValidDate;

    public MrzDate(int n, int n2, int n3) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.isValidDate = this.check();
        this.mrz = null;
    }

    public MrzDate(int n, int n2, int n3, String string2) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.isValidDate = this.check();
        this.mrz = string2;
    }

    private boolean check() {
        int n = this.year;
        if (n >= 0 && n <= 99) {
            n = this.month;
            if (n >= 1 && n <= 12) {
                int n2 = this.day;
                return n2 >= 1 && n2 <= 31;
                {
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        try {
            return outputFormat.format(new SimpleDateFormat("yyMMdd").parse(this.mrz));
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return "";
        }
    }

    public String toMrz() {
        Object[] objectArray = this.mrz;
        if (this.mrz != null) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[3];
        objectArray = objectArray2;
        objectArray[0] = this.year;
        objectArray[1] = this.month;
        objectArray2[2] = this.day;
        return String.format("%02d%02d%02d", objectArray);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (MrzDate)object;
        if (this.year != ((MrzDate)object).year) {
            return false;
        }
        if (this.month != ((MrzDate)object).month) {
            return false;
        }
        return this.day == ((MrzDate)object).day;
    }

    public int hashCode() {
        return ((77 + this.year) * 11 + this.month) * 11 + this.day;
    }

    @Override
    public int compareTo(MrzDate mrzDate) {
        MrzDate mrzDate2 = this;
        int n = mrzDate2.year * 10000;
        MrzDate mrzDate3 = mrzDate;
        int n2 = mrzDate3.year * 10000;
        return Integer.valueOf(mrzDate2.month * 100 + n + this.day).compareTo(mrzDate3.month * 100 + n2 + mrzDate.day);
    }

    public boolean isDateValid() {
        return this.isValidDate;
    }
}

