/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.tlv;

import com.fis.ekyc.nfc.build_in.scuba.tlv.ASN1Constants;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TLVUtil
implements ASN1Constants {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.nfc.build_in.scuba.tlv");

    private TLVUtil() {
    }

    public static boolean isPrimitive(int n) {
        int n2;
        for (n2 = 3; n2 >= 0 && (n & 255 << n2 * 8) == 0; --n2) {
        }
        return ((n & 255 << (n = n2 * 8)) >> n & 0xFF & 0x20) == 0;
    }

    public static int getTagLength(int n) {
        return TLVUtil.getTagAsBytes(n).length;
    }

    public static int getLengthLength(int n) {
        return TLVUtil.getLengthAsBytes(n).length;
    }

    public static byte[] getTagAsBytes(int n) {
        ByteArrayOutputStream byteArrayOutputStream;
        Object object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = (int)(Math.log(n) / Math.log(256.0)) + 1;
        for (int k = 0; k < n2; ++k) {
            int n3 = (n2 - k - 1) * 8;
            ((ByteArrayOutputStream)object).write((n & 255 << n3) >> n3);
        }
        object = ((ByteArrayOutputStream)object).toByteArray();
        n2 = TLVUtil.getTagClass(n);
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 == 3) {
                    Object object2 = object;
                    object2[0] = (byte)(object2[0] | 0xC0);
                }
            } else {
                Object object3 = object;
                object3[0] = (byte)(object3[0] | 0x80);
            }
        } else {
            Object object4 = object;
            object4[0] = (byte)(object4[0] | 0x40);
        }
        if (!TLVUtil.isPrimitive(n)) {
            Object object5 = object;
            object5[0] = (byte)(object5[0] | 0x20);
        }
        return object;
    }

    public static byte[] getLengthAsBytes(int n) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        if (n < 128) {
            byteArrayOutputStream2.write(n);
        } else {
            int n2 = TLVUtil.log(n, 256);
            byteArrayOutputStream2.write(n2 | 0x80);
            for (int k = 0; k < n2; ++k) {
                int n3 = (n2 - k - 1) * 8;
                byteArrayOutputStream2.write((n & 255 << n3) >> n3);
            }
        }
        return byteArrayOutputStream2.toByteArray();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] wrapDO(int n, byte[] byArray) {
        Throwable throwable2222222;
        ByteArrayOutputStream byteArrayOutputStream2;
        block8: {
            ByteArrayOutputStream byteArrayOutputStream2;
            if (byArray == null) throw new IllegalArgumentException("Data to wrap is null");
            byteArrayOutputStream2 = byteArrayOutputStream2;
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            TLVOutputStream tLVOutputStream = new TLVOutputStream(byteArrayOutputStream2);
            tLVOutputStream.writeTag(n);
            tLVOutputStream.writeValue(byArray);
            tLVOutputStream.flush();
            tLVOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            {
                catch (Throwable throwable2222222) {
                    break block8;
                }
                catch (IOException iOException) {}
                {
                    throw new IllegalStateException("Error writing stream", iOException);
                }
            }
            try {
                byteArrayOutputStream2.close();
                return byArray2;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, "Error closing stream", iOException);
            }
            return byArray2;
        }
        try {
            byteArrayOutputStream2.close();
            throw throwable2222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error closing stream", iOException);
        }
        throw throwable2222222;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unwrapDO(int n, byte[] object) {
        Throwable throwable222222;
        block11: {
            int n2;
            block10: {
                TLVInputStream tLVInputStream;
                ByteArrayInputStream byteArrayInputStream;
                if (object == null) throw new IllegalArgumentException("Wrapped data is null or length < 2");
                if (((Object)object).length < 2) throw new IllegalArgumentException("Wrapped data is null or length < 2");
                ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
                byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                object = tLVInputStream;
                n2 = new TLVInputStream(byteArrayInputStream2).readTag();
                if (n2 != n) break block10;
                Object object2 = object;
                Object object3 = object2;
                n = ((TLVInputStream)object2).readLength();
                byte[] byArray = new byte[n];
                System.arraycopy(((TLVInputStream)object2).readValue(), 0, byArray, 0, n);
                try {
                    ((TLVInputStream)object3).close();
                    return byArray;
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Error closing stream", iOException);
                }
                return byArray;
            }
            try {
                throw new IllegalArgumentException("Expected tag " + Integer.toHexString(n) + ", found tag " + Integer.toHexString(n2));
            }
            catch (Throwable throwable222222) {
                break block11;
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Error reading from stream", iOException);
            }
        }
        try {
            ((TLVInputStream)object).close();
            throw throwable222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error closing stream", iOException);
        }
        throw throwable222222;
    }

    public static int getTagClass(int n) {
        int n2;
        for (n2 = 3; n2 >= 0 && (n & 255 << n2 * 8) == 0; --n2) {
        }
        int n3 = n;
        n = n2 * 8;
        if ((n = (n3 & 255 << n) >> n & 0xFF & 0xC0) != 0) {
            if (n != 64) {
                if (n != 128) {
                    return 3;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private static int log(int n, int n2) {
        int n3 = 0;
        while (n > 0) {
            n /= n2;
            ++n3;
        }
        return n3;
    }
}

