package vn.kalapa.ekyc.utils

enum class KALAPA_LOG_LEVEL(val level: Int) {
    VERBOSE(-1), DEBUG(0), INFO(1), WARN(2), ERROR(3)
}

enum class KALAPA_LOG_ACTION {
    // COMMON
    EXIT_TAP_YES, EXIT_TAP_NO, TAP_GUIDE, TAP_CAPTURE, TAP_CONTINUE, TAP_RETRY, GUIDE_TAP_CLOSE, TAP_EXIT,
    ENTER_SCREEN, EXIT_SCREEN, SDK_IN_BACKGROUND, SDK_IN_FOREGROUND, EMULATOR_DETECTED, VIRTUAL_CAMERA_DETECTED,
    SESSION_EXPIRED, SESSION_EXPIRED_TAP_RETRY, SESSION_EXPIRED_TAP_GIVE_UP, TAP_SKIP,

    // EKYC
    EKYC_COMPLETE, EKYC_LEAVE, EKYC_EXPIRED,

    // Action thể hiện Session kết thúc: SESSION_EXPIRED_TAP_GIVE_UP, EXIT_TAP_YES.
    //
    // ID CAPTURE
    CAPTURE_AUTO_OFF, CAPTURE_AUTO_ON, CAPTURE_AUTO_SUCCESS, CAPTURE_FAIL, CAPTURE_ERROR, CAPTURE_SUCCESS,
    SCAN_QR_SUCCESS,

    // LIVENESS
    LIVENESS_START, LIVENESS_CAPTURE_SUCCESS, LIVENESS_INTERRUPTED, LIVENESS_SUCCESS, LIVENESS_FAIL, LIVENESS_ERROR, LIVENESS_TIMEOUT,

    // PASSPORT
    PASSPORT_TAP_UPLOAD, PASSPORT_UPLOAD_CANCEL, PASSPORT_UPLOAD_FAIL, PASSPORT_SUCCESS, PASSPORT_FAIL, PASSPORT_ERROR, PASSPORT_UPLOAD_SUCCESS,

    // NFC SCAN
    CAMERA_ERROR,
    PERMISSION_GRANTED, PERMISSION_DECLINED,
    NFC_START, NFC_SUCCESS, NFC_FAIL,NFC_TIMEOUT, NFC_ERROR, NFC_TAP_CANCEL, NFC_START_LISTEN,
    NFC_TAP_LOCATION, NFC_LOCATION_TAP_CLOSE, NFC_TAP_CARD, NFC_TAP_FAIL, NFC_TAP_SUCCESS,
    MRZ_SUCCESS, MRZ_FAIL, MRZ_TAP_CANCEL,
    TAP_SCAN_NFC,
    GET_DEVICE_INFO,
}