/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.CertId;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class OOBCertHash
extends ASN1Object {
    private AlgorithmIdentifier hashAlg;
    private CertId certId;
    private DERBitString hashVal;

    private OOBCertHash(ASN1Sequence aSN1Sequence) {
        ASN1Sequence aSN1Sequence2 = aSN1Sequence;
        this.hashVal = DERBitString.getInstance(aSN1Sequence2.getObjectAt(aSN1Sequence2.size() - 1));
        for (int k = (v20728) + -1; k >= 0; --k) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(k);
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.hashAlg = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
                continue;
            }
            this.certId = CertId.getInstance(aSN1TaggedObject, true);
        }
    }

    public static OOBCertHash getInstance(Object object) {
        if (object instanceof OOBCertHash) {
            return (OOBCertHash)object;
        }
        if (object != null) {
            return new OOBCertHash(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public OOBCertHash(AlgorithmIdentifier algorithmIdentifier, CertId certId, byte[] byArray) {
        DERBitString dERBitString;
        OOBCertHash oOBCertHash = aSN1Object;
        ASN1Object aSN1Object = dERBitString;
        dERBitString = new DERBitString(byArray);
        oOBCertHash(algorithmIdentifier, certId, (DERBitString)aSN1Object);
    }

    public OOBCertHash(AlgorithmIdentifier algorithmIdentifier, CertId certId, DERBitString dERBitString) {
        this.hashAlg = algorithmIdentifier;
        this.certId = certId;
        this.hashVal = dERBitString;
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            DERTaggedObject dERTaggedObject;
            ASN1Object aSN1Object = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, n, aSN1Encodable);
            aSN1EncodableVector.add(aSN1Object);
        }
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.hashAlg;
    }

    public CertId getCertId() {
        return this.certId;
    }

    public DERBitString getHashVal() {
        return this.hashVal;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        OOBCertHash oOBCertHash = this;
        OOBCertHash oOBCertHash2 = this;
        aSN1EncodableVector2(3);
        oOBCertHash2.addOptional(aSN1EncodableVector2, 0, this.hashAlg);
        oOBCertHash.addOptional(aSN1EncodableVector2, 1, oOBCertHash2.certId);
        aSN1EncodableVector.add(oOBCertHash.hashVal);
        return new DERSequence(aSN1EncodableVector2);
    }
}

