/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.Attributes;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.ContentInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.SignedData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp.PartialHashtree;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp.TSTInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class ArchiveTimeStamp
extends ASN1Object {
    private AlgorithmIdentifier digestAlgorithm;
    private Attributes attributes;
    private ASN1Sequence reducedHashTree;
    private ContentInfo timeStamp;

    public static ArchiveTimeStamp getInstance(Object object) {
        if (object instanceof ArchiveTimeStamp) {
            return (ArchiveTimeStamp)object;
        }
        if (object != null) {
            return new ArchiveTimeStamp(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ArchiveTimeStamp(AlgorithmIdentifier algorithmIdentifier, PartialHashtree[] partialHashtreeArray, ContentInfo contentInfo) {
        DERSequence dERSequence;
        aSN1Object.digestAlgorithm = algorithmIdentifier;
        ASN1Object aSN1Object = dERSequence;
        dERSequence = new DERSequence(partialHashtreeArray);
        v1.reducedHashTree = aSN1Object;
        v1.timeStamp = contentInfo;
    }

    public ArchiveTimeStamp(AlgorithmIdentifier algorithmIdentifier, Attributes attributes, PartialHashtree[] partialHashtreeArray, ContentInfo contentInfo) {
        DERSequence dERSequence;
        aSN1Object.digestAlgorithm = algorithmIdentifier;
        aSN1Object.attributes = attributes;
        ASN1Object aSN1Object = dERSequence;
        dERSequence = new DERSequence(partialHashtreeArray);
        v1.reducedHashTree = aSN1Object;
        v1.timeStamp = contentInfo;
    }

    public ArchiveTimeStamp(ContentInfo contentInfo) {
        this.timeStamp = contentInfo;
    }

    private ArchiveTimeStamp(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 1 && aSN1Sequence.size() <= 4) {
            for (int k = 0; k < aSN1Sequence.size() - 1; ++k) {
                ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(k);
                if (!(aSN1Encodable instanceof ASN1TaggedObject)) continue;
                int n = ((ASN1TaggedObject)(aSN1Encodable = ASN1TaggedObject.getInstance(aSN1Encodable))).getTagNo();
                if (n != 0) {
                    if (n != 1) {
                        if (n == 2) {
                            this.reducedHashTree = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Encodable, false);
                            continue;
                        }
                        throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b.a((ASN1TaggedObject)aSN1Encodable, b.b.a("invalid tag no in constructor: ")));
                    }
                    this.attributes = Attributes.getInstance((ASN1TaggedObject)aSN1Encodable, false);
                    continue;
                }
                this.digestAlgorithm = AlgorithmIdentifier.getInstance((ASN1TaggedObject)aSN1Encodable, false);
            }
            ASN1Sequence aSN1Sequence2 = aSN1Sequence;
            this.timeStamp = ContentInfo.getInstance(aSN1Sequence2.getObjectAt(aSN1Sequence2.size() - 1));
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("wrong sequence size in constructor: ")));
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        AlgorithmIdentifier algorithmIdentifier = ((ArchiveTimeStamp)aSN1Object).digestAlgorithm;
        if (algorithmIdentifier != null) {
            return algorithmIdentifier;
        }
        if (((ArchiveTimeStamp)aSN1Object).timeStamp.getContentType().equals(CMSObjectIdentifiers.signedData)) {
            ASN1Object aSN1Object = SignedData.getInstance(((ArchiveTimeStamp)aSN1Object).timeStamp.getContent());
            if (((SignedData)aSN1Object).getEncapContentInfo().getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo)) {
                return TSTInfo.getInstance(((SignedData)aSN1Object).getEncapContentInfo()).getMessageImprint().getHashAlgorithm();
            }
            throw new IllegalStateException("cannot parse time stamp");
        }
        throw new IllegalStateException("cannot identify algorithm identifier for digest");
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public PartialHashtree[] getReducedHashTree() {
        ASN1Sequence aSN1Sequence = this.reducedHashTree;
        if (aSN1Sequence == null) {
            return null;
        }
        int n = aSN1Sequence.size();
        PartialHashtree[] partialHashtreeArray = new PartialHashtree[n];
        for (int k = 0; k != n; ++k) {
            partialHashtreeArray[k] = PartialHashtree.getInstance(this.reducedHashTree.getObjectAt(k));
        }
        return partialHashtreeArray;
    }

    public ContentInfo getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(4);
        ASN1Object aSN1Object = this.digestAlgorithm;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            dERTaggedObject2 = new DERTaggedObject(false, 0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Object = this.attributes) != null) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            dERTaggedObject3 = new DERTaggedObject(false, 1, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Object = this.reducedHashTree) != null) {
            DERTaggedObject dERTaggedObject4;
            dERTaggedObject = dERTaggedObject4;
            dERTaggedObject4 = new DERTaggedObject(false, 2, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        aSN1EncodableVector2.add(this.timeStamp);
        return new DERSequence(aSN1EncodableVector2);
    }
}

